# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import datetime
import django.core.files.storage
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import mysite.admin.abstract_cloud_model
import mysite.att.models.model_breaktime
import mysite.att.models.model_clientdetails
import mysite.base.models.modelless
import mysite.personnel.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0002_auto_20200103_1729'),
        ('personnel', '0001_initial'),
        ('att', '0001_initial'),
        ('workflow', '0001_initial'),
        ('iclock', '0002_auto_20200103_1729'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChangeSchedule',
            fields=[
                ('abstractexception_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='workflow.AbstractException')),
                ('att_date', models.DateField(verbose_name='changeSchedule_field_attDate')),
                ('previous_timeinterval', models.CharField(blank=True, max_length=100, null=True, verbose_name='changeSchedule_field_previousTimeInterval')),
                ('apply_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='changeSchedule_field_applyTime')),
                ('apply_reason', models.CharField(blank=True, max_length=200, null=True, verbose_name='changeSchedule_field_applyReason')),
                ('audit_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='changeSchedule_field_approvalReason')),
                ('audit_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='changeSchedule_field_approvalTime')),
                ('approver', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='changeSchedule_field_approver')),
                ('start_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='changeSchedule_field_startTime')),
                ('end_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='changeSchedule_field_endTime')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='changeSchedule_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_changeSchedule',
                'verbose_name_plural': 'att_model_changeSchedule',
                'ordering': ['id'],
            },
            bases=('workflow.abstractexception',),
        ),
        migrations.CreateModel(
            name='ClientDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_id', models.CharField(max_length=55, verbose_name='clientDetails_field_clientId')),
                ('company_name', models.CharField(max_length=55, verbose_name='clientDetails_field_companyName')),
                ('address', models.TextField(verbose_name='clientDetails_field_address')),
                ('branch', models.CharField(max_length=55, verbose_name='clientDetails_field_branch')),
                ('contact_person', models.CharField(max_length=55, verbose_name='clientDetails_field_contactPerson')),
                ('mobile', models.CharField(max_length=15, verbose_name='clientDetails_field_mobile')),
                ('distance', models.IntegerField(default=50, verbose_name='clientDetails_field_location')),
                ('longitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-180.0), django.core.validators.MaxValueValidator(180.0)], verbose_name='clientDetails_field_longitude')),
                ('latitude', models.FloatField(validators=[django.core.validators.MinValueValidator(-90.0), django.core.validators.MaxValueValidator(90.0)], verbose_name='clientDetails_field_latitude')),
                ('punch_location_radius', models.FloatField(validators=[django.core.validators.MinValueValidator(1.0)], verbose_name='clientDetails_field_punchLocationRadius')),
                ('logo', models.ImageField(blank=True, max_length=200, null=True, storage=django.core.files.storage.FileSystemStorage(location='F:\\easytimepro\\master/files/'), upload_to=mysite.att.models.model_clientdetails.upload_path_handler)),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'att_model_clientDetails',
                'verbose_name_plural': 'att_model_clientDetails',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='DepartmentSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('start_date', models.DateField(verbose_name='deptSchedule_field_startDate')),
                ('end_date', models.DateField(verbose_name='deptSchedule_field_endDate')),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='deptSchedule_field_department')),
                ('shift', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='att.AttShift', verbose_name='deptSchedule_field_shift')),
            ],
            options={
                'verbose_name': 'att_model_deptSchedule',
                'verbose_name_plural': 'att_model_deptSchedule',
                'ordering': ['id'],
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='DeptAttRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(max_length=50, verbose_name='deptAttRule_field_alias')),
                ('rule', models.TextField(blank=True, null=True, verbose_name='deptAttRule_field_departmentRule')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('department', mysite.personnel.fields.DepartmentForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='deptAttRule_field_department')),
            ],
            options={
                'verbose_name': 'att_model_deptAttRule',
                'verbose_name_plural': 'att_model_deptAttRule',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='Holiday',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(max_length=50, verbose_name='holiday_field_alias')),
                ('start_date', models.DateField(default=datetime.datetime.now, verbose_name='holiday_field_startDate')),
                ('duration_day', models.SmallIntegerField(default=1, validators=[django.core.validators.MinValueValidator(0)], verbose_name='holiday_field_duration')),
                ('work_type', models.SmallIntegerField(choices=[(0, 'unscheduled_ignore'), (1, 'unscheduled_move2normalWork'), (2, 'unscheduled_move2normalOvertime'), (3, 'unscheduled_move2weekendOvertime'), (4, 'unscheduled_move2holidayOvertime')], default=4, verbose_name='holiday_field_workType')),
                ('overtime_lv1', models.SmallIntegerField(default=0, verbose_name='timeInterval_field_overtimeLevel1')),
                ('overtime_lv2', models.SmallIntegerField(default=0, verbose_name='timeInterval_field_overtimeLevel2')),
                ('overtime_lv3', models.SmallIntegerField(default=0, verbose_name='timeInterval_field_overtimeLevel3')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('department', mysite.personnel.fields.DepartmentForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='holiday_field_department')),
                ('location', mysite.personnel.fields.LocationForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Location', verbose_name='holiday_field_holiday')),
            ],
            options={
                'verbose_name': 'att_model_holiday',
                'verbose_name_plural': 'att_model_holiday',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='Leave',
            fields=[
                ('abstractexception_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='workflow.AbstractException')),
                ('start_time', models.DateTimeField(blank=True, null=True, verbose_name='leave_field_startTime')),
                ('end_time', models.DateTimeField(blank=True, null=True, verbose_name='leave_field_endTime')),
                ('apply_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='leave_field_applyReason')),
                ('apply_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='leave_field_applyTime')),
                ('audit_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='leave_field_approvalRemark')),
                ('audit_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='leave_field_approvalTime')),
                ('approval_level', models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='leave_field_approvalLevel')),
                ('audit_user_id', models.IntegerField(blank=True, editable=False, null=True, verbose_name='leave_field_approver')),
                ('approver', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='leave_field_approver')),
                ('day_type', models.SmallIntegerField(blank=True, choices=[(1, 'Full Day'), (2, 'First Half'), (3, 'Second Half')], null=True, verbose_name='leave_field_day_type')),
                ('days', models.FloatField(blank=True, null=True, verbose_name='leave_field_day_type')),
                ('leave_payment_type', models.SmallIntegerField(blank=True, choices=[(0, 'Paid Leave'), (1, 'Unpaid Leave')], null=True, verbose_name='staff_leave_leaveType')),
                ('leave_schedule', models.TextField(blank=True, null=True)),
                ('revoke_type', models.CharField(default='n', max_length=1)),
                ('leave_applied_data', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'att_model_leave',
                'verbose_name_plural': 'att_model_leave',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
            bases=('workflow.abstractexception',),
        ),
        migrations.CreateModel(
            name='LeaveCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category_name', models.CharField(max_length=50, verbose_name='leaveCategory_field_name')),
                ('minimum_unit', models.FloatField(default=1.0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='leaveCategory_field_minimumUnit')),
                ('unit', models.SmallIntegerField(choices=[(1, 'calculationUnit_option_minute'), (2, 'calculationUnit_option_hour'), (3, 'calculationUnit_option_workday'), (4, 'calculationUnit_option_minuteFormat')], default=2, verbose_name='leaveCategory_field_unit')),
                ('round_off', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=1, verbose_name='leaveCategory_field_roundOff')),
                ('report_symbol', models.CharField(max_length=5, verbose_name='leaveCategory_field_reportSymbol')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'att_model_leaveCategory',
                'verbose_name_plural': 'att_model_leaveCategory',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='LeaveSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('leave_details', models.TextField(blank=True, null=True, verbose_name='att_model_leavedetails')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='leave_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_leaveSchedule',
                'verbose_name_plural': 'att_model_leaveSchedule',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='LeaveSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('allotment_type', models.SmallIntegerField(choices=[(0, 'Yearly'), (1, 'Monthly')], default=0, verbose_name='att_model_allotmenttype')),
                ('effective_date', models.DateField(default=django.utils.timezone.now, verbose_name='att_model_effectivedate')),
                ('increment_date', models.DateField(blank=True, null=True, verbose_name='att_model_incrementdate')),
                ('days', models.FloatField(default=0, verbose_name='att_model_days')),
                ('max_leave_per_month', models.FloatField(blank=True, default=0, max_length=2, verbose_name='att_model_maxleave')),
                ('leave_balance', models.FloatField(default=0, verbose_name='att_model_leaveballance')),
                ('carry_forward_limit', models.FloatField(default=0, verbose_name='att_model_carryforward')),
                ('auto_deduct', models.SmallIntegerField(choices=[(0, 'YES'), (1, 'NO')], default=0, verbose_name='att_model_autoincrement')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='tempSchedule_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_leavesettings',
                'verbose_name_plural': 'att_model_leavesettings',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='ManualLog',
            fields=[
                ('abstractexception_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='workflow.AbstractException')),
                ('punch_time', models.DateTimeField(verbose_name='manualLog_field_punchTime')),
                ('punch_state', models.IntegerField(choices=[(0, 'punchState_option_checkIn'), (1, 'punchState_option_checkOut'), (2, 'punchState_option_breakOut'), (3, 'punchState_option_breakIn'), (4, 'punchState_option_overtimeIn'), (5, 'punchState_option_overtimeOut'), (255, 'punchState_option_noStatus')], verbose_name='manualLog_field_punchState')),
                ('work_code', models.CharField(blank=True, max_length=20, null=True, verbose_name='manualLog_field_workCode')),
                ('apply_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='manualLog_field_applyReason')),
                ('apply_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='manualLog_field_applyTime')),
                ('audit_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='manualLog_field_approvalRemark')),
                ('audit_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='manualLog_field_approvalTime')),
                ('approval_level', models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='manualLog_field_approvalLevel')),
                ('audit_user_id', models.IntegerField(blank=True, editable=False, null=True, verbose_name='manualLog_field_approver')),
                ('approver', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='manualLog_field_approver')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='manualLog_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_manualLog',
                'verbose_name_plural': 'att_model_manualLog',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
            bases=('workflow.abstractexception',),
        ),
        migrations.CreateModel(
            name='OutdoorEmployeeSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(verbose_name='scheduleEmp_field_startTime')),
                ('end_date', models.DateField(verbose_name='scheduleEmp_field_endTime')),
                ('assigned_by', models.CharField(blank=True, max_length=55, null=True)),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='scheduleEmp_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_scheduleEmployee',
                'verbose_name_plural': 'att_model_scheduleEmployee',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='OutdoorSchedulePlanner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('schedule_name', models.CharField(max_length=55, verbose_name='SchedulePlanner_field_scheduleName')),
                ('schedule_details', models.TextField(blank=True, null=True, verbose_name='SchedulePlanner_field_dates')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'att_model_schedulePlanner',
                'verbose_name_plural': 'att_model_schedulePlanner',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='OutdoorTrack',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('schedule_type', models.SmallIntegerField(choices=[(0, 'Schedule'), (1, 'Un-Schedule')], default=0, verbose_name='outdoorTrack_field_schedule_type')),
                ('date', models.DateField(default=django.utils.timezone.now)),
                ('checkin', models.TimeField(null=True, verbose_name='outdoorTrack_field_checkin')),
                ('checkout', models.TimeField(null=True, verbose_name='outdoorTrack_field_checkout')),
                ('checkin_latitude', models.FloatField(null=True, verbose_name='outdoorTrack_field_checkin_latitude')),
                ('checkout_latitude', models.FloatField(null=True, verbose_name='outdoorTrack_field_checkout_latitude')),
                ('checkin_longitude', models.FloatField(null=True, verbose_name='outdoorTrack_field_checkin_longitude')),
                ('checkout_longitude', models.FloatField(null=True, verbose_name='outdoorTrack_field_checkout_longitude')),
                ('checkin_capture', models.TextField(null=True)),
                ('checkout_capture', models.TextField(null=True)),
                ('summary', models.TextField(null=True)),
                ('client', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.ClientDetails')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='scheduleEmp_field_employee')),
                ('schedule', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.OutdoorSchedulePlanner')),
            ],
            options={
                'verbose_name': 'att_model_OutdoorTrack',
                'verbose_name_plural': 'att_model_OutdoorTrack',
                'default_permissions': ('add', 'delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='Overtime',
            fields=[
                ('abstractexception_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='workflow.AbstractException')),
                ('overtime_type', models.SmallIntegerField(choices=[(1, 'overtime_option_normalOvertime'), (2, 'overtime_option_weekendOvertime'), (3, 'overtime_option_holidayOvertime')], default=1, verbose_name='overtime_field_overtimeType')),
                ('start_time', models.DateTimeField(verbose_name='overtime_field_startTime')),
                ('end_time', models.DateTimeField(verbose_name='overtime_field_endTime')),
                ('apply_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='overtime_field_applyReason')),
                ('apply_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='overtime_field_applyTime')),
                ('audit_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='overtime_field_approvalReason')),
                ('audit_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='overtime_field_approvalTime')),
                ('approval_level', models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='overtime_field_approvalLevel')),
                ('audit_user_id', models.IntegerField(blank=True, editable=False, null=True, verbose_name='overtime_field_approver')),
                ('approver', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='overtime_field_approver')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='overtime_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_overtime',
                'verbose_name_plural': 'att_model_overtime',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
            bases=('workflow.abstractexception',),
        ),
        migrations.CreateModel(
            name='PayloadBase',
            fields=[
                ('uuid', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                ('att_date', models.DateField(blank=True, null=True, verbose_name='report_column_attendanceDate')),
                ('weekday', models.SmallIntegerField(blank=True, choices=[(0, 'weekday_option_monday'), (1, 'weekday_option_tuesday'), (2, 'weekday_option_wednesday'), (3, 'weekday_option_thursday'), (4, 'weekday_option_friday'), (5, 'weekday_option_saturday'), (6, 'weekday_option_sunday')], default=0, null=True)),
                ('check_in', models.DateTimeField(blank=True, null=True, verbose_name='report_column_checkInTime')),
                ('check_out', models.DateTimeField(blank=True, null=True, verbose_name='report_column_checkOutTime')),
                ('duration', models.IntegerField(blank=True, default=0, null=True)),
                ('duty_duration', models.IntegerField(blank=True, default=0, null=True)),
                ('work_day', models.FloatField(default=1.0)),
                ('clock_in', models.DateTimeField(blank=True, null=True, verbose_name='report_column_clockInTime')),
                ('clock_out', models.DateTimeField(blank=True, null=True, verbose_name='report_column_clockOutTime')),
                ('total_time', models.IntegerField(blank=True, default=0, null=True)),
                ('half_day', models.IntegerField(blank=True, default=0, null=True)),
                ('duty_worked', models.IntegerField(blank=True, default=0, null=True)),
                ('actual_worked', models.IntegerField(blank=True, default=0, null=True)),
                ('unscheduled', models.IntegerField(blank=True, default=0, null=True)),
                ('remaining', models.IntegerField(blank=True, default=0, null=True)),
                ('total_worked', models.IntegerField(blank=True, default=0, help_text='Duty Worked + OT', null=True)),
                ('late', models.IntegerField(blank=True, default=0, null=True)),
                ('early_leave', models.IntegerField(blank=True, default=0, null=True)),
                ('short', models.IntegerField(blank=True, default=0, null=True)),
                ('absent', models.IntegerField(blank=True, default=0, null=True)),
                ('leave', models.IntegerField(blank=True, default=0, null=True)),
                ('exception', models.CharField(blank=True, default='', max_length=50, null=True)),
                ('day_off', models.SmallIntegerField(default=0)),
            ],
        ),
        migrations.CreateModel(
            name='PayloadBreak',
            fields=[
                ('uuid', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                ('break_out', models.DateTimeField(blank=True, help_text='Valid break-out', null=True)),
                ('break_in', models.DateTimeField(blank=True, help_text='Valid break-in', null=True)),
                ('duration', models.IntegerField(blank=True, default=0, help_text='The duration of break time', null=True)),
                ('taken', models.IntegerField(blank=True, default=0, help_text='break-in - break-out', null=True)),
                ('actual_duration', models.IntegerField(blank=True, default=0, null=True)),
                ('early_in', models.IntegerField(blank=True, default=0, help_text='Duration - Taken Duration', null=True)),
                ('late_in', models.IntegerField(blank=True, default=0, help_text='Taken Duration - Duration', null=True)),
                ('late', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('early_leave', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('absent', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('work_time', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('overtime', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('weekend_ot', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
                ('holiday_ot', models.IntegerField(blank=True, default=0, help_text='For non auto deduct setting', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PayloadException',
            fields=[
                ('uuid', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                ('start_time', models.DateTimeField()),
                ('end_time', models.DateTimeField()),
                ('duration', models.IntegerField(blank=True, default=0, null=True)),
                ('days', models.FloatField(blank=True, default=0, null=True)),
                ('data_type', models.SmallIntegerField()),
                ('description', models.CharField(blank=True, max_length=50, null=True)),
                ('item', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.Leave')),
                ('skd', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.PayloadBase')),
            ],
        ),
        migrations.CreateModel(
            name='PayloadMulPunchSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('att_date', models.DateField()),
                ('weekday', models.SmallIntegerField(blank=True, choices=[(0, 'weekday_option_monday'), (1, 'weekday_option_tuesday'), (2, 'weekday_option_wednesday'), (3, 'weekday_option_thursday'), (4, 'weekday_option_friday'), (5, 'weekday_option_saturday'), (6, 'weekday_option_sunday')], null=True)),
                ('data_index', models.SmallIntegerField(default=1)),
                ('clock_in', models.DateTimeField(blank=True, null=True)),
                ('in_id', models.IntegerField(blank=True, null=True)),
                ('clock_out', models.DateTimeField(blank=True, null=True)),
                ('out_id', models.IntegerField(blank=True, null=True)),
                ('total_time', models.IntegerField(blank=True, null=True)),
                ('worked_time', models.IntegerField(blank=True, null=True)),
                ('data_type', models.SmallIntegerField(choices=[(1, 'mulTransaction_field_dataType_normalPunch'), (2, 'mulTransaction_field_dataType_breakTime')], default=1)),
                ('emp', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee')),
            ],
        ),
        migrations.CreateModel(
            name='PayloadOvertime',
            fields=[
                ('uuid', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                ('normal_wt', models.IntegerField(blank=True, default=0, help_text='Normal Work Time', null=True)),
                ('normal_ot', models.IntegerField(blank=True, default=0, help_text='Normal Overtime', null=True)),
                ('weekend_ot', models.IntegerField(blank=True, default=0, help_text='Weekend Overtime', null=True)),
                ('holiday_ot', models.IntegerField(blank=True, default=0, help_text='Holiday Overtime', null=True)),
                ('ot_lv1', models.IntegerField(blank=True, default=0, help_text='Overtime Level 1', null=True)),
                ('ot_lv2', models.IntegerField(blank=True, default=0, help_text='Overtime Level 2', null=True)),
                ('ot_lv3', models.IntegerField(blank=True, default=0, help_text='Overtime Level 3', null=True)),
                ('total_ot', models.IntegerField(blank=True, default=0, help_text='Total Overtime', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='PayloadPunch',
            fields=[
                ('uuid', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                ('att_date', models.DateField(blank=True, null=True)),
                ('correct_state', models.CharField(blank=True, choices=[('I', 'transaction_punchState_checkIn'), ('O', 'transaction_punchState_checkOut'), ('0', 'transaction_punchState_checkIn'), ('1', 'transaction_punchState_checkOut'), ('2', 'transaction_punchState_breakOut'), ('3', 'transaction_punchState_breakIn'), ('4', 'transaction_punchState_overtimeIn'), ('5', 'transaction_punchState_overtimeOut'), ('255', 'transaction_punchState_noStatus')], max_length=3, null=True)),
                ('emp', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee')),
                ('orig', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='iclock.Transaction')),
                ('skd', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.PayloadBase')),
            ],
        ),
        migrations.CreateModel(
            name='ReportParam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('param_name', models.CharField(max_length=20, verbose_name='reportParam_field_name')),
                ('param_value', models.TextField(verbose_name='reportParam_field_value')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'att_model_reportParameter',
                'verbose_name_plural': 'att_model_reportParameter',
                'ordering': ['param_name'],
            },
        ),
        migrations.CreateModel(
            name='ShiftDetail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('in_time', models.TimeField(default='09:00:00', verbose_name='shiftDetail_field_inTime')),
                ('out_time', models.TimeField(default='18:00:00', verbose_name='shiftDetail_field_outTime')),
                ('day_index', models.IntegerField(verbose_name='shiftDetail_field_dayIndex')),
                ('shift', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.AttShift', verbose_name='shiftDetail_field_shift')),
            ],
            options={
                'verbose_name': 'att_model_shiftDetail',
                'verbose_name_plural': 'att_model_shiftDetail',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='TempSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField(verbose_name='tempSchedule_field_startTime')),
                ('end_time', models.DateTimeField(verbose_name='tempSchedule_field_endTime')),
                ('rule_flag', models.SmallIntegerField(choices=[(1, 'tempSchedule_ruleFlagOption_activateTempSchedule'), (2, 'tempSchedule_ruleFlagOption_addAdditionalTempSchedule')], default=1, verbose_name='tempSchedule_field_rule')),
                ('work_type', models.SmallIntegerField(choices=[(0, 'tempSchedule_workTypeOption_normalWork'), (1, 'tempSchedule_workTypeOption_normalOvertime'), (2, 'tempSchedule_workTypeOption_weekendOvertime'), (3, 'tempSchedule_workTypeOption_holidayOvertime')], default=0, verbose_name='tempSchedule_field_workType')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='tempSchedule_field_employee')),
            ],
            options={
                'verbose_name': 'att_model_tempSchedule',
                'verbose_name_plural': 'att_model_tempSchedule',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='TimeInterval',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(max_length=50, verbose_name='timeInterval_field_alias')),
                ('use_mode', models.SmallIntegerField(choices=[(0, 'timeInterval_typeOption_normal'), (1, 'timeInterval_typeOption_flexible')], default=0, verbose_name='timeInterval_field_type')),
                ('in_time', models.TimeField(default='09:00:00', verbose_name='timeInterval_field_checkIn')),
                ('in_ahead_margin', models.IntegerField(default=60, verbose_name='timeInterval_field_inAheadMargin')),
                ('in_above_margin', models.IntegerField(default=60, verbose_name='timeInterval_field_inAboveMargin')),
                ('out_ahead_margin', models.IntegerField(default=60, verbose_name='timeInterval_field_outAheadMargin')),
                ('out_above_margin', models.IntegerField(default=60, verbose_name='timeInterval_field_outAboveMargin')),
                ('duration', models.IntegerField(default=480, help_text='time_unit_minute', verbose_name='timeInterval_field_attendanceDuration')),
                ('in_required', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=1, verbose_name='timeInterval_field_inRequired')),
                ('out_required', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=1, verbose_name='timeInterval_field_outRequired')),
                ('allow_late', models.PositiveIntegerField(default=0, help_text='time_unit_minute', verbose_name='timeInterval_field_allowLate')),
                ('allow_leave_early', models.PositiveIntegerField(default=0, help_text='time_unit_minute', verbose_name='timeInterval_field_allowLeaveEarly')),
                ('work_day', models.FloatField(default=1.0, help_text='time_unit_day', verbose_name='timeInterval_field_paidDay')),
                ('early_in', models.SmallIntegerField(choices=[(0, 'unscheduled_ignore'), (1, 'unscheduled_move2normalWork'), (2, 'unscheduled_move2normalOvertime'), (3, 'unscheduled_move2weekendOvertime'), (4, 'unscheduled_move2holidayOvertime')], default=0, verbose_name='timeInterval_field_earlyIn')),
                ('min_early_in', models.IntegerField(default=60, help_text='time_unit_minute', validators=[django.core.validators.MinValueValidator(0)], verbose_name='timeInterval_field_minEarlyIn')),
                ('late_out', models.SmallIntegerField(choices=[(0, 'unscheduled_ignore'), (1, 'unscheduled_move2normalWork'), (2, 'unscheduled_move2normalOvertime'), (3, 'unscheduled_move2weekendOvertime'), (4, 'unscheduled_move2holidayOvertime')], default=0, verbose_name='timeInterval_field_lateOut')),
                ('min_late_out', models.IntegerField(default=60, help_text='time_unit_minute', validators=[django.core.validators.MinValueValidator(0)], verbose_name='timeInterval_field_minLateOut')),
                ('overtime_lv', models.SmallIntegerField(choices=[(0, 'overtimeLevel_ignore'), (1, 'overtimeLevel_dependsOnWorkTime'), (2, 'overtimeLevel_dependsOnOvertime')], default=0, verbose_name='timeInterval_field_overtimeLevel')),
                ('overtime_lv1', models.SmallIntegerField(default=0, help_text='time_unit_hour', verbose_name='timeInterval_field_overtimeLevel1')),
                ('overtime_lv2', models.SmallIntegerField(default=0, help_text='time_unit_hour', verbose_name='timeInterval_field_overtimeLevel2')),
                ('overtime_lv3', models.SmallIntegerField(default=0, help_text='time_unit_hour', verbose_name='timeInterval_field_overtimeLevel3')),
                ('multiple_punch', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='timeInterval_field_useMultiplePunch')),
                ('available_interval_type', models.SmallIntegerField(choices=[(0, 'timeInterval_typeOption_basedOnRule'), (1, 'timeInterval_typeOption_userDefined')], default=0, verbose_name='timeInterval_field_availablePunchIntervalType')),
                ('available_interval', models.IntegerField(default=1, help_text='time_unit_minute', validators=[django.core.validators.MinValueValidator(0)], verbose_name='timeInterval_field_duplicatePunchPeriod')),
                ('work_time_duration', models.IntegerField(default=0, help_text='timeInterval_field_workTimeDurationHelpTxt', verbose_name='timeInterval_field_workTimeDuration')),
                ('func_key', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='timeInterval_field_baseOnPunchType')),
                ('work_type', models.SmallIntegerField(choices=[(0, 'timeInterval_workTypeOption_normalWork'), (1, 'timeInterval_workTypeOption_dayOff'), (2, 'timeInterval_workTypeOption_weekend')], default=0, verbose_name='timeInterval_field_workType')),
                ('day_change', models.TimeField(default=datetime.time(0, 0), verbose_name='timeInterval_field_dayChange')),
                ('first_half_out_time', models.TimeField(default='13:00:00', verbose_name='timeInterval_field_firstHalfOutTime')),
                ('second_half_in_time', models.TimeField(default='14:00:00', verbose_name='timeInterval_field_secondHalfInTime')),
                ('break_time', mysite.att.models.model_breaktime.BreakTimeManyToManyField(blank=True, to='att.BreakTime', verbose_name='timeInterval_field_breakTime')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'att_model_timeInterval',
                'verbose_name_plural': 'att_model_timeInterval',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='Training',
            fields=[
                ('abstractexception_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='workflow.AbstractException')),
                ('start_time', models.DateTimeField(verbose_name='training_field_startTime')),
                ('end_time', models.DateTimeField(verbose_name='training_field_endTime')),
                ('apply_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='training_field_applyReason')),
                ('apply_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='training_field_applyTime')),
                ('audit_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='training_field_approvalRemark')),
                ('audit_time', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='training_field_approvalTime')),
                ('approval_level', models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='training_field_approvalLevel')),
                ('audit_user_id', models.IntegerField(blank=True, editable=False, null=True, verbose_name='training_field_approver')),
                ('approver', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='training_field_approver')),
            ],
            options={
                'verbose_name': 'att_model_training',
                'verbose_name_plural': 'att_model_training',
                'ordering': ['id'],
            },
            bases=('workflow.abstractexception',),
        ),
        migrations.CreateModel(
            name='TrainingCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category_name', models.CharField(max_length=50, verbose_name='training_name')),
                ('minimum_unit', models.FloatField(default=1.0, validators=[django.core.validators.MinValueValidator(0)], verbose_name='minimum_unit')),
                ('unit', models.SmallIntegerField(choices=[(1, 'calculationUnit_option_hour'), (2, 'calculationUnit_option_minute'), (3, 'calculationUnit_option_workday'), (4, 'calculationUnit_option_minuteFormat')], default=1, verbose_name='unit')),
                ('round_off', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=1, verbose_name='round_off')),
                ('report_symbol', models.CharField(max_length=5, unique=True, verbose_name='report_symbol')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'training_category',
                'verbose_name_plural': 'training_category',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='AttSettingPermission',
            fields=[
            ],
            options={
                'verbose_name': 'Att Setting Permission',
                'verbose_name_plural': 'Att Setting Permissions',
                'proxy': True,
                'indexes': [],
            },
            bases=('base.abstractpermission',),
            managers=[
                ('objects', mysite.base.models.modelless.AttSettingPermissionManager()),
            ],
        ),
        migrations.CreateModel(
            name='ReportPermission',
            fields=[
            ],
            options={
                'verbose_name': 'Report Permission',
                'verbose_name_plural': 'Report Permissions',
                'proxy': True,
                'indexes': [],
            },
            bases=('base.abstractpermission',),
            managers=[
                ('objects', mysite.base.models.modelless.ReportPermissionManager()),
            ],
        ),
        migrations.AddField(
            model_name='training',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.TrainingCategory', verbose_name='training_field_trainingCategory'),
        ),
        migrations.AddField(
            model_name='training',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='training_field_employee'),
        ),
        migrations.AddField(
            model_name='tempschedule',
            name='time_interval',
            field=models.ForeignKey(blank=True, db_constraint=False, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.TimeInterval', verbose_name='tempSchedule_field_timeIntervalID'),
        ),
        migrations.AddField(
            model_name='shiftdetail',
            name='time_interval',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.TimeInterval', verbose_name='shiftDetail_field_timeInterval'),
        ),
        migrations.AddField(
            model_name='payloadmulpunchset',
            name='timetable',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.TimeInterval'),
        ),
        migrations.AddField(
            model_name='payloadbase',
            name='break_time',
            field=models.OneToOneField(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='att.PayloadBreak'),
        ),
        migrations.AddField(
            model_name='payloadbase',
            name='emp',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee'),
        ),
        migrations.AddField(
            model_name='payloadbase',
            name='overtime',
            field=models.OneToOneField(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='att.PayloadOvertime'),
        ),
        migrations.AddField(
            model_name='payloadbase',
            name='timetable',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='att.TimeInterval'),
        ),
        migrations.AddField(
            model_name='outdooremployeeschedule',
            name='schedule_planner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.OutdoorSchedulePlanner', verbose_name='scheduleEmp_field_schedulePlanner'),
        ),
        migrations.AddField(
            model_name='leave',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.LeaveCategory', verbose_name='leaveCategory'),
        ),
        migrations.AddField(
            model_name='leave',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='leave_field_employee'),
        ),
        migrations.AddField(
            model_name='changeschedule',
            name='timeinterval',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='att.TimeInterval', verbose_name='changeSchedule_field_adjustTimeInterval'),
        ),
        migrations.AddField(
            model_name='breaktime',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='attshift',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='attschedule',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='schedule_field_employee'),
        ),
        migrations.AddField(
            model_name='attschedule',
            name='shift',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, to='att.AttShift', verbose_name='schedule_field_shift'),
        ),
        migrations.AddField(
            model_name='attrule',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='attreportsetting',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AlterUniqueTogether(
            name='breaktime',
            unique_together=set([('alias',)]),
        ),
    ]
