# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-05-14 10:03
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mysite.admin.abstract_cloud_model


class Migration(migrations.Migration):

    dependencies = [
        ('personnel', '0011_auto_20200401_0954'),
        ('payroll', '0005_auto_20200417_1547'),
    ]

    operations = [
        migrations.CreateModel(
            name='AllowanceType',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('allowance_code', models.CharField(max_length=25, verbose_name='allowance_field_code')),
                ('allowance_name', models.CharField(max_length=25, verbose_name='allowance_filed_name')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'payroll_model_allowancetype',
                'verbose_name_plural': 'payroll_model_allowancetype',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='PurposeType',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('purpose_code', models.CharField(max_length=25, verbose_name='purpose_field_code')),
                ('purpose_name', models.CharField(max_length=255, verbose_name='purpose_filed_name')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'payroll_model_purposetype',
                'verbose_name_plural': 'payroll_model_purposetype',
                'ordering': ['id'],
            },
        ),
        migrations.AlterModelOptions(
            name='reimbursement',
            options={'default_permissions': ('delete', 'change', 'view'), 'verbose_name': 'payroll_model_Reimbursement', 'verbose_name_plural': 'payroll_model_Reimbursement'},
        ),
        migrations.RemoveField(
            model_name='reimbursement',
            name='rmb_time',
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='additional_employee',
            field=models.CharField(blank=True, max_length=1048, null=True, verbose_name='payroll_model_additional_employee'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='apply_time',
            field=models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='reimbursement_field_applyTime'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='approval_level',
            field=models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='reimbursement_field_approvalLevel'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='approver',
            field=models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='reimbursement_field_approver'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='audit_reason',
            field=models.TextField(blank=True, max_length=200, null=True, verbose_name='reimbursement_field_approvalRemark'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='audit_status',
            field=models.SmallIntegerField(choices=[(1, 'approvalStatus_option_pending'), (6, 'approvalStatus_option_revoke'), (2, 'approvalStatus_option_approved'), (3, 'approvalStatus_option_reject')], default=1, editable=False, verbose_name='approval_field_approvalStatus'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='audit_time',
            field=models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='reimbursement_field_approvalTime'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='audit_user_id',
            field=models.IntegerField(blank=True, editable=False, null=True, verbose_name='reimbursement_field_approver'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='revoke_reason',
            field=models.TextField(blank=True, max_length=200, null=True, verbose_name='workflow_field_revokeRemark'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='rmb_end_date',
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name='Reimbursement_field_end_date'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='rmb_start_date',
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name='Reimbursement_field_start_date'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='allowance_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='payroll.AllowanceType', verbose_name='payroll_model_allowancetype'),
        ),
        migrations.AddField(
            model_name='reimbursement',
            name='purpose_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='payroll.PurposeType', verbose_name='payroll_model_purposetype'),
        ),
    ]
