# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import datetime
import django.core.files.storage
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import django_countries.fields
import mysite.admin.abstract_cloud_model
import mysite.admin.fields
import mysite.personnel.fields
import mysite.personnel.models.model_employee
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Area',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('area_code', models.CharField(max_length=100, verbose_name='area_field_code')),
                ('area_name', models.CharField(max_length=120, verbose_name='area_field_name')),
                ('is_default', models.BooleanField(default=False, verbose_name='area_field_isDefault')),
            ],
            options={
                'verbose_name': 'psnl_model_area',
                'verbose_name_plural': 'psnl_model_area',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Certification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cert_code', models.CharField(max_length=20, unique=True, verbose_name='certification_field_code')),
                ('cert_name', models.CharField(max_length=50, unique=True, verbose_name='certification_field_name')),
            ],
            options={
                'verbose_name': 'psnl_model_certification',
                'verbose_name_plural': 'psnl_model_certification',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid1, primary_key=True, serialize=False, verbose_name='company_field_id')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='company_field_name')),
                ('sub_domain', models.URLField(max_length=50, verbose_name='company_field_sub_domain')),
                ('address_1', models.CharField(max_length=50, verbose_name='company_field_address_1')),
                ('country', django_countries.fields.CountryField(max_length=2, verbose_name='company_field_country')),
                ('city', models.CharField(max_length=100, verbose_name='company_field_city')),
                ('payment_type', models.IntegerField(choices=[(1, 'PayTM'), (2, 'PayPal'), (3, 'Others')], verbose_name='company_field_payment_type')),
                ('subscription_start_date', models.DateTimeField()),
                ('subscription_end_date', models.DateTimeField()),
                ('max_employees_limit', models.IntegerField()),
                ('company_address', models.CharField(blank=True, max_length=50, null=True, verbose_name='company_field_company_address')),
                ('company_phone', models.CharField(blank=True, max_length=20, null=True, verbose_name='company_field_company_phone')),
                ('company_cnr', models.CharField(blank=True, max_length=50, null=True, verbose_name='company_field_company_cnr')),
                ('owner_name', models.CharField(blank=True, max_length=20, null=True, verbose_name='company_field_owner_name')),
                ('owner_phone', models.CharField(blank=True, max_length=20, null=True, verbose_name='company_field_owner_phone')),
                ('contact_name', models.CharField(blank=True, max_length=20, null=True, verbose_name='company_field_contact_name)')),
                ('contact_phone', models.CharField(blank=True, max_length=20, null=True, verbose_name='company_field_contact_phone')),
                ('business_type', models.CharField(blank=True, max_length=5, null=True, verbose_name='company_field_business_type')),
                ('parent_vendor', models.CharField(blank=True, max_length=36, null=True, verbose_name='company_field_parent_vendor')),
            ],
            options={
                'verbose_name': 'psnl_model_company',
                'verbose_name_plural': 'psnl_model_company',
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('dept_code', models.CharField(max_length=50, verbose_name='department_field_code')),
                ('dept_name', models.CharField(max_length=100, verbose_name='department_filed_name')),
                ('is_default', models.BooleanField(default=False, verbose_name='department_field_isDefault')),
            ],
            options={
                'verbose_name': 'psnl_model_department',
                'verbose_name_plural': 'psnl_model_department',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('id', models.CharField(default=uuid.uuid1, editable=False, max_length=36, primary_key=True, serialize=False)),
                ('emp_code', models.CharField(max_length=20, verbose_name='emp_field_employeeCode')),
                ('first_name', models.CharField(max_length=100, null=True, verbose_name='emp_field_firstName')),
                ('last_name', models.CharField(max_length=25, null=True, verbose_name='emp_field_lastName')),
                ('nickname', models.CharField(blank=True, max_length=100, null=True, verbose_name='emp_field_localizedName')),
                ('passport', models.CharField(blank=True, max_length=30, null=True, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z]*$')], verbose_name='emp_field_passport_number')),
                ('driver_license_automobile', models.CharField(blank=True, max_length=30, null=True, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z]*$')], verbose_name='emp_field_driver_license_automobile')),
                ('driver_license_motorcycle', models.CharField(blank=True, max_length=30, null=True, validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z]*$')], verbose_name='emp_field_driver_license_motorcycle')),
                ('enable_outdoor_management', models.SmallIntegerField(blank=True, choices=[(0, 'Disable'), (1, 'Enable')], default=0, null=True, verbose_name='emp_field_outdoor_management')),
                ('photo', models.ImageField(blank=True, max_length=200, null=True, storage=django.core.files.storage.FileSystemStorage(location='F:\\easytimepro\\master/files/'), upload_to=mysite.personnel.models.model_employee.upload_path_handler, verbose_name='emp_field_photo')),
                ('self_password', mysite.admin.fields.PasswordField(blank=True, default='pbkdf2_sha256$36000$Gj09deAAUqW7$ih9vyun8PPwxvbG1+bhxB0TIQF+2IUfdhiDUf0AS0o4=', max_length=128, null=True, verbose_name='emp_field_selfPassword')),
                ('device_password', models.CharField(blank=True, max_length=20, null=True, validators=[django.core.validators.RegexValidator('^[0-9]*$')], verbose_name='emp_field_devicePassword')),
                ('dev_privilege', models.IntegerField(blank=True, choices=[(0, 'devicePrivilege_option_employee'), (2, 'devicePrivilege_option_registrar'), (6, 'devicePrivilege_option_systemAdministrator'), (14, 'devicePrivilege_option_superAdministrator')], default=0, null=True, verbose_name='emp_field_devicePrivilege')),
                ('card_no', models.CharField(blank=True, max_length=20, null=True, validators=[django.core.validators.RegexValidator('^[0-9]*$')], verbose_name='emp_field_cardNumber')),
                ('acc_group', models.CharField(blank=True, max_length=5, null=True, verbose_name='emp_field_accessGroup')),
                ('acc_timezone', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_accessTimezone')),
                ('gender', models.CharField(blank=True, choices=[('M', 'employee_genderOption_male'), ('F', 'employee_genderOption_female')], max_length=1, null=True, verbose_name='emp_field_gender')),
                ('birthday', models.DateField(blank=True, default=datetime.date.today, null=True, verbose_name='emp_field_birthday')),
                ('address', models.CharField(blank=True, max_length=200, null=True, verbose_name='emp_field_address')),
                ('postcode', models.CharField(blank=True, max_length=10, null=True, validators=[django.core.validators.RegexValidator('^[0-9]*$')], verbose_name='emp_field_postcode')),
                ('office_tel', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_officeTel')),
                ('contact_tel', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_contactTel')),
                ('mobile', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_mobile')),
                ('national', models.CharField(blank=True, max_length=50, null=True, validators=[django.core.validators.RegexValidator('^[a-zA-Z]*$')], verbose_name='emp_field_national')),
                ('religion', models.CharField(blank=True, max_length=20, null=True, validators=[django.core.validators.RegexValidator('^[a-zA-Z]*$')], verbose_name='emp_field_religion')),
                ('title', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_title')),
                ('enroll_sn', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_enrollSN')),
                ('ssn', models.CharField(blank=True, max_length=20, null=True, validators=[django.core.validators.RegexValidator('^[0-9]*$')], verbose_name='emp_field_SSN')),
                ('update_time', models.DateTimeField(blank=True, default=django.utils.timezone.now, editable=False, null=True, verbose_name='emp_field_updateTime')),
                ('hire_date', models.DateField(blank=True, default=datetime.date.today, null=True, verbose_name='emp_field_hireDate')),
                ('verify_mode', models.IntegerField(blank=True, choices=[(-1, 'employee_verificationOption_applyGroupMode'), (0, 'employee_verificationOption_any'), (1, 'employee_verificationOption_fingerprintOnly'), (2, 'employee_verificationOption_userIDOnly'), (3, 'employee_verificationOption_password'), (4, 'employee_verificationOption_badgeOnly'), (5, 'employee_verificationOption_fingerprintOrPassword'), (6, 'employee_verificationOption_fingerprintOrBadge'), (7, 'employee_verificationOption_passwordOrBadge'), (8, 'employee_verificationOption_userIDAndFingerprint'), (9, 'employee_verificationOption_fingerprintAndPassword'), (10, 'employee_verificationOption_fingerprintAndBadge'), (11, 'employee_verificationOption_fingerprintAndPasswordAndBadge'), (12, 'employee_verificationOption_passwordAndBadge'), (13, 'employee_verificationOption_userIDAndFingerprintPassword'), (14, 'employee_verificationOption_fingerprintAndBadgeOrUserID'), (15, 'employee_verificationOption_faceOnly'), (16, 'employee_verificationOption_faceAndFingerprint'), (17, 'employee_verificationOption_faceAndPassword'), (18, 'employee_verificationOption_faceAndCard'), (19, 'employee_verificationOption_faceAndFingerprintAndCard'), (20, 'employee_verificationOption_faceAndFingerprintAndPassword'), (21, 'employee_verificationOption_fingerVein'), (22, 'employee_verificationOption_fingerVeinAndPassword'), (23, 'employee_verificationOption_fingerVeinAndCard'), (24, 'employee_verificationOption_fingerVeinAndPasswordAndCard'), (25, 'employee_verificationOption_palm'), (26, 'employee_verificationOption_palmAndCard'), (27, 'employee_verificationOption_palmAndFace'), (28, 'employee_verificationOption_palmAndFingerprint'), (29, 'employee_verificationOption_palmAndFingerprintAndFace')], default=0, null=True, verbose_name='emp_field_verifyMode')),
                ('city', models.CharField(blank=True, max_length=20, null=True, validators=[django.core.validators.RegexValidator('^[a-zA-Z]*$')], verbose_name='emp_field_city')),
                ('is_admin', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_isAdmin')),
                ('emp_type', models.IntegerField(blank=True, choices=[(1, 'employee_employmentStatusOption_permanent'), (2, 'employee_employmentStatusOption_temporary')], null=True, verbose_name='emp_field_type')),
                ('enable_att', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=True, verbose_name='emp_field_enableAtt')),
                ('enable_payroll', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=True, verbose_name='emp_field_enablePayroll')),
                ('enable_overtime', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_enableOvertime')),
                ('enable_holiday', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=True, verbose_name='emp_field_enableHoliday')),
                ('enable_whatsapp', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_enableWhatsapp')),
                ('whatsapp_exception', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_whatsapp_exception')),
                ('whatsapp_punch', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_whatsapp_punch')),
                ('deleted', models.BooleanField(default=False, editable=False, verbose_name='deleted')),
                ('reserved', models.IntegerField(blank=True, default=0, editable=False, null=True, verbose_name='reserved')),
                ('del_tag', models.IntegerField(blank=True, default=0, editable=False, null=True, verbose_name='del_tag')),
                ('app_status', models.SmallIntegerField(blank=True, choices=[(1, 'employee_appStatusOption_enable'), (0, 'employee_appStatusOption_disable')], default=0, null=True, verbose_name='emp_field_appStatus')),
                ('app_role', models.SmallIntegerField(blank=True, choices=[(1, 'employee_appRoleOption_employee'), (2, 'employee_appRoleOption_administrator')], default=1, null=True, verbose_name='emp_field_appRole')),
                ('email', models.EmailField(blank=True, max_length=50, null=True, verbose_name='emp_field_email')),
                ('enable_sms', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_enable_sms')),
                ('sms_exception', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_sms_exception')),
                ('sms_punch', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='emp_field_sms_punch')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='emp_field_lastLogin')),
                ('is_active', models.BooleanField(default=True, editable=False, verbose_name='emp_field_isActive')),
                ('area', mysite.personnel.fields.AreaManyToManyField(to='personnel.Area', verbose_name='emp_field_area')),
            ],
            options={
                'verbose_name': 'model_employee',
                'verbose_name_plural': 'model_employee',
                'ordering': [],
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='EmployeeCertification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expire_on', models.DateField(blank=True, null=True, verbose_name='employeeCert_field_expireOn')),
                ('email_alert', models.BooleanField(choices=[(False, 'boolean_option_no'), (True, 'boolean_option_yes')], default=False, verbose_name='employeeCert_field_emailAlert')),
                ('before', models.IntegerField(blank=True, default=0, null=True, verbose_name='employeeCert_field_before')),
                ('certification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Certification', verbose_name='employeeCert_field_cert')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='employeeCert_field_employee')),
            ],
            options={
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='EmployeeProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('column_order', models.TextField(blank=True, default='', verbose_name='userProfile_field_order')),
                ('preferences', models.TextField(blank=True, default='')),
                ('emp', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee')),
            ],
            options={
                'verbose_name': 'pnsl_model_empProfile',
                'verbose_name_plural': 'pnsl_model_empProfile',
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('location_code', models.CharField(max_length=30, verbose_name='location_field_code')),
                ('location_name', models.CharField(max_length=30, verbose_name='location_field_name')),
                ('is_default', models.BooleanField(default=False, verbose_name='location_field_isDefault')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('parent_location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Location', verbose_name='location_field_parentLocation')),
            ],
            options={
                'verbose_name': 'psnl_model_location',
                'verbose_name_plural': 'psnl_model_location',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('position_code', models.CharField(max_length=50, verbose_name='position_field_code')),
                ('position_name', models.CharField(max_length=100, verbose_name='position_field_name')),
                ('is_default', models.BooleanField(default=False, verbose_name='position_field_isDefault')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('parent_position', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Position', verbose_name='position_field_parentPosition')),
            ],
            options={
                'verbose_name': 'psnl_model_position',
                'verbose_name_plural': 'psnl_model_position',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='Resign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('resign_date', models.DateField(default=datetime.datetime.now, verbose_name='resign_field_resignDate')),
                ('report_generation_end_date', models.DateField(default=datetime.datetime.now, verbose_name='resign_field_reportGenerationEndDate')),
                ('resign_type', models.IntegerField(choices=[(1, 'resign_typeOption_quit'), (2, 'resign_typeOption_dismissed'), (3, 'resign_typeOption_resign'), (4, 'resign_typeOption_transfer'), (5, 'resign_typeOption_retainJobWithoutSalary')], default=1, null=True, verbose_name='resign_field_resignType')),
                ('disableatt', models.BooleanField(choices=[(False, 'boolean_option_enable'), (True, 'boolean_option_disable')], default=True, verbose_name='resign_field_disableAttendanceFunction')),
                ('reason', models.CharField(blank=True, default='', max_length=200, null=True, verbose_name='resign_field_resignReason')),
                ('employee', mysite.personnel.fields.ModelOneToOneFieldWithCast(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='resign_field_employee')),
            ],
            options={
                'verbose_name': 'psnl_model_resign',
                'verbose_name_plural': 'psnl_model_resign',
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.AddField(
            model_name='employee',
            name='certification',
            field=models.ManyToManyField(blank=True, through='personnel.EmployeeCertification', to='personnel.Certification', verbose_name='employee_certification'),
        ),
        migrations.AddField(
            model_name='employee',
            name='department',
            field=mysite.personnel.fields.DepartmentForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='employee_field_department'),
        ),
    ]
