# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import datetime
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BioData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('bio_tmp', models.TextField(verbose_name='bioData_field_bioTemplate')),
                ('bio_no', models.IntegerField(default=0, null=True, verbose_name='bioData_field_bioIndex')),
                ('bio_index', models.IntegerField(default=0, null=True, verbose_name='bioData_field_templateIndex')),
                ('bio_type', models.IntegerField(choices=[(1, 'bio_fingerprint'), (2, 'bio_face'), (5, 'bio_finger_vein'), (8, 'bio_palm')], verbose_name='bioData_field_bioType')),
                ('major_ver', models.CharField(max_length=30, verbose_name='bioData_field_algorithmMajorVersion')),
                ('minor_ver', models.CharField(max_length=30, null=True, verbose_name='bioData_field_algorithmMinorVersion')),
                ('bio_format', models.IntegerField(default=0, null=True, verbose_name='bioData_field_algorithmFormat')),
                ('valid', models.IntegerField(choices=[(False, 'NO'), (True, 'YES')], default=1, verbose_name='bioData_field_isValid')),
                ('duress', models.IntegerField(choices=[(False, 'NO'), (True, 'YES')], default=0, verbose_name='bioData_field_isDuress')),
                ('update_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='bioData_field_updateTime')),
                ('sn', models.CharField(blank=True, max_length=50, null=True, verbose_name='bioData_field_enrollTerminal')),
            ],
            options={
                'verbose_name': 'iclock_model_bioData',
                'verbose_name_plural': 'iclock_model_bioData',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='BioPhoto',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('first_name', models.CharField(blank=True, default='', max_length=100, null=True, verbose_name='bioPhoto_field_firstName')),
                ('last_name', models.CharField(blank=True, max_length=25, null=True, verbose_name='bioPhoto_field_lastName')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='bioPhoto_field_email')),
                ('enroll_sn', models.CharField(blank=True, max_length=50, null=True, verbose_name='bioPhoto_field_enrollSN')),
                ('register_photo', models.CharField(blank=True, default='', editable=False, max_length=100, verbose_name='bioPhoto_field_registerPhoto')),
                ('register_time', models.DateTimeField(default=datetime.datetime.now, editable=False, verbose_name='bioPhoto_field_registerTime')),
                ('approval_photo', models.CharField(blank=True, editable=False, max_length=100, null=True, verbose_name='bioPhoto_field_approvalPhoto')),
                ('approval_state', models.SmallIntegerField(blank=True, choices=[(0, 'approve_pending'), (1, 'approve_approval_passed'), (2, 'approve_rejected'), (3, 'approve_auto_approved')], default=0, editable=False, verbose_name='bioPhoto_field_approvalState')),
                ('approval_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='bioPhoto_field_approvalTime')),
                ('remark', models.CharField(blank=True, max_length=100, null=True, verbose_name='bioPhoto_field_remark')),
            ],
            options={
                'verbose_name': 'iclock_model_bioPhoto',
                'verbose_name_plural': 'iclock_model_bioPhoto',
                'default_permissions': ('delete', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='DeviceConfig',
            fields=[
                ('uuid', models.CharField(default=uuid.uuid4, max_length=36, primary_key=True, serialize=False)),
                ('enable_registration', models.BooleanField(default=False, verbose_name='deviceConfig_field_enableRegistration')),
                ('enable_resigned_filter', models.BooleanField(default=False, verbose_name='deviceConfig_field_enableResignedFilter')),
                ('enable_auto_add', models.BooleanField(default=True, verbose_name='deviceConfig_field_autoAdd')),
                ('enable_employee_upload', models.BooleanField(default=True, verbose_name='deviceConfig_field_enableEmployeeUpload')),
                ('enable_name_upload', models.BooleanField(default=True, verbose_name='deviceConfig_field_enableNameUpload')),
                ('enable_card_upload', models.BooleanField(default=True, verbose_name='deviceConfig_field_enableCardUpload')),
                ('transaction_retention', models.IntegerField(default=9999, verbose_name='deviceConfig_field_transactionRetention')),
                ('command_retention', models.IntegerField(default=90, verbose_name='deviceConfig_field_commandRetention')),
                ('dev_log_retention', models.IntegerField(default=90, verbose_name='deviceConfig_field_devLogRetention')),
                ('upload_log_retention', models.IntegerField(default=90, verbose_name='deviceConfig_field_uploadLogRetention')),
                ('edit_policy', models.SmallIntegerField(choices=[(0, 'approve_pending'), (3, 'approve_auto_approved')], default=0, verbose_name='deviceConfig_field_editBioPhotoPolicy')),
                ('import_policy', models.SmallIntegerField(choices=[(0, 'approve_pending'), (3, 'approve_auto_approved')], default=0, verbose_name='deviceConfig_field_importBioPhotoPolicy')),
                ('mobile_policy', models.SmallIntegerField(choices=[(0, 'approve_pending'), (3, 'approve_auto_approved')], default=0, verbose_name='deviceConfig_field_mobileBioPhotoPolicy')),
                ('device_policy', models.SmallIntegerField(choices=[(0, 'approve_pending'), (3, 'approve_auto_approved')], default=3, verbose_name='deviceConfig_field_deviceBioPhotoPolicy')),
            ],
            options={
                'verbose_name': 'iclock_model_deviceConfig',
                'verbose_name_plural': 'iclock_model_deviceConfig',
            },
        ),
        migrations.CreateModel(
            name='ErrorCommandLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('error_code', models.CharField(blank=True, max_length=16, null=True, verbose_name='errorCommandLog_field_errorCode')),
                ('error_msg', models.CharField(blank=True, max_length=50, null=True, verbose_name='errorCommandLog_field_errorMsg')),
                ('data_origin', models.TextField(blank=True, null=True, verbose_name='errorCommandLog_field_dataOrigin')),
                ('cmd', models.CharField(blank=True, max_length=50, null=True, verbose_name='errorCommandLog_field_cmd')),
                ('additional', models.TextField(blank=True, null=True, verbose_name='errorCommandLog_field_additional')),
                ('upload_time', models.DateTimeField(verbose_name='errorCommandLog_field_uploadTime')),
            ],
            options={
                'verbose_name': 'terminal_model_errorCommandLog',
                'verbose_name_plural': 'terminal_model_errorCommandLog',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='PrivateMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('uid', models.CharField(blank=True, max_length=36, null=True)),
                ('start_time', models.DateTimeField(verbose_name='privateMessage_field_startTime')),
                ('duration', models.IntegerField(default=60, help_text='minutes', validators=[django.core.validators.MinValueValidator(1)], verbose_name='privateMessage_field_duration')),
                ('content', models.TextField(max_length=320, verbose_name='privateMessage_field_content')),
                ('last_send', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='privateMessage_field_lastSend')),
            ],
            options={
                'verbose_name': 'iclock_model_privateMessage',
                'verbose_name_plural': 'iclock_model_privateMessage',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='PublicMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('uid', models.CharField(blank=True, max_length=36, null=True)),
                ('start_time', models.DateTimeField(verbose_name='publicMessage_field_startTime')),
                ('duration', models.IntegerField(default=60, help_text='minutes', verbose_name='publicMessage_field_duration')),
                ('content', models.TextField(max_length=320, verbose_name='publicMessage_field_content')),
                ('last_send', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='publicMessage_field_lastSend')),
            ],
            options={
                'verbose_name': 'iclock_model_publicMessage',
                'verbose_name_plural': 'iclock_model_publicMessage',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Terminal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('sn', models.CharField(max_length=50, unique=True, verbose_name='terminal_field_sn')),
                ('alias', models.CharField(max_length=50, verbose_name='terminal_field_alias')),
                ('ip_address', models.GenericIPAddressField(verbose_name='terminal_field_ipAddress')),
                ('real_ip', models.GenericIPAddressField(blank=True, editable=False, null=True, verbose_name='terminal_field_realIPAddress')),
                ('state', models.IntegerField(default=1, editable=False, verbose_name='terminal_field_state')),
                ('terminal_tz', models.SmallIntegerField(choices=[(-750, 'Etc/GMT-12:30'), (-12, 'Etc/GMT-12'), (-690, 'Etc/GMT-11:30'), (-11, 'Etc/GMT-11'), (-630, 'Etc/GMT-10:30'), (-10, 'Etc/GMT-10'), (-570, 'Etc/GMT-9:30'), (-9, 'Etc/GMT-9'), (-510, 'Etc/GMT-8:30'), (-8, 'Etc/GMT-8'), (-450, 'Etc/GMT-7:30'), (-7, 'Etc/GMT-7'), (-390, 'Etc/GMT-6:30'), (-6, 'Etc/GMT-6'), (-330, 'Etc/GMT-5:30'), (-5, 'Etc/GMT-5'), (-270, 'Etc/GMT-4:30'), (-4, 'Etc/GMT-4'), (-210, 'Etc/GMT-3:30'), (-3, 'Etc/GMT-3'), (-150, 'Etc/GMT-2:30'), (-2, 'Etc/GMT-2'), (-90, 'Etc/GMT-1:30'), (-1, 'Etc/GMT-1'), (-30, 'Etc/GMT-0:30'), (0, 'Etc/GMT'), (30, 'Etc/GMT+0:30'), (1, 'Etc/GMT+1'), (90, 'Etc/GMT+1:30'), (2, 'Etc/GMT+2'), (150, 'Etc/GMT+2:30'), (3, 'Etc/GMT+3'), (210, 'Etc/GMT+3:30'), (4, 'Etc/GMT+4'), (270, 'Etc/GMT+4:30'), (5, 'Etc/GMT+5'), (330, 'Etc/GMT+5:30'), (6, 'Etc/GMT+6'), (390, 'Etc/GMT+6:30'), (7, 'Etc/GMT+7'), (450, 'Etc/GMT+7:30'), (8, 'Etc/GMT+8'), (510, 'Etc/GMT+8:30'), (9, 'Etc/GMT+9'), (570, 'Etc/GMT+9:30'), (10, 'Etc/GMT+10'), (630, 'Etc/GMT+10:30'), (11, 'Etc/GMT+11'), (690, 'Etc/GMT+11:30'), (12, 'Etc/GMT+12'), (750, 'Etc/GMT+12:30'), (13, 'Etc/GMT+13'), (810, 'Etc/GMT+13:30')], default=330, verbose_name='terminal_field_timezone')),
                ('heartbeat', models.IntegerField(default=10, help_text='terminal_field_heartbeatHelpTxt', verbose_name='terminal_field_heartbeat')),
                ('transfer_mode', models.SmallIntegerField(choices=[(1, 'transferMode_option_realTime'), (0, 'transferMode_option_timing')], default=1, verbose_name='terminal_field_transferMode')),
                ('transfer_interval', models.IntegerField(default=1, help_text='terminal_field_transferIntervalHelpTxt', verbose_name='terminal_field_transferInterval')),
                ('transfer_time', models.CharField(default='00:00;14:05', max_length=100, verbose_name='terminal_field_transferTime')),
                ('product_type', models.SmallIntegerField(blank=True, choices=[(9, 'deviceModel_option_attendance'), (5, 'deviceModel_option_accessController'), (8, 'deviceModel_option_informationScreen'), (31, 'deviceModel_option_AICamera')], default=9, editable=False, null=True, verbose_name='terminal_field_productType')),
                ('is_attendance', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=1, verbose_name='terminal_field_isAttendance')),
                ('is_registration', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='terminal_field_isRegistration')),
                ('purpose', models.SmallIntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_purpose')),
                ('controller_type', models.SmallIntegerField(blank=True, choices=[(1, '1_door_controller'), (2, '2_door_controller'), (4, '4_door_controller')], default=0, editable=False, null=True, verbose_name='terminal_field_accessControllerType')),
                ('authentication', models.SmallIntegerField(blank=True, default=1, editable=False, verbose_name='terminal_field_authentication')),
                ('style', models.CharField(blank=True, editable=False, max_length=20, null=True, verbose_name='terminal_field_style')),
                ('upload_flag', models.CharField(blank=True, default='1111100000', editable=False, max_length=10, null=True, verbose_name='terminal_field_uploadFlag')),
                ('fw_ver', models.CharField(blank=True, editable=False, max_length=100, null=True, verbose_name='terminal_field_firmwareVersion')),
                ('push_protocol', models.CharField(editable=False, max_length=30, verbose_name='terminal_field_pushProtocolVersion')),
                ('push_ver', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_pushVersion')),
                ('language', models.IntegerField(blank=True, default=84, editable=False, null=True, verbose_name='terminal_field_language')),
                ('is_tft', models.BooleanField(default=0, editable=False, verbose_name='terminal_field_isTft')),
                ('terminal_name', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_terminalName')),
                ('platform', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_platform')),
                ('oem_vendor', models.CharField(blank=True, editable=False, max_length=50, null=True, verbose_name='terminal_field_oemVendor')),
                ('log_stamp', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_logStamp')),
                ('op_log_stamp', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_operationLogStamp')),
                ('capture_stamp', models.CharField(blank=True, editable=False, max_length=30, null=True, verbose_name='terminal_field_captureStamp')),
                ('user_count', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_userCount')),
                ('user_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_userCapacity')),
                ('photo_func_on', models.BooleanField(default=0, editable=False, verbose_name='terminal_field_photoFuncOn')),
                ('transaction_count', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_transactionCount')),
                ('transaction_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_transactionCapacity')),
                ('fp_func_on', models.BooleanField(default=1, editable=False, verbose_name='terminal_field_fpFuncOn')),
                ('fp_count', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_fingerprintCount')),
                ('fp_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_fingerprintCapacity')),
                ('fp_alg_ver', models.CharField(blank=True, editable=False, max_length=10, null=True, verbose_name='terminal_field_fingerprintAlgorithmVersion')),
                ('face_func_on', models.BooleanField(default=0, editable=False, verbose_name='terminal_field_faceFuncOn')),
                ('face_count', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_faceCount')),
                ('face_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_faceCapacity')),
                ('face_alg_ver', models.CharField(blank=True, editable=False, max_length=10, null=True, verbose_name='terminal_field_faceAlgorithmVersion')),
                ('fv_func_on', models.BooleanField(default=0, editable=False, verbose_name='terminal_field_fingerVeinFuncOn')),
                ('fv_count', models.IntegerField(blank=True, default=0, editable=False, null=True, verbose_name='terminal_field_fingerVeinCount')),
                ('fv_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_fingerVeinCapacity')),
                ('fv_alg_ver', models.CharField(blank=True, editable=False, max_length=10, null=True, verbose_name='terminal_field_fingerVeinAlgorithmVersion')),
                ('palm_func_on', models.BooleanField(default=0, editable=False, verbose_name='terminal_field_palmFuncOn')),
                ('palm_count', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_palmCount')),
                ('palm_capacity', models.IntegerField(blank=True, editable=False, null=True, verbose_name='terminal_field_palmCapacity')),
                ('palm_alg_ver', models.CharField(blank=True, editable=False, max_length=10, null=True, verbose_name='terminal_field_palmAlgorithmVersion')),
                ('lock_func', models.SmallIntegerField(default=0, editable=False, verbose_name='terminal_field_lockFunc')),
                ('last_activity', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='terminal_field_lastActivity')),
                ('upload_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='terminal_field_uploadTime')),
                ('push_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='terminal_field_syncTime')),
                ('is_access', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='terminal_field_enableAccessControl')),
                ('gps_location', models.CharField(blank=True, default='', max_length=50, null=True, verbose_name='device_field_gpsLocation')),
            ],
            options={
                'verbose_name': 'iclock_model_terminal',
                'verbose_name_plural': 'iclock_model_terminal',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='TerminalCommand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(verbose_name='command_field_content')),
                ('commit_time', models.DateTimeField(verbose_name='command_field_commit_time')),
                ('transfer_time', models.DateTimeField(blank=True, null=True, verbose_name='command_field_transferTime')),
                ('return_time', models.DateTimeField(blank=True, null=True, verbose_name='command_field_returnTime')),
                ('return_value', models.IntegerField(blank=True, choices=[(0, 'terminalCommand_returnValue_successful'), (-1, 'terminalCommand_returnValue_parameterIncorrect'), (-2, 'terminalCommand_returnValue_userPhotoTransferError'), (-3, 'terminalCommand_returnValue_readOrWriteError'), (-9, 'terminalCommand_returnValue_bioTemplateTransferError'), (-10, 'terminalCommand_returnValue_userNotExist'), (-11, 'terminalCommand_returnValue_illegalFPTemplateFormat'), (-12, 'terminalCommand_returnValue_illegalFPTemplate'), (-1001, 'terminalCommand_returnValue_capacityLimitation'), (-1002, 'terminalCommand_returnValue_deviceNotSupport'), (-1003, 'terminalCommand_returnValue_timeout'), (-1004, 'terminalCommand_returnValue_dataException'), (-1005, 'terminalCommand_returnValue_deviceBusy'), (-1006, 'terminalCommand_returnValue_dataTooLong'), (-1007, 'terminalCommand_returnValue_memoryError'), (-1008, 'terminalCommand_returnValue_gettingServerDataFailed')], null=True, verbose_name='command_field_returnValue')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalCommand',
                'verbose_name_plural': 'iclock_model_terminalCommand',
            },
        ),
        migrations.CreateModel(
            name='TerminalEmployee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('terminal_sn', models.CharField(max_length=50, verbose_name='terminalEmployee_field_sn')),
                ('emp_code', models.CharField(max_length=20, verbose_name='terminalEmployee_field_employeeCode')),
                ('privilege', models.SmallIntegerField(default=0, verbose_name='terminalEmployee_field_privilege')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalEmployee',
                'verbose_name_plural': 'iclock_model_terminalEmployee',
            },
        ),
        migrations.CreateModel(
            name='TerminalLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gps_time', models.DateTimeField(verbose_name='terminal_field_gpstime')),
                ('latitude', models.CharField(max_length=25, verbose_name='terminal_field_latitude')),
                ('longitude', models.CharField(max_length=25, verbose_name='terminal_field_longitude')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalLocation',
                'verbose_name_plural': 'iclock_model_terminalLocation',
            },
        ),
        migrations.CreateModel(
            name='TerminalLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('terminal_tz', models.SmallIntegerField(blank=True, choices=[(-750, 'Etc/GMT-12:30'), (-12, 'Etc/GMT-12'), (-690, 'Etc/GMT-11:30'), (-11, 'Etc/GMT-11'), (-630, 'Etc/GMT-10:30'), (-10, 'Etc/GMT-10'), (-570, 'Etc/GMT-9:30'), (-9, 'Etc/GMT-9'), (-510, 'Etc/GMT-8:30'), (-8, 'Etc/GMT-8'), (-450, 'Etc/GMT-7:30'), (-7, 'Etc/GMT-7'), (-390, 'Etc/GMT-6:30'), (-6, 'Etc/GMT-6'), (-330, 'Etc/GMT-5:30'), (-5, 'Etc/GMT-5'), (-270, 'Etc/GMT-4:30'), (-4, 'Etc/GMT-4'), (-210, 'Etc/GMT-3:30'), (-3, 'Etc/GMT-3'), (-150, 'Etc/GMT-2:30'), (-2, 'Etc/GMT-2'), (-90, 'Etc/GMT-1:30'), (-1, 'Etc/GMT-1'), (-30, 'Etc/GMT-0:30'), (0, 'Etc/GMT'), (30, 'Etc/GMT+0:30'), (1, 'Etc/GMT+1'), (90, 'Etc/GMT+1:30'), (2, 'Etc/GMT+2'), (150, 'Etc/GMT+2:30'), (3, 'Etc/GMT+3'), (210, 'Etc/GMT+3:30'), (4, 'Etc/GMT+4'), (270, 'Etc/GMT+4:30'), (5, 'Etc/GMT+5'), (330, 'Etc/GMT+5:30'), (6, 'Etc/GMT+6'), (390, 'Etc/GMT+6:30'), (7, 'Etc/GMT+7'), (450, 'Etc/GMT+7:30'), (8, 'Etc/GMT+8'), (510, 'Etc/GMT+8:30'), (9, 'Etc/GMT+9'), (570, 'Etc/GMT+9:30'), (10, 'Etc/GMT+10'), (630, 'Etc/GMT+10:30'), (11, 'Etc/GMT+11'), (690, 'Etc/GMT+11:30'), (12, 'Etc/GMT+12'), (750, 'Etc/GMT+12:30'), (13, 'Etc/GMT+13'), (810, 'Etc/GMT+13:30')], null=True, verbose_name='terminalLog_field_timezone')),
                ('admin', models.CharField(blank=True, max_length=50, null=True, verbose_name='terminalLog_field_administrator')),
                ('action_name', models.SmallIntegerField(blank=True, choices=[(0, 'deviceLog_action_powerOn'), (1, 'deviceLog_action_powerOff'), (2, 'deviceLog_action_verifyFailed'), (3, 'deviceLog_action_alarm'), (4, 'deviceLog_action_enterMenu'), (5, 'deviceLog_action_modifySetting'), (6, 'deviceLog_action_enrollFP'), (7, 'deviceLog_action_enrollPassword'), (8, 'deviceLog_action_enrollCard'), (9, 'deviceLog_action_deleteUser'), (10, 'deviceLog_action_deleteFP'), (11, 'deviceLog_action_deletePassword'), (12, 'deviceLog_action_deleteCard'), (13, 'deviceLog_action_cleanData'), (14, 'deviceLog_action_generateMFCard'), (15, 'deviceLog_action_enrollMFCard'), (16, 'deviceLog_action_enrollMFCard'), (17, 'deviceLog_action_deleteMFCard'), (18, 'deviceLog_action_clearMFCard'), (19, 'deviceLog_action_migrateDataEnrollment2Card'), (20, 'deviceLog_action_migrateDataCard2Device'), (21, 'deviceLog_action_setupTime'), (22, 'deviceLog_action_restoreSetting'), (23, 'deviceLog_action_deleteAccessEntry'), (24, 'deviceLog_action_clearAdminPrivilege'), (25, 'deviceLog_action_updateAccessSetting'), (26, 'deviceLog_action_updateUserAccessSetting'), (27, 'deviceLog_action_updateAccessTimeZone'), (28, 'deviceLog_action_updateUnlockingCombination'), (29, 'deviceLog_action_unlock'), (30, 'deviceLog_action_enrollNewUser'), (31, 'deviceLog_action_updateFP'), (32, 'deviceLog_action_duressAlarm'), (34, 'deviceLog_action_antiPassBack'), (35, 'deviceLog_action_deleteAttPhoto'), (36, 'deviceLog_action_updateOtherUser'), (37, 'deviceLog_action_holiday'), (53, '53'), (54, '54'), (55, '55'), (56, '56'), (68, 'deviceLog_action_registerUserPhoto'), (69, 'deviceLog_action_updateUserPhoto'), (70, 'deviceLog_action_updateUserName'), (71, 'deviceLog_action_updateUserPrivilege'), (100, 'deviceLog_action_updatePalm'), (101, 'deviceLog_action_deletePalm')], null=True, verbose_name='terminalLog_field_actionName')),
                ('action_time', models.DateTimeField(blank=True, null=True, verbose_name='terminalLog_field_actionTime')),
                ('object', models.CharField(blank=True, max_length=50, null=True, verbose_name='terminalLog_field_object')),
                ('param1', models.IntegerField(blank=True, null=True, verbose_name='terminalLog_field_param1')),
                ('param2', models.IntegerField(blank=True, null=True, verbose_name='terminalLog_field_param2')),
                ('param3', models.IntegerField(blank=True, null=True, verbose_name='terminalLog_field_param3')),
                ('upload_time', models.DateTimeField(blank=True, null=True, verbose_name='terminalLog_field_uploadTime')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalLog',
                'verbose_name_plural': 'iclock_model_terminalLog',
            },
        ),
        migrations.CreateModel(
            name='TerminalParameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('param_type', models.CharField(max_length=10, null=True, verbose_name='terminalParameter_field_type')),
                ('param_name', models.CharField(max_length=30, verbose_name='terminalParameter_field_name')),
                ('param_value', models.CharField(max_length=100, verbose_name='terminalParameter_field_value')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalParameter',
                'verbose_name_plural': 'iclock_model_terminalParameter',
            },
        ),
        migrations.CreateModel(
            name='TerminalUploadLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event', models.CharField(max_length=80, verbose_name='terminalUploadLog_field_event')),
                ('content', models.CharField(max_length=80, verbose_name='terminalUploadLog_field_content')),
                ('upload_count', models.IntegerField(blank=True, default=1, verbose_name='terminalUploadLog_field_count')),
                ('error_count', models.IntegerField(blank=True, default=0, verbose_name='terminalUploadLog_field_errorCount')),
                ('upload_time', models.DateTimeField(verbose_name='terminalUploadLog_field_uploadTime')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalUploadLog',
                'verbose_name_plural': 'iclock_model_terminalUploadLog',
            },
        ),
        migrations.CreateModel(
            name='TerminalWorkCode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('code', models.CharField(max_length=8, unique=True, verbose_name='terminalWorkCode_field_code')),
                ('alias', models.CharField(max_length=24, verbose_name='terminalWorkCode_field_alias')),
                ('last_activity', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='terminalWorkCode_field_lastActivity')),
            ],
            options={
                'verbose_name': 'iclock_model_terminalWorkCode',
                'verbose_name_plural': 'iclock_model_terminalWorkCode',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Transaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('emp_code', models.CharField(max_length=20, verbose_name='transaction_field_employeeCode')),
                ('punch_time', models.DateTimeField(verbose_name='transaction_field_punchTime')),
                ('punch_state', models.CharField(choices=[('I', 'transaction_punchState_checkIn'), ('O', 'transaction_punchState_checkOut'), ('0', 'transaction_punchState_checkIn'), ('1', 'transaction_punchState_checkOut'), ('2', 'transaction_punchState_breakOut'), ('3', 'transaction_punchState_breakIn'), ('4', 'transaction_punchState_overtimeIn'), ('5', 'transaction_punchState_overtimeOut')], default='0', max_length=5, verbose_name='transaction_field_punchState')),
                ('verify_type', models.IntegerField(choices=[(0, 'terminal_verifyOption_password'), (1, 'terminal_verifyOption_fingerprint'), (2, 'terminal_verifyOption_badge'), (3, 'terminal_verifyOption_password'), (4, 'terminal_verifyOption_card'), (5, 'terminal_verifyOption_fingerprintOrPassword'), (6, 'terminal_verifyOption_fingerprintOrCard'), (7, 'terminal_verifyOption_passwordOrCard'), (8, 'terminal_verifyOption_badgeAndFingerprint'), (9, 'terminal_verifyOption_fingerprintAndPassword'), (10, 'terminal_verifyOption_fingerprintAndCard'), (11, 'terminal_verifyOption_passwordAndCard'), (12, 'terminal_verifyOption_fingerprintAndPasswordAndCard'), (13, 'terminal_verifyOption_badgeAndFingerprintAndPassword'), (14, 'terminal_verifyOption_fingerprintAndCardOrFingerprintAndBadge'), (15, 'terminal_verifyOption_face'), (16, 'terminal_verifyOption_faceAndFingerprint'), (17, 'terminal_verifyOption_faceAndPassword'), (18, 'terminal_verifyOption_faceAndCard'), (19, 'terminal_verifyOption_faceAndFingerprintAndCard'), (20, 'terminal_verifyOption_faceAndFingerprintAndPassword'), (21, 'terminal_verifyOption_fingerVein'), (22, 'terminal_verifyOption_fingerVeinAndPassword'), (23, 'terminal_verifyOption_fingerVeinAndCard'), (24, 'terminal_verifyOption_fingerVeinAndPasswordAndCard'), (25, 'terminal_verifyOption_palm'), (26, 'terminal_verifyOption_palmAndCard'), (27, 'terminal_verifyOption_palmAndFace'), (28, 'terminal_verifyOption_palmAndFingerprint'), (29, 'terminal_verifyOption_palmAndFingerprintAndFace'), (101, 'terminal_verifyOption_gps'), (102, 'terminal_verifyOption_aiCamera'), (200, 'terminal_verifyOption_other')], default=0, verbose_name='transaction_field_verifyType')),
                ('work_code', models.CharField(blank=True, max_length=20, null=True, verbose_name='transaction_field_workCode')),
                ('terminal_sn', models.CharField(blank=True, default='', max_length=50, null=True, verbose_name='transaction_field_terminalSN')),
                ('terminal_alias', models.CharField(blank=True, max_length=50, null=True, verbose_name='transaction_terminal_alias')),
                ('area_alias', models.CharField(blank=True, max_length=120, null=True, verbose_name='transaction_field_areaAlias')),
                ('longitude', models.FloatField(blank=True, null=True, verbose_name='transaction_field_longitude')),
                ('latitude', models.FloatField(blank=True, null=True, verbose_name='transaction_field_latitude')),
                ('gps_location', models.TextField(blank=True, default='', null=True, verbose_name='transaction_field_gpsLocation')),
                ('mobile', models.CharField(blank=True, max_length=50, null=True, verbose_name='transaction_field_mobile')),
                ('source', models.SmallIntegerField(blank=True, choices=[(1, 'dataSources_option_terminal'), (2, 'dataSources_option_manualLog'), (3, 'dataSources_option_mobile'), (4, 'pen driver')], default=1, null=True, verbose_name='transaction_field_source')),
                ('purpose', models.SmallIntegerField(blank=True, default=1, editable=False, null=True, verbose_name='transaction_field_purpose')),
                ('crc', models.CharField(blank=True, max_length=100, null=True, verbose_name='transaction_field_crcCode')),
                ('is_attendance', models.SmallIntegerField(blank=True, default=1, null=True, verbose_name='transaction_field_isAttendance')),
                ('reserved', models.CharField(blank=True, max_length=100, null=True, verbose_name='transaction_field_reserved')),
                ('upload_time', models.DateTimeField(blank=True, null=True, verbose_name='transaction_field_uploadTime')),
                ('sync_status', models.SmallIntegerField(blank=True, default=0, null=True, verbose_name='transaction_field_synchronizedStatus')),
                ('sync_time', models.DateTimeField(blank=True, null=True, verbose_name='transaction_field_synchronized_time')),
            ],
            options={
                'verbose_name': 'iclock_model_transaction',
                'verbose_name_plural': 'iclock_model_transaction',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='TransactionProofCmd',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_time', models.DateTimeField(verbose_name='action_time')),
                ('start_time', models.DateTimeField(verbose_name='start_time')),
                ('end_time', models.DateTimeField(verbose_name='end_time')),
                ('terminal_count', models.IntegerField(blank=True, null=True, verbose_name='terminal_count')),
                ('server_count', models.IntegerField(blank=True, null=True, verbose_name='server_count')),
                ('flag', models.SmallIntegerField(blank=True, default=0, null=True, verbose_name='compare_flag')),
                ('reserved_init', models.IntegerField(blank=True, default=0, editable=False, null=True, verbose_name='reserved_init')),
                ('reserved_float', models.FloatField(blank=True, default=0, editable=False, null=True, verbose_name='reserved_float')),
                ('reserved_char', models.CharField(blank=True, default=0, editable=False, max_length=30, null=True, verbose_name='reserved_char')),
                ('terminal', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='proof_terminal')),
            ],
            options={
                'verbose_name': 'transaction_proof_command',
                'verbose_name_plural': 'transaction_proof_command',
            },
        ),
    ]
