# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-28 17:18
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_countries.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('personnel', '0014_auto_20200708_1140'),
        ('cloud', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('effective_status', models.BooleanField(default=True)),
                ('discount_ratio', models.FloatField()),
                ('create_time', models.DateTimeField(auto_now_add=True)),
                ('create_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Discount',
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('number', models.CharField(max_length=25)),
                ('subscription_duration', models.IntegerField()),
                ('employees_count', models.IntegerField()),
                ('devices_count', models.IntegerField()),
                ('transactions_count', models.IntegerField(blank=True, null=True)),
                ('mobile_applications_count', models.IntegerField(blank=True, null=True)),
                ('whatsapp_push_count', models.IntegerField(blank=True, null=True)),
                ('original_price', models.FloatField()),
                ('discount_price', models.FloatField()),
                ('payment_price', models.FloatField()),
                ('payment_status', models.IntegerField(choices=[(0, 'User actively cancels'), (1, 'Automatic cancel after timeout'), (2, 'Paid'), (3, 'Unpaid')], default=3)),
                ('create_time', models.DateTimeField(auto_now_add=True)),
                ('company', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('create_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Order',
                'ordering': ['-create_time'],
            },
        ),
        migrations.CreateModel(
            name='PaymentRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('txn_date', models.DateTimeField(default=django.utils.timezone.now, verbose_name='TXN DATE')),
                ('txn_id', models.CharField(max_length=50, verbose_name='TXN ID')),
                ('tnx_amount', models.FloatField(verbose_name='TXN AMOUNT')),
                ('bank_txn_id', models.CharField(blank=True, max_length=50, null=True, verbose_name='BANK TXN ID')),
                ('bank_name', models.CharField(blank=True, max_length=50, null=True, verbose_name='BANK NAME')),
                ('resp_code', models.IntegerField(verbose_name='RESP CODE')),
                ('payment_mode', models.CharField(blank=True, max_length=10, null=True, verbose_name='PAYMENT MODE')),
                ('currency', models.CharField(blank=True, max_length=4, null=True, verbose_name='CURRENCY')),
                ('gateway_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='GATEWAY NAME')),
                ('mid', models.CharField(max_length=40)),
                ('resp_msg', models.TextField(max_length=250, verbose_name='RESP MSG')),
                ('status', models.CharField(max_length=12, verbose_name='STATUS')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cloud.Order')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Payment Record',
                'ordering': ['-txn_date'],
            },
        ),
        migrations.CreateModel(
            name='PriceStrategy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.SmallIntegerField(choices=[(1, 'Free Trial'), (2, 'Professional'), (3, 'Premium'), (4, 'Enterprise')], default=1)),
                ('subscription_duration_unit_price_pre_month', models.FloatField()),
                ('employee_threshold', models.IntegerField()),
                ('employee_unit_price', models.FloatField()),
                ('device_threshold', models.IntegerField()),
                ('device_unit_price', models.FloatField()),
                ('whatsapp_push_counts_limit_status', models.BooleanField(default=True)),
                ('whatsapp_push_threshold', models.IntegerField(blank=True, null=True)),
                ('whatsapp_push_unit_price', models.FloatField(blank=True, null=True)),
                ('mobile_app_counts_limit_status', models.BooleanField(default=True)),
                ('mobile_applications_threshold', models.IntegerField(blank=True, null=True)),
                ('mobile_applications_unit_price', models.FloatField(blank=True, null=True)),
                ('transaction_counts_limit_status', models.BooleanField(default=True)),
                ('transaction_threshold', models.IntegerField()),
                ('transaction_unit_price', models.FloatField()),
                ('country', django_countries.fields.CountryField(max_length=2)),
                ('currency', models.CharField(max_length=4)),
                ('create_time', models.DateTimeField(auto_now_add=True)),
                ('effective_status', models.BooleanField(default=True)),
                ('create_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('discount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cloud.Discount')),
            ],
            options={
                'verbose_name': 'Price Strategy',
            },
        ),
        migrations.AlterModelOptions(
            name='feature',
            options={'verbose_name': 'Feature'},
        ),
        migrations.AddField(
            model_name='feature',
            name='country',
            field=django_countries.fields.CountryField(default='IN', max_length=2),
        ),
        migrations.AddField(
            model_name='feature',
            name='currency',
            field=models.CharField(blank=True, max_length=4, null=True),
        ),
        migrations.AddField(
            model_name='feature',
            name='description',
            field=models.CharField(blank=True, max_length=200, null=True, verbose_name='feature_field_description'),
        ),
        migrations.AddField(
            model_name='feature',
            name='display_status',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='feature',
            name='effective_status',
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name='feature',
            name='price',
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='pricestrategy',
            name='feature',
            field=models.ManyToManyField(to='cloud.Feature'),
        ),
        migrations.AddField(
            model_name='order',
            name='feature',
            field=models.ManyToManyField(to='cloud.Feature'),
        ),
        migrations.AddField(
            model_name='order',
            name='price_strategy',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cloud.PriceStrategy'),
        ),
    ]
