# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2022-07-15 12:49
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import mysite.admin.abstract_cloud_model


class Migration(migrations.Migration):

    dependencies = [
        ('personnel', '0025_auto_20220520_2045'),
        ('base', '0008_membership_auth_pos'),
    ]

    operations = [
        migrations.CreateModel(
            name='ParallelDb',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('database', models.CharField(choices=[('sqlserver_ado', 'MSSQL Server'), ('mysql', 'My Sql'), ('oracle', 'Oracle'), ('postgresql', 'PostgresSql')], default='oracle', max_length=50, verbose_name='parallelDb_field_database')),
                ('ip_address', models.CharField(max_length=50, verbose_name='parallelDb_field_ip_address')),
                ('port', models.CharField(max_length=50, verbose_name='parallelDb_field_port')),
                ('database_name', models.CharField(max_length=50, verbose_name='parallelDb_field_database_name')),
                ('user', models.CharField(max_length=50, verbose_name='parallelDb_field_user')),
                ('password', models.CharField(max_length=50, verbose_name='parallelDb_field_password')),
                ('service_type', models.SmallIntegerField(blank=True, choices=[(0, 'parallelDb_field_serviceName'), (1, 'parallelDb_field_sid')], default=0, null=True, verbose_name='parallelDb_field_serviceType')),
                ('duplicate_punch', models.IntegerField(blank=True, default=0, null=True, verbose_name='parallelDb_field_duplicatePunch')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'parallel_database',
                'verbose_name_plural': 'parallel_database',
            },
        ),
        migrations.CreateModel(
            name='ParallelDBExport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('table_name', models.CharField(max_length=100, null=True, verbose_name='parallelDbExport_field_tableName')),
                ('emp_code', models.CharField(max_length=50, null=True, verbose_name='parallelDbExport_field_employeeCode')),
                ('punch_time', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_punchTime')),
                ('time_format', models.IntegerField(blank=True, choices=[(0, 'HH:MM:SS'), (1, 'HH:MM')], default=0, null=True, verbose_name='parallelDb_field_timeFormat')),
                ('punch_date_time', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_punchDateTime')),
                ('punch_date', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_punchDate')),
                ('punch_state', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_punchState')),
                ('punch_states', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_punchStates')),
                ('verify_type', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_verifyType')),
                ('verify_types', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDbExport_field_verifyTypes')),
                ('terminal_sn', models.CharField(blank=True, max_length=100, null=True, verbose_name='parallelDbExport_field_terminalSn')),
                ('terminal_alias', models.CharField(blank=True, max_length=100, null=True, verbose_name='parallelDbExport_field_terminalAlias')),
                ('area_alias', models.CharField(blank=True, max_length=100, null=True, verbose_name='parallelDb_field_areaAlias')),
                ('work_code', models.CharField(blank=True, max_length=100, null=True, verbose_name='parallelDb_field_workcode')),
                ('upload_time', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_uploadTime')),
                ('purpose', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_purpose')),
                ('emp_id', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_employee')),
                ('terminal_id', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_terminal')),
                ('source', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_source')),
                ('temperature', models.CharField(blank=True, max_length=50, null=True, verbose_name='Temperature')),
                ('mask_flag', models.CharField(blank=True, max_length=50, null=True, verbose_name='Mask Flag')),
                ('terminal_ip', models.CharField(blank=True, max_length=50, null=True, verbose_name='parallelDb_field_ipAddress')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'base_model_ParallelDBExport',
                'verbose_name_plural': 'base_model_ParallelDBExport',
            },
        ),
    ]
