# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.manager
import django.utils.timezone
import mysite.base.models.modelless


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeductionFormula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=30, verbose_name='deductionFormula_field_name')),
                ('formula', models.CharField(default='', max_length=100, verbose_name='deductionFormula_field_formula')),
                ('remark', models.TextField(blank=True, default='', max_length=300, null=True, verbose_name='deductionFormula_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_deductionFormula',
                'verbose_name_plural': 'payroll_model_deductionFormula',
            },
        ),
        migrations.CreateModel(
            name='EmpLoan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('loan_amount', models.FloatField(verbose_name='empLoan_field_loanAmount')),
                ('loan_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='empLoan_field_loanTime')),
                ('refund_cycle', models.SmallIntegerField(choices=[(1, '1_period'), (2, '2_periods'), (3, '3_periods'), (4, '4_periods'), (5, '5_periods'), (6, '6_periods'), (7, '7_periods'), (8, '8_periods'), (9, '9_periods'), (10, '10_periods'), (11, '11_periods'), (12, '12_periods')], verbose_name='empLoan_field_refundCycle')),
                ('per_cycle_refund', models.FloatField(verbose_name='empLoan_field_per_cycle_amount')),
                ('loan_clean_time', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='empLoan_field_clean_time')),
                ('remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='empLoan_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_empLoan',
                'verbose_name_plural': 'payroll_model_empLoan',
                'default_permissions': ('delete',),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='EmpPayrollProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_mode', models.SmallIntegerField(choices=[(1, 'paroll_mode_monthly')], default=1, null=True, verbose_name='empPayrollProfile_field_payment_mode')),
                ('payment_type', models.SmallIntegerField(choices=[(1, 'paroll_type_cash'), (2, 'paroll_type_cheque'), (3, 'paroll_type_bank_transfer')], default=1, null=True, verbose_name='empPayrollProfile_field_payment_type')),
                ('bank_name', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='empPayrollProfile_field_bank_name')),
                ('bank_account', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='empPayrollProfile_field_bank_account')),
                ('personnel_id', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='empPayrollProfile_field_personnel_id')),
                ('agent_id', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='empPayrollProfile_field_agent_id')),
                ('agent_account', models.CharField(blank=True, default='', max_length=30, null=True, verbose_name='empPayrollProfile_field_agent_account')),
            ],
            options={
                'verbose_name': 'payroll_model_empPayrollProfile',
                'verbose_name_plural': 'payroll_model_empPayrollProfile',
            },
        ),
        migrations.CreateModel(
            name='ExceptionFormula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=30, verbose_name='exceptionFormula_field_name')),
                ('exception_type', models.SmallIntegerField(choices=[(1, 'report_column_lateDuration'), (2, 'report_column_earlyLeaveDuration'), (3, 'report_column_absentDuration')], default=1, verbose_name='exceptionFormula_field_exception_type')),
                ('formula', models.CharField(default='', max_length=100, verbose_name='exceptionFormula_field_formula')),
                ('remark', models.TextField(blank=True, default='', max_length=300, null=True, verbose_name='exceptionFormula_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_exceptionFormula',
                'verbose_name_plural': 'payroll_model_exceptionFormula',
            },
        ),
        migrations.CreateModel(
            name='ExtraDeduction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('amount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='extraDeduction_field_amount')),
                ('issued_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='extraDeduction_field_issuedTime')),
                ('remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='extraDeduction_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_extraDeduction',
                'verbose_name_plural': 'payroll_model_extraDeduction',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='ExtraIncrease',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('amount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)], verbose_name='extraIncrease_field_amount')),
                ('issued_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='extraIncrease_field_issuedTime')),
                ('remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='extraIncrease_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_extraIncrease',
                'verbose_name_plural': 'payroll_model_extraIncrease',
                'default_permissions': ('delete', 'change', 'view'),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='IncreasementFormula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=30, verbose_name='increasementFormula_field_name')),
                ('formula', models.CharField(default='', max_length=100, verbose_name='increasementFormula_field_formula')),
                ('remark', models.TextField(blank=True, default='', max_length=300, null=True, verbose_name='increasementFormula_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_increasementFormula',
                'verbose_name_plural': 'payroll_model_increasementFormula',
            },
        ),
        migrations.CreateModel(
            name='LeaveFormula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=30, verbose_name='leaveFormula_field_name')),
                ('formula', models.CharField(default='', max_length=100, verbose_name='leaveFormula_field_formula')),
                ('remark', models.TextField(blank=True, default='', max_length=300, null=True, verbose_name='leaveFormula_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_leaveFormula',
                'verbose_name_plural': 'payroll_model_leaveFormula',
            },
        ),
        migrations.CreateModel(
            name='MonthlySalary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('calc_time', models.DateField(blank=True, null=True, verbose_name='monthlySalary_field_calc_time')),
                ('basic_salary', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_basic_salary')),
                ('effective_date', models.DateField(blank=True, null=True, verbose_name='monthlySalary_field_effective_date')),
                ('format_dict', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_format_dict')),
                ('ot1', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_ot1')),
                ('ot2', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_ot2')),
                ('ot3', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_ot3')),
                ('normal_ot', models.FloatField(blank=True, null=True, verbose_name='report_column_normalOvertime')),
                ('weekend_ot', models.FloatField(blank=True, null=True, verbose_name='report_column_weekendOvertime')),
                ('holiday_ot', models.FloatField(blank=True, null=True, verbose_name='report_column_holidayOvertime')),
                ('late_time', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_late_time')),
                ('early_leave', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_early_leave')),
                ('absent_time', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_absent_time')),
                ('increase', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_increase')),
                ('deduction', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_deduction')),
                ('leave', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_leave')),
                ('ot1_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot1_formula')),
                ('ot2_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot2_formula')),
                ('ot3_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot3_formula')),
                ('normal_ot_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_normal_ot_formula')),
                ('weekend_ot_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_weekend_ot_formula')),
                ('holiday_ot_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_holiday_ot_formula')),
                ('late_time_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_late_time_formula')),
                ('early_leave_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_early_leave_formula')),
                ('absent_time_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_absent_time_formula')),
                ('increase_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_increase_formula')),
                ('deduction_formula', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_deduction_formula')),
                ('leave_formula', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_leave_formula')),
                ('ot1_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot1_formula_name')),
                ('ot2_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot2_formula_name')),
                ('ot3_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_ot3_formula_name')),
                ('normal_ot_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_normal_ot_formula_name')),
                ('weekend_ot_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_weekend_ot_formula_name')),
                ('holiday_ot_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_holiday_ot_formula_name')),
                ('late_time_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_late_time_formula_name')),
                ('early_leave_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_early_leave_formula_name')),
                ('absent_time_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_absent_time_formula_name')),
                ('increase_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_increase_formula_name')),
                ('deduction_formula_name', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_deduction_formula_name')),
                ('leave_formula_name', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_leave_formula_name')),
                ('extra_increase', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_extra_increase')),
                ('extra_deduction', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_extra_deduction')),
                ('total_loan_amount', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_total_loan_amount')),
                ('refund_loan_amount', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_refund_loan_amount')),
                ('unrefund_loan_amount', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_unrefund_loan_amount')),
                ('loan_deduction', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_loan_deduction')),
                ('loan_increase', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_loan_increase')),
                ('advance_increase', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_advance_increase')),
                ('advance_deduction', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_advance_deduction')),
                ('reimbursement', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_reimbursement')),
                ('total_increase_formula', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_increase_formula')),
                ('total_increase_formula_name', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_increase_formula_name')),
                ('total_increase_expression', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_increase_expression')),
                ('total_increase', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_total_increase')),
                ('total_deduction_formula', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_deduction_formula')),
                ('total_deduction_formula_name', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_deduction_formula_name')),
                ('total_deduction_expression', models.TextField(blank=True, max_length=1000, null=True, verbose_name='monthlySalary_field_total_deduction_expression')),
                ('total_deduction', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_total_deduction')),
                ('total_salary_expression', models.TextField(blank=True, max_length=500, null=True, verbose_name='monthlySalary_field_total_salary_expression')),
                ('total_salary', models.FloatField(blank=True, null=True, verbose_name='monthlySalary_field_total_salary')),
            ],
            options={
                'verbose_name': 'payroll_model_monthlysalary',
                'verbose_name_plural': 'payroll_model_monthlysalary',
            },
        ),
        migrations.CreateModel(
            name='OvertimeFormula',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', max_length=30, verbose_name='overtimeFormula_field_name')),
                ('overtime_level', models.SmallIntegerField(choices=[(1, 'report_column_overtimeLevel1'), (2, 'report_column_overtimeLevel2'), (3, 'report_column_overtimeLevel3'), (4, 'report_column_normalOvertime'), (5, 'report_column_weekendOvertime'), (6, 'report_column_holidayOvertime')], default=1, verbose_name='overtimeFormula_field_overtime_level')),
                ('formula', models.CharField(default='', max_length=100, verbose_name='overtimeFormula_field_formula')),
                ('remark', models.TextField(blank=True, default='', max_length=300, null=True, verbose_name='overtimeFormula_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_overtimeFormula',
                'verbose_name_plural': 'payroll_model_overtimeFormula',
            },
        ),
        migrations.CreateModel(
            name='Reimbursement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rmb_amount', models.FloatField(verbose_name='Reimbursement_field_amount')),
                ('rmb_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Reimbursement_field_time')),
                ('rmb_file', models.CharField(blank=True, max_length=200, null=True, verbose_name='Reimbursement_field_file')),
                ('rmb_remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='Reimbursement_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_Reimbursement',
                'verbose_name_plural': 'payroll_model_Reimbursement',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='SalaryAdvance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('advance_amount', models.FloatField(verbose_name='salaryAdvance_field_amount')),
                ('advance_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='salaryAdvance_field_time')),
                ('advance_remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='salaryAdvance_field_remark')),
            ],
            options={
                'verbose_name': 'payroll_model_SalaryAdvance',
                'verbose_name_plural': 'payroll_model_SalaryAdvance',
                'default_permissions': ('delete',),
            },
        ),
        migrations.CreateModel(
            name='SalaryStructure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('salary_amount', models.FloatField(verbose_name='salaryStructure_field_amount')),
                ('effective_date', models.DateField(verbose_name='salaryStructure_field_effectiveDate')),
                ('salary_remark', models.CharField(blank=True, max_length=300, null=True, verbose_name='salaryAdvance_field_remark')),
                ('deductionformula', models.ManyToManyField(blank=True, to='payroll.DeductionFormula', verbose_name='payroll_model_deductionFormula')),
            ],
            options={
                'verbose_name': 'payroll_model_salarystructure',
                'verbose_name_plural': 'payroll_model_salarystructure',
                'ordering': ['employee_id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='PayrollReportPermission',
            fields=[
            ],
            options={
                'verbose_name': 'Payroll Report Permission',
                'verbose_name_plural': 'Payroll Report Permission',
                'proxy': True,
                'indexes': [],
            },
            bases=('base.abstractpermission',),
            managers=[
                ('objects', mysite.base.models.modelless.PayrollReportPermissionManager()),
            ],
        ),
    ]
