# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import mysite.admin.fields
import mysite.base.models.modelless


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdminLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(max_length=50, verbose_name='adminLog_field_action')),
                ('targets', models.TextField(blank=True, null=True, verbose_name='adminLog_field_objects')),
                ('targets_repr', models.TextField(blank=True, default='', null=True, verbose_name='adminLog_field_objects')),
                ('action_status', models.SmallIntegerField(choices=[(-1, 'actionStatus_option_fail'), (0, 'actionStatus_option_success')], default=0, verbose_name='adminLog_field_actionStatus')),
                ('description', models.TextField(blank=True, default='', null=True, verbose_name='adminLog_field_description')),
                ('ip_address', models.GenericIPAddressField(blank=True, default='', null=True, verbose_name='adminLog_field_ipAddress')),
                ('can_routable', models.BooleanField(default=False, verbose_name='adminLog_field_routable')),
                ('op_time', models.DateTimeField(verbose_name='adminLog_field_operationTime')),
            ],
            options={
                'verbose_name': 'base_model_adminLog',
                'verbose_name_plural': 'base_model_adminLog',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='attParamDepts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ruleName', models.CharField(db_column='rulename', max_length=40, unique=True)),
                ('DeptID', models.IntegerField(db_column='deptid', default=0)),
                ('Operator', models.CharField(blank=True, db_column='operator', max_length=20, null=True)),
                ('OpTime', models.DateTimeField(blank=True, db_column='optime', null=True)),
            ],
            options={
                'verbose_name': 'attParamDepts',
                'verbose_name_plural': 'attParamDepts',
            },
        ),
        migrations.CreateModel(
            name='AutoExportTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('task_code', models.CharField(max_length=30, unique=True, verbose_name='autoExportTask_field_code')),
                ('task_name', models.CharField(max_length=30, verbose_name='autoExportTask_field_name')),
                ('params', models.TextField(blank=True, null=True, verbose_name='autoExportTask_field_params')),
            ],
            options={
                'verbose_name': 'base_model_autoExportTask',
                'verbose_name_plural': 'base_model_autoExportTask',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Bookmark',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=128, verbose_name='bookmark_field_title')),
                ('filters', models.CharField(blank=True, max_length=1000, verbose_name='bookmark_field_filtersString')),
                ('is_share', models.BooleanField(default=False, verbose_name='bookmark_field_isShared')),
                ('time_saved', models.DateTimeField(default=django.utils.timezone.now, verbose_name='bookmark_field_savedTime')),
            ],
            options={
                'verbose_name': 'base_model_bookmark',
                'verbose_name_plural': 'base_model_bookmark',
                'ordering': ['time_saved', '-pk'],
                'default_permissions': ('delete', 'change'),
            },
        ),
        migrations.CreateModel(
            name='DBBackupLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('db_type', models.CharField(choices=[('mysql', 'MySQL'), ('sql_server', 'Microsoft SQL'), ('oracle', 'Oracle'), ('postgresql', 'PostgreSQL')], max_length=50, verbose_name='dbBackupLog_field_type')),
                ('db_name', models.CharField(max_length=50, verbose_name='dbBackupLog_field_name')),
                ('operator', models.CharField(max_length=50, null=True, verbose_name='dbBackupLog_field_operator')),
                ('backup_file', models.FilePathField(verbose_name='dbBackupLog_field_filePath')),
                ('backup_time', models.DateTimeField(auto_now_add=True, verbose_name='dbBackupLog_field_time')),
                ('status', models.SmallIntegerField(choices=[(0, 'backup_status_success'), (1, 'backup_status_failed')], default=0, verbose_name='dbBackupLog_field_status')),
                ('backup_status', models.SmallIntegerField(choices=[(0, 'backup_status_success'), (1, 'backup_status_failed')], default=0, verbose_name='dbBackupLog_field_status')),
                ('remark', models.TextField(blank=True, null=True, verbose_name='dbBackupLog_field_remark')),
            ],
            options={
                'verbose_name': 'base_model_dbBackupLog',
                'verbose_name_plural': 'base_model_dbBackupLog',
                'default_permissions': (),
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='DbMigrate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('name', models.CharField(max_length=30, verbose_name='dbMigrate_field_name')),
                ('value', models.TextField(verbose_name='dbMigrate_field_value')),
            ],
            options={
                'verbose_name': 'db_migrate',
                'verbose_name_plural': 'db_migrate',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='GroupProfile',
            fields=[
                ('group_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='auth.Group')),
            ],
            options={
                'verbose_name': 'GroupProfile',
                'verbose_name_plural': 'GroupProfile',
                'db_table': 'auth_group_profile',
            },
            bases=('auth.group', models.Model),
        ),
        migrations.CreateModel(
            name='LineNotifySetting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('include_sub_department', models.IntegerField(blank=True, choices=[(1, 'boolean_option_yes'), (0, 'boolean_option_no')], null=True, verbose_name='lineNotify_field_includeSubDepartment')),
                ('line_notify_token', models.CharField(help_text='lineNotify_field_lineNotifyTokenHelpTxt', max_length=200, null=True, verbose_name='lineNotify_field_lineNotifyToken')),
                ('message_type', models.IntegerField(blank=True, choices=[(100, 'lineNotifySetting_messageType_realTime'), (200, 'lineNotifySetting_messageType_intradayAttendanceSummary')], default=100, null=True, verbose_name='lineNotify_field_messageType')),
                ('message_head', models.CharField(blank=True, max_length=100, null=True, verbose_name='lineNotify_field_messageHead')),
                ('message_tail', models.CharField(blank=True, max_length=100, null=True, verbose_name='lineNotify_field_messageTail')),
                ('push_time', models.TimeField(blank=True, null=True, verbose_name='lineNotify_field_pushTime')),
                ('is_valid', models.IntegerField(blank=True, choices=[(1, 'enableStatus_option_enable'), (0, 'enableStatus_option_disable')], null=True, verbose_name='lineNotify_field_isValid')),
                ('remark', models.CharField(blank=True, max_length=200, null=True, verbose_name='lineNotify_field_remark')),
            ],
            options={
                'verbose_name': 'base_model_lineNotifySetting',
            },
        ),
        migrations.CreateModel(
            name='Membership',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('role', models.SmallIntegerField(choices=[(-1, 'no_active'), (0, 'stuff'), (1, 'superuser'), (2, 'vendor')], default=0, verbose_name='user_field_role')),
            ],
            options={
                'verbose_name': 'base_membership',
                'verbose_name_plural': 'base_membership',
            },
        ),
        migrations.CreateModel(
            name='SftpSetting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('host', models.GenericIPAddressField(protocol='ipv4', verbose_name='sftpSetting_field_hostAddress')),
                ('port', models.IntegerField(default=22, validators=[django.core.validators.MinValueValidator(0)], verbose_name='sftpSetting_field_portNumber')),
                ('auth_method', models.IntegerField(choices=[(0, 'sftpSetting_field_authenticMethodOption_password'), (1, 'sftpSetting_field_authenticMethodOption_publicKey')], default=0, verbose_name='sftpSetting_field_authenticMethod')),
                ('user_name', models.CharField(max_length=30, verbose_name='sftpSetting_field_username')),
                ('user_password', mysite.admin.fields.PasswordField(blank=True, max_length=128, null=True, verbose_name='sftpSetting_field_userPassword')),
                ('user_key', models.TextField(blank=True, null=True, verbose_name='sftpSetting_field_userSshKey')),
                ('key_password', mysite.admin.fields.PasswordField(blank=True, max_length=128, null=True, verbose_name='sftpSetting_field_keyPassword')),
            ],
            options={
                'verbose_name': 'sftp_setting',
            },
        ),
        migrations.CreateModel(
            name='SyncArea',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('post_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_postTime')),
                ('flag', models.SmallIntegerField(default=0, verbose_name='middlewareTable_field_flag')),
                ('update_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_updateTime')),
                ('sync_ret', models.CharField(blank=True, max_length=200, null=True, verbose_name='middlewareTable_field_syncResult')),
                ('area_code', models.CharField(max_length=100, verbose_name='area_field_code')),
                ('area_name', models.CharField(max_length=120, verbose_name='area_field_name')),
            ],
            options={
                'verbose_name': 'base_integrationTable_area',
                'verbose_name_plural': 'base_integrationTable_area',
                'db_table': 'sync_area',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='SyncDepartment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('post_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_postTime')),
                ('flag', models.SmallIntegerField(default=0, verbose_name='middlewareTable_field_flag')),
                ('update_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_updateTime')),
                ('sync_ret', models.CharField(blank=True, max_length=200, null=True, verbose_name='middlewareTable_field_syncResult')),
                ('dept_code', models.CharField(max_length=50, verbose_name='department_field_code')),
                ('dept_name', models.CharField(max_length=100, verbose_name='department_filed_name')),
            ],
            options={
                'verbose_name': 'base_integrationTable_department',
                'verbose_name_plural': 'base_integrationTable_department',
                'db_table': 'sync_department',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='SyncEmployee',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('post_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_postTime')),
                ('flag', models.SmallIntegerField(default=0, verbose_name='middlewareTable_field_flag')),
                ('update_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_updateTime')),
                ('sync_ret', models.CharField(blank=True, max_length=200, null=True, verbose_name='middlewareTable_field_syncResult')),
                ('emp_code', models.CharField(max_length=20, verbose_name='emp_field_employeeCode')),
                ('first_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='emp_field_firstName')),
                ('last_name', models.CharField(blank=True, max_length=25, null=True, verbose_name='emp_field_lastName')),
                ('dept_code', models.CharField(blank=True, max_length=50, null=True, verbose_name='department_field_code')),
                ('dept_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='department_filed_name')),
                ('job_code', models.CharField(blank=True, max_length=50, null=True, verbose_name='position_field_code')),
                ('job_name', models.CharField(blank=True, max_length=100, null=True, verbose_name='position_field_name')),
                ('area_code', models.CharField(blank=True, max_length=100, null=True, verbose_name='area_field_code')),
                ('area_name', models.CharField(blank=True, max_length=120, null=True, verbose_name='area_field_name')),
                ('card_no', models.CharField(blank=True, max_length=20, null=True, verbose_name='emp_field_cardNumber')),
                ('multi_area', models.BooleanField(default=False, verbose_name='emp_field_multipleArea')),
                ('hire_date', models.DateField(blank=True, max_length=8, null=True, verbose_name='emp_field_hireDate')),
                ('gender', models.CharField(blank=True, max_length=2, null=True, verbose_name='emp_field_gender')),
                ('birthday', models.DateField(blank=True, max_length=8, null=True, verbose_name='emp_field_birthday')),
                ('email', models.CharField(blank=True, max_length=100, null=True, verbose_name='emp_field_email')),
                ('active_status', models.BooleanField(default=True, verbose_name='emp_field_activeStatus')),
            ],
            options={
                'verbose_name': 'base_integrationTable_employee',
                'verbose_name_plural': 'base_integrationTable_employee',
                'db_table': 'sync_employee',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='SyncJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('post_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_postTime')),
                ('flag', models.SmallIntegerField(default=0, verbose_name='middlewareTable_field_flag')),
                ('update_time', models.DateTimeField(blank=True, null=True, verbose_name='middlewareTable_field_updateTime')),
                ('sync_ret', models.CharField(blank=True, max_length=200, null=True, verbose_name='middlewareTable_field_syncResult')),
                ('job_code', models.CharField(max_length=50, verbose_name='position_field_code')),
                ('job_name', models.CharField(max_length=100, verbose_name='position_field_name')),
            ],
            options={
                'verbose_name': 'base_integrationTable_position',
                'verbose_name_plural': 'base_integrationTable_position',
                'db_table': 'sync_job',
                'default_permissions': ('view',),
            },
        ),
        migrations.CreateModel(
            name='SysParam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('para_name', models.CharField(max_length=30, verbose_name='sysParam_field_name')),
                ('para_type', models.CharField(max_length=10, null=True, verbose_name='sysParam_field_type')),
                ('para_value', models.CharField(max_length=250, null=True, verbose_name='sysParam_field_value')),
            ],
            options={
                'verbose_name': 'System Rule',
                'verbose_name_plural': 'System Rule',
            },
        ),
        migrations.CreateModel(
            name='SysParamDept',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rule_name', models.CharField(max_length=40, unique=True)),
                ('dept_id', models.IntegerField(default=0)),
                ('operator', models.CharField(blank=True, max_length=20, null=True)),
                ('op_time', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'System Parameter related to Department',
                'verbose_name_plural': 'System Parameter related to Department',
            },
        ),
        migrations.CreateModel(
            name='SystemSetting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_time', models.DateTimeField(auto_now_add=True, null=True, verbose_name='baseModel_field_createTime')),
                ('create_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_createUser')),
                ('change_time', models.DateTimeField(auto_now=True, null=True, verbose_name='baseModel_field_changeTime')),
                ('change_user', models.CharField(blank=True, editable=False, max_length=150, null=True, verbose_name='baseModel_field_changeUser')),
                ('status', models.SmallIntegerField(choices=[(0, 'baseModel_field_dataStatus_option_statusValid'), (99, 'baseModel_field_dataStatus_option_statusInvalid'), (100, 'baseModel_field_dataStatus_option_statusInvalid'), (999, 'baseModel_field_dataStatus_option_statusInvalid')], default=0, editable=False, verbose_name='baseModel_field_dataStatus')),
                ('name', models.CharField(max_length=30, verbose_name='systemSetting_field_name')),
                ('value', models.TextField(verbose_name='systemSetting_field_value')),
            ],
            options={
                'verbose_name': 'base_model_systemSetting',
                'verbose_name_plural': 'base_model_systemSetting',
            },
            managers=[
                ('all_objects', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='TaskResultLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task', models.CharField(max_length=50, verbose_name='Task')),
                ('status', models.CharField(max_length=10, verbose_name='Status')),
                ('result', models.CharField(max_length=500, verbose_name='Result')),
                ('time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Time')),
            ],
            options={
                'verbose_name': 'task_result_log',
                'verbose_name_plural': 'task_result_log',
            },
        ),
        migrations.CreateModel(
            name='TempUser',
            fields=[
                ('email', models.CharField(max_length=30, primary_key=True, serialize=False)),
                ('self_password', models.CharField(blank=True, max_length=128, null=True)),
                ('company_name', models.CharField(max_length=25)),
                ('user_name', models.CharField(max_length=25)),
                ('joined', models.CharField(blank=True, default='False', max_length=5, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='AbstractPermission',
            fields=[
            ],
            options={
                'verbose_name': 'Abstract Permission',
                'verbose_name_plural': 'Abstract Permissions',
                'proxy': True,
                'indexes': [],
            },
            bases=('auth.permission',),
            managers=[
                ('objects', mysite.base.models.modelless.AbstractPermissionManager()),
            ],
        ),
    ]
