# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='MyUser',
            fields=[
                ('id', models.CharField(default=uuid.uuid1, editable=False, max_length=36, primary_key=True, serialize=False)),
                ('username', models.CharField(help_text='user_field_usernameHelpTxt', max_length=30, unique=True, validators=[django.core.validators.RegexValidator('^[\\w.@+-]+$', 'user_field_usernameValidator', 'invalid')], verbose_name='user_field_username')),
                ('password', models.CharField(max_length=128, verbose_name='user_field_password')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='user_field_firstName')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='user_field_lastName')),
                ('emp_pin', models.CharField(blank=True, editable=False, max_length=30, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='user_field_email')),
                ('tel_phone', models.CharField(blank=True, max_length=30, null=True)),
                ('auth_time_dept', models.IntegerField(blank=True, default=0, null=True)),
                ('login_id', models.IntegerField(blank=True, default=0, null=True)),
                ('login_type', models.IntegerField(blank=True, default=0, null=True)),
                ('login_count', models.IntegerField(blank=True, default=0, editable=False, null=True, verbose_name='user_field_loginTimes')),
                ('is_staff', models.BooleanField(default=False, help_text='user_field_staffStatusHelpTxt', verbose_name='user_field_staff')),
                ('is_active', models.BooleanField(default=True, help_text='user_field_activeStatusHelpTxt', verbose_name='user_field_active')),
                ('is_public', models.BooleanField(default=False, editable=False)),
                ('can_manage_all_dept', models.BooleanField(default=False)),
                ('del_flag', models.IntegerField(blank=True, default=0, editable=False, null=True)),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='user_field_dateJoined')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='user_field_lastLogin')),
                ('login_name', models.CharField(default='', max_length=30, verbose_name='userProfile_field_username')),
                ('pin_tabs', models.TextField(blank=True, default='', verbose_name='userProfile_field_pinTabs')),
                ('disabled_fields', models.TextField(blank=True, default='', verbose_name='userProfile_field_hideColumns')),
                ('column_order', models.TextField(blank=True, default='', verbose_name='userProfile_field_order')),
                ('preferences', models.TextField(blank=True, default='', verbose_name='userProfile_field_preferences')),
                ('current_company', models.CharField(blank=True, max_length=36, null=True, verbose_name='user_field_current_company')),
                ('recent_company', models.CharField(blank=True, max_length=36, null=True, verbose_name='user_field_recent_company')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'base_model_user',
                'verbose_name_plural': 'base_model_user',
                'db_table': 'auth_user',
                'ordering': ['id'],
                'permissions': (('enter_system_module', 'can_enter_menu_system_module'), ('enter_personnel_module', 'can_enter_personnel_module'), ('enter_terminal_module', 'can_enter_terminal_module'), ('enter_attendance_module', 'can_enter_attendance_module'), ('enter_payroll_module', 'can_enter_payroll_module'), ('enter_access_module', 'can_enter_access_module')),
                'default_permissions': ('add', 'change'),
            },
        ),
    ]
