# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import mysite.admin.abstract_cloud_model
import mysite.personnel.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('personnel', '0001_initial'),
        ('iclock', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='transaction',
            name='emp',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='personnel.Employee', verbose_name='transaction_field_employee'),
        ),
        migrations.AddField(
            model_name='transaction',
            name='terminal',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='iclock.Terminal', verbose_name='transaction_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminalworkcode',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='terminaluploadlog',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='terminalUploadLog_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminalparameter',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='terminalParameter_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminallog',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='terminalLog_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminallocation',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='terminalParameter_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminalcommand',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='command_field_terminal'),
        ),
        migrations.AddField(
            model_name='terminal',
            name='area',
            field=mysite.personnel.fields.AreaForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Area', verbose_name='terminal_field_area'),
        ),
        migrations.AddField(
            model_name='terminal',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='publicmessage',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='publicMessage_field_terminal'),
        ),
        migrations.AddField(
            model_name='privatemessage',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='privateMessage_field_employee'),
        ),
        migrations.AddField(
            model_name='errorcommandlog',
            name='terminal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='iclock.Terminal', verbose_name='errorCommandLog_field_terminal'),
        ),
        migrations.AddField(
            model_name='deviceconfig',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='biophoto',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='bioPhoto_field_employee'),
        ),
        migrations.AddField(
            model_name='biodata',
            name='employee',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='bioData_field_employee'),
        ),
        migrations.AlterUniqueTogether(
            name='terminalparameter',
            unique_together=set([('terminal', 'param_name')]),
        ),
        migrations.AlterUniqueTogether(
            name='terminallocation',
            unique_together=set([('terminal', 'gps_time')]),
        ),
        migrations.AlterUniqueTogether(
            name='biodata',
            unique_together=set([('employee', 'bio_no', 'bio_index', 'bio_type', 'bio_format', 'major_ver')]),
        ),
    ]
