# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mysite.admin.abstract_cloud_model
import mysite.personnel.fields
import mysite.workflow.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('personnel', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AbstractException',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('audit_status', models.SmallIntegerField(choices=[(1, 'approvalStatus_option_pending'), (4, 'approvalStatus_option_reApply'), (6, 'approvalStatus_option_revoke'), (5, 'approvalStatus_option_auditing'), (2, 'approvalStatus_option_approved'), (3, 'approvalStatus_option_reject')], default=1, editable=False, verbose_name='approval_field_approvalStatus')),
                ('revoke_reason', models.TextField(blank=True, max_length=200, null=True, verbose_name='workflow_field_revokeRemark')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NodeInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, verbose_name='name')),
                ('order', models.SmallIntegerField(default=0, verbose_name='number_order')),
                ('state', models.SmallIntegerField(choices=[(1, 'workflow_node_state_pending'), (2, 'workflow_node_state_approved'), (4, 'workflow_node_state_void'), (5, 'workflow_node_state_reapply'), (6, 'workflow_node_state_revoke')], default=1, editable=False, verbose_name='node_state')),
                ('is_last_node', models.BooleanField(default=False, verbose_name='is_last_node')),
                ('is_next_node', models.BooleanField(default=False, verbose_name='is_next_node')),
                ('remark', models.CharField(max_length=255, null=True, verbose_name='remark')),
                ('apply_time', models.DateTimeField(null=True, verbose_name='apply_time')),
                ('approver_admin', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='node_approver_admin')),
                ('approver_employee', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='node_approver_employee')),
                ('departments', mysite.personnel.fields.DepartmentForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='departments')),
            ],
            options={
                'verbose_name': 'workflow_node_instance',
            },
        ),
        migrations.CreateModel(
            name='WorkflowEngine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('workflow_code', models.CharField(max_length=50, unique=True, verbose_name='workflowEngine_field_code')),
                ('workflow_name', models.CharField(max_length=50, verbose_name='workflowEngine_field_name')),
                ('start_date', models.DateField(verbose_name='workflowEngine_field_startDate')),
                ('end_date', models.DateField(verbose_name='workflowEngine_field_endDate')),
                ('description', models.CharField(max_length=50, verbose_name='workflowEngine_field_description')),
                ('workflow_type', models.SmallIntegerField(default=0, verbose_name='workflowEngine_field_type')),
                ('inform_type', models.SmallIntegerField(choices=[(0, 'workflowEngine_informTypeOption_none'), (1, 'workflowEngine_informTypeOption_email'), (2, 'workflowEngine_informTypeOption_alert'), (3, 'workflowEngine_informTypeOption_email&alert')], default=1, verbose_name='workflowEngine_field_informType')),
                ('del_flag', models.SmallIntegerField(blank=True, default=0, editable=False, null=True)),
                ('applicant_position', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Position', verbose_name='workflowEngine_field_applicantPosition')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='workflowEngine_field_contentType')),
                ('departments', mysite.personnel.fields.DepartmentForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='workflowEngine_field_departments')),
                ('employee', mysite.workflow.fields.EmployeeManyToManyField(blank=True, to='personnel.Employee', verbose_name='workflowEngine_field_employee')),
            ],
            options={
                'verbose_name': 'workflow_model_workflowEngine',
            },
        ),
        migrations.CreateModel(
            name='WorkflowInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('workflow_code', models.CharField(max_length=255, verbose_name='workflow_code')),
                ('workflow_name', models.CharField(max_length=255, verbose_name='workflow_name')),
                ('start_date', models.DateField(verbose_name='start_date')),
                ('end_date', models.DateField(verbose_name='end_date')),
                ('issue_date', models.DateField(auto_now_add=True, verbose_name='issue_date')),
                ('description', models.CharField(max_length=255, verbose_name='workflow_description')),
                ('content_type', models.IntegerField(verbose_name='content_type')),
                ('inform_type', models.SmallIntegerField(verbose_name='inform_type')),
                ('del_flag', models.BooleanField(default=False, verbose_name='del_flag')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='personnel.Employee', verbose_name='workflow_instance_user')),
                ('exception', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='workflow.AbstractException')),
                ('workflow_engine', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='workflow.WorkflowEngine', verbose_name='workflow_engine')),
            ],
            options={
                'verbose_name': 'workflow_instance',
            },
        ),
        migrations.CreateModel(
            name='WorkflowNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('node_code', models.CharField(max_length=30, verbose_name='workflowNode_field_code')),
                ('node_name', models.CharField(max_length=30, verbose_name='workflowNode_field_name')),
                ('order_id', models.IntegerField(verbose_name='workflowNode_field_orderID')),
                ('approver_type', models.SmallIntegerField(blank=True, default=1, null=True, verbose_name='workflowNode_field_approverType')),
                ('notifier_type', models.SmallIntegerField(blank=True, default=1, null=True, verbose_name='workflowNode_field_notifierType')),
                ('approver_by_overall', models.BooleanField(choices=[(False, 'workflowNode_scopeOption_ownDepartment'), (True, 'workflowNode_scopeOption_all')], default=False, verbose_name='workflowNode_field_approverScope')),
                ('notify_by_overall', models.BooleanField(choices=[(False, 'workflowNode_scopeOption_ownDepartment'), (True, 'workflowNode_scopeOption_all')], default=False, verbose_name='workflowNode_field_notifyScope')),
                ('workflow_engine', models.IntegerField(verbose_name='workflowNode_field_engine')),
                ('workflow_engine_name', models.CharField(max_length=50, verbose_name='workflow_engine_name')),
            ],
            options={
                'verbose_name': 'workflow_model_workflowNode',
                'verbose_name_plural': 'workflow_model_workflowNode',
            },
        ),
        migrations.CreateModel(
            name='WorkflowRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role_code', models.CharField(max_length=30, unique=True, verbose_name='workflowRole_field_code')),
                ('role_name', models.CharField(max_length=50, unique=True, verbose_name='workflowRole_field_name')),
                ('description', models.CharField(blank=True, max_length=200, null=True, verbose_name='workflowRole_field_description')),
                ('company', models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company')),
            ],
            options={
                'verbose_name': 'workflow_model_workflowRole',
                'verbose_name_plural': 'workflow_model_workflowRole',
            },
        ),
        migrations.AddField(
            model_name='workflownode',
            name='approver',
            field=mysite.workflow.fields.WorkflowRoleManyToManyField(blank=True, to='workflow.WorkflowRole', verbose_name='workflowNode_field_approver'),
        ),
        migrations.AddField(
            model_name='workflownode',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='workflownode',
            name='notifier',
            field=mysite.workflow.fields.WorkflowRoleManyToManyField(blank=True, related_name='notifier_id', to='workflow.WorkflowRole', verbose_name='workflowNode_field_notifier'),
        ),
        migrations.AddField(
            model_name='nodeinstance',
            name='node_engine',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='workflow.WorkflowNode', verbose_name='workflow_node'),
        ),
        migrations.AddField(
            model_name='nodeinstance',
            name='workflow_instance',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='workflow.WorkflowInstance', verbose_name='workflow_instance'),
        ),
    ]
