# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mysite.admin.abstract_cloud_model
import mysite.base.models.modelless
import mysite.personnel.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('personnel', '0001_initial'),
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='systemsetting',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AlterUniqueTogether(
            name='sysparam',
            unique_together=set([('para_name', 'para_type')]),
        ),
        migrations.AlterUniqueTogether(
            name='syncjob',
            unique_together=set([('job_code', 'job_name')]),
        ),
        migrations.AlterUniqueTogether(
            name='syncemployee',
            unique_together=set([('emp_code',)]),
        ),
        migrations.AlterUniqueTogether(
            name='syncdepartment',
            unique_together=set([('dept_code', 'dept_name')]),
        ),
        migrations.AlterUniqueTogether(
            name='syncarea',
            unique_together=set([('area_code', 'area_name')]),
        ),
        migrations.AddField(
            model_name='sftpsetting',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='membership',
            name='auth_area',
            field=mysite.personnel.fields.AreaManyToManyField(blank=True, help_text='user_field_authorizedAreaHelpTxt', to='personnel.Area', verbose_name='user_field_authorizedArea'),
        ),
        migrations.AddField(
            model_name='membership',
            name='auth_dept',
            field=mysite.personnel.fields.DepartmentManyToManyField(blank=True, help_text='user_field_authorizedDepartmentHelpTxt', to='personnel.Department', verbose_name='user_field_authorizedDepartment'),
        ),
        migrations.AddField(
            model_name='membership',
            name='company',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company', to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='membership',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='membership',
            name='vendor_company',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vendor_company', to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='linenotifysetting',
            name='line_notify_dept',
            field=mysite.personnel.fields.DepartmentForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Department', verbose_name='lineNotify_field_department'),
        ),
        migrations.AddField(
            model_name='groupprofile',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='groupprofile',
            name='group_user',
            field=models.ManyToManyField(blank=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='dbmigrate',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='dbbackuplog',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='bookmark',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='bookmark',
            name='content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType', verbose_name='bookmark_field_contentType'),
        ),
        migrations.AddField(
            model_name='bookmark',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='bookmark_field_user'),
        ),
        migrations.AddField(
            model_name='autoexporttask',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='adminlog',
            name='company',
            field=models.ForeignKey(blank=True, default=mysite.admin.abstract_cloud_model.get_current_company, null=True, on_delete=django.db.models.deletion.CASCADE, to='personnel.Company'),
        ),
        migrations.AddField(
            model_name='adminlog',
            name='content_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType', verbose_name='adminLog_field_contentType'),
        ),
        migrations.AddField(
            model_name='adminlog',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='adminLog_field_user'),
        ),
        migrations.CreateModel(
            name='SystemSettingPermission',
            fields=[
            ],
            options={
                'verbose_name': 'System Setting Permission',
                'verbose_name_plural': 'System Setting Permissions',
                'proxy': True,
                'indexes': [],
            },
            bases=('base.abstractpermission',),
            managers=[
                ('objects', mysite.base.models.modelless.ReportPermissionManager()),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='sftpsetting',
            unique_together=set([('user_name', 'host')]),
        ),
        migrations.AlterUniqueTogether(
            name='membership',
            unique_together=set([('user', 'company')]),
        ),
        migrations.AlterUniqueTogether(
            name='linenotifysetting',
            unique_together=set([('line_notify_dept', 'line_notify_token', 'message_type')]),
        ),
    ]
