# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-01-03 17:29
from __future__ import unicode_literals

import datetime
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AttCalcLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('department_id', models.IntegerField(blank=True, db_column='dept_id', null=True)),
                ('employee_id', models.IntegerField(blank=True, db_column='emp_id', null=True)),
                ('start_date', models.DateTimeField(verbose_name='start_date')),
                ('end_date', models.DateTimeField(verbose_name='end_date')),
                ('update_time', models.DateTimeField(verbose_name='update_time')),
                ('log_type', models.IntegerField(verbose_name='log_type')),
            ],
            options={
                'verbose_name': 'att_calc_log',
                'verbose_name_plural': 'att_calc_log',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='AttReportSetting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('resign_emp', models.SmallIntegerField(default=1)),
                ('short_date', models.SmallIntegerField(default=1)),
                ('short_time', models.SmallIntegerField(default=1)),
                ('func_key', models.TextField(blank=True, null=True)),
                ('att_item', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'att_model_calculateItem',
                'verbose_name_plural': 'att_model_calculateItem',
            },
        ),
        migrations.CreateModel(
            name='AttRule',
            fields=[
                ('param_name', models.CharField(max_length=56, primary_key=True, serialize=False, verbose_name='attRule_field_paramName')),
                ('param_value', models.TextField(verbose_name='attRule_field_paramValue')),
            ],
            options={
                'verbose_name': 'att_model_attRule',
                'verbose_name_plural': 'att_model_attRule',
                'ordering': ['param_name'],
            },
        ),
        migrations.CreateModel(
            name='AttSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_date', models.DateField(verbose_name='schedule_field_startDate')),
                ('end_date', models.DateField(verbose_name='schedule_field_endDate')),
            ],
            options={
                'verbose_name': 'att_model_schedule',
                'verbose_name_plural': 'att_model_schedule',
                'ordering': ['id'],
                'default_permissions': ('delete', 'change', 'view'),
            },
        ),
        migrations.CreateModel(
            name='AttShift',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(max_length=50, verbose_name='attShift_field_alias')),
                ('cycle_unit', models.SmallIntegerField(choices=[(0, 'attShift_cycleUnitOption_day'), (1, 'attShift_cycleUnitOption_week'), (2, 'attShift_cycleUnitOption_month')], default=1, verbose_name='attShift_field_cycleUnit')),
                ('shift_cycle', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1)], verbose_name='attShift_field_cycle')),
                ('work_weekend', models.BooleanField(default=True, verbose_name='work_on_weekend_as')),
                ('weekend_type', models.SmallIntegerField(choices=[(0, 'shift_OTOption_normalWork'), (1, 'shift_OTOption_normalOT'), (2, 'shift_OTOption_weekendOT')], default=0, verbose_name='work_on_weekend_as')),
                ('work_day_off', models.BooleanField(default=True, verbose_name='work_on_day_off_as')),
                ('day_off_type', models.SmallIntegerField(choices=[(0, 'shift_OTOption_normalWork'), (1, 'shift_OTOption_normalOT'), (2, 'shift_OTOption_weekendOT')], default=0, verbose_name='work_on_day_off_as')),
                ('auto_shift', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='attShift_field_autoShift')),
            ],
            options={
                'verbose_name': 'att_model_shift',
                'verbose_name_plural': 'att_model_shift',
            },
        ),
        migrations.CreateModel(
            name='BreakTime',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias', models.CharField(max_length=50, verbose_name='breakTime_field_alias')),
                ('period_start', models.TimeField(default=datetime.time(12, 0), verbose_name='breakTime_field_startTime')),
                ('duration', models.IntegerField(default=60, help_text='time_unit_minute', validators=[django.core.validators.MinValueValidator(0)], verbose_name='breakTime_field_duration')),
                ('end_margin', models.IntegerField(default=60, help_text='breakTime_field_endMarginHelpTxt', validators=[django.core.validators.MinValueValidator(0)], verbose_name='breakTime_field_endMargin')),
                ('func_key', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='breakTime_field_baseOnPunchType')),
                ('available_interval_type', models.SmallIntegerField(choices=[(0, 'timeInterval_typeOption_basedOnRule'), (1, 'timeInterval_typeOption_userDefined')], default=0, verbose_name='breakTime_field_duplicatePunch')),
                ('available_interval', models.IntegerField(default=1, help_text='time_unit_minute', verbose_name='breakTime_field_duplicatePunchPeriod')),
                ('multiple_punch', models.SmallIntegerField(choices=[(0, 'boolean_option_no'), (1, 'boolean_option_yes')], default=0, verbose_name='breakTime_field_useMultiplePunch')),
                ('calc_type', models.SmallIntegerField(choices=[(0, 'breakTime_calculateMode_autoDeduct'), (1, 'breakTime_calculateMode_requiredPunch')], default=0, verbose_name='breakTime_field_calculateType')),
                ('minimum_duration', models.IntegerField(default=0, help_text='time_unit_minute', null=True, verbose_name='breakTime_field_minimumBreakTime')),
                ('early_in', models.SmallIntegerField(choices=[(0, 'unscheduled_ignore'), (1, 'unscheduled_move2normalWork'), (2, 'unscheduled_move2normalOvertime'), (3, 'unscheduled_move2weekendOvertime'), (4, 'unscheduled_move2holidayOvertime')], default=0, verbose_name='breakTime_field_earlyIn')),
                ('min_early_in', models.IntegerField(default=0, help_text='time_unit_minute', verbose_name='breakTime_field_minEarlyIn')),
                ('late_in', models.SmallIntegerField(choices=[(0, 'breakTime_lateInMode_ignore'), (1, 'breakTime_lateInMode_move2Late'), (2, 'breakTime_lateInMode_move2EarlyOut'), (3, 'breakTime_lateInMode_move2Absence')], default=0, verbose_name='breakTime_field_lateIn')),
                ('min_late_in', models.IntegerField(default=0, help_text='time_unit_minute', verbose_name='breakTime_field_minLateIn')),
            ],
            options={
                'verbose_name': 'att_model_breakTime',
                'verbose_name_plural': 'att_model_breakTime',
            },
        ),
    ]
