(function ($, window) {
    var div = document.createElement('div');
    var tempHtml = '<div id="{{id}}" class="previewbox"><div class="preview-header">{{header}}</div><div class="preview-content"></div></div>';
    var itemTempHtml = '<div class="content-item"><div class="content-item-scroller">{{imageContainer}}</div></div>';
    var imageContainerHtml1 = '<div class="image-container" style="{{style}}"><img src="{{src}}" style="width: 100%;height: 100%;" alt="" /></div>';
    var PreviewPhoto = function (opt) {
        this.options = $.extend({
            id: "__HTY__PHOTO__" + Date.now(),
            header: '<span class="preview-indicator"></span>',
            index: 0, // 获取当前被点击的图片的索引值
            maxIndex: 0, // 获取图片总数
            screenWidth: 0, // 屏幕分辨率宽度
            minMoveDistance: 0, // 最小滑动距离
            actualMoveDistance: 0, // 实际滑动距离
            startClickX: 0, // 单指滑动开始的坐标 X
            startClickY: 0, // 单指滑动开始的坐标 Y
            startX: 0, // 多指滑动开始的坐标 X
            startY: 0, // 多指滑动开始的坐标 Y
            slideStyle: 'translate3d(0, 0, 0)', // 默认滚动样式
            scaleCells: [], // 缩放记录集合
            imageContainerType: 1 // 图片承载类型 1、iframe  2、div
        }, opt || {});
        this.init();
        this.initEvent();
    };
    PreviewPhoto.prototype = {
        // 初始化方法
        init: function () {
            if ($('#' + this.options.id)) { $('#' + this.options.id).remove(); }
            var el = document.getElementById(this.options.id);
            if (!el) {
                $('.previewbox').remove(); //重要的一步,防止重复初始。
                div.innerHTML = tempHtml.replace(/\{\{id\}\}/g, this.options.id).replace('{{header}}', this.options.header);
                document.body.appendChild(div.firstElementChild);
                el = document.getElementById(this.options.id);
            }

            this.element = el;
            this.scroller = this.element.querySelector('.preview-content');
            this.indicator = this.element.querySelector('.preview-indicator');

            this.generateImages();
        },
        // 初始化事件
        initEvent: function () {
            var self = this;
            // 页面点击事件
            $('.preview-content').on('click', function () {
                self.element.style.display = "none";
            });

            // 页面图片点击事件
            $('img[data-preview-src]').each(function (index) {
                $(this).on('click', function () {
                    self.openImage(index);
                });
            });
        },
        // 初始化照片
        generateImages: function () {
            this.scroller.innerHTML = ''
            var imgs = document.querySelectorAll("img[data-preview-src]");
            if (imgs.length) {
                var sWidth = $(window).width(), sHeight = $(window).height();
                this.options = $.extend(this.options, {
                    maxIndex: imgs.length, // 获取图片总数
                    screenWidth: sWidth, // 屏幕分辨率宽度
                    minMoveDistance: Math.floor(this.options.screenWidth / 6), // 最小滑动距离
                });
                this.loadImage(0, imgs, sWidth, sHeight);
            }
            this.element.style.display = "none";
        },
        // 加载单张照片
        loadImage: function (i, imgs, sWidth, sHeight) {
            var that = this; var count = imgs.length;
            if (count > 0) {
                var src = $(imgs[i]).attr('src');
                var mapload = $(imgs[i]).attr('data-preview-src');
                if (!mapload) {
                    mapload = src;
                }
                // 创建对象
                var img = new Image();
                // 改变图片的src
                img.src = mapload;
                // 加载完成执行
                img.onload = function () {
                    if(sWidth >= img.width && sHeight >= img.height){ //如果图片比容器小
                        var rate = (sWidth - img.width > sHeight - img.height) ? sHeight / img.height  : sWidth / img.width;
                        img.width = parseInt((img.width * rate)-200);
                        img.height = parseInt((img.height * rate)-200);
                    }else{
                        if (img.height > img.width){
                            img.width = parseInt(sWidth) / 4;
                            img.height = parseInt(sHeight) / 4 * 3;
                        }else {
                            img.width = parseInt(sWidth) / 4 * 3;
                            img.height = parseInt(sHeight) / 4 * 3;
                        }
                    }
                    var _style = ("width: " + (img.width) + "px; height: " + (img.height) + "px;") + (sWidth > img.width ? " max-width: 100%;" + (sWidth > 800 ? "" : " max-height: " + sHeight * 0.6 + "px;") : "max-width: " + sWidth * 0.72 + "px; max-height: " + sHeight * 0.72 + "px;");
                    var _imageContainerHtml = "";
                    _imageContainerHtml = imageContainerHtml1;
                    _imageContainerHtml = _imageContainerHtml.replace(/{{style}}/g, _style).replace('{{src}}', mapload);
                    that.scroller.innerHTML += itemTempHtml.replace('{{imageContainer}}', _imageContainerHtml);
                    that.loadImage(i + 1, imgs, sWidth, sHeight);
                };
            }
        },
        // 打开照片
        openImage: function (index) {
            var el = $('#' + this.options.id).find(".content-item"), count = el.length;
            if (count > index) {
                this.options.index = index;
                this.indicator.innerHTML = (index ? index + 1 : 1) + '/' + this.options.maxIndex;
                this.options.slideStyle = "translate3d(" + (index * this.options.screenWidth * (-1)) + "px, 0, 0)";
                this.scroller.style.transform = this.options.slideStyle;
                this.element.style.display = "";
            }
        }
    };

    // 设置调用方法
    window.PreviewPhoto = function (opt) {
        return new PreviewPhoto(opt);
    };
})(jQuery, window);