/*****
 * 使用前需要引用echarts.js
 * 向外提供三个方法
 *  PersonTrack.init() //渲染页面
 *  PersonTrack.addData() //添加数据
 *  PersonTrack.deleteData() //删除数据
 */
(function() {

    function PersonTrack() { }

    /**
     * 点位显示大小
     * 0  不显示
     * 15 正常大小
     */
    let showFlag = 15;

    /**
     * 点位数组
     * @type {any[]}
     */
    let pointArr = new Array();


    /**
     * x轴数据
     * 同时length当作y轴 下一个 替换默认数据的index
     */
    let xzhou = [];


    //数据列表，当点击时，push进该列表
    var eventList = new Array();

    /**
     * 数据
     */
    let myData = new Array();


    /**
     * 假数据
     */
    let fakeEvent = false;

    /**
     * 初始化数据
     * x 轴就是 x
     * Y 轴就是设备的数组下标
     */
    function initMyData(skin){
        //一定要默认6个点位，首先判断是否达到
        pointArr = new Array();
        if (pointArr.length < 6 ){
            //初始化假点位
            for (let i = 0; i < 6; i++) {
                let tmpPoint = {
                    "pointName":"",
                    "pointId":""
                };
                tmpPoint.pointName = I18n.getValue('esdc_leave_post_point') + i;
                tmpPoint.pointId = "id" + i;
                pointArr[i] = tmpPoint;
            }
        }

        //判断 标星的 数据列表个数，因为y 轴是根据数据来的，没有数据就没有y 轴，这时候必须造一个假数据。
        if (eventList.length == 0){
            var fakeEventItem = {
                eventId:"fakeId",
                deviceId: "device5",
                deviceName : I18n.getValue('esdc_entrance_point_position_5'),
                eventTime: I18n.getValue('esdc_common_timePoint')+"1"
            };
            eventList[0] = fakeEventItem;
            fakeEvent = true;
        }

        //根据星选数据列表，初始化 x 轴
        xzhou = new Array();
        for (let i = 0; i < eventList.length; i++) {
            let item = eventList[i];
            if (item != undefined){
                //首先认为需要新加 x 轴元素
                let xIndex = xzhou.length;
                let xFlag = false;
                let xText = item.eventTime;
                //遍历已有 x 轴，判断该文本是否已经存在？
                for (let j = 0; j < xzhou.length; j++) {
                    if (xzhou[j] == xText){
                        xIndex = j;
                        xFlag = true;
                    }
                }
                //如果该时间没有在 x轴上生成，就push到x轴数组内去 初始化生成
                if (!xFlag){
                    xzhou[xIndex] = item.eventTime;
                }
            }
        }
        //排序时间
        xzhou.sort();

        //根据星选数据列表， 初始化 y 轴
        //已经替换了 6 个中的第几个？
        let positionPointer = 0;
        for (let i = 0; i < eventList.length; i++) {
            //因为y轴的点位都是默认设置的，所以首先需要根据 真实的 星选数据 逐个替换
            /**
             * 已经替换了几个默认点位
             */
            let item = eventList[i];
            if (item != undefined){
                //替换第pointer个
                if (positionPointer == 6){
                    //超过了6个点位，需要生成新的点位
                    let existFlag;
                    for (let j = 0; j < pointArr.length; j++) {
                        if(pointArr[j].pointId == item.deviceId){
                            existFlag = true;
                        }
                    }
                    if (!existFlag){
                        let tmpPoint = {
                            "pointName":"",
                            "pointId":""
                        };
                        tmpPoint.pointName = item.deviceName;
                        tmpPoint.pointId = item.deviceId;
                        pointArr.push(tmpPoint)
                    }
                }else{
                    //查询该点位是否已经存在了
                    let existFlag;
                    for (let j = 0; j < pointArr.length; j++) {
                        if(pointArr[j].pointId == item.deviceId){
                            existFlag = true;
                        }
                    }
                    if (!existFlag){
                        let tmpPoint = {
                            "pointName":"",
                            "pointId":""
                        };
                        tmpPoint.pointName = item.deviceName;
                        tmpPoint.pointId = item.deviceId;
                        pointArr[5 - positionPointer] = tmpPoint;
                        positionPointer ++;
                    }
                }
            }
        }

        //确定各个星选数据 的 x y坐标位置
        //x 就是x轴的index
        //y就是 pointArr 的index
        myData = [];
        for (let i = 0; i < eventList.length; i++) {
            let item = eventList[i];
            if (item != undefined){
                let x;
                let y;
                //找x 坐标
                let eventTime = item.eventTime;
                for (let j = 0; j < xzhou.length; j++) {
                    if(xzhou[j] == eventTime){
                        x = j;
                    }
                }

                for (let j = 0; j < pointArr.length; j++) {
                    if (item.deviceId == pointArr[j].pointId){
                        y = j;
                    }
                }
                myData[x] = y;
            }
        }

        option.series[0].data = myData;

    }
    //折线图蓝皮肤颜色切换
    function psResultStarColor(){
        if ($("#psResultSkinColor").val() == 'techblue'){
            return 'image://data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAABWzo5XAAAAAXNSR0IArs4c6QAAAi5JREFUOE+tlM1LVGEUxn/n3nHGAhNaVBRZZFBCi4gWFqahyRBRiwqCIEpwFkGjtGjRfxCtdIaIspI+Nn1u2hgypUTiIlpEHy7USIOoTZkLvePce+K9M+PMXC9Di97VPR/vc573OedcIeykF9rx5BQi7SgNfoowg+pL0Ef0rsoEr0mFI+3sROU6qgdDCxSdIiOInicZm1h2LV9ILbWh3nOgripIKTiPWEfpqRnNEzbHMHEZR6gPgpxtsrAF7nzyVuIrc9g0G2aCqpDKjgHNwcw1UfiRiPrVNtzK8tsJ5TpOT3S/kFo4hFrDYSnnmiwGOyN+qDuT4/bHEFb+u7xOIbV4E5WEsTfXCfEGwSq0ILHLZu+6vPHup3Ljg+t/ewovZpTZec3XFx0Q+p1JoNHYfa02vbvtf9L62nuXCyN5YGDKAJmXR41VH4X+tghG4GrnwYRHcjRXrlnWAP0JtvzYNouHhyPUBsg5LpweyvFsaoVWPpAZqh3lDLbUCV+6agqzUYoYRbbfXWJ6rqBNKTRtgO4BZ8qBLu2xudqSp/PLAVVYW5vPuDzmcuXtsjbFa/eFvsU4IkPlQKMnamjdJAx99ejOuH6XBjpsjmy1ePNdaXm8VCmhaDx0IA9sFNavFp5OepQ/4nij5TN89a1Co8JAGuwqK1K1fWZFlH1cjH0ubf9/WdpiWcPMYzBs7wLMxrHoCv+NFDPNEqedTuAkKh1mc4AsMIvoa+AJydgwIhUz8Bdm88fRiVfHjgAAAABJRU5ErkJggg==';
        }
        return 'image://data:image/png;base64,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';
    }

    /**
     * 待加载的配置
     */
    let option = {
        backgroundColor: '#FFFFFF',
        xAxis: {
            type: 'category',
            data: xzhou,
            axisTick:{
                show:false//不显示坐标轴刻度线
            },
            axisLine: {
                show: false,//不显示坐标轴线
            },
            axisLabel: {
                textStyle: {
                    color: '#717880',
                    fontSize: 10
                },
                formatter: function(params){
                    var time = params.split(" ");
                    if(time.length > 1){
                        return time[1]+"\n"+time[0];
                    }
                    return time[0];
                }
            },
        },
        yAxis: {
            type: 'value',
            // splitNumber: pointArr.length,
            splitNumber: pointArr.length,
            axisLabel: {
                textStyle: {
                    color: '#717880',
                    fontSize: 10
                },
                formatter: function(v){
                    // return v;
                    if (pointArr[v] == undefined){
                        return "";
                    }
                    return pointArr[v].pointName.length > 18 ? pointArr[v].pointName.slice(0, 18) + '...' : pointArr[v].pointName;
                    // return v;
                }
            },
            axisTick:{
                show:false//不显示坐标轴刻度线
            },
            axisLine: {
                show: false,//不显示坐标轴线
            },
            interval: 1
        },
        color:[$("#psResultSkinColor").val() == 'techblue' ? '#0091F9' : '#7AC143'],
        series: [{
            data: myData,
            type: 'line',
            symbol: psResultStarColor(),
            symbolSize: showFlag,
            //是否启用所有点
            // showAllSymbol: true,
            lineStyle: {
                width: 1,
                type: 'solid'
            },
            itemStyle: {
                borderWidth: 3,
                borderColor: $("#psResultSkinColor").val() == 'techblue' ? '#0091F9' : '#7AC143',
            }
        }],
        dataZoom: [
        //     {
        //     type: 'slider',
        //     show: false,
        //     xAxisIndex: [0],
        //     // height: 20,
        //     start: 0,
        //     end: 50
        // },
            {
                type: 'inside',
                xAxisIndex: [0],
                start: 0,
                end: 100
            }],
        grid: {
            top: '10%',
            left: '17%',
            bottom: '20%',
            right: '2%'
        },
        tooltip: {
            show : true,
            trigger: 'item',
            formatter:function (params) {
                var res = "";
                for (let i = 0; i < eventList.length; i++) {
                    if (params['name'] == eventList[i].eventTime){
                        var eventId = eventList[i].eventId + ","+eventList[i].faceRate;
                        res = "<div id='"+eventId+"'>"+I18n.getValue('esdc_leave_post_point')+":" + eventList[i].deviceName + "<br/>" + I18n.getValue('esdc_dashboard_eventTime') + ":" + eventList[i].eventTime + "<br/></div>";
                    }
                }
                return res;
            }
        }
    };

    /**
     * 初始化
     */
    let myLineChart1;
    function init(domId, skin){
        initMyData(skin);
        let element = document.getElementById(domId);
        myLineChart1 = echarts.init(element);

        option.yAxis.splitNumber = pointArr.length;

        option.xAxis.data = xzhou;

        option.series.data = myData;

        if (fakeEvent){
            showFlag = 0;
        }else{
            showFlag = 15;
        }

        option.series[0].symbolSize = showFlag;

        if (skin == "techblue") {
            option.backgroundColor = '#03528B';
            option.xAxis.axisLabel.textStyle.color = '#CBE1F1';
            option.yAxis.axisLabel.textStyle.color = '#CBE1F1';
            option.color = '#0091F9';
            option.series.forEach(function () {
                option.series[0].symbol = 'image://data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAASCAYAAABWzo5XAAAAAXNSR0IArs4c6QAAAi5JREFUOE+tlM1LVGEUxn/n3nHGAhNaVBRZZFBCi4gWFqahyRBRiwqCIEpwFkGjtGjRfxCtdIaIspI+Nn1u2hgypUTiIlpEHy7USIOoTZkLvePce+K9M+PMXC9Di97VPR/vc573OedcIeykF9rx5BQi7SgNfoowg+pL0Ef0rsoEr0mFI+3sROU6qgdDCxSdIiOInicZm1h2LV9ILbWh3nOgripIKTiPWEfpqRnNEzbHMHEZR6gPgpxtsrAF7nzyVuIrc9g0G2aCqpDKjgHNwcw1UfiRiPrVNtzK8tsJ5TpOT3S/kFo4hFrDYSnnmiwGOyN+qDuT4/bHEFb+u7xOIbV4E5WEsTfXCfEGwSq0ILHLZu+6vPHup3Ljg+t/ewovZpTZec3XFx0Q+p1JoNHYfa02vbvtf9L62nuXCyN5YGDKAJmXR41VH4X+tghG4GrnwYRHcjRXrlnWAP0JtvzYNouHhyPUBsg5LpweyvFsaoVWPpAZqh3lDLbUCV+6agqzUYoYRbbfXWJ6rqBNKTRtgO4BZ8qBLu2xudqSp/PLAVVYW5vPuDzmcuXtsjbFa/eFvsU4IkPlQKMnamjdJAx99ejOuH6XBjpsjmy1ePNdaXm8VCmhaDx0IA9sFNavFp5OepQ/4nij5TN89a1Co8JAGuwqK1K1fWZFlH1cjH0ubf9/WdpiWcPMYzBs7wLMxrHoCv+NFDPNEqedTuAkKh1mc4AsMIvoa+AJydgwIhUz8Bdm88fRiVfHjgAAAABJRU5ErkJggg==';
            });
        }

        myLineChart1.setOption(option);
        //点击点位弹出详情框
        if (!myLineChart1._$handlers.click) {
            myLineChart1.on('click',function (params) {
                var paramEventId = $(this._dom.innerHTML)[1].firstChild.id;
                var splitParam = paramEventId.split(",");
                var eventId = splitParam[0];
                var faceRate = splitParam[1];
                if (faceRate != "undefined"){
                    var opts = {
                        path: "esdcPersonnelSearch.do?getEventDetail&eventId=" + eventId + "&faceRate=" + faceRate,
                        width: 800,
                        height: 450,
                        title: I18n.getValue('esdc_common_detailInfo')
                    };
                    DhxCommon.createWindow(opts);
                }
            });
        }
    }

    /**
     * 初始化渲染轨迹
     */
    PersonTrack.init = function (domId, skin){
        init(domId, skin);
    }

    /**
     * 添加数据
     * @param data
     */
    PersonTrack.addData = function (data){
        if (fakeEvent){
            data.eventTime = timestampToTime(data.eventTime.replace(/-/g,"/"),"yyyy-MM-dd HH:mm:ss");
            eventList[0] = data;
        }else{
            for (let i = 0; i < eventList.length; i++) {
                if (eventList[i].eventId == data.eventId){
                   return;
                }
            }
            data.eventTime = timestampToTime(data.eventTime.replace(/-/g,"/"),"yyyy-MM-dd HH:mm:ss");
            eventList.push(data);
        }
        fakeEvent =false;
    }

    /**
     * 删除数据
     * @param id
     */
    PersonTrack.deleteData = function (id){
        let index = -1;
        for (let i = 0; i < eventList.length; i++) {
            if (eventList[i].eventId == id){
                index = i;
            }
        }
        if (index != -1){
            eventList.splice(index,1);
        }
    }

    /**
     * 删除所有数据
     * @param id
     */
    PersonTrack.deleteAllData = function (){
        eventList.splice(0,eventList.length);
    }


    /***********************************************************
     *      成员方法定义  end
     **********************************************************/

    window.PersonTrack = PersonTrack;

    //点击左侧菜单栏初始折线图
    $("#leftHeader").on('click',function () {
        myLineChart1.resize();
    });
})()