/***************************************************************************************
 侧边栏插件
 @autor     iProg
 @date      2016-01-25
 @version   1.0

 使用方法：
 在页面建立html标签如下：
 <div class="sliderbar-container">
 <div class="title"><i></i> 通知消息</div>
 <div class="body">
 无消息
 </div>
 </div>

 说明：上面的class属性值，除了sliderbar-container1可以随意更改，其它的如title，body都
 不能更改哦！

 然后加入js代码如下，就可以了:
 <script type="text/javascript">
 $(function(){
    $('.sliderbar-container').sliderBar({
        open : true,
        top : 200,
        width : 360,
        height : 240,
        theme : '#463eee',
        position : 'right'
    });
 });
 </script>
 ****************************************************************************************/
;(function ($) {
    $.fn.extend({
        "sliderBar": function (options) {
            // 使用jQuery.extend 覆盖插件默认参数
            var opts = $.extend(
                {} ,
                $.fn.sliderBar.defalutPublic ,
                options
            );

            // 这里的this 就是 jQuery对象，遍历页面元素对象
            // 加个return可以链式调用
            return this.each(function () {
                //获取当前元素 的this对象 
                var $this = $(this);

                $this.data('open', opts.open);

                privateMethods.initSliderBarCss($this, opts);

                switch(opts.position){
                    case 'right' : privateMethods.showAtRight($this, opts); break;
                    case 'left'  : privateMethods.showAtLeft($this, opts); break;
                    case 'bottom' :  privateMethods.showAtBottom($this, opts); break;
                }

            });
        }
    });

    // 默认公有参数
    $.fn.sliderBar.defalutPublic = {
        open : true,           // 默认是否打开，true打开，false关闭
        top : 200,             // 距离顶部多高
        width : 260,           // body内容宽度
        height : 200,          // body内容高度
        theme : 'green',       // 主题颜色
        position : 'left'      // 显示位置，有left和right两种
    }

    var privateMethods = {
        initSliderBarCss : function(obj, opts){
            obj.css({
                'width': opts.width+20+'px',
                // 'height' : opts.height+20+'px',
                // 'height' : opts.height+'%',
                /**'top' : opts.top+'px',*/
                // 'border' : '1px solid '+opts.theme,
                // 'position':'fixed',
                'position':'absolute',
                'font-family':'Microsoft Yahei',
                'z-index': '9999'
            }).find('.body').css({
                /*'width': opts.width+'px',*/
                'height' : "100%",
                'position':'relative',
                /*'padding':'10px',*/
                'overflow-x':'hidden',
                'overflow-y':'auto',
                'font-family':'Microsoft Yahei',
                'font-size' : '12px'
            });

            var titleCss = {

                'position':'absolute',
                'display':'block',
                'font-size': '13px',
                'color':'#fff',
                'cursor': 'pointer',
                'font-family':'Microsoft Yahei',
                'margin-left':'3px'
            }

            obj.find('.title').css(titleCss).find('i').css({
                'font-size': '12px'
            });
        },
        showAtLeft : function(obj, opts){
            obj.css('top',opts.top + 'px');
            obj.css({'height' :opts.height + '%'});
            obj.css('box-shadow','rgba(0, 0, 0, 0.3) 2px 2px 3px');
            obj.css(' -moz-box-shadow','10px 10px 5px #888888');
            // obj.find('.title').css('background',"url('../images/esdc_arrow_r.png') no-repeat center  #EAEBEC");
            // obj.find('.title').css('background-size',"20px");
            if(opts.open){
                obj.css({margin:'0px'});
                obj.css({"margin-top":opts.top + 'px'});
                obj.css({border:'none'});
                // obj.find('.title').css('right','-12px').find('i').attr('class','fa fa-chevron-circle-left');
                // obj.find('.title').css('top','-1px');
                // obj.find('.title').css('width','3px');
                // obj.find('.title').css('height','100%');
            }else{
                obj.css({"margin-left":-opts.width-22+'px'});
                // obj.find('.title').css('right','-12px').find('i').attr('class','fa fa-chevron-circle-right');
                // obj.find('.title').css('top','-1px');
                // obj.find('.title').css('width','3px');
                // obj.find('.title').css('height','100%');
            }
            $('.realTimeEvent').click(function(){
                if(obj.data('open')){
                    obj.animate({"margin-left":-opts.width-22+'px'}, 500);
                    // $(this).find('i').attr('class','fa fa-chevron-circle-right');
                    // obj.find('.title').css('background',"url('../images/esdc_arrow_r.png') no-repeat center  #EAEBEC") ;
                    // obj.find('.title').css('background-size',"20px");
                }else{
                    obj.animate({"margin-left":'0px'}, 500);
                    // $(this).find('i').attr('class','fa fa-chevron-circle-left');
                    // obj.find('.title').css('background',"url('../images/esdc_arrow_l.png') no-repeat center  #EAEBEC") ;
                    // obj.find('.title').css('background-size',"20px");
                }
                obj.data('open',obj.data('open') == true ? false : true);
            });
        },
        showAtRight : function(obj, opts){
            if(opts.open){
                obj.css({right:'0px'});
                obj.css({top:opts.top + 'px'});
                obj.find('.title').css('right', opts.width+20+'px').find('i').attr('class','fa fa-chevron-circle-right');
                obj.find('.title').css('top','-1px')
            }else{
                obj.css({right:'25px'});
                obj.find('.title').css('right', opts.width+20+'px').find('i').attr('class','fa fa-chevron-circle-left');
            }

            obj.find('.title').click(function(){
                if(obj.data('open')){
                    obj.animate({right:-opts.width-22+'px'}, 500);
                    $(this).find('i').attr('class','fa fa-chevron-circle-left');
                }else{
                    obj.animate({right:'0px'}, 500);
                    $(this).find('i').attr('class','fa fa-chevron-circle-right');
                }
                obj.data('open',obj.data('open') == true ? false : true);
            });
        },
        showAtBottom : function(obj, opts){
            obj.css('box-shadow',' rgba(0, 0, 0, 0.3) -2px 7px 20px 3px');
            if(opts.open){
                obj.css({left:'0px'});
                obj.css({bottom:'0px'});
                obj.css({width:'80%'});
                obj.css({border :'none'});
                obj.css({height :opts.height + 20 + 'px'});
                // obj.css({top:opts.top + 'px'});
                // obj.find('.title').css('right','-25px').find('i').attr('class','fa fa-chevron-circle-left');
                obj.find('.title').css('top','-33px');
                // obj.find('.title').css('width','70px');
                // obj.find('.title').css('left','0');
                // obj.find('.title').css('border-radius','0 50px 50px 0');
                // obj.find('.title').css('background-color','#ffffff');
                // obj.find('.title').css('color','red');
            }else{
                obj.css({left:-opts.width-22+'px'});
                // obj.find('.title').css('right','-25px').find('i').attr('class','fa fa-chevron-circle-right');
            }

                $('.alarmStatistics').click(function(){
                if(obj.data('open')){
                    obj.animate({bottom:-opts.height-22+'px'}, 500);
                    // $(this).find('i').attr('class','fa fa-chevron-circle-right');
                }else{
                    obj.animate({bottom:'0px'}, 500);
                    // $(this).find('i').attr('class','fa fa-chevron-circle-left');
                }
                obj.data('open',obj.data('open') == true ? false : true);
            });

            obj.find('.title').click(function(){
                if(obj.data('open')){
                    obj.animate({bottom:-opts.height-22+'px'}, 500);
                    // $(this).find('i').attr('class','fa fa-chevron-circle-right');
                }else{
                    obj.animate({bottom:'0px'}, 500);
                    //移除图标报警动画
                    $("#alarmFlag").removeClass("breathe");
                    // $(this).find('i').attr('class','fa fa-chevron-circle-left');
                }
                obj.data('open',obj.data('open') == true ? false : true);
            });
        },
    };
})(jQuery)
