
(function() {

    /**
     * 面板主类
     * @constructor
     */
    function Ranking() { }

    /***********************************************************
     *      变量定义  begin
     **********************************************************/

        //当前选中的tab页
    var seleteModule = "";
    var chatrTimeType = "day";

    //通道报警监控过滤条件区域名称
    var psgAreaName = "";

    //计数器指针
    var _timer;

    //面板国际化数据
    var dbI18n = {};

    var uuid = "";

    var clientId = "";

    var countOfNormal = 0;//正常事件
    var countOfAlarm = 0;//报警事件
    var countOfWarn = 0;//异常事件
    var countOfTotal = 0;//事件总数




    /***********************************************************
     *      变量定义  end
     **********************************************************/



    /***********************************************************
     *      私有方法定义  begin
     **********************************************************/



    /***********************************************************
     *      私有方法定义  end
     **********************************************************/


    /***********************************************************
     *      成员方法定义  begin
     **********************************************************/

    Ranking.loadRankingWidgetData = function () {
        $.ajax({
            type: "get",
            contentType: "application/json; charset=utf-8",
            async: false,
            url: "esdcRankingWidget.do?list",
            data: {

            },
            success: function (data) {
                return data;
            }
        });
    }

    /**
     * 加载自定义查询的卡片
     */
    Ranking.loadRankingWidget = function () {
        $.ajax({
            type: "get",
            contentType: "application/json; charset=utf-8",
            async: true,
            url: "esdcRankingWidget.do?userWidgetList",
            data: {

            },
            success: function (data) {
                $("#rankingWidgets").html("");
                let settingList = data.data;
                for (let i = 0; i < settingList.length; i++) {
                    let setting = settingList[i];
                    // 根据是否是默认看板生成不同的看板样式
                    if("defaultWidgetsId" == setting.widgetId){
                        $.ajax({
                           type: "POST",
                           async: false,
                           dataType:"json",
                           url:"esdcRankingWidget.do?getDefaultWidget",
                           success: function (result) {
                               //加载默认的看板
                               loadDefaultWidgets(result);
                           }
                        });
                    }else{
                        $.ajax({
                            type: "GET",
                            // contentType: "application/json; charset=utf-8",
                            dataType: "html",
                            async: false,
                            url: "esdcRankingWidget.do?simpleRankingWidget",
                            data: {
                                rankingWidgetId: setting.widgetId
                            },
                            success: function (data) {
                                $("#rankingWidgets").append(data);
                                // $("#rankingBox").append("<div class=\"db_cont\">\n" +
                                //     "    <div class=\"db_left\">"+setting.rankingName+data.data.objName+"</div>\n" +
                                //     "</div>")
                            }
                        });
                    }
                }
            }
        });
    }

    /**
     * 加载面板
     */
    Ranking.load = function(_i18n, _uuid) {
        //国际化数据
        dbI18n = _i18n;
        uuid = _uuid;

        clientId = Math.round(Math.random() * 10000) + uuid;

        //加载人员总数
        // Ranking.loadNum(".db_chart_pers .db_chart_num", 0);

        //开启时间计数器
        // Ranking.timer();

        //注册全屏事件
        Web.attachEvent("onFullScreen", function(isFull) {
            if(isFull) {//全屏
                $("#top").hide();
                $(".db_box").css("top", "0px");
                document.body.style.minWidth="1000px";
            } else {
                $("#top").show();
                $(".db_box").css("top", "44px");
                if($(".top_fix_cla").length > 0 && $(".top_fix_cla").width() > 1000) {
                    $(document.body).css("min-width", $(".top_fix_cla").width());
                }
            }
        })

        // 加载卡片
        Ranking.loadRankingWidget();
    }



    /***********************************************************
     *      成员方法定义  end
     **********************************************************/

    window.Ranking = Ranking;
})()

var rankingFun = {

    //ajax异步请求的简单再次封装
    postAjax:function (url,parames,backFun,ecb, isRefresh) {
        $.ajax({
            url:url,
            type: 'post',
            dataType: 'json',
            data: parames,
            async : true,
            success: function(data){
                if(backFun instanceof Function){
                    backFun(data.data, isRefresh)
                }
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                if(ecb instanceof Function){
                    ecb(textStatus)
                }
            }
        })
    },
    removeLoadingSpiner:function(itemName,callBack){
        var loadingSpiner =  $("#"+itemName+"_loadingSpiner");
        if(!callBack){
            if(loadingSpiner){
                loadingSpiner.remove()
            }
        }
        else{
            callBack(loadingSpiner);
        }

    },

}

function linkToTag(tag) {
    window.event.cancelBubble = true;
    changeBorder("esdcRankingPanel.do?panelItem&panelId=" + tag);
}

function changeBorder(borderUrl) {
    $("#panelItem").html("");
    $.ajax({
        url: borderUrl,
        dataType: "text",
        async: false,
        success: function (res) {
            $("#mainPanel").hide();
            $("#panelItem").append(res);
            // $("#panelItem").addClass("animated lightSpeedIn");
            // setTimeout('$("#panelItem").removeClass("animated lightSpeedIn");', 1000);
        }
    });
}

function backToMain() {
    $("#panelItem").html("");
    $("#mainPanel").show();
    $("#mainPanel").addClass("animated lightSpeedIn");
    setTimeout('$("#mainPanel").removeClass("animated lightSpeedIn")', 1000);
}

//获取当前页面下的看板顺序
function getCurrentRankingWidgets(){
    let simpleWidgets = $("#rankingWidgets input");
    let widgets = "";
    simpleWidgets.each(function (){
        widgets += $(this).val()+",";
    })
    widgets = widgets.substring(0,widgets.length - 1);
    $.ajax({
        url:"esdcRankingWidget.do?recordWidgetsOrder",
        type: "POST",
        data: {"widgetOrder":widgets},
        async:false,
        success: function(result){

        }
    })
}
