var echartsLineType = "";
var keyPersonSkin =  $("#keyPersonSkin").val();
$(function () {
    $("#typeLineSelectDiv").hover(function () {
        $(".sele_tt_ul_line").show();
    }, function () {
        $(".sele_tt_ul_line").hide();
    });
    $("#typePieSelectDiv").hover(function () {
        $(".sele_tt_ul_pie").show();
    }, function () {
        $(".sele_tt_ul_pie").hide();
    });
    $("#typeAreaPieSelectDiv").hover(function () {
        $(".sele_tt_ul_area_pie").show();
    }, function () {
        $(".sele_tt_ul_area_pie").hide();
    });
    getInitEvent();
    getCurrentDayData();
    esdcEventData($('#esdc_event_day'), 'day', 'all');
});

/**
 * 获取实时时钟
 */
setInterval(getRealTime, 1000);

function getRealTime() {
    var date = new Date();
    var Week = [I18n.getValue('common_sunday'), I18n.getValue('common_monday'), I18n.getValue('common_tuesday'), I18n.getValue('common_wednesday'), I18n.getValue('common_thursday'), I18n.getValue('common_friday'), I18n.getValue('common_saturday')];
    var str = date.getFullYear() + "-" + (date.getMonth() >= 9 ? date.getMonth() + 1 : "0" + (date.getMonth() + 1)) + "-" + (date.getDate() > 9 ? date.getDate() : "0" + date.getDate()) + "  " + Week[date.getDay()] + "  " + (date.getHours() > 9 ? date.getHours() : "0" + date.getHours()) + ":" + (date.getMinutes() > 9 ? date.getMinutes() : "0" + date.getMinutes()) + ":" + (date.getSeconds() > 9 ? date.getSeconds() : "0" + date.getSeconds());
    $("#time").html(str);
}

/**
 * 获取当日数据
 */
function getCurrentDayData() {
    $.ajax({
        url: '/esdcTransaction.do?getCurrentDayData',
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (retData) {
            if (retData[sysCfg.ret] == sysCfg.success) {
                var numByType = retData.data;
                runNum(numByType.sum, $("#sumCount"));
                runNum(numByType.stranger, $("#strangerCount"));
                runNum(numByType.black, $("#blackCount"));
                runNum(numByType.white, $("#whiteCount"));
                $("#allEventId").val(numByType.allEventId);
                $("#strangerEventId").val(numByType.strangerEventId);
                $("#blackEventId").val(numByType.blackEventId);
                $("#whiteEventId").val(numByType.whiteEventId);
            }
        }
    });
}

/**
 * 统计事件时间切换
 */
function esdcEventData(event, type, chartType) {
    echartsLineType = type;
    if (chartType == 'line') {
        initEventLineCountChart(type);
    } else if (chartType == 'pie') {
        //initEventPieCountChart(type);
    } else if (chartType == 'areaPie') {
        //initAreaPieCountChart(type);
    } else {
        initEventLineCountChart(type);
        //initEventPieCountChart(type);
        //initAreaPieCountChart(type);
    }
}

/**
 * 折线图图统计后台请求方法
 */
function initEventLineCountChart(type) {
    if (type == "" || type == null || type == undefined) {
        esdcEventData($('#esdc_event_day'), 'day', 'line');
    }
    $.ajax({
        url: 'esdcDashboard.do?getEventStatisticData&dataType=line&eventType=keyPerson&timeType=' + type,
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (retData) {
            if (retData[sysCfg.ret] == sysCfg.success) {
                dataTypeMap = retData.data;
                /**数据扇形面板*/
                initLineChart(dataTypeMap);
            }
        }
    });
}
//根据皮肤修改折线图线条颜色
function changeLineChartColor() {
    if ($("#keyPersonSkin").val() == 'techblue'){
        return '#0091F9';
    }
    return '#88C856';
}
/**
 * 折线图初始化
 */
var myLineChart;
function initLineChart(dataTypeMap) {
    var element = document.getElementById('esdc_line_chart');
    if (element != null) {
        myLineChart = echarts4.init(element);
        var personType = new Array();
        var xAxisData = new Array();
        var seriesData = new Array();
        var lineColor = changeLineChartColor();
        $.each(dataTypeMap, function (type, dataList) {
            personType.push(type);
            xAxisData = [];
            $.each(dataList, function (index, value) {
                xAxisData.push(value.time);
                seriesData.push({name: value.time, value: value.number})
            });
        });
        option = {
            tooltip: {
                trigger: 'axis',
                position: function (point, params, dom, rect, size) {
                    //x轴坐标
                    var x = 0;
                    //y轴坐标
                    var y = 0;
                    //当前鼠标位置
                    var pointX = point[0];
                    var pointY = point[1];
                    //提示框大小
                    var boxWidth = size.contentSize[0];
                    var boxHeight = size.contentSize[1];
                    //左边放不下
                    if (boxWidth > pointX) {
                        x = 5;
                    } else {
                        x = pointX - boxWidth;
                    }
                    //上边放不下
                    if (boxHeight > pointY) {
                        y = 5;
                    } else {
                        y = pointY - boxHeight;
                    }
                    return [x, y];
                }
            },
            color: lineColor,
            legend: {
                show: false,
                textStyle: {
                    fontSize: 10
                },
                data: personType
            },
            xAxis: {
                type: 'category',
                boundaryGap: false,
                data: xAxisData,
                axisLabel: {
                    interval: 5,
                    textStyle: {
                        color: '#B4BBC6'
                    }
                },
                axisLine: {       //x轴
                    show: false

                },
                axisTick: {       //x轴刻度线
                    show: false
                },
                splitLine: {     //网格线
                    show: false
                }
            },
            yAxis: {
                type: 'value',
                axisLine: {
                    lineStyle: {
                        color: '#CCCCCC',
                        width: 1, //这里是为了突出显示加上的  
                    }
                },
                axisLabel: {
                    textStyle: {
                        color: '#B4BBC6'
                    }
                },
                axisLine: {       //y轴
                    show: false

                },
                axisTick: {       //y轴刻度线
                    show: false
                },
                splitLine: {     //网格线
                    show: true
                }
            },
            series: {
                // name: type,
                type: 'line',
                data: seriesData,
                smooth: true,
                stack: "总量",
                itemStyle: {
                    normal: {
                        areaStyle: {
                            type: 'default',
                            //渐变色实现
                            color: new echarts4.graphic.LinearGradient(0, 0, 0, 1,//变化度
                                //三种由深及浅的颜色
                                [{
                                    offset: 0,
                                    color: lineColor
                                }, {
                                    offset: 0.5,
                                    color: lineColor
                                }, {
                                    offset: 1,
                                    color: '#FEFEFF'
                                }]),
                        }
                    },
                },
            },
            grid: {
                x: 60,
                y: 10,
                x2: 30,
                y2: 30
            }
        };
        if (echartsLineType != "day") {
            delete option.xAxis.axisLabel.interval;
        }
        // 使用刚指定的配置项和数据显示图表。
        myLineChart.clear();
        myLineChart.setOption(option);

    }
}

/**
 * 类型扇形图统计后台请求方法
 */
function initEventPieCountChart(type) {
    if (type == "" || type == null || type == undefined) {
        esdcEventData($('#esdc_event_day'), 'day');
    }
    $.ajax({
        url: 'esdcDashboard.do?getEventStatisticData&dataType=pie&eventType=keyPerson&timeType=' + type,
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (retData) {
            if (retData[sysCfg.ret] == sysCfg.success) {
                dataMap = retData.data;
                /**数据扇形面板*/
                initPieChart(dataMap);
            }
        }
    })
}

/**
 * 类型扇形图初始化
 */
var myTypePieChart;
function initPieChart(dataMap) {
    // 基于准备好的dom，初始化echarts实例
    var element = document.getElementById('esdc_pie_chart');
    // 防止div为null 初始化时报错
    if (element != null) {
        var radius = ['35%', '55%'];
        myTypePieChart = echarts4.init(element);
        var seriesData = new Array();
        var dataArray = new Array();
        $.each(dataMap, function (name, num) {
            seriesData.push({name: name, value: num});
            dataArray.push(name);
        });
        option = {
            tooltip: {
                trigger: 'item',
                formatter: '{c} ({d}%)'
            },
            legend: {
                orient: 'vertical',
                right: "3%",
                top: "10%",
                textStyle: {
                    fontSize: 10
                },
                icon: "circle",
                data: dataArray || []
            },
            series: [{
                type: 'pie',
                radius: ['40%', '80%'],
                center: ['25%', '50%'],
                roseType: 'radius',
                color: ["#F32C18","#FC5F21","#7AC143"
                    // EsdcDashboardWio.getPieGradientColor("#0F71CD", "#25B7E0", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#62BBA5", "#76C051", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#E94D4A", "#FB7D7E", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EB5B9D", "#F891C9", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#9561EE", "#AF91FF", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EBA054", "#FFC889", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EEC454", "#FFEF8A", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#E6EA54", "#F5FF8A", 0.5)
                ],
                label: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '12',
                        fontWeight: 'bold'
                    }
                },
                labelLine: {
                    show: false
                },
                data: seriesData || []
            }]
        };
        // 使用刚指定的配置项和数据显示图表。
        myTypePieChart.clear();
        myTypePieChart.setOption(option);
    }
}

/**
 * 区域扇形图统计后台请求方法
 */
function initAreaPieCountChart(type) {
    if (type == "" || type == null || type == undefined) {
        esdcEventData($('#esdc_event_day'), 'day');
    }
    $.ajax({
        url: 'esdcDashboard.do?getEventStatisticData&dataType=areaPie&eventType=keyPerson&timeType=' + type,
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (retData) {
            if (retData[sysCfg.ret] == sysCfg.success) {
                dataMap = retData.data;
                /**数据扇形面板*/
                initAreaPieChart(dataMap);
            }
        }
    })
}

/**
 * 区域扇形图初始化
 */
var myPieChart;
function initAreaPieChart(dataMap) {
    // 基于准备好的dom，初始化echarts实例
    var element = document.getElementById('esdc_areaPie_chart');
    // 防止div为null 初始化时报错
    if (element != null) {
        myPieChart = echarts4.init(element);
        var seriesData = new Array();
        var dataArray = new Array();
        $.each(dataMap, function (name, num) {
            seriesData.push({name: name, value: num});
            dataArray.push(name);
        });
        option = {
            tooltip: {
                formatter: '{c} ({d}%)'
            },
            legend: {
                orient: 'vertical',
                right: "3%",
                top: "10%",
                textStyle: {
                    fontSize: 10
                },
                icon: "circle",
                data: dataArray || []
            },
            series: [{
                type: 'pie',
                radius: ['40%', '65%'],
                center: ['23%', '50%'],
                selectedMode: 'single',
                color: ["#FC5F21","#FFC600","#7AC143"
                    // EsdcDashboardWio.getPieGradientColor("#62BBA5", "#76C051", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#E97C4A", "#FFB17F", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#E94D4A", "#FB7D7E", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EB5B9D", "#F891C9", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#9561EE", "#AF91FF", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EBA054", "#FFC889", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#EEC454", "#FFEF8A", 0.5),
                    // EsdcDashboardWio.getPieGradientColor("#E6EA54", "#F5FF8A", 0.5)
                ],
                label: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '12',
                        fontWeight: 'bold'
                    }
                },
                labelLine: {
                    show: false
                },
                data: seriesData || []
            }]
        };
        // 使用刚指定的配置项和数据显示图表。
        myPieChart.clear();
        myPieChart.setOption(option);
    }
}

function getInitEvent(){
    $.ajax({
        url: 'esdcTransaction.do?getKeyPersonInitEvent',
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (resp) {
            $('.kpLoading').hide();
            $('#tipWhite').hide();
            $('#tipStranger').hide();
            $('#tipBlack').hide();
            var rows = resp.data;
            moreRowsLen = rows.length;
            if (rows && rows.length > 0) {
                for (var index in rows) {
                    let data = rows[index];
                    var name = data.personName == "" ? I18n.getValue("esdc_common_unknown") : data.personName;
                    var captureImage = data.image.endsWith("esdc_user.png") ? "" : data.image;
                    var libFaceImage = data.libFacePic.endsWith("esdc_user.png") ? "" : data.libFacePic;
                    //库图url
                    var libImageUrl = data.libImage.endsWith("esdc_user.png") ? "" : data.libImage;
                    var relatedDetails = I18n.getValue('common_op_detailInfo');
                    var eventDetail = "<div class=\"lastestAllowEventDiv\" data-eventtime='"+data.eventTime+"' data-eventtype='"+data.eventType+"' onclick=\"esdcTransactionDetails('" + data.id + "')\"><div class=\"lastestEventTimeDiv\"><div id='eventDate'>" +data.eventTime + "</div><div id='eventType' class='eventTypeAllowBackImage'><div>" + data.personType + "</div></div></div>\n" +
                        "                <div class=\"lastestEventCaptureDiv\">\n" +
                        "                    <img src='" + captureImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                        "                    <input value='" + data.searchImage + "' class='imagePath' type='hidden' />\n" +
                        "                </div>\n" +
                        "                <div class=\"lastestEventDetailDiv\">\n" +
                        "                    <div class=\"lastestEventMatchRate\">\n" +
                        "                        <img src=\"/images/"+$("#keyPersonSkin").val()+"/esdc_box_allow.png\" style=\"height: 100%\"/>\n" +
                        "                        <p class=\'lastestEventMatchRateValue\'>" + data.matchRate + "</p>\n" +
                        "                    </div>\n" +
                        "                    <div class=\"lastestEventDetail\">\n" +
                        // "                        <div class=\"lastestEventDetailPosition\">" + rows[index].data[3] + "</div>\n" +
                        "                        <div class=\"lastestEventDetailPosition\" style='width: 100%;white-space: nowrap;text-overflow: ellipsis;overflow: hidden'>" + name + "</div>\n" +
                        "                        <div class=\"lastestEventDetailPositionDetail\"><p onclick=\"esdcTransactionDetails('" + data.id + "');event.cancelBubble = true\">" + relatedDetails + "</p></div>\n" +
                        "                        <input class='lastestEventPin' value='" + data.pin + "'  type='hidden' />\n" +
                        "                    </div>\n" +
                        "                </div>\n" +
                        "                <div class=\"libFacePic\">\n" +
                        "                    <img src='" + libFaceImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                        "                    <input value='" + libImageUrl + "' class='imagePath' type='hidden' />\n" +
                        "                </div>\n" +
                        "                <div class=\"lastestEventDetailDeviceName\">" +data.deviceAlias + "</div>\n" +
                        "            </div>";
                    if (screen.width == 1920 && screen.height == 1080) {
                        if (browserType() == "Chrome") {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        } else {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        }
                    } else {
                        if (browserType() == "Chrome") {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivChrome");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        } else {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        }
                    }
                    if (rows.length > 0) {
                        if (data.eventType == "esdc.event.keyPerson.white"){
                            $("#keyPersonEventWhite").children().last().after(eventDetail);
                        }else if (data.eventType == "esdc.event.keyPerson.black"){
                            $("#keyPersonEventBlack").children().last().after(eventDetail);
                        }else{
                            $("#keyPersonEventStranger").children().last().after(eventDetail);
                        }
                    }
                }
                if ($('#keyPersonEventWhite')[0].children.length <= 2) {//这三个要区分开
                    $('#tipWhite').show();
                }
                if ($('#keyPersonEventStranger')[0].children.length <= 2) {
                    $('#tipStranger').show();
                }
                if ($('#keyPersonEventBlack')[0].children.length <= 2) {
                    $('#tipBlack').show();
                }
                initEventScroll();
                //右键快速检索功能
                rightClickEvent();
            } else {
                $('#tipWhite').show();
                $('#tipStranger').show();
                $('#tipBlack').show();
            }
            initEventSocket();
        }
    });
}

/**
 * webSocket接收设备传输数据
 */
//客户端id
var clientId = Math.round(Math.random() * 10000) + "${uuid!}";
var moreRowsLen = null; //获取推送数据的长度
function initEventSocket() {
    var client = Web.getSocket({
        id: "eventClient",
        url: "esdcKeyPersonEvent/getEventData",
        param: JSON.stringify({"clientId": clientId, "authAreaId": "areaId"}),
        onMessage: function (resp) {
            var data = JSON.parse(resp.body);
            if (data.clientId && clientId != data.clientId) {
                // $('#tip').show();
                return;
            }
            $('#tipWhite').hide();
            $('#tipStranger').hide();
            $('#tipBlack').hide();
            var rows = data.rows;
            moreRowsLen = rows.length;
            var authAreaName = $("#esdcFilterAreaName").val();
            if (rows && rows.length > 0) {
                for (var index in rows) {
                    let data = rows[index];
                    if (!esdcCheckAuthArea(data.areaName,authAreaName)){
                        continue;
                    }
                    var name = data.personName == "" ? I18n.getValue("esdc_common_unknown") : data.personName;
                    var relatedDetails = I18n.getValue('common_op_detailInfo');
                    var captureImage = data.image.endsWith("esdc_user.png") ? "" : data.image;
                    var libFaceImage = data.libFacePic.endsWith("esdc_user.png") ? "" : data.libFacePic;
                    //库图url
                    var libImageUrl = data.libImage.endsWith("esdc_user.png") ? "" : data.libImage;
                    var eventDetail = "<div class=\"lastestAllowEventDiv\" data-eventtime='"+data.eventTime+"' data-eventtype='"+data.eventType+"' onclick=\"esdcTransactionDetails('" + data.id + "')\"><div class=\"lastestEventTimeDiv\"><div id='eventDate'>" +data.eventTime + "</div><div id='eventType' class='eventTypeAllowBackImage'><div>" + data.personType + "</div></div></div>\n" +
                        "                <div class=\"lastestEventCaptureDiv\">\n" +
                        "                    <img src='" + captureImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                        "                    <input value='" + data.searchImage + "' class='imagePath' type='hidden' />\n" +
                        "                </div>\n" +
                        "                <div class=\"lastestEventDetailDiv\">\n" +
                        "                    <div class=\"lastestEventMatchRate\">\n" +
                        "                        <img src=\"/images/"+$("#keyPersonSkin").val()+"/esdc_box_allow.png\" style=\"height: 100%\"/>\n" +
                        "                        <p class=\'lastestEventMatchRateValue\'>" + data.matchRate + "</p>\n" +
                        "                    </div>\n" +
                        "                    <div class=\"lastestEventDetail\">\n" +
                        // "                        <div class=\"lastestEventDetailPosition\">" + rows[index].data[3] + "</div>\n" +
                        "                        <div class=\"lastestEventDetailPosition\" style='width: 100%;white-space: nowrap;text-overflow: ellipsis;overflow: hidden'>" + name + "</div>\n" +
                        "                        <div class=\"lastestEventDetailPositionDetail\"><p onclick=\"esdcTransactionDetails('" + data.id + "');event.cancelBubble = true\">" + relatedDetails + "</p></div>\n" +
                        "                        <input value='" + data.pin + "' type='hidden' />\n" +
                        "                    </div>\n" +
                        "                </div>\n" +
                        "                <div class=\"libFacePic\">\n" +
                        "                    <img src='" + libFaceImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                        "                    <input value='" + libImageUrl + "' class='imagePath' type='hidden' />\n" +
                        "                </div>\n" +
                        "                <div class=\"lastestEventDetailDeviceName\">" +data.deviceAlias + "</div>\n" +
                        "            </div>";
                    if (screen.width == 1920 && screen.height == 1080) {
                        if (browserType() == "Chrome") {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreenChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        } else {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        }
                    } else {
                        if (browserType() == "Chrome") {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivChrome");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivChrome");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        } else {
                            if(data.eventType == "esdc.event.keyPerson.white" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                            }else if(data.eventType == "esdc.event.keyPerson.black" && data.matchRate != "0%"){
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                eventDetail = eventDetail.replace("7BC145", "F32C18");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                            }else{
                                eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                            }
                        }
                    }
                    var length = $("#lastestEventOuterDiv").children().length;
                    if (data.firstTime || rows.length > 1) {
                        if (data.eventType == "esdc.event.keyPerson.white"){
                            $("#keyPersonEventWhite").children().last().after(eventDetail);
                        }else if (data.eventType == "esdc.event.keyPerson.black"){
                            $("#keyPersonEventBlack").children().last().after(eventDetail);
                        }else{
                            $("#keyPersonEventStranger").children().last().after(eventDetail);
                        }
                    } else {
                        if (data.eventType == "esdc.event.keyPerson.white"){
                            $("#keyPersonEventWhite").children().first().before(eventDetail);
                            $("#keyPersonEventWhite").children().first().hide().fadeIn(500);
                        }else if (data.eventType == "esdc.event.keyPerson.black"){
                            $("#keyPersonEventBlack").children().first().before(eventDetail);
                            $("#keyPersonEventBlack").children().first().hide().fadeIn(500);
                        }else{
                            $("#keyPersonEventStranger").children().first().before(eventDetail);
                            $("#keyPersonEventStranger").children().first().hide().fadeIn(500);
                        }
                        // $("#lastestEventOuterDiv").children().first().before(eventDetail);
                        // $("#lastestEventOuterDiv").children().first().hide().fadeIn(500);
                        //分类型+1
                        var el = null;
                        if (data.eventType.indexOf("white") > 0) {
                            el = $('#whiteCount');
                        } else if (data.eventType.indexOf("black") > 0) {
                            el = $('#blackCount');
                        } else {
                            el = $('#strangerCount');
                        }
                        var num = (parseInt(el.val()) + 1).toString(10);
                        var json = getRunNumJson(el, num);

                        var flag = (num+"").length == ((num-1)+"").length+1;
                        if (flag && num % 10 == 0) {
                            var str = '<li style="float:left;width:' + json.width + 'px;top:-' + (json.value[json.length - 1] * json.height) + 'px;height:' + json.height * 10 + 'px;">';
                            for (var j = 0; j < 10; j++) {
                                str += '<div style="height:' + json.height + 'px">' + j + '</div>';
                            }
                            str += '</li>';
                            json.el.children().first().before(str);
                        }
                        animate(json.el.children("li"), num, json, "add");
                        //今日总数+1
                        var allNum = (parseInt($('#sumCount').val()) + 1).toString(10);
                        var json = getRunNumJson($('#sumCount'), allNum);

                        flag = (allNum+"").length == ((allNum-1)+"").length+1;
                        if (flag && allNum % 10 == 0) {
                            var str = '<li style="float:left;width:' + json.width + 'px;top:-' + (json.value[json.length - 1] * json.height) + 'px;height:' + json.height * 10 + 'px;">';
                            for (var j = 0; j < 10; j++) {
                                str += '<div style="height:' + json.height + 'px">' + j + '</div>';
                            }
                            str += '</li>';
                            json.el.children().first().before(str);
                        }
                        animate(json.el.children("li"), allNum, json, "add");

                        el.val(num);
                        $('#sumCount').val(allNum)
                    }
                }
                if ($('#keyPersonEventWhite')[0].children.length <= 2) {//这三个要区分开
                    $('#tipWhite').show();
                }
                if ($('#keyPersonEventStranger')[0].children.length <= 2) {
                    $('#tipStranger').show();
                }
                if ($('#keyPersonEventBlack')[0].children.length <= 2) {
                    $('#tipBlack').show();
                }
                //右键快速检索功能
                rightClickEvent();
            } else {
                $('#tipWhite').show();
                $('#tipStranger').show();
                $('#tipBlack').show();
            }
        }
    });
    return client;
}

// initGetMoreRecordData();








/**
 * 发展趋势折线图下拉框变换数据
 */
function typeLineChange(event) {
    var timeType = "";
    if (event == "refresh") {
        timeType = $("#acc_tt_text").html();
    } else {
        timeType = event.getAttribute("timeType");
    }
    if (timeType == 'day' || timeType == I18n.getValue('esdc_common_day')) {
        esdcEventData($('#esdc_event_day'), 'day', 'line');
        $("#acc_tt_text").html(I18n.getValue('esdc_common_day'));
    } else if (timeType == 'week' || timeType == I18n.getValue('esdc_common_week')) {
        esdcEventData($('#esdc_event_week'), 'week', 'line');
        $("#acc_tt_text").html(I18n.getValue('esdc_common_week'));
    } else if (timeType == 'month' || timeType == I18n.getValue('esdc_common_month')) {
        esdcEventData($('#esdc_event_month'), 'month', 'line');
        $("#acc_tt_text").html(I18n.getValue('esdc_common_month'));
    } else if (timeType == 'year' || timeType == I18n.getValue('esdc_common_year')) {
        esdcEventData($('#esdc_event_year'), 'year', 'line');
        $("#acc_tt_text").html(I18n.getValue('esdc_common_year'));
    }
}

/**
 * 类型占比图下拉框变换数据
 */
function typePieChange(event) {
    var timeType = "";
    if (event == "refresh") {
        timeType = $("#acc_tt_text_pie").html();
    } else {
        timeType = event.getAttribute("timeType");
    }
    if (timeType == 'day' || timeType == I18n.getValue('esdc_common_day')) {
        esdcEventData($('#esdc_event_day'), 'day', 'pie');
        $("#acc_tt_text_pie").html(I18n.getValue('esdc_common_day'));
    } else if (timeType == 'week' || timeType == I18n.getValue('esdc_common_week')) {
        esdcEventData($('#esdc_event_week'), 'week', 'pie');
        $("#acc_tt_text_pie").html(I18n.getValue('esdc_common_week'));
    } else if (timeType == 'month' || timeType == I18n.getValue('esdc_common_month')) {
        esdcEventData($('#esdc_event_month'), 'month', 'pie');
        $("#acc_tt_text_pie").html(I18n.getValue('esdc_common_month'));
    } else if (timeType == 'year' || timeType == I18n.getValue('esdc_common_year')) {
        esdcEventData($('#esdc_event_year'), 'year', 'pie');
        $("#acc_tt_text_pie").html(I18n.getValue('esdc_common_year'));
    }
}

/**
 * 区域分布占比图下拉框变换数据
 */
function areaPieChange(event) {
    var timeType = "";
    if (event == "refresh") {
        timeType = $("#acc_tt_text_area_pie").html();
    } else {
        timeType = event.getAttribute("timeType");
    }
    if (timeType == 'day' || timeType == I18n.getValue('esdc_common_day')) {
        esdcEventData($('#esdc_event_day'), 'day', 'areaPie');
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_day'));
    } else if (timeType == 'week' || timeType == I18n.getValue('esdc_common_week')) {
        esdcEventData($('#esdc_event_week'), 'week', 'areaPie');
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_week'));
    } else if (timeType == 'month' || timeType == I18n.getValue('esdc_common_month')) {
        esdcEventData($('#esdc_event_month'), 'month', 'areaPie');
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_month'));
    } else if (timeType == 'year' || timeType == I18n.getValue('esdc_common_year')) {
        esdcEventData($('#esdc_event_year'), 'year', 'areaPie');
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_year'));
    }
}


/**
 *    滚动数字
 *    @ val 值,params 参数对象
 *    params{speed(动画滚动速度),width(列宽),height(行高)}
 */
function runNum(val, el) {
    /*初始化动画参数*/
    var valString = val + "";
    var runNumJson = getRunNumJson(el, valString);
    list(runNumJson.el, runNumJson);
    animate(runNumJson.el.children("li"), runNumJson.value.toString(10), runNumJson, "first");
    el.val(val);
}

function getRunNumJson(el, valString) {
    return {
        el: el,
        value: valString,
        valueStr: valString.toString(10),
        width: 15,
        addMin: 1,
        height: 23,
        speed: 0,
        length: valString.toString(10).length
    };
}

function list(el, json) {
    var str = '';
    for (var i = 0; i < json.length; i++) {
        var h = json.height * 10;
        str += '<li style="float:left;width:' + json.width + 'px;top:-' + (json.value[i] * json.height) + 'px;height:' + h + 'px;">';
        for (var j = 0; j < 10; j++) {
            str += '<div style="height:' + json.height + 'px">' + j + '</div>';
        }
        str += '</li>';
    }
    el.html(str);
}

function animate(el, value, json, from) {
    for (var x = 0; x < json.length; x++) {
        var topPx = value[x] * json.height;
        if (value[x] == 0 && from != "first") {
            el.eq(x).children("div").eq(9).css("opacity", 0);
            el.eq(x).css("top", -topPx + json.height + 'px');
        } else if (value[x] != 0 || from == "first") {
            el.eq(x).children("div").eq(value[x] - 1).css("opacity", 0);
        }
        el.eq(x).animate({top: -topPx + 'px'}, json.speed);
        el.eq(x).children("div").eq(value[x]).css("opacity", 1);
    }
}

$("#esdc_areaPie_chart").resize(function (){
    myPieChart.resize();
});
$("#esdc_pie_chart").resize(function (){
    myTypePieChart.resize();
});

function initEventScroll() {
    //滚动监听事件
    $(".kpKeyPersonEventClassAll").each(function () {
        var psEventTypeId = $(this)[0].id;
        scrollInit(psEventTypeId,0,0,0,function () {
            renderAlarmData(true,psEventTypeId);
        });
        //滚动监听事件
        $('#'+psEventTypeId).on('scroll', function(){
        });
    });
}
var mapEventLastScrollTime = 0 ;
function scrollInit(id,nScrollHight,nScrollTop,nDivHight,callback) {
    /*初始化滚动事件*/
    $("#"+id).scroll(function(){
        nDivHight = $("#"+id).height();
        nScrollHight = $(this)[0].scrollHeight;
        nScrollTop = $(this)[0].scrollTop;
        var paddingBottom = parseInt( $(this).css('padding-bottom') ),paddingTop = parseInt( $(this).css('padding-top') );
        if(nScrollTop + paddingBottom + paddingTop + nDivHight + 1>= nScrollHight && (new Date().getTime() > mapEventLastScrollTime + 300)){
            callback();
            mapEventLastScrollTime = new Date().getTime();
        }
    });
}

function renderAlarmData(isScroll,psEventTypeId) {
    var postData={
        "pageNo" :0,
        "pageSize" :10,
    };
    // 如果是滚动更新，查询最底部的一条记录之后的数据
    if (isScroll){
        var eventTime = $("#"+psEventTypeId)[0].lastElementChild.dataset["eventtime"];
        if(eventTime != undefined && eventTime != "" && eventTime != null){
            postData.moreRecordEndTime = Date.parse(new Date($("#"+psEventTypeId)[0].lastElementChild.dataset["eventtime"].replace(/-/g,"/"))); //最后一条的时间戳
        }
        postData.eventType = $("#"+psEventTypeId)[0].lastElementChild.dataset["eventtype"];//事件类型区分
    }
    listAlarmItemByPage(postData,function (result) {
        if(result.ret == "ok") {
            if(result.data){
                var moreRecord = JSON.parse(JSON.stringify(result.data));
                var val = moreRecord.rows;
                if (val.length > 0){
                    for (var index in val){
                        var name = val[index][7] == null ? I18n.getValue("esdc_common_unknown") : val[index][7];
                        var relatedDetails = I18n.getValue('common_op_detailInfo');
                        var captureImage = val[index][9].endsWith("esdc_user.png") ? "" : val[index][9];
                        var libFaceImage = val[index][10].endsWith("esdc_user.png") ? "" : val[index][10];
                        //库图路径
                        var libFaceImageUrl = val[index][14].endsWith("esdc_user.png") ? "" : val[index][14];
                        var eventDetail = "<div class=\"lastestAllowEventDiv\" data-eventtime='"+val[index][2]+"' data-eventtype='"+val[index][1]+"' onclick=\"esdcTransactionDetails('" + val[index][12] + "')\"><div class=\"lastestEventTimeDiv\"><div id='eventDate'>" + val[index][2] + "</div><div id='eventType' class='eventTypeAllowBackImage'><div>" + val[index][3] + "</div></div></div>\n" +
                            "                <div class=\"lastestEventCaptureDiv\">\n" +
                            "                    <img src='" + captureImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                            "                    <input value='" + val[index][13] + "' class='imagePath' type='hidden' />\n" +
                            "                </div>\n" +
                            "                <div class=\"lastestEventDetailDiv\">\n" +
                            "                    <div class=\"lastestEventMatchRate\">\n" +
                            "                        <img src=\"/images/"+$("#keyPersonSkin").val()+"/esdc_box_allow.png\" style=\"height: 100%\"/>\n" +
                            "                        <p class=\'lastestEventMatchRateValue\'>" + val[index][8] + "</p>\n" +
                            "                    </div>\n" +
                            "                    <div class=\"lastestEventDetail\">\n" +
                            // "                        <div class=\"lastestEventDetailPosition\">" + rows[index].data[3] + "</div>\n" +
                            "                        <div class=\"lastestEventDetailPosition\" style='width: 100%;white-space: nowrap;text-overflow: ellipsis;overflow: hidden'>" + name + "</div>\n" +
                            "                        <div class=\"lastestEventDetailPositionDetail\"><p onclick=\"esdcTransactionDetails('" + val[index][12] + "');event.cancelBubble = true\">" + relatedDetails + "</p></div>\n" +
                            "                        <input value='" + val[index][14] + "' type='hidden' />\n" +
                            "                    </div>\n" +
                            "                </div>\n" +
                            "                <div class=\"libFacePic\">\n" +
                            "                    <img src='" + libFaceImage + "' onerror=\"this.src='/images/'+keyPersonSkin+'/esdc_user.png'\" />\n" +
                            "                    <input value='" + libFaceImageUrl + "' class='imagePath' type='hidden' />\n" +
                            "                </div>\n" +
                            "                <div class=\"lastestEventDetailDeviceName\">" +val[index][6] + "</div>\n" +
                            "            </div>";
                        if (screen.width == 1920 && screen.height == 1080) {
                            if (browserType() == "Chrome") {
                                if(val[index][1] == "esdc.event.keyPerson.white" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreenChrome");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                                }else if(val[index][1] == "esdc.event.keyPerson.black" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreenChrome");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "F32C18");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                                }else{
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreenChrome");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                                }
                            } else {
                                if(val[index][1] == "esdc.event.keyPerson.white" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                                }else if(val[index][1] == "esdc.event.keyPerson.black" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "F32C18");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                                }else{
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                                }
                            }
                        } else {
                            if (browserType() == "Chrome") {
                                if(val[index][1] == "esdc.event.keyPerson.white" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivChrome");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                                }else if(val[index][1] == "esdc.event.keyPerson.black" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivChrome");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "F32C18");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                                }else{
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivChrome");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                                }
                            } else {
                                if(val[index][1] == "esdc.event.keyPerson.white" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestAllowEventDivBigScreen");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailGreen");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueGreen");
                                }else if(val[index][1] == "esdc.event.keyPerson.black" && val[index][8] != "0%"){
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestBanEventDivBigScreen");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeBanBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "F32C18");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_ban");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailRed");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueRed");
                                }else{
                                    eventDetail = eventDetail.replace("lastestAllowEventDiv", "lastestStrangerEventDivBigScreen");
                                    eventDetail = eventDetail.replace("eventTypeAllowBackImage", "eventTypeStrangerBackImage");
                                    eventDetail = eventDetail.replace("7BC145", "FC5F21");
                                    eventDetail = eventDetail.replace("esdc_box_allow","esdc_box_stranger");
                                    eventDetail = eventDetail.replace("lastestEventDetailPositionDetail", "lastestEventDetailPositionDetailOrange");
                                    eventDetail = eventDetail.replace("lastestEventMatchRateValue", "lastestEventMatchRateValueOrange");
                                }
                            }
                        }
                        // $("#lastestEventOuterDiv").children().last().after(eventDetail);
                        if (val[index][1] == "esdc.event.keyPerson.white"){
                            $("#keyPersonEventWhite").children().last().after(eventDetail);
                        }else if (val[index][1] == "esdc.event.keyPerson.black"){
                            $("#keyPersonEventBlack").children().last().after(eventDetail);
                        }else{
                            $("#keyPersonEventStranger").children().last().after(eventDetail);
                        }
                        //右键快速检索功能
                        rightClickEvent();
                    }
                }
            }
        }else{
            messageBox({messageType:"alert",text: result.msg});
        }
    })

}

/**
 * 请求告警记录
 * @param callback
 */
function listAlarmItemByPage(postData,callback) {
    $.ajax({
        type: "post",
        url: "/esdcTransaction.do?getMoreKeyPersonRecord",
        dataType: "json",
        data: postData,
        async: true,
        success: function(result)
        {
            if(result.ret == "ok") {
                return callback(result);
            }else{
                messageBox({messageType:"alert",text: result.msg});
            }
        }
    });
}
//点击左侧菜单栏初始折线图
$("#leftHeader").on('click',function () {
    myLineChart.resize();
});

/**
 * 右键快速检索功能
 */
function rightClickEvent(){
    // 左侧图片右击快速检索功能
    $(".lastestEventCaptureDiv").contextMenu('search_menu',
        {
            menuStyle: {
                width: 'auto'
            },
            bindings: {
                'fuzzySearch': function(obj) {
                    //陌生人跳转携带图片
                    let imgBase64 = obj.children[0].src;
                    let imgUrl = obj.children[1].value;
                    imgUrl = imgUrl.replace(/\\/g,"Excel");
                    localStorage.setItem("targetSearchImgBase64Store",imgBase64);
                    localStorage.setItem("searchByImg",imgUrl);
                    openMenuItem("esdcPersonnelSearch.do", "Esdc");
                },
                'preciseSearch': function(obj) {
                    //跳转携带姓名
                    let name = obj.nextElementSibling.children[1].children[0].innerText;
                    localStorage.setItem("searchByName",name);
                    if(name.indexOf("*") !== -1){
                        let pin = obj.nextElementSibling.children[1].children[2].value;
                        localStorage.setItem("searchByPin",pin);
                    }
                    openMenuItem("esdcPersonnelSearch.do", "Esdc");
                },
                "addStrangerToPers": function (obj) {
                    let src = obj.children[0].src;
                    var opts = {//弹窗配置对象
                        path: "skip.do?page=esdc_strangeradd_esdcStrangerAdd&src=" + src,
                        width: 500,//设置弹窗宽度
                        height: 400,//设置弹窗高度
                        title: I18n.getValue('common_op_addPerson'),//设置弹窗标题
                        gridName: "gridbox"//设置grid
                    };
                    DhxCommon.createWindow(opts);
                }
            },
            onShowMenu: function (e,menu) {
                let library = e.currentTarget.nextElementSibling.children[1].children[0].innerText;
                let stranger = I18n.getValue('esdc_dashboard_unknown');
                if(library == null || library === "" || library === stranger){
                    $('#preciseSearch', menu).remove();
                }
                if(library !== null && library !== "" && library !== stranger){
                    $('#addStrangerToPers', menu).remove();
                }
                return menu;
            }
        });
    // 右侧图片右击快速检索
    // 一个页面只需要初始化一个menu，其他地方使用到不用再bindings可复用的menu
    $(".libFacePic").contextMenu('search_menu',
        {
            menuStyle: {
                width: 'auto'
            },
            bindings: {
                'fuzzySearch': function(obj) {
                    //陌生人跳转携带图片
                    let imgBase64 = obj.children[0].src;
                    let imgUrl = obj.children[1].value;
                    imgUrl = imgUrl.replace(/\\/g,"Excel");
                    localStorage.setItem("targetSearchImgBase64Store",imgBase64);
                    localStorage.setItem("searchByImg",imgUrl);
                    openMenuItem("esdcPersonnelSearch.do", "Esdc");
                 },
                'preciseSearch': function(obj) {
                    //跳转携带姓名
                    let name = obj.previousElementSibling.children[1].children[0].innerText;
                    localStorage.setItem("searchByName",name);
                    if(name.indexOf("*") !== -1){
                        let pin = obj.previousElementSibling.children[1].children[2].value;
                        localStorage.setItem("searchByPin",pin);
                    }
                    openMenuItem("esdcPersonnelSearch.do", "Esdc");
                }
            },
            onShowMenu: function (e,menu) {
                let library = e.currentTarget.previousElementSibling.children[1].children[0].innerText;
                let stranger = I18n.getValue('esdc_dashboard_unknown');
                if (e.currentTarget.children[0].src.endsWith("esdc_user.png")){
                    $('#fuzzySearch', menu).remove();
                }
                if(library == null || library === "" || library === stranger){
                    $('#preciseSearch', menu).remove();
                }
                $('#addStrangerToPers', menu).remove();
                return menu;
            }
        });
}