

//将触发条件信息保存到页面
function setTriggerInfoToPage(tree) {
    var triggerEventId = "";
    var triggerEventName = "";
    var temptriggerNoArray = tree.getAllChecked().split(",");
    var parentId = "";
    var parentIdIndex = -1;
    for (var i = 0; i < temptriggerNoArray.length; i++) {
        if (temptriggerNoArray[i].indexOf("_parent") >= 0) {
            parentId = temptriggerNoArray[i];
        }
    }
    if ("" != parentId && $.inArray(parentId, temptriggerNoArray) >= 0) {
        parentIdIndex = $.inArray(parentId, temptriggerNoArray);
        temptriggerNoArray.splice(parentIdIndex, 1);
    }
    var tempCheckedIds = temptriggerNoArray;
    if (temptriggerNoArray.length == 1) {
        triggerEventId = temptriggerNoArray.toString();
    } else if (temptriggerNoArray.length > 1) {
        for (var i = 0; i < temptriggerNoArray.length; i++) {
            if (i == temptriggerNoArray.length - 1) {
                triggerEventId += temptriggerNoArray[i];
            } else {
                triggerEventId += temptriggerNoArray[i] + ",";
            }
        }
    }
    $("#triggerEventId").val(triggerEventId);

    if (tempCheckedIds.length == 1) {
        triggerEventName = tree.getItemText(tempCheckedIds);
    } else if (tempCheckedIds.length > 1) {
        for (var i = 0; i < tempCheckedIds.length; i++) {
            if (i == tempCheckedIds.length - 1) {
                triggerEventName += tree.getItemText(tempCheckedIds[i]);
            } else {
                triggerEventName += tree.getItemText(tempCheckedIds[i]) + ",";
            }
        }
    }
    $("#triggerEventName").val(triggerEventName);
}

var checkedParentIds = new Array();// 选中的父节点
function onlyCheckOneParent(tree) {
    var parentIds = new Array();
    var subIds = new Array();
    subIds = getCheckedSubIds(tree.getAllChecked());
    parentIds = getCheckedParentIds(tree, subIds);

    if (parentIds.length == 1) {
        checkedParentIds = parentIds;
    } else if (parentIds.length > 1) {
        var currentId = new Array();
        for (var i = 0; i < parentIds.length; i++) {
            for (var j = 0; j < checkedParentIds.length; j++) {
                if (parentIds[i] == checkedParentIds[j]) {
                    tree.setSubChecked(checkedParentIds[j], false);
                } else {
                    currentId[currentId.length] = parentIds[i];
                }
            }
        }
        checkedParentIds = currentId;
    }
}

//根据子节点获取父节点id
function getCheckedParentIds(tree, subIds) {
    var parentIds = new Array();
    for (var i = 0; i < subIds.length; i++) {
        var parentId = tree.getParentId(subIds[i]);
        if ($.inArray(parentId, parentIds) < 0 && new RegExp("_").test(parentId)) {
            parentIds[parentIds.length] = parentId;
        }
    }
    return parentIds;
}

//获取选中的子节点id
function getCheckedSubIds(ids) {
    var checkedIds = new Array();
    if (new RegExp("_").test(ids)) {
        var checkedIdArray = ids.split(",");
        for (var i = 0; i < checkedIdArray.length; i++) {
            if (checkedIdArray[i].indexOf("_parent") < 0) {
                checkedIds[checkedIds.length] = checkedIdArray[i];
            }
        }
    } else {
        new RegExp(",").test(ids) ? checkedIds = ids.split(",") : checkedIds[0] = ids;
    }
    return checkedIds;
}




function esdcSelectContent(id, opts, type) {
    $(id).data("hasReg", true);
    $(id).on("click", function (evt) {
        if ($("#triggerEventId").val() != "" || ($("#triggerEventId").val() == "" && type != "input")) {
            if (typeof (opts) == "string") {
                opts = DhxCommon.paramStrToObj(opts);
            }
            updateOptsPath(opts);
            if (opts.path && opts.path.indexOf("value=") == -1 && opts.selectValue) {
                opts.path = toURL(opts.path, "value=" + opts.selectValue);
            } else if (opts.path && opts.path.indexOf("value=") == -1 && opts.value) {
                opts.path = toURL(opts.path, "value=" + opts.value);
            }
            opts.callback = opts.callback || function () {
                var sid = $(this.cell).find(".select_layout_box")[0];
                if (sid) {
                    DhxCommon.initEvents(ZKUI.Select.get(sid.id), ZKUI.Select.suport_evts, opts);
                    if (!opts.onSure) {
                        ZKUI.Select.get(sid.id).attachEvent("onSure", function () {
                            $(id).val(this.getSelectRowTexts());
                            $(id).blur();
                        })
                    }
                }
            }
            DhxCommon.createWindow(opts);
        } else {
            if (type == "input") {
                messageBox({
                    messageType: "alert",
                    text: I18n.getValue("esdc_globalLinkage_selectTrigger")
                });
            }
        }
    })
}

function configOpenSelectWindow(path, title, width, height, onSure, button, op, type) {
    var opts = {//选人控件弹窗配置
        path: path,//弹窗路径
        title: I18n.getValue(title),//弹窗标题
        width: width,//窗口宽度
        height: height,//窗口高度
        onSure: onSure,//回调事件
        op: op
    };
    esdcSelectContent(button, opts, type);
}

/**
 * 用于全局联动选择参数后勾选或取消勾选后，添加或删除要提交的数据
 *
 * @author <a href=mailto:yulong.dai@zkteco.com>yulong.dai</a>
 * @since 2014年12月24日 上午10:22:17
 * @param obj checkbox对象
 * @param idField 存储对应实体id的隐藏域id
 * @param nameField 存储对应实体name的隐藏域id
 */
function operate(obj, idField, nameField) {
    var id = $(obj).val();
    var name = $(obj).attr("entityName");
    if ($(obj).attr("checked") == undefined) {
        var oldIds = $("#" + idField).val();
        var oldIdArry = oldIds.split(",");
        var indexId = 0;
        var idString = "";
        for (var i = 0; i < oldIdArry.length; i++) {
            if (id == oldIdArry[i]) {
                indexId = i
                break;
            }
        }
        oldIdArry.splice(indexId, 1);
        if (oldIdArry.length > 0) {
            for (var i = 0; i < oldIdArry.length; i++) {
                idString += oldIdArry[i] + ",";
            }
            idString = idString.substring(0, idString.length - 1);
        }
        $("#" + idField).val(idString);

        var nameString = $("#" + nameField).val().replace(name, "");
        var oldNames = $("#" + nameField).val();
        var indexName = oldNames.indexOf(name);
        var nameString = "";
        if (indexName + name.length == oldNames.length) {
            nameString = $("#" + nameField).val().replace("," + name, "");
            if (indexName == 0) {
                nameString = $("#" + nameField).val().replace(name, "");
            }
        } else {
            nameString = $("#" + nameField).val().replace(name + ",", "");
        }
        $("#" + nameField).val(nameString);
    } else if ($(obj).attr("checked") == "checked") {
        if ($("#" + idField).val() == "") {
            $("#" + idField).val($("#" + idField).val() + id);
            $("#" + nameField).val($("#" + nameField).val() + name);
        } else {
            $("#" + idField).val($("#" + idField).val() + "," + id);
            $("#" + nameField).val($("#" + nameField).val() + "," + name);
        }
    }
    if (idField == "triggerEventId") {
        $("#selectedIds").val($("#" + idField).val());
    }
    reloadIsApplyToAll();
}

/**
 * 组装页面显示数据
 *
 * @author <a href=mailto:yulong.dai@zkteco.com>yulong.dai</a>
 * @since 2014年12月25日 上午10:36:59
 * @param idField 存储对应实体id的隐藏域id
 * @param nameField 存储对应实体name的隐藏域id
 * @param displayField 用于显示的div的id
 */
function buildPageData(idField, nameField, displayField) {
    var html = "";
    if ($("#" + idField).val() != "") {
        var idArray = $("#" + idField).val().split(",");
        var nameArray = $("#" + nameField).val().split(",");
        for (var i = 0; i < idArray.length; i++) {
            // 去空格处理,避免因digifort的id和name一致,id中包含空格,导致控件加载异常
            var trimId = idArray[i].replace(/\s/g, "");
            html += "<span id='esdcTriggerCondSpan" + trimId + "'></span><span>" + nameArray[i] + "</span><br>";
            loadUIToDiv("input", "#esdcTriggerCondSpan" + trimId, {
                useInputReq: true,
                hideLabel: true,
                type: "checkbox",
                id: "idTriggerCond_" + idArray[i],
                name: idField + "Checked",
                entityName: nameArray[i],
                value: idArray[i],
                onchange: "operate(this, '" + idField + "', '" + nameField + "')",
                trueValue: idArray[i],
                falseValue: idArray[i],
                eventCheck: true
            });
        }
    }
    $("#" + displayField).html(html);
}

//获取当前的日期时间，日期时间格式后续和日期控件一起处理
var initTime = function initDateTime() {
    var date = new Date();
    var curYear = date.getFullYear();
    var curMonth = (date.getMonth() + 1).toString().length < 2 ? "0" + (date.getMonth() + 1) : (date.getMonth() + 1);
    var curDate = date.getDate().toString().length < 2 ? "0" + date.getDate() : date.getDate();
    return curYear + "-" + curMonth + "-" + curDate;
}



//全选
function checkAll(idField, nameField) {
    $(":input[name='" + idField + "Checked']").each(function () {
        if ($(this).attr("checked") == undefined) {
            $(this).attr("checked", "checked");
            operate($(this), idField, nameField);
        }
    });
}

//全不选
function uncheckAll(idField, nameField) {
    $(":input[name='" + idField + "Checked']").each(function () {
        if ($(this).attr("checked") == "checked") {
            $(this).removeAttr("checked");
            operate($(this), idField, nameField);
        }
    });
}

function globalLinkageOpenWindow(path, width, height, title) {
    var opts = {
        path: path,
        width: width,
        height: height,
        title: I18n.getValue(title),
        gridName: "gridbox"
    }
    DhxCommon.createWindow(opts);
}

function reloadIsApplyToAll() {
    var reloadIsApplyToAll = false;
    $(":input[name='triggerCondChecked']").each(function () {
        if ($(this).siblings("input[type=checkbox]").attr("checked") == "checked") {
            if ($(this).val() == 300 || $(this).val() == 301) {
                reloadIsApplyToAll = true;
                return;
            }
        }
    });
    if (reloadIsApplyToAll) {
        $("#isApplyToAll").attr("disabled", false);
    } else {
        $("#applyToAllStr").val("0");
        $("#isApplyToAll").attr("checked", true).attr("disabled", true);
    }
}
// 邮箱验证
jQuery.validator.addMethod("EsdcMailValid", function (val, element) {
    //var mailReg = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/;
    var mailReg = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*$/;
    if (val == "") {
        return true;
    } else {
        var mailArray = val.replace(/;/g, ",").split(",");//统一将输入的分号替换成逗号，支持混合输入
        for (var i = 0; i < mailArray.length; i++) {
            if (mailArray[i] != "" && !(this.optional(element) || (mailReg.test(mailArray[i])))) {
                return false;
            }
        }
        return true;
    }
}, I18n.getValue("common_email_inputEmailError"));

//验证每个邮箱地址的长度
jQuery.validator.addMethod("EsdcMailLengthValid", function (val, element) {
    var mailArray = val.replace(/;/g, ",").split(",");//统一将输入的分号替换成逗号，支持混合输入
    for (var i = 0; i < mailArray.length; i++) {
        if (mailArray[i].length > 100) {
            return false;
        }
    }
    return true;
}, I18n.getValue("common_email_exceedMaxLen"));

//电话长度验证
jQuery.validator.addMethod("EsdcPhoneLengthValid", function (val, element) {
    var mobileNoArray = val.replace(/;/g, ",").split(",");//统一将输入的分号替换成逗号，支持混合输入
    for (var i = 0; i < mobileNoArray.length; i++) {
        if (mobileNoArray[i].length > 20) {
            return false;
        }
    }
    return true;
}, I18n.getValue("pers_import_phoneTooLong"));
//电话验证
jQuery.validator.addMethod("EsdcPhoneValid", function (val, element) {
    var mobileNoArray = val.replace(/;/g, ",").split(",");//统一将输入的分号替换成逗号，支持混合输入
    var pattenChar =  /^[0-9,;]*$/;
    for (var i = 0; i < mobileNoArray.length; i++) {
        return pattenChar.test(val);
    }
    return true;
}, I18n.getValue("common_jqMsg_number"));
