I18n.load([
    "esdc_entrance_ip_address",
    "esdc_transaction_config_event_level",
    "esdc_transaction_event_device",
    "esdc_entrance_fence_event_area",
    "esdc_entrance_fence_alarm_time",
    "esdc_entrance_fence_event_event_type",
    "esdc_entrance_no_data",
    "esdc_entrance_point_position_1",
    "esdc_entrance_point_position_2",
    "esdc_entrance_point_position_3",
    "esdc_entrance_point_position_4",
    "esdc_entrance_point_position_5",
    "esdc_entrance_to_be_configured",
    "esdc_common_detailInfo",
    "esdc_transaction_deal_result1",
    "esdc_transaction_deal_result2",
    "esdc_entrance_preview",
    "esdc_entrance_playback"
], true);
$(function () {
    /** 初始化越线围栏统计 */
    initEntranceFenceDate()
    /** 初始化频发点位TOP5 */
    loadEsdcEntranceFenceTop("day");
    /** 初始化区域分布扇形图 */
    initEventPieCountChart("day");
    /** 初始化越线围栏事件数据*/
    getInitEvent();

    $("#typeAreaTop5SelectDiv").hover(function () {
        $(".sele_tt_ul_Top5").show();
    }, function () {
        $(".sele_tt_ul_Top5").hide();
    });

    $("#typeAreaPieSelectDiv").hover(function () {
        $(".sele_tt_ul_area_pie").show();
    }, function () {
        $(".sele_tt_ul_area_pie").hide();
    });

    /** 登录用户区域权限获取区域id*/
    esdcInitAndMonitorGetAreaByUser();
})

/*------------------------------------展示图---------------------------------------*/
//客户端id
var clientId = Math.round(Math.random() * 100000) + "${uuid!}";

//查询标识，
var rowsTurn = true;
//设备初始化标识
var initDeviceChangeFlag = false;
var alarmDeviceIds = new Array();
var eventFlag = false;
var esdcDeviceIds = null;
var dataFlag=null;
function initEfEventSocket() {
    var client = Web.getSocket({
        id: "eventClient",
        url: "esdcEntranceFenceEvent/getEventData",
        param: JSON.stringify({"clientId": clientId}),
        onMessage: function (resp) {
            var data = JSON.parse(resp.body);
            if (data.clientId && clientId != data.clientId) {
                return;
            }
            $(".efBigImgLoad").html("");
            /**倒序排列，保证列表最新的记录在最上方*/
            //var rows = data.rows.reverse();
            var rows = data.rows;
            //数据标识，判断后端是否有数据推送
            dataFlag = rows;
            if(rows.length != 0){
                $(".imgShowNoDate").remove();
                $(".search_nothing_img").remove();
                $(".search_nothing_text").remove();
            }
            if (dealAndFocusRefresh == 1){
                $(".eventImgBox").empty();
                dealAndFocusRefresh = 0;
            }
            var authAreaName = $("#esdcFilterAreaName").val();
            for(var index in rows){
                let data = rows[index];
                if (!esdcCheckAuthArea(data.areaName,authAreaName)){
                    continue;
                }
                if(data.operate != null && rows.length != 1 && $(".eventImgBox").children().length < 10){
                    // $('#eventImg').append('<li class="item" >'+rows[index].data[9]+'</li>');
                    $('.eventImgBox').append(data.operate);
                }else if(data.operate != null && rows.length == 1 && $(".eventImgBox").children().length < 10){
                    $('.eventImgBox').prepend(data.operate);
                }else if(rows.length > 1 && $(".eventImgBox").children().length > 1){
                    $(".eventImgBox").empty();
                    $('.eventImgBox').append(data.operate);
                } else{
                    var len = $(".eventImgBox").children().length-1;
                    //表示删除最后一个元素
                    $('.eventImgBox div').last().remove();
                    $('.eventImgBox').prepend(data.operate);
                    $('.eventImgBox').children().first().hide().fadeIn(500);
                   //esdcCaptureImage(rows[0].data[1],rows[0].data[2],rows[0].data[5],rows[0].data[7],rows[0].data[6],rows[0].data[4],'','',rows[0].data[8]);
                    initShowImg();
                }

            }
            // $("img.imgSnapshot").lazyload({effect: "fadeIn"});
            initShowImg();
            initEntranceFenceDate()
        }
    });
    return client;
}

function getInitEvent(){
    $('.efBigImg').append("<div class='efBigImgLoad' style=\"width: 6vw;height: 1vw;position: absolute;top: 45%;left: 45%;\">\n" +
        "        <img src=\"/images/esdc_loading.gif\"> loading...\n" +
        "    </div>");
    $(".imgShowNoDate").css("display","none");
    $.ajax({
        url: 'esdcTransaction.do?getEntranceFenceInitEvent',
        type: 'post',
        dataType: 'json',
        async: true,
        success: function (resp) {
            $(".efBigImgLoad").html("");
            /**倒序排列，保证列表最新的记录在最上方*/
                //var rows = data.rows.reverse();
            var rows = resp.data;
            //数据标识，判断后端是否有数据推送
            dataFlag = rows;
            if(rows.length != 0){
                $(".efBigImgLoad").html("");
                $(".imgShowNoDate").remove();
                $(".search_nothing_img").remove();
                $(".search_nothing_text").remove();
            }
            if (dealAndFocusRefresh == 1){
                $(".eventImgBox").empty();
                dealAndFocusRefresh = 0;
            }
            for(var index in rows){
                let data = rows[index];

                if(data.operate != null && rows.length != 1 && $(".eventImgBox").children().length < 10){
                    // $('#eventImg').append('<li class="item" >'+rows[index].data[9]+'</li>');
                    $('.eventImgBox').append(data.operate);
                }else if(data.operate != null && rows.length == 1 && $(".eventImgBox").children().length < 10){
                    $('.eventImgBox').prepend(data.operate);
                }else if(rows.length > 1 && $(".eventImgBox").children().length > 1){
                    $(".eventImgBox").empty();
                    $('.eventImgBox').append(data.operate);
                } else{
                    var len = $(".eventImgBox").children().length-1;
                    //表示删除最后一个元素
                    $('.eventImgBox div').last().remove();
                    $('.eventImgBox').prepend(data.operate);
                    $('.eventImgBox').children().first().hide().fadeIn(500);
                    initShowImg();
                }

            }
            initEfEventSocket();
            initShowImg();
            initEntranceFenceDate()
        }
    });
}


//如果是页面没有加载到展示图、详情则重新加载webSocket
function reloadWebSocket() {
    if($(".imgSnapshot").length == 0  && $(".divController0").length == 0){
        initEfEventSocket();
    }
}
//字符串穿插字符
function insertStr(source, start, newStr){
    return source.slice(0, start) + newStr + source.slice(start);
}
//处理和收藏后刷新围栏页
var dealAndFocusRefresh = 0; //处理收藏刷新清理标志
function efRefreshSocket() {
    dealAndFocusRefresh = 1;
    getInitEvent();
}
// var client = setTimeout(initEventSocket,100);
var eventId = 0;
var clickTimer = null;
var focusFlags = null;//是否关注
var devChannel = null;
var eventTimes = null;
var imageViewObj = null;
//单击图片能显示图片大图及详情
function esdcCaptureImage(eventName,time,areaName,devAlias,ipAddress,eventLevel,id,dealType,focusFlag,deviceChannel,lineCoordinate,obj) {
    //推送列右下角图标皮肤切换
    $(".imgSnapshotBox .dealImgIcon").each(function () {
        var skinColor = $("#efSkinColor").val()+"/";
        var src = $(this)[0].src;
        if ($(this)[0].src.indexOf(skinColor) == -1){ //如果不包含
            $(this)[0].src = insertStr(src,src.lastIndexOf("/")+1,skinColor);
        }
    });
    //提示选中的图片
    $("#"+id+"_1").css("border","1px solid #FC5F21");
    $("#"+id+"_1").next().css("bottom","-1px").css("right","-1px");
    var currentId = $("#"+id+"_1")[0].id;
    $(".imgSnapshot").each(function () {
        var selectId = $(this).attr("id");
        if (currentId != selectId){
            $(this).css("border","");
            $(this).next().css("bottom","0").css("right","0");
        }
    });
    if(clickTimer) {
        window.clearTimeout(clickTimer);
        clickTimer = null;
    }
    clickTimer = window.setTimeout(function(){
        eventId=id;
        focusFlags=focusFlag;
        eventTimes = time;
        devChannel =deviceChannel;
        imageViewObj = obj;
        //var imgUrl = src;
        var data = new Array();
        document.getElementById("efEventTypeSpan").innerText = eventName;
        document.getElementById("efEventLevelSpan").innerText = I18n.getValue('esdc_transaction_level_' + eventLevel);
        document.getElementById("efAlarmTimeSpan").innerText = time;
        document.getElementById("efEventAreaSpan").innerText = areaName;
        document.getElementById("efIpAddressSpan").innerText = ipAddress;
        document.getElementById("efEventDeviceSpan").innerText = devAlias;
        document.getElementById("dealResultShow").innerHTML = '';
        if (dealType == "1"){
            if ($("#efSkinColor").val() == 'techblue'){//处理后蓝皮肤
                $("#dealResultShow").css("background","#0091F9");
            }else {
                $("#dealResultShow").css("background","#7AC143");
            }
            $("#dealResultShow").append("<div style=\"position: absolute;top: 50%;left: 50%;transform: translate(-50%,-50%);color: #FFFFFF;\">"+I18n.getValue('esdc_transaction_deal_result1')+"</div>");
        }else{
            $("#dealResultShow").css("background","#FC5F21");
            $("#dealResultShow").append("<div style=\"position: absolute;top: 50%;left: 50%;transform: translate(-50%,-50%);color: #FFFFFF;\">"+I18n.getValue('esdc_transaction_deal_result2')+"</div>");
        }
        document.getElementsByClassName("dealButtonClass").id = id;
        if (focusFlags == "false"){
            $(".focusFlagClass img").attr("src","/images/ic_shoucang.png");
            document.getElementById ("focusFlagImg").title=I18n.getValue('esdc_common_addFocus');
        }else{
            $(".focusFlagClass img").attr("src","/images/"+$("#efSkinColor").val()+"/ic_shoucang_green.png");
            document.getElementById ("focusFlagImg").title=I18n.getValue('esdc_common_removeFocus');
        }
        //显示左边的大图
        $(".imgShow").css("display","block");
        //添加警戒线
        var imgUrl = obj.src;
        imageViewObj.src = imgUrl;
        //由于回调函数与调用函数是异步执行所以if else内必须有相对应的后续代码
        if(lineCoordinate != "" && lineCoordinate != undefined){
            addLineCoordinate(imgUrl,lineCoordinate,function (res) {
                let imgBase64 = (res == "" ? imgUrl : res);
                $(".imgShow").attr('data-original', imgBase64);
                //图片懒加载特效，渐入
                $("img.imgShow").lazyload({effect: "fadeIn"});
                $(".divController").remove();
                $(".divController0").remove();
            })
        }else{
            $(".imgShow").attr('data-original', imgUrl);
            //图片懒加载特效，渐入
            $("img.imgShow").lazyload({effect: "fadeIn"});
            $(".divController").remove();
            $(".divController0").remove();
        }
        //显示预览等四个按钮
        // $("#viewButton").css("display","block");
    });
}

//初始化大图展示最新的一张抓拍图
function initShowImg() {
    if (dataFlag.length == 0){
        $(".eventImgBox").empty();
        $(".dealLabel").css("display","none");
        $(".imgShowNoDate").css("display","block");
        var imgUrl = "../images/"+$("#efSkinColor").val()+"/img_video_default.png";
        $(".search_nothing_img").remove();
        $(".search_nothing_text").remove();
        $(".imgViewDetail").append('<img class="search_nothing_img" src="'+'/images/esdc_person_search_nothing.png'+'">');
        $(".imgViewDetail").append('<div class="search_nothing_text">'+I18n.getValue('esdc_entrance_no_data')+'');
        $(".imgViewDetail").css("background-color","#F0F1F5");
        var j = 10;
        $('.eventImgBox').empty()
        for (var i = 1;i <= j;i++){
            $('.eventImgBox').append("<div class='imgSmallBoxNoDate'><img src='../images/"+$("#efSkinColor").val()+"/img_video_default_small.png' class='imgSnapshotNoDate' /></div>");
        }
        $(".imgView").css("background-color","#F0F1F5");
        $(".imgShowNoDate").attr('data-original', imgUrl);
        //图片懒加载特效，渐入
        $("img.imgShowNoDate").lazyload({effect: "fadeIn"});
    }else {
        var timeFn = null;
        $(".eventImgBox div img")[0].onclick()
        $(".dealLabel").css("display","block");
    }
}
/**弹出视频预览*/
function videoPlay(type) {
    $.ajax({
        url:'esdcTransaction.do?getTransactionItemById&id='+eventId,
        type: 'post',
        dataType: 'json',
        async : true,
        success: function(retData){
            var cameraType = retData.cameraType;
            var devCode = retData.devCode;
            var deviceName = retData.deviceName;
            var eventTime = retData.eventTime;
            if(type == "play"){
                esdcVideoPlay(deviceName, cameraType, devCode);
            }
            if(type == "replay"){
                esdcVideoReplay(deviceName, cameraType, devCode,eventTime);
            }
        }
    })
}
/** 查看详情 */
function getEsdcTransactionDetails(id) {
    if(clickTimer) {
        window.clearTimeout(clickTimer);
        clickTimer = null;
    }
    var path = "esdcTransaction.do?viewDetail&id=" + id;
    var opts = {
        path: path,
        width: 1050,
        height: 420,
        title: I18n.getValue('esdc_common_detailInfo'),
        gridName: "${gridName}"
    };
    DhxCommon.createWindow(opts);

}

/**查看详情跳转*/
function viewDetails() {
    if(eventId == 0 || eventId == "null" || eventId == "undefined"){
        return;
    }
    //跳转到页面详情
    getEsdcTransactionDetails(eventId)
}
/**点击按钮跳转处理页*/
function toEfDealDetail() {
    if (eventId !=0){
        dealWorkOrder("eventScene",eventId);
    }
}
/**是否关注*/
function addRemoveFocus() {
    if (eventId != 0){
        if (focusFlags == "false"){
            esdcAddFocus("","",eventId);
        }else{
            esdcRemoveFocus("","",eventId);
        }
    }
}
/*------------------------------------越线围栏统计---------------------------------------*/
/**
* 越线围栏统计后台请求方法
*/
var dateStatistics = {};
function initEntranceFenceDate() {
    $.ajax({
        url:'esdcTransaction.do?getEntranceFenceStatistics',
        type: 'post',
        dataType: 'json',
        async : true,
        success: function(retData){
            if (retData[sysCfg.ret] == sysCfg.success) {
                dateStatistics = retData.data;
                /**越线围栏数据统计*/
                initStatistics(dateStatistics);
                $("#fenceEventId").val(dateStatistics.fenceEventId);
            }
        }
    })
}

//点击今日数据跳至全部记录
function clickFenceToTran(eventId,dealType) {
    if (dealType == "1"){ // dealType 1 已处理 2.未处理
        localStorage.setItem('transactionConfigId', eventId +"_e1");
        openMenuItem("esdcTransaction.do", "Esdc",{"transactionConfigId":eventId + "_e1"});
    }else {
        localStorage.setItem('transactionConfigId', eventId +"_e2");
        openMenuItem("esdcTransaction.do", "Esdc",{"transactionConfigId":eventId + "_e2"});
    }
}
/**
 * 越线围栏统计数据
 */
function initStatistics(dateStatistics) {
    if(dateStatistics != null){
        $("#entranceFenceToday").html(dateStatistics.entranceFenceToday);
        $("#transactionDeal").html(dateStatistics.transactionDeal);
        $("#newDealRate").html(dateStatistics.newDealRate);
        $("#diffTimeAverage").html(dateStatistics.diffTimeAverage);
    }else {
        $("#entranceFenceToday").html("0");
        $("#transactionDeal").html("0");
        $("#newDealRate").html("0");
        $("#diffTimeAverage").html("0h 0m");
    }
}
/*------------------------------------越线频发点位TOP5---------------------------------------*/
var esdcEntranceFenceTopId = "esdcEntranceFenceTop_chart_canvas";
function loadEsdcEntranceFenceTop(timeType) {
    $.ajax({
        url:'esdcTransaction.do?getEntranceFenceTopData&timeType=' + timeType,
        type: 'post',
        dataType: 'json',
        async : true,
        success: function(retData){
            if (retData[sysCfg.ret] == sysCfg.success) {
                /**越线围栏TOP5数据统计*/
                esdcEntranceFenceTopCallback(retData.data);

            }
        }
    })
}
function removeLoadingSpiner(itemName,callBack) {
    var loadingSpiner =  $("#"+itemName+"_loadingSpiner");
    if(!callBack){
        if(loadingSpiner){
            loadingSpiner.remove()
        }
    }
    else{
        callBack(loadingSpiner);
    }
}


/**
 * 选择日周年月日
 */
function selectTimeType(event) {
    $("#esdcEntranceFenceTop_chart_canvas").empty();
    var timeType = "";
    if (event == "refresh") {

        timeType = $("#acc_tt_text_top5").html();
    } else {
        timeType = event.innerHTML;
    }
    if (timeType == I18n.getValue('esdc_common_day')) {
        loadEsdcEntranceFenceTop("day");
        $("#acc_tt_text_top5").html(I18n.getValue('esdc_common_day'));
    } else if (timeType == I18n.getValue('esdc_common_week')) {
        loadEsdcEntranceFenceTop("week");
        $("#acc_tt_text_top5").html(I18n.getValue('esdc_common_week'));
    } else if (timeType == I18n.getValue('esdc_common_month')) {
        loadEsdcEntranceFenceTop("month");
        $("#acc_tt_text_top5").html(I18n.getValue('esdc_common_month'));
    } else if (timeType == I18n.getValue('esdc_common_year')) {
        loadEsdcEntranceFenceTop("year");
        $("#acc_tt_text_top5").html(I18n.getValue('esdc_common_year'));
    }
}

/**
 * 渲染越线围栏top图表
 */
var esdcEntranceFenceTopId = "esdcEntranceFenceTop_chart_canvas";
function esdcEntranceFenceTopInit (data, total){
    $("#"+esdcEntranceFenceTopId).empty();
    var htmlText = "";
    var text = 1;
    $.each(data, function(index, val){
        var percentage = (val.exceptionVal/total)*100;
        htmlText+='<div class="bar-box">';
        htmlText+='<div class="bar-text">';
        htmlText+='<div class="bar-text-left" id='+'text_'+text+'>'+val.name+'</div>';
        htmlText+='<div class="bar-text-right"><span style="color:'+val.color+'">'+ val.exceptionVal+"/"+total + '</span></div>';
        htmlText+='</div>';
        htmlText+='<div class="bar-chart">';
        htmlText+='<div class="bar-chart-content" style="width:'+percentage+'%;background-image:' + val.image + '"></div>';
        htmlText+='</div>';
        htmlText+='</div>';
        text++;
    });
    $("#"+esdcEntranceFenceTopId).html(htmlText)
}
//根据皮肤修改折线图线条颜色
function efLineChartColor() {
    if ($("#efSkinColor").val() == 'techblue'){
        return '#0091F9';
    }
    return '#79C14A';
}
function esdcEntranceFenceTopCallback (data) {
    var dataTop5 = [];
    var dataReturnTotal = 0;
    var database = new Array();
    database = [
        {entranceFenceTopName:I18n.getValue('esdc_entrance_point_position_1') + "&nbsp;&nbsp;" + I18n.getValue('esdc_entrance_to_be_configured') ,number:"0"},
        {entranceFenceTopName:I18n.getValue('esdc_entrance_point_position_2') + "&nbsp;&nbsp;" + I18n.getValue('esdc_entrance_to_be_configured') ,number:"0"},
        {entranceFenceTopName:I18n.getValue('esdc_entrance_point_position_3') + "&nbsp;&nbsp;" + I18n.getValue('esdc_entrance_to_be_configured') ,number:"0"},
        {entranceFenceTopName:I18n.getValue('esdc_entrance_point_position_4') + "&nbsp;&nbsp;" + I18n.getValue('esdc_entrance_to_be_configured') ,number:"0"},
        {entranceFenceTopName:I18n.getValue('esdc_entrance_point_position_5') + "&nbsp;&nbsp;" + I18n.getValue('esdc_entrance_to_be_configured') ,number:"0"},
        {entranceFenceTopName:"total",number:"0"}
    ]
    //若后台查询无设备，则会返回一个total:0的值，因此data.size()=1
    if(data.length == 1){
        removeLoadingSpiner('esdcEntranceFenceTop');
        if(typeof database != 'undefined') {
            var index = 0;
            $.each(database, function (index, value) {

                var dataRet = {
                    exceptionVal: 0,
                    name: '',
                    color: '#387FC7',
                    image: 'linear-gradient(to right, red , yellow)'
                };

                if (value.entranceFenceTopName == "total") {
                    dataReturnTotal = value.number
                } else {
                    switch (index) {
                        case 0:
                            dataRet.color = '#387FC7';
                            dataRet.image = 'linear-gradient(to right, '+efLineChartColor()+' , '+efLineChartColor()+');';
                            break;
                        case 1:
                            dataRet.color = '#8E5FEB';
                            dataRet.image = 'linear-gradient(to right, #8E5FEB , #AC85F8);';
                            break;
                        case 2:
                            dataRet.color = '#EA67A8';
                            dataRet.image = 'linear-gradient(to right, #EA67A8 , #F698C2);';
                            break;
                        case 3:
                            dataRet.color = '#EB8254';
                            dataRet.image = 'linear-gradient(to right, #EB8254 , #FDA984);';
                            break;
                        default:
                            dataRet.color = '#EA9F54';
                            dataRet.image = 'linear-gradient(to right, #EA9F54 , #F4FD85);';

                    }
                    dataRet.name = value.entranceFenceTopName;
                    dataRet.exceptionVal = Number(value.number);
                    dataTop5.push(dataRet);
                    index++;
                }
            })
        }
    }else{
        removeLoadingSpiner('esdcEntranceFenceTop');
        if(typeof data != 'undefined'){
            var index = 0;
            $.each(data, function(index, value) {
                var dataRet = {
                    exceptionVal: 0,
                    name:'',
                    color: '#E67571',
                    image:'linear-gradient(to right, red , yellow)'
                };

                if (value.entranceFenceTopName == "total")
                {
                    dataReturnTotal = value.number
                }else
                {
                    switch(index)
                    {
                        case 0:
                            dataRet.color = '#387FC7';
                            dataRet.image = 'linear-gradient(to right, '+efLineChartColor()+' , '+efLineChartColor()+');';
                            break;
                        case 1:
                            dataRet.color = '#8E5FEB';
                            dataRet.image = 'linear-gradient(to right, #8E5FEB , #AC85F8);';
                            break;
                        case 2:
                            dataRet.color = '#EA67A8';
                            dataRet.image = 'linear-gradient(to right, #EA67A8 , #F698C2);';
                            break;
                        case 3:
                            dataRet.color = '#EB8254';
                            dataRet.image = 'linear-gradient(to right, #EB8254 , #FDA984);';
                            break;
                        default:
                            dataRet.color = '#EA9F54';
                            dataRet.image = 'linear-gradient(to right, #EA9F54 , #F4FD85);';

                    }
                    dataRet.name = value.entranceFenceTopName;
                    dataRet.exceptionVal = Number(value.number);
                    dataTop5.push(dataRet);
                    index++;
                }
            })
    }
    }
    esdcEntranceFenceTopInit(dataTop5, dataReturnTotal);
}

/*------------------------------------区域分布扇形图---------------------------------------*/

/**
 * 选择日周年月日
 */
function selectPieTimeType(event) {
    var timeType = "";
    if (event == "refresh") {
        timeType = $("#acc_tt_text_area_pie").html();
    } else {
       timeType = event.innerHTML;
    }
    if (timeType == I18n.getValue('esdc_common_day')) {
        initEventPieCountChart("day");
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_day'));
    } else if (timeType == I18n.getValue('esdc_common_week')) {
        initEventPieCountChart("week");
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_week'));
    } else if (timeType == I18n.getValue('esdc_common_month')) {
        initEventPieCountChart("month");
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_month'));
    } else if (timeType == I18n.getValue('esdc_common_year')) {
        initEventPieCountChart("year");
        $("#acc_tt_text_area_pie").html(I18n.getValue('esdc_common_year'));
    }
}

/**
 * 区域分布扇形图统计后台请求方法
 */
function initEventPieCountChart(timeType) {
    if(timeType=="" || timeType == null || timeType == undefined){
        $(".selectPieTime").children('option:selected').val("0");
        initEventPieCountChart('day');
    }
    $.ajax({
        url:'esdcDashboard.do?getEntranceFencePieDate&dataType=areaPie&eventType=entranceFence&timeType=' + timeType,
        type: 'post',
        dataType: 'json',
        async : true,
        success: function(retData){
            if (retData[sysCfg.ret] == sysCfg.success) {
                dataMap = retData.data;
                /**数据扇形面板*/
                initPieChart(dataMap);

            }
        }
    })
}
/**
 * 扇形图初始化
 */
function initPieChart(dataMap) {
    // 基于准备好的dom，初始化echarts实例
    var element = document.getElementById('esdc_pie_chart');
    // 防止div为null 初始化时报错
    if(element!=null){
        var radius = ['24%', '45%'];
        var myPieChart = echarts4.init(element);
        var seriesData = new Array();
        var dataArray = new Array();
        $.each(dataMap, function(name, num) {
            seriesData.push({name:name, value:num});
            dataArray.push(name);
        });
        option = {
            tooltip: {
                formatter: '{c} ({d}%)'
            },
            legend: {
                orient: 'vertical',
                right: "15%",
                top: "10%",
                textStyle: {
                    fontSize: 10,
                    color: $("#efSkinColor").val() == 'techblue' ? '#FFFFFF' : '#000'
                },
                icon: "circle",
                data: dataArray || []
            },
            series:[{
                type:'pie',
                //radius: '65%',
                radius: ['40%', '65%'],
                center: radius,
                selectedMode: 'single',
                color: [
                    EsdcDashboardWio.getPieGradientColor(efLineChartColor(), efLineChartColor(), 0.5),
                    EsdcDashboardWio.getPieGradientColor("#E97C4A", "#FFB17F", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#E94D4A", "#FB7D7E", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#EB5B9D", "#F891C9", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#9561EE", "#AF91FF", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#EBA054", "#FFC889", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#EEC454", "#FFEF8A", 0.5),
                    EsdcDashboardWio.getPieGradientColor("#E6EA54", "#F5FF8A", 0.5)
                ],
                label: {
                    show: false,
                    position: 'center',
                    /*normal: {
                        fontSize:10,
                        formatter: '{c}\n{d}%',
                        //position: 'inside'
                        //alignTo:'edges'
                        //alignTo:'labelLine'
                    }*/
                },
                emphasis: {
                    label: {
                        show: true,
                        fontSize: '12',
                        fontWeight: 'bold',
                        color: $("#efSkinColor").val() == 'techblue' ? '#FFFFFF' : '#000'
                    }
                },
                labelLine: {
                    show: false
                },
                data:seriesData || []
            }]
        };

        // 使用刚指定的配置项和数据显示图表。
        myPieChart.clear();
        myPieChart.setOption(option);
    }
}

function efVideoPlay() {
    if (devChannel != null){
        var opts = {
            path: "/skip.do?page=esdc_videoPlay_videoPlay&devChannel="+devChannel,
            width: 750,
            height: 550,
            title: I18n.getValue('esdc_entrance_preview'),
            gridName: "gridbox"//设置grid
        };
        DhxCommon.createWindow(opts);
    }
}

function efVideoRtPlay() {
    if (devChannel != null && eventTimes != null){
        var opts = {
            path: "/skip.do?page=esdc_videoPlay_videoReplay&devChannel="+devChannel+"&eventTime="+eventTimes,
            width: 750,
            height: 550,
            title: I18n.getValue('esdc_entrance_playback'),
            gridName: "gridbox"//设置grid
        };
        DhxCommon.createWindow(opts);
    }
}

//查看全景图
function efImageView() {
    let imgUrl = $(".imgShow").attr("src");
    if (imgUrl != undefined && imgUrl != ""){
        let eventTime = document.getElementById("efAlarmTimeSpan").innerText;
        let eventName = document.getElementById("efEventTypeSpan").innerText;
        let img = new Image()
        img.src = imgUrl;
        esdcCaptureImageView(img,eventTime,eventName);
    }
}

function esdcInitAndMonitorGetAreaByUser() {
    $.ajax({
        url:"esdcParams.do?getAreasByUser",
        type:"post",
        async:false,
        dataType:"json",
        data:{
        },
        success:function (result) {
            if (result.data != null) {
                $("#esdcFilterAreaId").val(result.data.areaId);
                $("#esdcFilterAreaName").val(result.data.areaName);
            }
        }
    });
}