(function() {

    /**
     * 面板主类
     * @constructor
     */
    function EsdcDashboardWio() { }

    //面板国际化数据
    var dbI18n = {};

    /**
     * 画轨迹
     * @param array
     * @returns {{x: number, y: number, y2: number, x2: number, global: boolean, colorStops: [{offset: number, color: *}, {offset: prototype._len|prototype._dashOffset, color: *}], type: string}}
     */
    EsdcDashboardWio.renderTrack=function(array){
        var x1 = 100;
        var y1 = 100;

        var x2 = 300;
        var y2 = 300;
        // 初始化zrender
        var zr = zrender.init(document.getElementById('main'));
        var line = new zrender.Line({
            style: {
                lineDash: [10, 10],
                stroke: 'rgba(10, 80, 60, 0.8)'
            },
            shape: {
                x1: x1,
                y1: y1,
                x2: x2,
                y2: y2

            }
        });
        zr.add(line);

        line.animate('style', true)
            .when(1000, {
                lineDashOffset: -20
            }).start();


        var circle2 = new zrender.Circle({
            scale: [1, 1],
            shape: {
                cx: 0,
                cy: 0,
                r: 5
            },
            style: {
                fill:'red'
            },
            hoverable: false
        });

        var group = new zrender.Group({
            position: [x1, y1]
        });

        group.add(circle2);

        zr.add(group);

        group.animate('', true)
            .when(4000, {
                position: [x2, y2]
            })
            .start();

        circle.animate('', true)
            .when(100, {
                position: [0, 0]
            })
            .when(200, {
                position: [0, 0]
            })
            .when(300, {
                position: [0, 0]
            })
            .when(400, {
                position: [0, 0]
            })
            .start();

        zr.configLayer(0, {
            // clearColor: 'rgba(255, 255, 255, 0.1)',
            motionBlur: true,
            lastFrameAlpha: 0.99
        });
    }

    /**
     * 加载实时事件饼图
     */
    EsdcDashboardWio.loadRTMPie = function() {
        // EsdcDashboardWio.rtmpie = echarts.init($("#esdc_chart_pie"));
        EsdcDashboardWio.rtmpie = echarts4.init($(".db_chart_pie")[0]);
        var options = {
            series: [
                {
                    name: 'rmt',
                    type: 'pie',
                    radius: ['50%', '70%'],
                    itemStyle:{
                        normal:{
                            label:{
                                show:false
                            },
                            labelLine:{
                                show:false
                            }
                        }
                    },
                    color:[
                        EsdcDashboardWio.getPieGradientColor("#5BBABD","#79C043",0.5),
                        EsdcDashboardWio.getPieGradientColor("#FFD37B","#F9A13F",0.5),
                        EsdcDashboardWio.getPieGradientColor("#F46A45","#FB7E85",0.5),
                        EsdcDashboardWio.getPieGradientColor("#009394","#00E0C7",0.5),
                        EsdcDashboardWio.getPieGradientColor("#9F44D3","#7367F0",0.5),
                    ],
                    selectedMode: 'single',
                    // selectedOffset: 30,
                    data: [
                        {value: 0, name: dbI18n['base_rt_event_normal']},
                        {value: 0, name: dbI18n['base_rt_event_exception']},
                        {value: 0, name: dbI18n['base_rt_event_alarm']}
                    ]
                }
            ]
        }
        EsdcDashboardWio.rtmpie.setOption(options);
    };

    /**
     * 加载实时事件折线图
     */
    EsdcDashboardWio.loadRTMLine = function() {
        // EsdcDashboardWio.rtmpie = echarts.init($("#esdc_chart_pie"));
        EsdcDashboardWio.rtmline = echarts4.init($(".db_chart_line")[0]);
        var options = {
            series: [
                {
                    name: 'rmtLine',
                    type: 'line',
                    data: [820, 932, 901, 934, 1290, 1330, 1320],
                }
            ],
            xAxis: {
                type: 'category',
                data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
            },
            yAxis: {
                type: 'value'
            },
        }
        EsdcDashboardWio.rtmline.setOption(options);
    };

    /**
     * 获取圆环的渐变色
     * @param startColor
     * @param endColor
     * @param offset
     * @returns {{x: number, y: number, y2: number, x2: number, global: boolean, colorStops: *[], type: string}}
     */
    EsdcDashboardWio.getPieGradientColor=function(startColor,endColor,offset){
        return {
            type: 'linear',
            x: 0,
            y: 0,
            x2: 0,
            y2: 1,
            colorStops: [
                { offset: 0, color: startColor },
                { offset: offset, color: endColor }
            ],
            global: false // 缺省为 false
        }
    }

    /**
     * 加载sliderBar
     */
    EsdcDashboardWio.loadSliderBar = function(){
        $('.sliderbar-container').sliderBar({
            open : false,           // 默认是否打开，true打开，false关闭
            top : 5,             // 距离顶部多高
            width : 251,           // body内容宽度
            height : 80,          // body内容高度
            theme : 'gray',       // 主题颜色
            position : 'left'      // 显示位置，有left和right两种
        });
        $('.sliderbar-container-bottom').sliderBar({
            open : true,           // 默认是否打开，true打开，false关闭
            top : 0,             // 距离顶部多高
            width : '100%',           // body内容宽度
            height : 90,          // body内容高度
            theme : 'gray',       // 主题颜色
            position : 'bottom'      // 显示位置，有left和right两种
        });
    }

    /**
     * 加载面板
     */
    EsdcDashboardWio.load = function(_i18n, _uuid) {
        //国际化数据
        dbI18n = _i18n;
        uuid = _uuid;

        clientId = Math.round(Math.random() * 10000) + uuid;

        //加载sliderbar
        EsdcDashboardWio.loadSliderBar();

        //加载饼状图
        EsdcDashboardWio.loadRTMPie();

        //加载折线图
        EsdcDashboardWio.loadRTMLine();

        //EsdcDashboardWio.renderTrack();

        // //加载人员总数
        // DashboardWio.loadNum(".db_chart_pers .db_chart_num", 0);
        //
        // //加载设备总数
        // DashboardWio.loadNum(".db_chart_dev .db_chart_num", 0);
        //
        // //加载生物模板
        // DashboardWio.loadBio();
        //
        // //加载模块报表
        // DashboardWio.loadModule();

        // //加载实时监控
        // DashboardWio.loadRTM();
        //
        // //大小调整
        // DashboardWio.resize();
        //
        // //开启时间计数器
        // DashboardWio.timer();
        //
        // //注册全屏事件
        // Web.attachEvent("onFullScreen", function(isFull) {
        //     if(isFull) {//全屏
        //         $("#top").hide();
        //         $(".db_box").css("top", "0px");
        //         document.body.style.minWidth="1000px";
        //     } else {
        //         $("#top").show();
        //         $(".db_box").css("top", "44px");
        //         if($(".top_fix_cla").length > 0 && $(".top_fix_cla").width() > 1000) {
        //             $(document.body).css("min-width", $(".top_fix_cla").width());
        //         }
        //     }
        // })
    }


    /**
     * 打开工单页面
     * @param id
     */
    EsdcDashboardWio.openWorkOrder = function esdcWorkOrder(id) {
        var path = "esdcWorkOrder.do?editByEventId&eventId=" + id;
        var opts = {
            path:path,
            width: 520,
            height: 500,
            title: I18n.getValue('esdc_work_order'),
            gridName:"${gridName}"
        };
        DhxCommon.createWindow(opts);
    }

    window.EsdcDashboardWio = EsdcDashboardWio;


})();

    //清空告警
    function clearAlarms() {
        $("#tabEventContainer").html("<div></div>");
        $("#botomContainer").html("<div></div>");
        // $("#bottom_alarm_number").html("(0)");
    }

    //查看事件详情
    function viewDetail(id){
        var path = "esdcTransaction.do?viewDetail&id="+id;
        var opts = {//弹窗配置对象
            path: path,//设置弹窗路径
            width: 670,//设置弹窗宽度
            height: 450,//设置弹窗高度
            title: I18n.getValue('esdc_common_detail'),//设置弹窗标题
            // gridName: "gridbox"//设置grid

        };
        DhxCommon.createWindow(opts);
    }

    //搜索事件
    function searchEvent(){
        let beginDate = $("#beginDate").val();
        let endDate = $("#endDate").val();
        $.ajax({
            url : "esdcTransaction.do?getTransactionList",
            type : "post",
            data : {
                "startTime" : beginDate,
                "endTime" : endDate,
                "posStart":0,
                "pageSize":10
            },
            success : function(result) {
                //删除所有节点
                $("#tabEventContainer").empty();
                $("#tabEventContainer").append("<div></div>");
                var color = "red";
                for(var index in result.data){
                    if(result.data[index].eventLevel != null && result.data[index].eventLevel != undefined && result.data[index].eventLevel != ""){
                        switch (result.data[index].eventLevel) {
                            case 1: color = "red";break;
                            case 2: color = "#FF6600";break;
                            case 3: color = "#FFCC00";break;
                            case 4: color = "#009900";break;
                        }
                    }
                    var tabContent = " <div onclick=\"viewDetail('"+result.data[index].id+"')\" style=\"border-left: 1px dashed grey; margin-left: 10px; cursor: pointer\">\n" +
                        "                                        <p style=\"text-align: left; margin-left: 2px;margin: 0;padding-top:10px\">---"+new Date(result.data[index].eventTime).Format("yyyy-MM-dd HH:mm:ss")+"</p>\n" +
                        "                                        <p style=\"text-align: left;margin-left: 20px;color:  "+color+";margin: 0;padding-left: 20px;padding-top: 10px\">"+result.data[index].deviceAlias + "发生" +result.data[index].eventName + "</p>\n" +
                        "                                    </div>";

                    var length = $("#tabEventContainer").children().length;
                    $("#tabEventContainer").children().last().after(tabContent);
                }
            }
        });
    }