I18n.load([
    "esdc_crossline_enter_stop",
    "esdc_crossline_admittance",
    "esdc_crossline_overLimit",
    "esdc_crossline_enter_please"
], true);
var crosslineSkinColor = $('#crosslineSkin').val();
function initCrosslineEventSocket() {
    var areaId = $("#currentAreaId").val();
    console.log("currentAreaId:" + areaId);
    var client = Web.getSocket({
        id: "eventClient",
        url: "esdcCrosslineEvent/getEventData",
        param: JSON.stringify({"clientId": clientId, "authAreaId": areaId}),
        onMessage: function (resp) {
            var data = JSON.parse(resp.body);
            if (data.clientId && clientId != data.clientId) {
                return;
            }
            var calculation = data.calculation;
            for (var i = 0; i < calculation.length; i++) {

                var areaId = calculation[i].areaId;
                var totalIn = calculation[i].totalIn;
                var totalOut = calculation[i].totalOut;
                var checkCount = calculation[i].checkCount;
                //实际人数占最大容量比例(百分制)
                var ratio = calculation[i].ratio;
                var total;//当前区域的人数
                if (parseInt(totalIn) - parseInt(totalOut) + checkCount < 0) {
                    total = 0;
                } else {
                    total = parseInt(totalIn) - parseInt(totalOut) + checkCount;
                }
                if ($("#currentAreaId").val() == areaId) {
                    var remain = parseInt($("#capacity").html()) - parseInt(total);//还可以进的人数
                    var capacity = parseInt($("#capacity").html());
                    var remainRadio = remain / capacity;//还可以进的百分比
                    if (ratio > 99) {
                        //大于99%，超载
                        $('#remain').css('color', 'red');
                        document.getElementById('centerDivCircle').style.backgroundImage = 'url(../../images/'+crosslineSkinColor+'/esdc_wait_bg.png)';
                        document.getElementById('centerDivCircleBig').style.backgroundImage = 'url(../../images/newCrosslineImg/crossline_circle_border_red.png)';
                        document.getElementById('centerDivImg').src = '../../images/'+crosslineSkinColor+'/wait.png';
                        $("#inOutWord").html(I18n.getValue('esdc_crossline_enter_stop'));
                        $('#inOutWord').css('color', 'red');
                        $('#warnWord').css("display", "block");
                        $("#personCountNum").html(I18n.getValue('esdc_crossline_admittance'));
                        if ($('#crosslineSkin').val() == 'techblue'){
                            $("#personCountNum").css("color", "#CBE1F1");
                        }else{
                            $("#personCountNum").css("color", "#000000");
                        }
                        $("#centerDivCircle").removeClass("breathe_btn_blue");
                        $("#centerDivCircle").addClass("breathe_btn_red");
                        if (ratio >= 100) {
                            $("#personCountNum").html(I18n.getValue('esdc_crossline_overLimit'));
                            $("#personCountNum").css("color", "red");
                        }
                    } else {
                        //小于等于99%，允许进入
                        document.getElementById('centerDivCircle').style.backgroundImage = 'url(../../images/'+crosslineSkinColor+'/esdc_open_bg.png)';
                        document.getElementById('centerDivCircleBig').style.backgroundImage = 'url(../../images/newCrosslineImg/crossline_circle_border_green.png)';
                        document.getElementById('centerDivImg').src = '../../images/'+crosslineSkinColor+'/esdc_ic_open.png';
                        $("#inOutWord").html(I18n.getValue('esdc_crossline_enter_please'));
                        $('#warnWord').css("display", "none");
                        $("#personCountNum").html(I18n.getValue('esdc_crossline_admittance'));
                        if ($('#crosslineSkin').val() == 'techblue'){
                            $("#personCountNum").css("color", "#CBE1F1");
                            $('#remain').css('color', '#CBE1F1');
                            $('#inOutWord').css('color', '#CBE1F1');
                        }else{
                            $('#remain').css('color', '#7AC143');
                            $('#inOutWord').css('color', '#7AC143');
                            $("#personCountNum").css("color", "#000000");
                        }
                        $("#centerDivCircle").removeClass("breathe_btn_red");
                        $("#centerDivCircle").addClass("breathe_btn_blue");
                        if (ratio < 70) {
                            //小于70%时，
                        } else {
                            //大于等于70%小于等于99%
                        }
                    }
                    $("#percentage").html(ratio + "%");
                    countProgress(ratio);

                    $('#personNum').html(total);
                    $('#remain').html(Math.abs(remain));
                    break;
                }

            }

            //实时列表
            /**倒序排列，保证列表最新的记录在最上方*/
            var rows = data.event.reverse();

            for (var index in rows) {
                var dhxGrid = ZKUI.Grid.get("esdcCrosslineGrid").grid;
                if (rows[index] != null && typeof (dhxGrid.setSizes) == "function") {
                    //页面显示的最多事件条数
                    var maxEventCount = 20;
                    //超过20就删除第一个
                    if (dhxGrid.getRowsNum() >= maxEventCount) {
                        dhxGrid.deleteRow(dhxGrid.getRowId(dhxGrid.getRowsNum() - 1));
                    }
                    var id = rows[index].data[0];
                    dhxGrid.addRow(id, rows[index].data, 0);
                    // dhxGrid.setRowTextStyle(id, rows[index].style);
                    dhxGrid._f_rowsBuffer = null;
                    dhxGrid.setSizes(false);
                }
                // $('#allInNum').text(rows[index].data[7]);
                // $('#allOutNum').text(rows[index].data[8]);
            }
        }
    });
    /**获取区域内人数趋势图**/
    setTimeout(function () {
        getCrosslineTrendData();
    },300);
    return client;
    /**注册全屏事件**/
    if (Web) {
        Web.attachEvent("onFullScreen", function (isFullScreen) {
            //判断是否防疫监控页面
            if ($("#crosslineFullScreenBtn").length > 0) {
                //全屏
                if (isFullScreen) {
                    fullScreen = true;
                    // $("#hepFullScreenIcon").attr("src","images/hep_exist_fullScreen.png");
                } else {
                    //退出全屏
                    fullScreen = false;
                    // $("#hepFullScreenIcon").attr("src","images/hep_full_screen_blue.png");
                }

            }
        })
    }
}

function getCrosslineTrendData() {
    var date = $('#trendDate').val();
    var areaId = $("#currentAreaId").val();
    $.ajax({
        url: "/esdcCrosslineEvent.do?getCrosslineTrend",
        type: "post",
        data: {
            "time" : date,
            "areaId" : areaId
        },
        success: function (result) {
            $('#passengeFlow').text(result.data.passengerFlow);
            initCrossLineTrendChart("currentPersonCountTrend",result.data.trendData,result.data.markLine);
        }
    })
}
var myLineChart;
function initCrossLineTrendChart(divId,data,markLine){
    // 基于准备好的dom，初始化echarts实例
    var element = document.getElementById(divId);
    // 防止div为null 初始化时报错
    if (element != null) {
        myLineChart = echarts4.init(element);
        var areaName = new Array();
        var xAxisData = new Array();
        var optionData = new Array();
        $.each(data, function(type, list) {
            var seriesData = new Array();
            areaName.push(type);
            xAxisData = [];
            $.each(list, function (index, value) {
                xAxisData.push(value.time);
                seriesData.push({name: value.time, value: value.number})
            });
            optionData.push({name: type, color: $("#crosslineSkin").val() == 'techblue' ? '#0091f9' : '#7ac142',smooth:true,markLine:{symbol:"none",data:[{lineStyle:{color:"red"},yAxis: markLine}]}, type: 'line',symbol:'none', stack:'cover', data: seriesData})
        });
        var option = {
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'line',
                    label: {
                        backgroundColor: '#6a7985'
                    }
                }
            },
            grid: {
                top: '10%',
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: {
                type: 'category',
                boundaryGap: false,
                data: xAxisData,
                axisLabel: {
                    interval: 5,
                    textStyle: {
                        color: '#B4BBC6'
                    }
                },
                axisLine: {
                    show: false
                },
                axisTick: {
                    show: false
                }
            },
            yAxis: [
                {
                    type: 'value',
                    axisLine: {
                        show: false
                    },
                    axisTick: {
                        show: false
                    },
                    axisLabel: {
                        textStyle: {
                            color: '#B4BBC6'
                        }
                    }
                }
            ],
            series: optionData
        };
        // 使用刚指定的配置项和数据显示图表。
        myLineChart.clear();
        myLineChart.setOption(option);
    }
}
//点击左侧菜单栏初始折线图
if(!window["hasAttachLeftEvent"]) {
    $("#leftHeader").on('click',function () {
        if (myLineChart != "" && myLineChart != null){
            myLineChart.resize();
        }
    });
    window["hasAttachLeftEvent"]=true;
}