I18n.load([
    "esdc_aiBox_alertType_personnelCrossing",
    "esdc_aiBox_alertType_personnelIntrusion",
    "esdc_aiBox_alertType_vehicleCrossing",
    "esdc_aiBox_alertType_noParking",
    "esdc_aiBox_alertType_vehicleDeparture",
    "esdc_aiBox_alertType_personnelWandering",
    "esdc_aiBox_alertType_personnelWall",
    "esdc_aiBox_behavior_alertType_crowd",
    "esdc_aiBox_behavior_alertType_fight",
    "esdc_aiBox_behavior_alertType_fall",
    "esdc_aiBox_behavior_alertType_smoke",
    "esdc_aiBox_behavior_alertType_run",
    "esdc_aiBox_behavior_alertType_call",
    "esdc_aiBox_behavior_alertType_watchPhone",
    "esdc_aiBox_alertSubType_singleTripWire",
    "esdc_aiBox_alertSubType_accessArea",
    "esdc_aiBox_alertSubType_leaveArea",
    "esdc_aiBox_alertSubType_accessLeaveArea",
    "esdc_aiBox_alertSubType_stayArea",
    "esdc_aiBox_alertSubType_wallOverturning",
    "esdc_aiBox_areaType_oneWay_singleTripWire",
    "esdc_aiBox_areaType_twoWay_singleTripWire",
    "esdc_aiBox_areaType_oneWay_doubleTripWire",
    "esdc_aiBox_areaType_twoWay_doubleTripWire",
    "esdc_aiBox_areaType_area"
], true);

//封装告警类型(周边警戒、行为警戒) 子类型 ROI类型格式
var perimeterAlertTypeSort = {
    "1" : I18n.getValue('esdc_aiBox_alertType_personnelCrossing'),
    "2" : I18n.getValue('esdc_aiBox_alertType_personnelIntrusion'),
    "3" : I18n.getValue('esdc_aiBox_alertType_vehicleCrossing'),
    "4" : I18n.getValue('esdc_aiBox_alertType_noParking'),
    "5" : I18n.getValue('esdc_aiBox_alertType_vehicleDeparture'),
    "6" : I18n.getValue('esdc_aiBox_alertType_personnelWandering'),
    "7" : I18n.getValue('esdc_aiBox_alertType_personnelWall')
};

var behaviorAlertTypeSort = {
    "8" : I18n.getValue('esdc_aiBox_behavior_alertType_crowd'),
    "9" : I18n.getValue('esdc_aiBox_behavior_alertType_fight'),
    "10" : I18n.getValue('esdc_aiBox_behavior_alertType_fall'),
    "11" : I18n.getValue('esdc_aiBox_behavior_alertType_smoke'),
    "12" : I18n.getValue('esdc_aiBox_behavior_alertType_run'),
    "13" : I18n.getValue('esdc_aiBox_behavior_alertType_call'),
    "14" : I18n.getValue('esdc_aiBox_behavior_alertType_watchPhone')
};

var alertSubTypeSort = {
    "1" : I18n.getValue('esdc_aiBox_alertSubType_singleTripWire'),
    "2" : I18n.getValue('esdc_aiBox_alertSubType_accessArea'),
    "3" : I18n.getValue('esdc_aiBox_alertSubType_leaveArea'),
    "4" : I18n.getValue('esdc_aiBox_alertSubType_accessLeaveArea'),
    "5" : I18n.getValue('esdc_aiBox_alertSubType_stayArea'),
    "6" : I18n.getValue('esdc_aiBox_alertSubType_wallOverturning')
}

var areaTypeSort = {
    "1" : I18n.getValue('esdc_aiBox_areaType_oneWay_singleTripWire'),
    "2" : I18n.getValue('esdc_aiBox_areaType_twoWay_singleTripWire'),
    "3" : I18n.getValue('esdc_aiBox_areaType_oneWay_doubleTripWire'),
    "4" : I18n.getValue('esdc_aiBox_areaType_twoWay_doubleTripWire'),
    "5" : I18n.getValue('esdc_aiBox_areaType_area')
}

var channelMode = $("#channelMode").val();
var vendor = $("#vendor ").val();
var alertType = $("#alertType").val();
var alertSubType = $("#alertSubType").val();
var areaType = $("#areaType").val();

//初始加载警戒类型,通过通道模式
function loadInitAlertType(mode) {
    var alertTypeMap = {};
    var alertTypeArray = new Array();
    if (vendor === "0" && mode === "2"){
        alertTypeMap = perimeterAlertTypeSort;
    }else if (vendor === "0" && mode === "3"){
        alertTypeMap = behaviorAlertTypeSort;
    }
    if (Object.keys(alertTypeMap).length !== 0){
        for (var key in alertTypeMap) {
            var obj = {text: alertTypeMap[key] , value : key};
            alertTypeArray.push(obj);
        }
        ZKUI.Combo.get("alertRuleAlertTypeCombo").combo.clearAll();
        ZKUI.Combo.get("alertRuleAlertTypeCombo").addOption(alertTypeArray);
        if (mode === channelMode){
            ZKUI.Combo.get("alertRuleAlertTypeCombo").setValue(alertType);
            controlAlertSubType(alertType);
            controlAlertAreaType(alertType)
        }else {
            ZKUI.Combo.get("alertRuleAlertTypeCombo").combo.selectOption(0);
            var selectValue = ZKUI.Combo.get("alertRuleAlertTypeCombo").getValue();
            controlAlertSubType(selectValue);
            controlAlertAreaType(selectValue);
        }
    }else {
        //这里可以作为 选择非传入通道模式时 下拉置为空
        controlAlertSubType("");
        controlAlertAreaType("");
    }
}

//控制子告警类型下拉和选中
function controlAlertSubType(value) {
    var alertSubTypeArray = new Array();
    var obj = {};
    var obj1 = {};
    var obj2 = {};
    switch (value) {
        case "1":
        case "3":
            obj.text = alertSubTypeSort["1"];
            obj.value = "1";
            alertSubTypeArray.push(obj);
            break;
        case "2":
            obj.text = alertSubTypeSort["2"];
            obj.value = "2";
            alertSubTypeArray.push(obj);
            obj1.text = alertSubTypeSort["3"];
            obj1.value = "3";
            alertSubTypeArray.push(obj1);
            obj2.text = alertSubTypeSort["4"];
            obj2.value = "4";
            alertSubTypeArray.push(obj2);
            break;
        case "4":
        case "6":
        case "8":
        case "9":
        case "10":
        case "11":
        case "12":
        case "13":
        case "14":
            obj.text = alertSubTypeSort["5"];
            obj.value = "5";
            alertSubTypeArray.push(obj);
            break;
        case "5":
            obj.text = alertSubTypeSort["3"];
            obj.value = "3";
            alertSubTypeArray.push(obj);
            break;
        case "7":
            obj.text = alertSubTypeSort["6"];
            obj.value = "6";
            alertSubTypeArray.push(obj);
            break;
        default:break;
    }
    if (alertSubTypeArray.length > 0){
        ZKUI.Combo.get("alertRuleAlertSubTypeCombo").combo.clearAll();
        ZKUI.Combo.get("alertRuleAlertSubTypeCombo").addOption(alertSubTypeArray);
        if (value === alertType){
            ZKUI.Combo.get("alertRuleAlertSubTypeCombo").setValue(alertSubType);
        }else {
            ZKUI.Combo.get("alertRuleAlertSubTypeCombo").combo.selectOption(0);
        }
    }else {
        ZKUI.Combo.get("alertRuleAlertSubTypeCombo").combo.clearAll();
        ZKUI.Combo.get("alertRuleAlertSubTypeCombo").addOption([{value:"", text:"----------"}]);
        ZKUI.Combo.get("alertRuleAlertSubTypeCombo").combo.selectOption(0);
    }
}

//控制ROI类型下拉和选中
function controlAlertAreaType(value) {
    var alertAreaTypeArray = new Array();
    var obj = {};
    var obj1 = {};
    switch (value) {
        case "1":
        case "3":
            obj.text = areaTypeSort["1"];
            obj.value = "1";
            alertAreaTypeArray.push(obj);
            obj1.text = areaTypeSort["2"];
            obj1.value = "2";
            alertAreaTypeArray.push(obj1);
            break;
        case "2":
        case "4":
        case "5":
        case "6":
        case "8":
        case "9":
        case "10":
        case "11":
        case "12":
        case "13":
        case "14":
            obj.text = areaTypeSort["5"];
            obj.value = "5";
            alertAreaTypeArray.push(obj);
            break;
        case "7":
            obj.text = areaTypeSort["3"];
            obj.value = "3";
            alertAreaTypeArray.push(obj);
            obj1.text = areaTypeSort["4"];
            obj1.value = "4";
            alertAreaTypeArray.push(obj1);
            break;
        default:break;
    }
    if (alertAreaTypeArray.length > 0){
        ZKUI.Combo.get("alertRuleAreaTypeCombo").combo.clearAll();
        ZKUI.Combo.get("alertRuleAreaTypeCombo").addOption(alertAreaTypeArray);
        if (value === alertType){
            ZKUI.Combo.get("alertRuleAreaTypeCombo").setValue(areaType);
        } else {
            ZKUI.Combo.get("alertRuleAreaTypeCombo").combo.selectOption(0);
        }
    }else {
        ZKUI.Combo.get("alertRuleAreaTypeCombo").combo.clearAll();
        ZKUI.Combo.get("alertRuleAreaTypeCombo").addOption([{value:"", text:"----------"}]);
        ZKUI.Combo.get("alertRuleAreaTypeCombo").combo.selectOption(0);
    }
}

