I18n.load([
    "common_devMonitor_msgTip",
    "base_mail_sendServerSetting",
    "esdc_entrance_ip_address",
    "esdc_transaction_config_event_level",
    "esdc_transaction_event_device",
    "esdc_entrance_fence_event_area",
    "esdc_entrance_fence_alarm_time",
    "esdc_entrance_fence_event_event_type",
    "esdc_common_rt_preview",
    "esdc_event_level_0",
    "esdc_event_level_1",
    "esdc_event_level_2",
    "esdc_device_alarm_type_14",
    "esdc_device_alarm_type_118",
    "esdc_device_alarm_type_122",
    "esdc_event_type_14",
    "esdc_event_type_12",
    "esdc_event_type_3",
    "esdc_event_type_4",
    "esdc_event_type_15",
    "esdc_common_detailInfo",
    "esdc_common_detail",
    "common_prompt_sureToDelThese",
    "esdc_common_prompt_sureToAddFocus",
    "esdc_common_prompt_sureToRemoveFocus",
    "esdc_transaction_level_1",
    "esdc_transaction_level_2",
    "esdc_transaction_level_3",
    "esdc_transaction_level_0",
    "esdc_transaction_type_3",
    "esdc_transaction_type_4",
    "esdc_transaction_type_12",
    "esdc_transaction_type_14",
    "esdc_work_order",
    "esdc_patrolPlan_deleteAll",
    "esdc_patrolPlan_capyTo",
    "esdc_panoramic_picture",
    "esdc_common_mapPos_prompt",
    "esdc_common_prompt_sureToRemoveFocus",
    "esdc_dashboard_shortcut_collection_confim",
    "esdc_dashboard_shortcut_collection_del",
    "acc_newEventNo_0",
    "esdc_transaction_level_0",
    "esdc_transaction_level_null",
    "esdc_common_loading",
    "esdc_common_unknown",
    "esdc_common_addFocus",
    "esdc_common_removeFocus",
    "esdc_common_addFocus_event",
    "esdc_common_removeFocus_event",
    "esdc_work_order_deal_advice",
    "esdc_common_prompt_send_email",
    "common_online",
    "common_offline",
    "esdc_device_state_unknown",
    "esdc_map_addDevice",
    "esdc_dismission_capture_sum",
    "esdc_dismission_stranger_enabled",
    "esdc_dismission_black_enabled",
    "esdc_dismission_white_enabled",
    "esdc_dismission_related_details",
    "esdc_common_day",
    "esdc_common_week",
    "esdc_common_month",
    "esdc_common_year",
    "esdc_transaction_no_relevant_data",
    "common_unknown",
    "esdc_crossLine_echarts_save_picture",
    "esdc_entrance_viewDetail",
    "esdc_passback_event_not_yet",
    "esdc_leave_post_point",
    "esdc_entrance_point_position_5",
    "esdc_dashboard_eventTime",
    "esdc_common_timePoint",
    "esdc_personnelSearch_track_information",
    "esdc_personSearch_esdc_record",
    "esdc_personSearch_acc_record",
    "esdc_personSearch_att_record",
    "esdc_personSearch_vid_record",
    "esdc_personSearch_ele_record",
    "esdc_personSearch_cow_record",
    "esdc_personSearch_pas_record",
    "esdc_personSearch_select_record_type",
    "esdc_person_gender_male",
    "esdc_person_gender_female",
    "esdc_personSearch_entry_name_or_pin",
    "esdc_body_structed_unlimited",
    "esdc_body_structed_unknown",
    "esdc_body_structed_children",
    "esdc_body_structed_juvenile",
    "esdc_body_structed_youth",
    "esdc_body_structed_middle_age",
    "esdc_body_structed_old_age",
    "esdc_body_structed_yes",
    "esdc_body_structed_no",
    "esdc_body_structed_black",
    "esdc_body_structed_blue",
    "esdc_body_structed_brown",
    "esdc_body_structed_green",
    "esdc_body_structed_grey",
    "esdc_body_structed_orange",
    "esdc_body_structed_pink",
    "esdc_body_structed_violet",
    "esdc_body_structed_red",
    "esdc_body_structed_white",
    "esdc_body_structed_yellow",
    "esdc_body_structed_other",
    "esdc_all",
    "esdc_picture_not_enlarge",
    "esdc_picture_not_narrow",
    "esdc_dismission_find_more_record",
    "esdc_dismission_not_data",
    "esdc_transaction_white_people",
    "esdc_transaction_black_people",
    "esdc_work_order_list",
    "esdc_common_from",
    "esdc_common_build_in",
    "esdc_entrance_preview",
    "esdc_entrance_playback",
    "esdc_dashboard_unknown",
    "esdc_transaction_stranger",
    "esdc_crossline_check",
    "esdc_target_recognition_alarm",
    "esdc_crossline_wear_please",
    "esdc_crossline_distance_prompt",
    "esdc_crossline_touch_hand_prompt",
    "esdc_crossline_no_climbing",
    "esdc_crossline_no_diet",
    "esdc_crossline_no_fight",
    "esdc_crossline_no_firearms",
    "esdc_crossline_lookafter_baby",
    "esdc_crossline_come_in_monitor",
    "esdc_crossline_no_smoking",
    "esdc_crossline_no_pets",
    "esdc_crossline_no_photograph",
    "esdc_crossline_no_play",
    "esdc_crossline_no_lean",
    "esdc_crossline_takecare_slide",
    "esdc_crossline_takecare_steps",
    "esdc_crossline_supply_umbrella",
    "esdc_crossline_supply_wifi",
    "esdc_module",
    "ivs_module",
    "esdc_sdc_server_system",
    "esdc_crossline_no_wine",
    "esdc_transaction_entrance_fence",
    "esdc_transaction_leave_post",
    "esdc_ranking_init_earliest_allow",
    "esdc_ranking_init_earliest",
    "esdc_ivs_module",
    "esdc_transaction_behavior_personnel_target",
    "esdc_linkage_set_mail_list",
    "esdc_globalLinkage_selectTrigger"
], true);

/**
 * 设备模块来源转换
 * @param v
 * @returns {*}
 */
function esdcConvertSourceModule(v){
    if(v){
        return I18n.getValue(v + "_module");
    }
    return v;
}

/**
 * 设备状态转换
 * @param v
 * @returns {string}
 */
function esdcConvertConnectState(v) {
    if (v == "1") {
        v = "<span style='color: green'>" + I18n.getValue("common_online") + "</span>";
    }
    if (!v || v == "0") {
        v = "<span style='color: red'>" + I18n.getValue("common_offline") + "</span>";
    }
    if (v == "2") {
        v = "<span style='color: #E57A14'>" + I18n.getValue("esdc_device_state_unknown") + "</span>";
    }
    return v;
}

/** 0或1状态转换成图标 */
function EsdcConvertToIcon(v) {
    v = v + '';
    printLog(v);
    if (v == '1' || v == "true") {
        return '<div class="icon_state_yes"></div>';
    }
    else if (v == '0' || v == "false") {
        return '<div class="icon_state_no"></div>';
    }
    else {
        return v;
    }
}

//转换图片
function esdcConvertImg(v) {
    var ret = "";
    if (v != "") {
        var html =
            "    <img src=" + v + " onerror=\"this.src='images/notFoundMapPic.jpg'\"  width='80px' height='80px' >\n";
        ret = html;
    }
    return ret;
}

//转换图片，可放大预览
function esdcConvertCaptureImage(v) {
    var uuid = guid();
    var ret = "";
    if (v != "") {
        var html =
            "    <img  style='cursor: pointer;' ondblclick='esdcCaptureImageView(this)' onerror=\"this.src='/images/notFoundPic.jpg'\" onload='esdcPreCaptureImage(this)' id=" + uuid + " src=" + v + " height='30px' >\n";
        ret = html;
    }
    return ret;
}

function S4() {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
}

function guid() {
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
}

//图片放大预览
function esdcPreCaptureImage(obj) {
    $("#" + obj.id).imgPreview({
        imgCSS: {width: 200, height: 150}
    });
}

//双击查看全景图
function esdcCaptureImageView(obj,eventTime,eventName) {
    sessionStorage.setItem("panoramaDetail",obj.src);
    var opts = {
        path: "/skip.do?page=esdc_vid_imagesView&eventTime="+ eventTime + "&eventName=" +eventName,
        width: 700,
        height: 500,
        title: I18n.getValue('esdc_panoramic_picture')
    };
    DhxCommon.createWindow(opts);
}

//告警事件类型的转换
function convertToAlarmTypeName(v) {
    v = v + '';
    switch (v) {
        case '14': //泛出入口围栏
            return I18n.getValue('esdc_device_alarm_type_14');
            break;
        case '118': //过线统计
            return I18n.getValue('esdc_device_alarm_type_118');
            break;
        case '122': //脱岗离岗
            return I18n.getValue('esdc_device_alarm_type_122');
            break;
        default:
            return v;
    }
}

/**
 * 普通告警事件类型定义在EsdcContants中
 * @param v
 * @returns {string|*}
 */
function convertEventType(v) {
    v = v + '';
    switch (v) {
        case '3': //重点人员管控
            return I18n.getValue('esdc_event_type_3');
            break;
        case '4': //尾随事件
            return I18n.getValue('esdc_event_type_4');
            break;
        case '12': //脱岗离岗事件
            return I18n.getValue('esdc_event_type_12');
            break;
        case '15': //过线统计
            return I18n.getValue('esdc_event_type_15');
            break;
        case '14': //泛出入口围栏
            return I18n.getValue('esdc_event_type_14');
            break;
        default:
            return v;
    }
}


/**
 * 告警事件等级类型定义在EsdcContants中
 * @param v
 * @returns {string|*}
 */
function convertEventLevel(v) {
    v = v + '';
    switch (v) {
        case '0': //泛出入口围栏
            return I18n.getValue('esdc_event_level_0');
            break;
        case '1': //人群密度
            return I18n.getValue('esdc_event_level_1');
            break;
        case '2': //过线统计
            return I18n.getValue('esdc_event_level_2');
            break;
        default:
            return v;
    }
}

/**
 * 告警事件等级类型定义在EsdcContants中
 * @param v
 * @returns {string|*}
 */
function convertEventLevelNew(v) {
    v = v + '';
    switch (v) {
        case '1':
            return I18n.getValue('esdc_transaction_level_1');
            break;
        case '2':
            return I18n.getValue('esdc_transaction_level_2');
            break;
        case '3':
            return I18n.getValue('esdc_transaction_level_3');
            break;
        case '0':
            return I18n.getValue('esdc_transaction_level_0');
            break;
        default:
            return I18n.getValue('esdc_common_unknown');
    }
}

/**
 * 当事件等级配置被删除时，事件类型读取为默认
 * @param v
 * @returns {string|*}
 */
function convertEventType(v) {
    v = v + '';
    switch (v) {
        case '':
            return I18n.getValue('esdc_common_unknown');
            break;
        default:
            return v;
    }
}

/**
 * eventId超链接转换,跳转事件详情
 * @param eventId
 * @returns {string}
 */
function esdcConvertLinkDetail(eventCode) {
    if (eventCode == undefined || eventCode == null || eventCode == "") {
        return "";
    } else {
        return "<a href='javascript:esdcTransactionDetailsByCode(\"" + eventCode + "\")'>" + eventCode + "</a>";
    }
}

/** 查看详情 */
var flag = true;

function esdcTransactionDetailsByCode(eventCode) {
    if (flag) {
        var path = "esdcTransaction.do?viewDetailByCode&eventCode=" + eventCode;
        var opts = {
            path: path,
            width: 670,
            height: 450,
            title: I18n.getValue('esdc_common_detailInfo'),
            gridName: "${gridName}"
        };
        DhxCommon.createWindow(opts);
        flag = false;
        setTimeout(function () {
            flag = true;
        }, 3000)

    }

}

/** 查看详情 */
function esdcTransactionDetails(id) {
    var path = "esdcTransaction.do?viewDetail&id=" + id;
    var opts = {
        path: path,
        width: 1050,
        height: 420,
        title: I18n.getValue('esdc_common_detailInfo'),
        gridName: "${gridName}"
    };
    if($("#jbox")){
        $("#jbox").css("z-index","100");
    }
    DhxCommon.createWindow(opts);
}

/** 查看详情 */
function esdcTransactionDetailsFromAll(id) {
    var rowIdsArray = [];
    var idStr = "";
    rowIdsArray = transactionGrid.getAllRowIds().split(",");
    var presentIndex = rowIdsArray.indexOf(id);
    if(rowIdsArray.length != 1) {
        if (presentIndex == 0) {
            idStr = "start," + rowIdsArray[presentIndex] + "," + rowIdsArray[presentIndex + 1];
        } else if (presentIndex == rowIdsArray.length - 1) {
            idStr = rowIdsArray[presentIndex - 1] + "," + rowIdsArray[presentIndex] + ",end";
        } else {
            idStr = rowIdsArray[presentIndex - 1] + "," + rowIdsArray[presentIndex] + "," + rowIdsArray[presentIndex + 1];
        }
    }else {
        idStr = "start," + rowIdsArray[presentIndex] + ",end"
    }

    var path = "esdcTransaction.do?viewDetailFromAll&id=" + id + "&idStr=" + idStr;
    var opts = {
        path: path,
        width: 1050,
        height: 420,
        title: I18n.getValue('esdc_common_detailInfo'),
        gridName: "${gridName}"
    };
    DhxCommon.createWindow(opts);
}

/** 删除泛出入口围栏记录 */
function deleteTransactionRecord(id) {

    messageBox({
        messageType: "confirm",
        text: I18n.getValue('common_prompt_sureToDelThese'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?del",
                        type: "POST",
                        data: {"ids": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                ZKUI.Grid.get("${gridName}").grid.deleteRow(id);
                                openMessage(msgType.success);
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/** 工单 */
function dealWorkOrder(from, id) {
    var path = "esdcWorkOrder.do?dealWorkOrder&eventId=" + id + "&from=" + from;
    var opts = {
        path: path,
        width: 650,
        height: 400,
        title: I18n.getValue('esdc_work_order_deal_advice'),
        gridName: "${gridName}"
    };
    DhxCommon.createWindow(opts);
}

/**工单管理跳转方法：grid列表操作栏*/
function editWorkOrder(gridName, domObj, rid) {
    var path = "esdcWorkOrder.do?editByEventId&eventId=" + rid;
    var opts = {
        path: path,
        width: 520,
        height: 530,
        title: I18n.getValue('esdc_work_order'),
        gridName: "${gridName}"
    };
    DhxCommon.createWindow(opts);
}

/**关注*/
function esdcFocus(id) {
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToAddFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?addFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                transactionGrid.cells(id, 10).cell.innerHTML = transactionGrid.cells(id, 10).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_addFocus'), "gm"), I18n.getValue('esdc_common_removeFocus')).replace("esdcFocus", "esdcRemoveMarker");
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**移除关注*/
function esdcRemoveMarker(id) {
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToRemoveFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?removeFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                transactionGrid.cells(id, 10).cell.innerHTML = transactionGrid.cells(id, 10).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_removeFocus'), "gm"), I18n.getValue('esdc_common_addFocus')).replace("esdcRemoveMarker", "esdcFocus");
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**关注（电子围栏和脱岗离岗）*/
function esdcEntranceAndLeaveFocus(id) {
    console.log(id);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToAddFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?addFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                transactionGrid.cells(id, 8).cell.innerHTML = transactionGrid.cells(id, 8).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_addFocus'), "gm"), I18n.getValue('esdc_common_removeFocus')).replace("esdcEntranceAndLeaveFocus", "esdcRemoveEntranceAndLeaveMarker");
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**移除关注（电子围栏和脱岗离岗）*/
function esdcRemoveEntranceAndLeaveMarker(id) {
    console.log(id);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToRemoveFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?removeFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                transactionGrid.cells(id, 8).cell.innerHTML = transactionGrid.cells(id, 8).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_removeFocus'), "gm"), I18n.getValue('esdc_common_addFocus')).replace("esdcRemoveEntranceAndLeaveMarker", "esdcEntranceAndLeaveFocus");
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**添加关注*/
function esdcAddFocus(gridName, domObj, rid) {
    console.log(rid);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToAddFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?addFocus",
                        type: "POST",
                        data: {"id": rid},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                ZKUI.Grid.reloadGrid(gridName);
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                            efRefreshSocket();
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**移除关注*/
function esdcRemoveFocus(gridName, domObj, rid) {
    console.log(rid);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToRemoveFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?removeFocus",
                        type: "POST",
                        data: {"id": rid},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                ZKUI.Grid.reloadGrid(gridName);
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                            efRefreshSocket();
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**事件详情内的关注*/
function addFocus(id) {
    console.log(id);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToAddFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?addFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                $('#addFocus').html($('#addFocus').html().replace("addFocus", "removeFocus").replace("<@i18n 'esdc_common_addFocus'/>", "<@i18n 'esdc_common_removeFocus'/>"));
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**事件详情内的取消关注*/
function removeFocus(id) {
    console.log(id);
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToRemoveFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?removeFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                $('#addFocus').html($('#addFocus').html().replace("removeFocus", "addFocus").replace("<@i18n 'esdc_common_removeFocus'/>", "<@i18n 'esdc_common_addFocus'/>"));
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

function bigImg(size) {
    size.style.height = "100px";
    size.style.width = "150px";
}

function normalImg(size) {
    size.style.height = "50px";
    size.style.width = "50px";
}

//全屏
function esdcFullScreen(e) {
    if (document.fullscreenElement || document.msFullscreenElement ||
        document.mozFullScreenElement || document.webkitFullscreenElement || false) {
        // 校验用户密码
        // var opts = {
        //     path: "/skip.do?page=esdc_authUserCheck_esdcAuthUserCheck",//设置弹窗路径
        //     width: 350,//设置弹窗宽度
        //     height: 150,//设置弹窗高度
        //     title: "common_securityVerify"//设置弹窗标题
        // };
        // DhxCommon.createWindow(opts);
        fullScreenTab(e, false);

    } else {
        fullScreenTab(e, true);
        setIntervalOverTime();
    }
}

function setIntervalOverTime() {
    window.setInterval(refreshSession, 900000);
}

//请求后台刷新session。（防止长时间未操监控页面session失效）
function refreshSession() {
    $.ajax({
        url: "/esdcCrossline.do?setIntervalOverTime",
        type: "post",
        async: false,
        dataType: "json",
        data: {},
        success: function (result) {
        }
    });
}

/**事件列表、统计图切换*/
function esdcSwitchEvent(type) {
    if (type == 1) {
        /**切换统计*/
        //esdcBottomRTEvent
        $("#esdcBottomRTEvent").css("display", "block");
        $("#esdcBottomEventCount").css("display", "none");
        var className = "";
        if (localStorage.skin == "default") {
            className = "esdcMenuCurrentDef";
        } else {
            className = "esdcMenuCurrent";
        }
        $("#esdc_bottom_event").addClass(className);
        $("#esdc_bottom_statistics").removeClass(className);
        $("#esdc_bottom_event img").attr("src", "images/ic_event_blue.png");
        $("#esdc_bottom_statistics img").attr("src", "images/ic_statistics_normal.png");
    } else {
        /**切换实时事件*/
        $("#esdcBottomRTEvent").css("display", "none");
        $("#esdcBottomEventCount").css("display", "block");
        var className = "";
        if (localStorage.skin == "default") {
            className = "esdcMenuCurrentDef";
        } else {
            className = "esdcMenuCurrent";
        }
        $("#esdc_bottom_statistics").addClass(className);
        $("#esdc_bottom_event").removeClass(className);
        $("#esdc_bottom_event img").attr("src", "images/ic_event_normal.png");
        $("#esdc_bottom_statistics img").attr("src", "images/ic_statistics_blue.png");
    }
}

/**
 * 设备图标切换
 * @param deviceId
 */
function changeImages(deviceIds) {
    for (var index in deviceIds) {
        var images = $("#" + deviceIds[index] + "_image");
        if (images != undefined && images != null && images != "") {
            images.attr('src', "../../images/esdc_device.png");
        }
    }
}

/**
 * 门禁事件等级转换
 * @param eventName
 * @returns {string | *}
 */
function eventLevelConverter(eventName) {
    if (I18n.getValue("acc_newEventNo_0") === eventName) {
        return I18n.getValue("esdc_transaction_level_0");
    }
    return I18n.getValue("esdc_transaction_level_null");
}

function loading(id) {
    $('body').loading({
        loadingWidth: 100,
        title: '',
        name: id,
        discription: I18n.getValue("esdc_common_loading"),
        direction: 'column',
        type: 'origin',
        // originBg:'#71EA71',
        originDivWidth: 10,
        originDivHeight: 10,
        originWidth: 6,
        originHeight: 6,
        smallLoading: false,
        loadingMaskBg: 'rgba(0,0,0,0)'
    });
}

/**
 * pike轮播图初始化
 */
function esdcPikeInit() {
    var myPike = new Pike(".pi", {
        type: 1, // 轮播的类型(1渐隐)
        automatic: true, //是否自动轮播 (默认false)
        autoplay: 3000, //自动轮播毫秒 (默认3000)
        hover: true, //鼠标悬停轮播 (默认false)
        arrowColor: "yellow", //箭头颜色 (默认绿色)
        arrowBackgroundType: 2, //箭头背景类型 (1: 方形, 2:圆形)
        arrowBackground: 1, //箭头背景色 (1:白色,2:黑色, 默认:无颜色)
        arrowTransparent: 0.2, //箭头背景透明度 (默认: 0.5)
        spotColor: "white",//圆点颜色 (默认: 白色)
        spotType: 1, //圆点的形状 (默认: 圆形, 1:圆形, 2.矩形)
        spotSelectColor: "red", //圆点选中颜色 (默认绿色)
        spotTransparent: 0.8, //圆点透明度 (默认0.8)
        mousewheel: true, //是否开启鼠标滚动轮播(默认false)
        drag: false, //是否开启鼠标拖动 (默认为: true, 如不需要拖动设置false即可)
        loop: true, //是否循环轮播 (默认为: false)
        arrowList: { //自定义箭头图片
            left: "/images/ic_pike_left.png",
            right: "/images/ic_pike_right.png",
            width: 20, //如果不设置宽高,则按照图片默认宽高显示
            height: 40,
        },
    });
    var width = $(".pike div").width();
    $(".pike img").css("width", width);
}

/**
 * 姓名转换
 * @param name
 * @returns {string|*}
 */
function convertName(name) {
    if (name != null && name != "" && name != undefined) {
        return name;
    } else {
        return I18n.getValue("esdc_common_unknown");
    }
}

//判断30还是31
function isInArray(arr, value) {
    for (var i = 0; i < arr.length; i++) {
        if (value === arr[i]) {
            return true;
        }
    }
    return false;
}

//结束时间默认当月最后一天23:59:59
function endTimeCheck(endTimeDay) {
    //2020-10-28 15:31:06
    var endTimeCheck = endTimeDay.substring(0, endTimeDay.lastIndexOf("\-"));
    var endTimeYear = endTimeCheck.substring(0, 4);
    var endTimeMonth = endTimeCheck.substring(endTimeCheck.lastIndexOf("\-") + 1, endTimeCheck.length);
    var attr1 = ['01', '03', '05', '07', '08', '10', '12'];
    var attr2 = ['04', '06', '09', '11'];
    if (isInArray(attr1, endTimeMonth)) {
        $("input[name='endTime']").val(endTimeYear + "-" + endTimeMonth + "-" + "31" + " 23:59:59");
    } else if (isInArray(attr2, endTimeMonth)) {
        $("input[name='endTime']").val(endTimeYear + "-" + endTimeMonth + "-" + "30" + " 23:59:59");
    } else {
        if ((endTimeYear % 4) == 0) {
            $("input[name='endTime']").val(endTimeYear + "-" + endTimeMonth + "-" + "29" + " 23:59:59");
        } else {
            $("input[name='endTime']").val(endTimeYear + "-" + endTimeMonth + "-" + "28" + " 23:59:59");
        }
    }
}

/**发送邮件*/
function sendEmail(id) {
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_send_email'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "/esdcTransaction.do?sendEmail",
                        type: "post",
                        async: false,
                        data: {"id": id},
                        dataType: "json",
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
        }
    })
}

/**事件详情内的关注*/
function addFocus(from, flag, id) {
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToAddFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?addFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                document.getElementById ("focusEvent").title=I18n.getValue('esdc_common_removeFocus');
                                var eventClick = "removeFocus('" + from + "', '" + flag + "', '" + id + "')";
                                var focusEvent = $("#focusEvent img");
                                var focusSkinColor = $("#focusEvent img")[0].id;//适应蓝皮肤收藏五角星颜色
                                focusEvent.attr("src","images/"+focusSkinColor+"/ic_focus.png");
                                focusEvent.removeAttr("onclick");
                                focusEvent.attr("onclick",eventClick);
                                if (from == "all" || from == "focusPage") {
                                    transaction.reload();
                                } else if (from == "faceScene") {
                                    transactionGrid.cells(id, 10).cell.innerHTML = transactionGrid.cells(id, 10).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_addFocus'), "gm"), I18n.getValue('esdc_common_removeFocus')).replace("esdcFocus", "esdcRemoveMarker");
                                } else if (from == "eventScene") {
                                    transactionGrid.cells(id, 8).cell.innerHTML = transactionGrid.cells(id, 8).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_addFocus'), "gm"), I18n.getValue('esdc_common_removeFocus')).replace("esdcEntranceAndLeaveFocus", "esdcRemoveEntranceAndLeaveMarker");
                                }
                                $('#preview').focus();
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
            $('#preview').focus();
        }
    })
}

/**事件详情内的取消关注*/
function removeFocus(from, flag, id) {
    messageBox({
        messageType: "confirm",
        text: I18n.getValue('esdc_common_prompt_sureToRemoveFocus'),
        callback: function (result) {
            if (result) {
                openMessage(msgType.loading);
                setTimeout(function () {
                    $.ajax({
                        url: "esdcTransaction.do?removeFocus",
                        type: "POST",
                        data: {"id": id},
                        async: false,
                        success: function (retData) {
                            if (retData[sysCfg.ret] == sysCfg.success) {
                                closeMessage();
                                openMessage(msgType.success);
                                document.getElementById ("focusEvent").title=I18n.getValue('esdc_common_addFocus');
                                var eventClick = "addFocus('" + from + "', '" + flag + "', '" + id + "')";
                                var focusEvent = $("#focusEvent img");
                                focusEvent.attr("src","images/ic_unfocus.png");
                                focusEvent.removeAttr("onclick");
                                focusEvent.attr("onclick",eventClick);

                                if (from == "all" || from == "focusPage") {
                                    transaction.reload();
                                } else if (from == "faceScene") {
                                    transactionGrid.cells(id, 10).cell.innerHTML = transactionGrid.cells(id, 10).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_removeFocus'), "gm"), I18n.getValue('esdc_common_addFocus')).replace("esdcRemoveMarker", "esdcFocus");
                                } else if (from == "eventScene") {
                                    transactionGrid.cells(id, 8).cell.innerHTML = transactionGrid.cells(id, 8).cell.innerHTML.replace(new RegExp(I18n.getValue('esdc_common_removeFocus'), "gm"), I18n.getValue('esdc_common_addFocus')).replace("esdcRemoveEntranceAndLeaveMarker", "esdcEntranceAndLeaveFocus");
                                }
                                $('#preview').focus();
                            } else if (retData[sysCfg.ret] == sysCfg.error) {
                                closeMessage();
                                openMessage("warning", retData[sysCfg.msg]);
                            } else {
                                closeMessage();
                                openMessage("warning", I18n.getValue('common_op_failed'));
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            messageBox({
                                messageType: "alert",
                                title: I18n.getValue('common_prompt_title'),
                                text: I18n.getValue('common_prompt_serverError') + "-628"
                            });
                        }
                    });
                }, 500);
            }
            $('#preview').focus();
        }
    })
}

/**事件处理回调*/
function method(from, flag) {
    //刷新越线围栏今日统计页面
    if(from == "0" && flag == "4"){
        efRefreshSocket();
        initEntranceFenceDate();
    }
    var id = "";
    if (flag == 1) {
        id = $("#keyPersonId").val();
    } else if (flag == 2) {
        id = $("#passBackId").val();
    } else if (flag == 3) {
        id = $("#leavePostId").val();
    } else {
        id = $("#entranceFenchId").val();
    }
    $.ajax({
        url: "/esdcTransaction.do?getWorkOrderItemsById",
        type: "post",
        async: false,
        dataType: "json",
        data: {"id": id},
        success: function (result) {
            var divStr = "<div style=\"height: 8%;width: 100%\">\n" +
                "                            <p style=\"position: relative;top: 50%;transform: translateY(-50%);left: 3%;font-weight: 900\">\n" +
                I18n.getValue("esdc_work_order_list") +
                "                            </p>\n" +
                "                        </div>";
            if (result.workOrderOperationItemList.length > 0) {
                for (var i = 0; i < result.workOrderOperationItemList.length; i++) {
                    divStr += "<li class=\"scrollbar\">" +
                        I18n.getValue("esdc_common_from")+ '&nbsp;' + result.workOrderOperationItemList[i].operator +'&nbsp;'+ I18n.getValue("esdc_common_build_in") + '&nbsp;' + new Date(result.workOrderOperationItemList[i].updateTime).format("yyyy-MM-dd HH:mm:ss") + "<br/>";
                    if (result.workOrderOperationItemList[i].description.length > 0) {
                        divStr += "<div style=\"padding: 4% 0 0 0%\">" + result.workOrderOperationItemList[i].description + "</div>";
                    }
                    divStr += "</li>";
                }
            } else {
                divStr += "<div style='position: relative;top: 50%;text-align: center'><@i18n 'esdc_transaction_no_relevant_data'/></div>";
            }
            if (flag == 1) {
                $("#keyPersonDeal").html(divStr);
            } else if (flag == 2) {
                $("#passBackDeal").html(divStr);
            } else if (flag == 3) {
                $("#leavePostDeal").html(divStr);
            } else {
                $("#entranceFenceDeal").html(divStr);
            }
            if (from == 1) {
                transaction.reload();
            }
            $('#preview').focus();
        }
    });

}

//同比例缩放事件详情登记图片，防止拉伸
function modifyImageWh() {
    //图片的宽高
    var imgWidth = document.getElementById('getImgWH').offsetWidth;
    var imgHeight = document.getElementById('getImgWH').offsetHeight;
    //盛放图片的宽高
    var imgDivWidth = document.getElementById('imgDivWh').offsetWidth;
    var imgDivHeight = document.getElementById('imgDivWh').offsetHeight;
    var widthInterval = parseFloat(imgDivWidth) - parseFloat(imgWidth);
    var heightInterval = parseFloat(imgDivHeight) - parseFloat(imgHeight);
    var finalWidth;
    var finalHeight;
    if (widthInterval <= 0 && heightInterval <= 0) {
        if (Math.abs(widthInterval) > Math.abs(heightInterval)) {
            finalWidth = parseFloat(imgWidth) - Math.abs(widthInterval);
            finalHeight = (finalWidth / (finalWidth + Math.abs(widthInterval))) * imgHeight;
            $('#getImgWH').css({'width': Math.floor(finalWidth) -12 + 'px', 'height': Math.floor(finalHeight) -12 + 'px'});
        } else {
            finalHeight = parseFloat(imgHeight) - Math.abs(heightInterval);
            finalWidth = (finalHeight / (finalHeight + Math.abs(heightInterval))) * imgWidth;
            $('#getImgWH').css({'width': Math.floor(finalWidth) -12 + 'px', 'height': Math.floor(finalHeight) -12 + 'px'});
        }
    } else {
        $('#getImgWH').css({'width': imgWidth -12 + 'px', 'height': imgHeight -12 + 'px'});
    }
}

//监听div大小变化
// (function($, h, c) {
//     var a = $([]),
//         e = $.resize = $.extend($.resize, {}),
//         i,
//         k = "setTimeout",
//         j = "resize",
//         d = j + "-special-event",
//         b = "delay",
//         f = "throttleWindow";
//     e[b] = 250;
//     e[f] = true;
//     $.event.special[j] = {
//         setup: function() {
//             if (!e[f] && this[k]) {
//                 return false;
//             }
//             var l = $(this);
//             a = a.add(l);
//             $.data(this, d, {
//                 w: l.width(),
//                 h: l.height()
//             });
//             if (a.length === 1) {
//                 g();
//             }
//         },
//         teardown: function() {
//             if (!e[f] && this[k]) {
//                 return false;
//             }
//             var l = $(this);
//             a = a.not(l);
//             l.removeData(d);
//             if (!a.length) {
//                 clearTimeout(i);
//             }
//         },
//         add: function(l) {
//             if (!e[f] && this[k]) {
//                 return false;
//             }
//             var n;
//             function m(s, o, p) {
//                 var q = $(this),
//                     r = $.data(this, d);
//                 r.w = o !== c ? o: q.width();
//                 r.h = p !== c ? p: q.height();
//                 n.apply(this, arguments);
//             }
//             if ($.isFunction(l)) {
//                 n = l;
//                 return m;
//             } else {
//                 n = l.handler;
//                 l.handler = m;
//             }
//         }
//     };
//     function g() {
//         i = h[k](function() {
//                 a.each(function() {
//                     var n = $(this),
//                         m = n.width(),
//                         l = n.height(),
//                         o = $.data(this, d);
//                     if (m !== o.w || l !== o.h) {
//                         n.trigger(j, [o.w = m, o.h = l]);
//                     }
//                 });
//                 g();
//             },
//             e[b]);
//     }
// })(jQuery, this);

//时间戳转时间格式
function timestampToTime(timestamp,dataType) {
    var date = new Date(timestamp);//时间戳为10位需*1000，时间戳为13位的话不需乘1000
    var Y = date.getFullYear() + '-';
    var M = (date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1) + '-';
    var D = (date.getDate() < 10 ? '0' + (date.getDate()) : date.getDate()) + ' ';
    var h = (date.getHours() < 10 ? '0' + (date.getHours() ) : date.getHours() )+ ':';
    var m = (date.getMinutes() <10 ? '0' + (date.getMinutes() ) : date.getMinutes() )+ ':';
    var mm = (date.getMinutes() <10 ? '0' + (date.getMinutes() ) : date.getMinutes() );
    var s = (date.getSeconds()  < 10 ? '0' + (date.getSeconds() ) : date.getSeconds() );
    if(dataType == 'yyyy-MM-dd HH:mm:ss'){
        return Y + M + D + h + m + s;
    }else if(dataType == 'HH:mm:ss'){
        return h + m + s;
    }else if(dataType == 'MM-dd HH:mm:ss'){
        return M + D + h + m + s;
    }else if(dataType == 'yyyy-MM-dd'){
        return Y + M + D;
    }else if(dataType == 'MM-dd HH:mm'){
        return M + D + h + mm;
    }
}


function jumpToReport(reportId,jumpSign) {
    $.ajax({
        type: "get",
        dataType: "html",
        contentType: "application/json; charset=utf-8",
        async: false,
        url: "esdcPersonnelSearch.do?report",
        data: {
            trackReportId:reportId,
            jumpSign:jumpSign
        },
        success: function (data) {
            $("#change").html(data);
        }
    });
}
//数据来源国际化
function sourceModulesLanguage(language) {
    switch (language){
        case "esdc":
            language = I18n.getValue("esdc_personSearch_esdc_record");break;
        case "acc":
            language = I18n.getValue("esdc_personSearch_acc_record");break;
        case "att":
            language = I18n.getValue("esdc_personSearch_att_record");break;
            break;
        case "ivs":
            language = I18n.getValue("esdc_personSearch_vid_record");break;
            break;
        case "ele":
            language = I18n.getValue("esdc_personSearch_ele_record");break;
            break;
        case "cow":
            language = I18n.getValue("esdc_personSearch_cow_record");break;
            break;
        case "pas":
            language = I18n.getValue("esdc_personSearch_pas_record");break;
            break;
        default:
            language = I18n.getValue("esdc_common_unknown");break;
            break;
    }
    return language;
}

//用于图片触发效果
function clickChangeGreenImg(event) {
    var obj = document.getElementById(event.id);
    switch (obj.id){
        case "psPhotoImg":
            obj.src = "/images/person_search_photo_green.png";
            break;
        case "psHistoryImg":
            obj.src = "/images/person_search_history_green.png";
            break;
        case "psLastPageImg":
            obj.src = "/images/person_search_last_page_green.png";
            break;
        case "psNextPageImg":
            obj.src = "/images/person_search_next_page_green.png";
            break;
        case "psSearchButton":
            obj.style.backgroundColor = "#A0DB47";
            break;
        case "psMoreCondition":
            obj.style.color = "#7AC143";
            break;
        case "moreShowReportInfo":
            obj.style.color = "#7AC143";
        default:break;
    }
}
//复原效果
function clickChangeGrayImg(event) {
    var obj = document.getElementById(event.id);
    switch (obj.id){
        case "psPhotoImg":
            obj.src = "/images/person_search_photo.png";
            break;
        case "psHistoryImg":
            obj.src = "/images/person_search_history.png";
            break;
        case "psLastPageImg":
            obj.src = "/images/person_search_last_page.png";
            break;
        case "psNextPageImg":
            obj.src = "/images/person_search_next_page.png";
            break;
        case "psSearchButton":
            obj.style.backgroundColor = "#88ca3f";
            break;
        case "psMoreCondition":
            obj.style.color = "black";
            break;
        case "moreShowReportInfo":
            obj.style.color = "black";
            break;
        default:break;
    }
}

function esdcVideoPlay(deviceName, channelType, devCode) {
    showLiveVideo(deviceName, channelType, devCode, getCenterTop(), getCenterLeft(), 'center', 700, 500);
}

function esdcVideoReplay(deviceName, channelType, devCode,eventTime) {
    var startTime = new Date(new Date(eventTime).getTime() - 10000).format("yyyyMMddHHmmss");
    var endTime = new Date(new Date(eventTime).getTime() + 10000).format("yyyyMMddHHmmss");
    showReplayVideo (deviceName, channelType, devCode, getCenterTop(), getCenterLeft(), 'center', 700, 500, startTime, endTime)
}

/**iclient弹出预览窗口的中心计算*/
function getCenterTop(){
    return (window.innerWidth - 700) / 2;
}
function getCenterLeft(){
    return (window.innerHeight - 500) / 2;
}

/** 详情页处理样式变换*/
function changeColor(mouseOprate){
    if(mouseOprate === "up"){
        $("#deal").css("color","#717880").css("background","white");
        $("#deal img").attr("src", "images/ic_deal.png");
    }else{
        $("#deal").css("color","white").css("background","#7AC143");
        $("#deal img").attr("src", "images/ic_deal_select.png");
    }
}

//详情视频预览
function detailVideoPlay(devChannel) {
    var opts = {
        path: "/skip.do?page=esdc_videoPlay_videoPlay&devChannel="+devChannel,
        width: 750,
        height: 550,
        title: I18n.getValue('esdc_entrance_preview'),
        gridName: "gridbox"//设置grid
    };
    DhxCommon.createWindow(opts);
}
//详情视频回放
function detailVideoRtPlay(devChannel,eventTimes) {
    var opts = {
        path: "/skip.do?page=esdc_videoPlay_videoReplay&devChannel="+devChannel+"&eventTime="+eventTimes,
        width: 750,
        height: 550,
        title: I18n.getValue('esdc_entrance_playback'),
        gridName: "gridbox"//设置grid
    };
    DhxCommon.createWindow(opts);
}
/**
 * 浏览器判断
 */
function browserType() {
    var userAgent = window.navigator.userAgent
    if (userAgent.indexOf('Edge') > -1) {
        return 'Edge'
    }
    if (userAgent.indexOf('Firefox') > -1) {
        return 'Firefox'
    }
    if (userAgent.indexOf('Chrome') > -1) {
        return 'Chrome'
    }
    if (userAgent.indexOf('.NET') > -1) {
        return 'IE'
    }
}
//展示全景图（兼容ie，firefox）
function showPanoramaImg(obj){
    var height = 0;
    var width = 0;
    $(obj).get(0).onload;
    height = $(obj).height();
    width = $(obj).width();
    if(height > width){
        $(obj).css({'max-width':180 + 'px'});
    }else{
        $(obj).css({'width':96+ '%','height':88+ '%'});
    }
}



/**
 * webSocket接收设备传输数据
 */
//客户端id
function initEventPopUpAlarmSocket() {
    var clientId = Math.round(Math.random() * 10000) + "${uuid!}";
    var client = Web.getSocket({
        id: "popUpAlarmClient",
        url: "esdcTransactionEvent/popUpAlarm",
        keepActive:true,
        param: JSON.stringify({"clientId": clientId}),
        onMessage: function (resp){
            var sysCode = localStorage.getItem("sysCode");
            console.log("===PopUpAlarm Connect Success===")
            if(sysCode == "Esdc"){
                //当处于泛出入口模块时，才进行弹窗告警
                let res = JSON.parse(resp.body);
                let libNameContext = res.showLibName == null ? "" : "<p style='text-overflow:ellipsis; overflow: hidden; width: 150px; white-space:nowrap;'>"+ res.showLibName + "</p>";
                let name = res.name ==null ? I18n.getValue("esdc_common_unknown") : res.name;
                let content = "<div align='center' ondblclick=\"esdcTransactionDetails('" + res.id + "')\" >" +
                    "<img src='" + res.base64Picture + "'  onerror='this.src=\"/images/userImage.gif\"' style='height: 140px;max-width:180px; border: 1px solid #a4bed4;'/>" +
                    "<p style='width: 150px;'>" + name + "</p>" +
                    libNameContext+
                    "<p style='margin-top: 3px; text-overflow:ellipsis; overflow: hidden; width: 150px; white-space:nowrap;'>" + res.eventName + "</p>" +
                    "<p>" + new Date(res.eventTime).format("yyyy-MM-dd HH:mm:ss") + "</p>" +
                    "</div>";
                $.jBox.messager(content, I18n.getValue("common_devMonitor_msgTip"), 0, {
                    width: 200,
                    height: 265,
                    showType: 'fade',
                    timeout: 5000
                });
            }
        },
    });
    return client;
}

setTimeout(function (){
    initEventPopUpAlarmSocket();
},5000)

//添加警戒线,imgUrl为图片base64，lineCoordinate为划线坐标，callback为回调函数，保证代码同步
function addLineCoordinate(imageUrl,lineCoordinate,callback){
    let panoramaImgBase64 = "";
    let objCoordinate = lineCoordinate;
    if(objCoordinate == null && objCoordinate == "" || objCoordinate == undefined){
        callback(imageUrl);
    }
    let coordinateArrs = objCoordinate.split("_")
    let img = new Image();
    img.onload = function (){
        let myCanvas = document.getElementById("myCanvas");
        myCanvas.width = img.width;
        myCanvas.height = img.height;
        let ctx = myCanvas.getContext("2d");
        ctx.strokeStyle = "red";
        ctx.lineWidth = "5";
        ctx.drawImage(img, 0, 0, img.width, img.height);
        ctx.beginPath();
        for (let i = 0; i < coordinateArrs.length; i++) {
            let coordinateArr = coordinateArrs[i].split(",")
            //线的起点
            ctx.moveTo(coordinateArr[0] * (img.width / 352), coordinateArr[1] * (img.height / 288));
            //线的终点
            ctx.lineTo(coordinateArr[2] * (img.width / 352), coordinateArr[3] * (img.height / 288));
            ctx.stroke();
        }
        //将画板内容输出为base64
        panoramaImgBase64 = myCanvas.toDataURL("image/jpeg", 0.9)
        callback(panoramaImgBase64);
    }
    img.src = imageUrl;
}

//添加警戒框，imgUrl为图片base64，boxCoordinate为划框坐标，callback为回调函数，保证代码同步
function addBoxCoordinate(imgUrl,boxCoordinate,callback){
    var panoramaImgBase64 = "";
    var objCoordinate = boxCoordinate;
    if(objCoordinate == null && objCoordinate == "" || objCoordinate == undefined){
        callback(imgUrl);
    }
    var coordinateArrs = objCoordinate.split("_")
    var img = new Image();
    img.onload = function () {
        var myCanvas = document.getElementById("myCanvas");
        myCanvas.width = img.width;
        myCanvas.height = img.height;
        var ctx = myCanvas.getContext("2d");
        ctx.strokeStyle = "red";
        ctx.lineWidth="5";
        ctx.drawImage(img, 0, 0, img.width, img.height);
        ctx.beginPath();
        for (let i = 0; i < coordinateArrs.length; i++) {
            let coordinateArr = coordinateArrs[i].split(",");
            //线的起点
            ctx.moveTo(coordinateArr[0] * (img.width/352) , coordinateArr[1] * (img.height/288));
            //线的终点
            if (i < coordinateArrs.length - 1){
                let nextCoordinateArr = coordinateArrs[i+1].split(",");
                ctx.lineTo(nextCoordinateArr[0] * (img.width/352), nextCoordinateArr[1] * (img.height/288));
            }else{
                let startCoordinateArr = coordinateArrs[0].split(",");
                ctx.lineTo(startCoordinateArr[0] * (img.width/352), startCoordinateArr[1] * (img.height/288));
            }
            ctx.stroke();
        }
        //将画板内容输出为base64，再填回页面中
        panoramaImgBase64 = myCanvas.toDataURL("image/jpeg",0.9);
        //将结果放入回调函数参数中，保证代码同步
        callback(panoramaImgBase64);
    }
    img.src = imgUrl;
}

//跳转到脱岗报表详情页面
function jumpToLeavePostReport(reportId,jumpSign) {
    $.ajax({
        type: "get",
        dataType: "html",
        contentType: "application/json; charset=utf-8",
        async: false,
        url: "esdcLeavePostReport.do?report",
        data: {
            leavePostReportId:reportId,
            jumpSign:jumpSign
        },
        success: function (data) {
            $(".lpBigDivClass").html(data);
        }
    });
}

/** 非空判断 */
function isNuLL(params) {
    return params == null || typeof params == "undefined" || params === "";
}

//验证当前区域id或区域名匹配权限区域
function esdcCheckAuthArea(nowArea, filerArea) {
    if(filerArea != "" && filerArea.indexOf(nowArea) <0) {
        return false;
    }
    return true;
}