//人员查找时间定义格式
$('.J-datepicker-time').datePicker({
    format: 'HH:mm:ss',
    min: '04:23:11'
});
$('.J-datepicker-time-range').datePicker({
    format: 'HH:mm:ss',
    isRange: true,
    min: '04:23:11',
    max: '20:59:59'
});

var DATAPICKERAPI = {
    activeMonthRange: function () {
        return {
            begin: moment().set({ 'date': 1, 'hour': 0, 'minute': 0, 'second': 0 }).format('YYYY-MM-DD HH:mm:ss'),
            end: moment().set({ 'hour': 23, 'minute': 59, 'second': 59 }).format('YYYY-MM-DD HH:mm:ss')
        }
    },
    shortcutMonth: function () {
        var nowDay = moment().get('date');
        var prevMonthFirstDay = moment().subtract(1, 'months').set({ 'date': 1 });
        var prevMonthDay = moment().diff(prevMonthFirstDay, 'days');
        return {
            now: '-' + nowDay + ',0',
            prev: '-' + prevMonthDay + ',-' + nowDay
        }
    },
    shortcutPrevHours: function (hour) {
        var nowDay = moment().get('date');
        var prevHours = moment().subtract(hour, 'hours');
        var prevDate = prevHours.get('date') - nowDay;
        var nowTime = moment().format('HH:mm:ss');
        var prevTime = prevHours.format('HH:mm:ss');
        return {
            day: prevDate + ',0',
            time: prevTime + ',' + nowTime,
            name: 'Nearly ' + hour + ' Hours'
        }
    },
    rangeMonthShortcutOption1: function () {
        var result = DATAPICKERAPI.shortcutMonth();
        var resultTime = DATAPICKERAPI.shortcutPrevHours(18);
        return [{
            name: 'Today',
            day: '0',
            time: '00:00:00,23:59:59'
        },{
            name: 'This Month',
            day: result.now,
            time: '00:00:00,'
        }, {
            name: 'Lasy Month',
            day: result.prev,
            time: '00:00:00,23:59:59'
        }, {
            name: resultTime.name,
            day: resultTime.day,
            time: resultTime.time
        }];
    },
    rangeShortcutOption1: [{
        name: 'Last week',
        day: '-7,0'
    }, {
        name: 'Last Month',
        day: '-30,0'
    }],
    singleShortcutOptions1: [{
        name: 'Today',
        day: '0',
        time: '00:00:00'
    }, {
        name: 'Yesterday',
        day: '-1',
        time: '00:00:00'
    }, {
        name: 'One Week Ago',
        day: '-7'
    }]
};
$('.J-datepicker').datePicker({
    hasShortcut: true,
    min: '2018-01-01 04:00:00',
    max: '2029-10-29 20:59:59',
    shortcutOptions: [{
        name: 'Today',
        day: '0'
    }, {
        name: 'Yesterday',
        day: '-1',
        time: '00:00:00'
    }, {
        name: 'One Week Ago',
        day: '-7'
    }],
    hide: function () {
        console.info(this)
    }
});


$('.J-datepicker-day').datePicker({
    hasShortcut: true,
    shortcutOptions: [{
        name: 'Today',
        day: '0'
    }, {
        name: 'Yesterday',
        day: '-1'
    }, {
        name: 'One week ago',
        day: '-7'
    }]
});


$('.J-datepicker-range-day').datePicker({
    hasShortcut: true,
    format: 'YYYY-MM-DD',
    isRange: true,
    shortcutOptions: DATAPICKERAPI.rangeShortcutOption1
});


$('.J-datepickerTime-single').datePicker({
    format: 'YYYY-MM-DD HH:mm'
});


$('.J-datepickerTime-range').datePicker({
    format: 'YYYY-MM-DD HH:mm',
    isRange: true
});


$('.J-datepicker-range').datePicker({
    hasShortcut: true,
    min: '2018-01-01 06:00:00',
    max: '2029-04-29 20:59:59',
    isRange: true,
    shortcutOptions: [{
        name: 'Today',
        day: '0,0',
        time: '00:00:00,'
    },{
        name: 'Last Week',
        day: '-7,0',
        time: '00:00:00,'
    }, {
        name: 'Last Month',
        day: '-30,0',
        time: '00:00:00,'
    }],
    hide: function (type) {
        console.info(this.$input.eq(0).val(), this.$input.eq(1).val());
        console.info('Type:', type)
    }
});
$('.J-datepicker-range-betweenMonth').datePicker({
    isRange: true,
    between: 'month',
    hasShortcut: true,
    shortcutOptions: DATAPICKERAPI.rangeMonthShortcutOption1()
});


$('.J-datepicker-range-between30').datePicker({
    isRange: true,
    between: 30
});

$('.J-yearMonthPicker-single').datePicker({
    format: 'YYYY-MM',
    min: '2018-01',
    max: '2029-04',
    hide: function (type) {
        console.info(this.$input.eq(0).val());
    }
});

$('.J-yearPicker-single').datePicker({
    format: 'YYYY',
    min: '2018',
    max: '2029'
});

//用于图片触发效果
function clickChangeGreenImg(event, skin) {
    var obj = document.getElementById(event.id);
    switch (obj.id){
        case "psPhotoImg":
            obj.src = "/images/person_search_photo_green_1.png";
            break;
        case "psHistoryImg":
            obj.src = "/images/person_search_history_green.png";
            break;
        case "psLastPageImg":
            obj.src = "/images/person_search_last_page_green.png";
            break;
        case "psNextPageImg":
            obj.src = "/images/person_search_next_page_green.png";
            break;
        case "psSearchButton":
            if (skin == "techblue") {
                obj.style.backgroundColor = "#0091F9";
            }else {
                obj.style.backgroundColor = "#A0DB47";
            }
            break;
        case "psMoreCondition":
            obj.style.color = "#88ca3f";
            break;
        default:break;
    }
    // if (obj.id == "psPhotoImg"){
    //     obj.src = "/images/person_search_photo_green.png";
    // }
}
//复原效果
function clickChangeGrayImg(event, skin) {
    var obj = document.getElementById(event.id);
    switch (obj.id){
        case "psPhotoImg":
            obj.src = "/images/person_search_photo_1.png";
            break;
        case "psHistoryImg":
            obj.src = "/images/person_search_history.png";
            break;
        case "psLastPageImg":
            obj.src = "/images/person_search_last_page.png";
            break;
        case "psNextPageImg":
            obj.src = "/images/person_search_next_page.png";
            break;
        case "psSearchButton":
            if (skin == "techblue") {
                obj.style.backgroundColor = "#0091F9";
            }else {
                obj.style.backgroundColor = "#88ca3f";
            }
            break;
        case "psMoreCondition":
            obj.style.color = "black";
            break;
        default:break;
    }
}