/**
A jQuery plugin for search hints

Author: Lorenzo Cioni - https://github.com/lorecioni
*/

(function($) {
	$.fn.autocomplete = function(params) {
		
		//Selections
		var currentSelection = -1;
		var currentProposals = [];
		
		//Default parameters
		params = $.extend({
			pinByPin: [],
			showByPin: [],
			nameByPin: [],
			idCardByPin: [],
			pinByName: [],
			showByName: [],
			nameByName: [],
			idCardByName: [],
			width: 200,
			height: 16,
			onSubmit: function(text){},
			onBlur: function(){}
		}, params);

		//Build messagess
		this.each(function() {
			//Container
			var searchContainer = $('.autocomplete-container');
				
			//Text input		
			var input = $('#pin');

			//Proposals
			var proposals = $('<div></div>')
				.addClass('proposal-box')
				.css('width', "85%")
				.css('top', input.height()+2)
				.css('left', 7);
			var proposalList = $('<ul></ul>')
				.addClass('proposal-list');

			proposals.append(proposalList);
			
			input.keydown(function(e) {
				switch(e.which) {
					case 38: // Up arrow
					e.preventDefault();
					$('ul.proposal-list li').removeClass('selected');
					if((currentSelection - 1) >= 0){
						currentSelection--;
						$( "ul.proposal-list li:eq(" + currentSelection + ")" )
							.addClass('selected');
					} else {
						currentSelection = -1;
					}
					break;
					case 40: // Down arrow
					e.preventDefault();
					if((currentSelection + 1) < currentProposals.length){
						$('ul.proposal-list li').removeClass('selected');
						currentSelection++;
						$( "ul.proposal-list li:eq(" + currentSelection + ")" )
							.addClass('selected');
					}
					break;
					case 13: // Enter
						if(currentSelection > -1){
							var text = $( "ul.proposal-list li:eq(" + currentSelection + ")" ).text();
							if($('#searchSelectImg').val()!=""){
								$('#searchSelectImg').val("");
							}
							input.val(text);
						}
						if(currentSelection != -1){
							// submitPsSearch();
							currentSelection = -1;
							proposalList.empty();
							params.onSubmit(input.val());
						}
						// if(currentProposals.length == 0){
						// 	submitPsSearch();
						// 	currentSelection = -1;
						// 	params.onSubmit(input.val());
						// }
						break;
					case 27: // Esc button
						currentSelection = -1;
						proposalList.empty();
						input.val('');
						break;
				}
			});
				
			input.bind("input propertychange", function(){
				currentProposals = [];
				currentSelection = -1;
				proposalList.empty();
				if(input.val() != ''){
					var word = "^" + input.val() + ".*";
					proposalList.empty();
					for(var test in params.pinByPin){
						if(currentProposals.length < 5){
							if(params.pinByPin[test].match(word)){
								currentProposals.push(params.pinByPin[test]);
								var element = $("<li value=\""+params.pinByPin[test]+"\"></li>")
									.html(params.showByPin[test])
									.val(params.pinByPin[test])
									.addClass('proposal')
									.click(function(){
										if($('#searchSelectImg').val()!=""){
											$('#searchSelectImg').val("");
										}
										input.val(this.innerText);
										proposalList.empty();
										params.onSubmit(input.val());
										// submitPsSearch();
									})
									.mouseenter(function() {
										$(this).addClass('selected');
									})
									.mouseleave(function() {
										$(this).removeClass('selected');
									});
								proposalList.append(element);
							}else if(params.nameByName[test].toLowerCase().match(word.toLowerCase())){
								currentProposals.push(params.pinByName[test]);
								var element = $("<li value=\""+params.pinByName[test]+"\"></li>")
									.html(params.showByName[test])
									.val(params.pinByName[test])
									.addClass('proposal')
									.click(function(){
										if($('#searchSelectImg').val()!=""){
											$('#searchSelectImg').val("");
										}
										input.val(this.innerText);
										proposalList.empty();
										params.onSubmit(input.val());
										// submitPsSearch();
									})
									.mouseenter(function() {
										$(this).addClass('selected');
									})
									.mouseleave(function() {
										$(this).removeClass('selected');
									});
								proposalList.append(element);
							}

						}
					}
					// $('#psSearchButton').attr("disabled",true);
					// $('#psSearchButton').css("background-color","#9C9C9C");
					// if (currentProposals.length <= 0) {
					// 	$('#psSearchButton').attr("disabled",false);
					// 	$('#psSearchButton').css("background-color","#88CA3F");
					// }
				}else{
					// $('#psSearchButton').attr("disabled",false);
					// $('#psSearchButton').css("background-color","#88CA3F");
				}
			});
			
			input.blur(function(e){
				setTimeout(function () {
					currentSelection = -1;
					proposalList.empty();
					params.onBlur();
				},200);
			});

			input.focus(function(e){
				currentProposals = [];
				currentSelection = -1;
				proposalList.empty();
				if(input.val() != ''){
					var word = "^" + input.val() + ".*";
					proposalList.empty();
					for(var test in params.pinByPin){
						if(currentProposals.length < 5){
							if(params.pinByPin[test].match(word)){
								currentProposals.push(params.pinByPin[test]);
								var element = $("<li value=\""+params.pinByPin[test]+"\"></li>")
									.html(params.showByPin[test])
									.val(params.pinByPin[test])
									.addClass('proposal')
									.click(function(){
										if($('#searchSelectImg').val()!=""){
											$('#searchSelectImg').val("");
										}
										input.val(this.value);
										proposalList.empty();
										params.onSubmit(input.val());
										// submitPsSearch();
									})
									.mouseenter(function() {
										$(this).addClass('selected');
									})
									.mouseleave(function() {
										$(this).removeClass('selected');
									});
								proposalList.append(element);
							}else if(params.nameByName[test].toLowerCase().match(word.toLowerCase())){
								currentProposals.push(params.pinByName[test]);
								var element = $("<li value=\""+params.pinByName[test]+"\"></li>")
									.html(params.showByName[test])
									.val(params.pinByName[test])
									.addClass('proposal')
									.click(function(){
										if($('#searchSelectImg').val()!=""){
											$('#searchSelectImg').val("");
										}
										input.val(this.value);
										proposalList.empty();
										params.onSubmit(input.val());
										// submitPsSearch();
									})
									.mouseenter(function() {
										$(this).addClass('selected');
									})
									.mouseleave(function() {
										$(this).removeClass('selected');
									});
								proposalList.append(element);
							}


						}
					}
					// $('#psSearchButton').attr("disabled",true);
					// $('#psSearchButton').css("background-color","#9C9C9C");
					// if (currentProposals.length <= 0) {
					// 	$('#psSearchButton').attr("disabled",false);
					// 	$('#psSearchButton').css("background-color","#88CA3F");
					// }
				}else{
					// $('#psSearchButton').attr("disabled",false);
					// $('#psSearchButton').css("background-color","#88CA3F");
				}
			});
			
			searchContainer.append(proposals);		
			
		});

		return this;
	};

})(jQuery);