// 定义全局变量
/*是否包含下级*/
var posidGlobalIsIncludeLower;
/*当前部门树ID*/
var posidGlobalDeptTreeId;
/*当前gridName*/
var posidGlobalGridName;
/*是否显示包含下级选项*/
var posidGlobalShowIncludeLower;
/*当前点击的部门ID*/
var posidGlobalDeptTreeClickId;

/**初始化部门树的顶级按钮*/
function posidGlobalInitDeptTree(layout) {
    // 默认包含子部门
    posidGlobalIncludeLowerClick(true, false);

    var containsSubordinateText = I18n.getValue("common_tree_containsSubordinate");

    var html = "<span><div id='idPosidDeptIncludeLower' class='tree_header_box'>" +
        "<span onclick='posidGlobalImgClick(1)' class='plus_minus_img icv-head-plus'></span>" +
        "<span onclick='posidGlobalImgClick(0)' class='plus_minus_img icv-head-minus'></span>";
    if (posidGlobalShowIncludeLower) {
        html += "<span id='posidGlobalIncludeLowerCheckboxSpan'></span><span>" + containsSubordinateText + "</span></div></span>";
    }
    layout.cells("a").setText(html);

    loadUIToDiv("input", "#posidGlobalIncludeLowerCheckboxSpan", {
        id: "posidGlobalIncludeLowerCheckbox",
        useInputReq: true,
        type: "checkbox",
        value: true,
        eventCheck: true,
        onclick: "posidGlobalIncludeLowerChange()"
    })

    layout.attachEvent("onExpand", function (name) {
        resizeUI();
        $("#idPosidDeptIncludeLower").show();
    });

    layout.attachEvent("onCollapse", function (name) {
        resizeUI();
        $("#idPosidDeptIncludeLower").hide();
    });
}

/** 选中控制部门树是否包含下级 */
function posidGlobalIncludeLowerChange() {
    // 由loadUIToDiv的onclick的点击事件，选中为false，未选中为true
    posidGlobalIncludeLowerClick(!$("#posidGlobalIncludeLowerCheckbox").prop("checked"), true)
}

/**是否包含下级部门*/
function posidGlobalIncludeLowerClick(value, refresh) {
    posidGlobalIsIncludeLower = value;
    if(ZKUI.Tree.get(posidGlobalDeptTreeId)){
        var tree = ZKUI.Tree.get(posidGlobalDeptTreeId).tree;
        tree.enableThreeStateCheckboxes(value);
        if (refresh) {
            var selectDeptId = tree.getSelected();
            if (selectDeptId) {
                posidGlobalDeptTreeClick(selectDeptId);
            }
        }
    }
}

/**部门树的展开与合并*/
function posidGlobalImgClick(flag) {
    var tree = ZKUI.Tree.get(posidGlobalDeptTreeId).tree;
    if (flag == 1) {
        tree.openAllItems(0);
    } else {
        tree.closeAllItems(0);
    }
}

/*部门树点击事件刷新列表*/
function posidGlobalDeptTreeClick(id) {
    posidGlobalDeptTreeClickId = id;
    ZKUI.Grid.reloadGrid(posidGlobalGridName, function () {
    }, {deptId: id, isIncludeLower: posidGlobalIsIncludeLower});
}

/*刷新列表*/
function posidGlobalReloadGrid() {
    ZKUI.Grid.reloadGrid(posidGlobalGridName);
    //ZKUI.Grid.get(posidGlobalGridName).reload()
}

/*导出模版，提交表单*/
function posidGlobalImportTemplate() {
    $("#posidImportTemplateFrom").ajaxSubmit({
        async:false,
        success: function(result){
        }
    });
}