function moneyControl(id)
{
    $("#"+id).keyup(function(event)
    {
        var val = $(this).val();
        if(isNaN(val)||$.trim(val)!=val)
        {
            $(this).val(val.substring(0,val.length-1));
        }
        if(val.split(".").length==2)
        {
            if(val.split(".")[1].length>2)
            {
                $(this).val(val.substring(0,val.length-1));
            }
        }
    });
}

function searchMoneyControl(id)
{
    $("#"+id).keyup(function(event)
    {
    	money($(this));
    });
    $("#"+id).keypress(function(event)
    {
    	money($(this));
    });
    $("#"+id).blur(function(event) {
    	money($(this));
    });
}

function money(obj) {
	var val = obj.val();
    if(isNaN(val)||$.trim(val)!=val)
    {
    	obj.val('');
    }
    if(val.split(".").length==2)
    {
        if(val.split(".")[1].length>2)
        {
        	obj.val(val.substring(0,val.length-1));
        }
    }
    if(val.length>10)
    {
    	obj.val(val.substring(0,val.length-1));
    }
} 

function intControl(obj) {
	var val = obj.val();
    if(isNaN(val)||$.trim(val)!=val)
    {
    	obj.val('');
    }
    if(val.length>8)
    {
    	obj.val(val.substring(0,val.length-1));
    }
}

function searchIntControl(id)
{
    $("#"+id).keyup(function(event)
    {
        var c=$(this);
        if(/[^\d]/.test(c.val())){//替换非数字字符
            var temp_amount=c.val().replace(/[^\d]/g,'');
            $(this).val(temp_amount);
        }
    });
}

function overPwdControl(id)
{
    $("#"+id).keyup(function(){
        var val = $(this).val();
        var checkStr = /^\d*$/;
        if(!checkStr.test(val))
        {
            $(this).val(val.substring(0,val.length-1));
        }
    });
}

jQuery.validator.addMethod("posValidCode", function(value, element)
{
    var pattenChar = /^[1-9]\d*$/;
    return this.optional(element) || (pattenChar.test(value));
}, function()
{
    return I18n.getValue("posid_common_letterNumber");
});

jQuery.validator.addMethod("validMoney", function(value, element){
    var pattenChar = /(^[1-9]([0-9]+)?(\.[0-9]{1,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;
    return this.optional(element) || (pattenChar.test(value));
}, function(){
    return I18n.getValue("posid_alert_money");
});

jQuery.validator.addMethod("checkMoney", function (value, element) {
    inputZ = value;
    var ArrMen = inputZ.split(".");
    if (ArrMen.length == 2) {
        if (ArrMen[1].length > 2) {
            return false;
        }
    }
    var vzNum = parseFloat(inputZ).toFixed(2);
    if (isNaN(vzNum)) {
        return false;
    }
    var ele = parseFloat('999.99');
    if (ele < parseFloat(vzNum)) {
        return false;
    }
    return true;
},function(){
	return I18n.getValue("posid_unit_moneyCheck");
});

jQuery.validator.addMethod("validMaxMoney", function(value, element){
	//配合固件的最大余额验证，统一修改为99999.00  mod by lizhongwei
	return this.optional(element) || value > 99999 ? false:true;
}, function(){
	return I18n.getValue("posid_alert_maxMoney");
});

jQuery.validator.addMethod("validMaxMoney100", function(value, element){
    // 折扣金额 最大100
    return this.optional(element) || value > 100 ? false:true;
}, function(){
    return I18n.getValue("posid_alert_maxMoney100");
});

jQuery.validator.addMethod("validEqualsMoney", function(value){
    var compteSolde = $("#id_cardUnit").val();
    var flag = false;
    if(compteSolde==value)
    {
        flag = true;
    }
    return  flag;
},function(){
    return I18n.getValue("posid_alert_differentMoney");
});

/**
 * 离线时长约束
 */
jQuery.validator.addMethod("posDevValitTimeOfflineConsumeDuration", function(value, element){
    return this.optional(element) || value > 1440 ? false:true;
}, function(){
    return I18n.getValue("posid_offline_consume_duration_validate").format("1440");
});


jQuery.validator.addMethod("posidMoneyMaxMinCheck", function(value, element)
{
    var returnVal = true;
    inputZ = value;
    var ArrMen = inputZ.split(".");
    if (ArrMen.length == 2)
    {
        if (ArrMen[1].length > 2)
        {
            returnVal = false;
            return false;
        }
    }
    var vzNum = parseFloat(inputZ).toFixed(2);
    if (isNaN(vzNum))
    {
        returnVal = false;
        return false;
    }
    var ele = parseFloat('999.99');
    if (ele < parseFloat(vzNum)||parseFloat(vzNum)<=0)
    {
        returnVal = false;
        return false;
    }
    return returnVal;
}, function(){
    return I18n.getValue("posid_stortDetail_zeroError");
});