# 视频插件

## websocket-html通讯时序
```sequence
H5->Server: 连接WS
Server->H5: 返回UUID（SetForm）
H5->Server: 初始化token（InitProgram）
H5->Server: 启动Client，将UUID传过去（StartProgram）
Server->Client: 启动Client
Client->Server: 连接WS
Server->Client: 返回UUID
Client->Server: 发送给H5，将UUID传过去
Server->H5: 收到Client的UUID（SetAddressee）
H5-->Client: 进行通讯
Client-->H5:
H5->Server: 断开WS/发送退出程序(CloseProgram)
Server->Client: 关闭程序
```
## web端启动加载时序
```sequence
浏览器刷新-->连接websocket
初始化全局空插件备用-->携带参数调用初始化插件方法加载插件
调用startPlayVideo唤起插件-->进行视频预览及回放等
```
## 如何在html页面内使用
```sequence
/**
  * 返回值sign为该插件初始化完成的唯一标识，
  * 在操作需要调用qt接口的方法时，都需要携带该标识，
  * 标识=init时传入的第一个参数+随机数，随机数由插件自动生成.
  * 若初始化失败。不会返回sing，返回值为空串。
  */
var sign = ZKQTPlay.init("ivsPreview", "ivsPreview.do", "qtPlayId", "1338", "690", false);
if (sign != '') {
    /** 携带init返回的标识，开启预览插件 */
    ZKQTPlay.startPlayVideo(sign);
}
```
## API方法支持
###插件初始化--ZKQTPlay.init("ivsPreview", "ivsPreview.do", "qtPlayId","${systemLanguage!}");
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | ivsPreview | 插件唯一标识，任意唯一字符串皆可。此唯一为整个web项目唯一、非当前页面唯一。推荐：模块名+业务名|
|param | ivsPreview.do | 当前页面的三级菜单跳转路径|
|param | qtPlayId | 作为该插件占位的div标识|
|param | ${systemLanguage!} | 语言
###是否已初始化--ZKQTPlay.isInit(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | ivsPreview | init初始化方法的入参标识ivsPreview|
###启动预览插件弹出--ZKQTPlay.startPlayVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###显示弹出框--ZKQTPlay.showProgram(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###隐藏弹出框--ZKQTPlay.hideProgram(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###停止插件--ZKQTPlay.stopPlayVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###启动回放插件弹出--ZKQTPlay.startReplayVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###启动单窗口回放插件弹出--ZKQTPlay.startSingleReplayVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###4分屏不带设备树的播放插件--ZKQTPlay.startMultiVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###窗口移动(自适应div占位大小及位置)--ZKQTPlay.moveProgram(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###启动单预览插件弹出--ZKQTPlay.startSingleVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###单预览窗口播放--ZKQTPlay.playVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###多预览窗口播放插件--ZKQTPlay.playMultiVideo(sign, rtspUrl, mainType, winIdIndex)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
|param | rtspUrl | 流地址|
|param | mainType | 主设备类型[主设备类型:1800 = 0,NVR = 2，ZKNVR = 7] |
|param | winIdIndex | 窗口索引|
###单回放播放窗口插件--ZKQTPlay.playReplayVideo(sign, rtspUrl, mainType, startTime, endTime, userName, passWord)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
|param | rtspUrl | 流地址|
|param | mainType | 主设备类型[主设备类型:1800 = 0,NVR = 2，ZKNVR = 7] |
|param | startTime | 开始时间|
|param | endTime | 结束时间|
|param | userName | 用户名|
|param | passWord | 密码|
###启动视频划线插件--ZKQTPlay.startIntelligentVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###隐藏启动视频划线插件--ZKQTPlay.startHideIntelligentVideo(sign)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
###添加视频画线--ZKQTPlay.putVideoDash(sign, watchAreaList)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
|param | watchAreaList | 划线数据集合|
###区域启停或者删除--ZKQTPlay.editAreaInfo(sign, editType, index, enableStatus, direction)
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | init初始化方法的返回值|
|param | editType | [deleteArea:删除区域  enableArea:区域启停 getAreaInfo:获取区域信息 arrowDirection:设置划线方向] |  
|param | index | 监视区域id |
|param | enableStatus | [0:停用 1:启用] |  
|param | direction | [方向 0：双向 1:右方向 2:左方向] |  

##注意事项
```sequence
视频插件是通过websocket与平台通信，发送命令，回调响应。当我们发起开启插件的指令，
插件会被启动，且覆盖在浏览器的指定位置。当切换浏览器tab，切换平台左侧菜单时，该插
件依旧会附着于指定位置。严重遮挡浏览器内容。所以，我们监听了浏览器tab的切换事件，
在切换时发起插件的隐藏命令。切回时发起插件的显示命令。且由于是覆盖插件，平台的弹窗
也都会被遮盖，在使用弹窗类功能时，要先把插件隐藏。特殊业务场景请提出，我们会进行修
复或给予使用建议。
```