(function() {
	function SystemTray() { }

    /**
     * 打开菜单
     **/
	SystemTray.openMenu = function(url, container, callback) {
	    container = container || ".side-right";
	    url = url || SystemTray.currentMenu;
	    SystemTray.currentMenu = url;
	    $.ajax({
	        url:url,
	        type:"get",
	        dataType:"html",
	        success: function(res) {
                if(callback && callback(res)) {
                    return
                }
                $(container).html(res);
            },
            error:function(err) {
                if(callback && callback(err)) {
                    return
                }
                $(container).html(err.responseText);
            }
	    })
	}

    /**
     * 菜单点击事件
     **/
	SystemTray.menuClick = function(obj, url) {
	    $(".side-left-menu-item-active").removeClass("side-left-menu-item-active");
	    SystemTray.openMenu(url, "", function() {
	        $(obj).addClass("side-left-menu-item-active");
	    })
	}

    /**
     * 创建dom对象
     **/
	function createElement(tag, opts) {
	    var ele = document.createElement(tag);
	    if(opts.className) {
	        ele.className = opts.className;
	    }
	    if(opts.id) {
            ele.id = opts.id;
        }
        if(opts.name) {
            ele.name = opts.name;
        }
        if(opts.text) {
            ele.textContent = opts.text;
        }
	    if(opts.children) {
            ele.appendChild(opts.children);
        }
	    return ele;
	}

    /**
     * 关闭窗口
     **/
    SystemTray.closeWindow = function() {
        $(".tray-win-active").animate({
            top:"-800px",
            opacity:0
        },
        400, "",
        function() {
            $(".tray-win-active").remove();
            $(".tray-win-box").last().addClass("tray-win-active");
            $(".tray-win-cover").last().remove();
        });

    }

    /**
     * 创建窗口
     **/
	SystemTray.createWindow = function(opts) {
	    var defOpts = {
	        title:"common_add",
	        width:400,
	        height:320
	    }
	    opts = $.extend(defOpts, opts);
	    opts.title = i18n(opts.title);
	    $(".tray-win-active").removeClass("tray-win-active");
	    var win = createElement("div", {className:"tray-win-box tray-win-active"});
	    var title = createElement("div", {className:"tray-win-title"});
	    title.appendChild(createElement("label", {text:opts.title}));
	    title.appendChild(createElement("span", {className:"tray-icon-cross"}));
	    win.appendChild(title);
        win.appendChild(createElement("div", {className:"tray-win-cont"}));
        document.body.appendChild(createElement("div", {className:"tray-win-cover"}));
        document.body.appendChild(win);
        win.style.width = opts.width + "px";
        win.style.height = opts.height + "px";
        win.style.left = (document.body.clientWidth - opts.width)/2 + "px";
        win.style.top = (document.body.clientHeight - opts.height)/2 + "px";
        $.ajax({
            url:opts.url,
            type:"get",
            dataType:"html",
            success: function(res) {
                $(win).find(".tray-win-cont").append(res);
            },
            error:function(err) {
                openMessage(msgType.error, "common_open_error");
            }
        })
        $(title).find(".tray-icon-cross").on("click", SystemTray.closeWindow);

	}

    /**
     * 主页初始化
     **/
	SystemTray.init = function() {
	    $(".side-left-menu-item:eq(0)").click();
	}

    /**
     * 登录页初始化
     **/
	SystemTray.initLoginPage = function(formId) {
        $(formId).ajaxForm({
            success:function(res) {
                if(typeof(res) === "string") {
                    res = JSON.parse(res);
                }
                if(res.ret === "ok") {
                    localStorage.setItem("token", res.data.token);
                    window.location.href = "/home?token=" + res.data.token;
                } else {
                    openMessage(msgType.error, res.msg || "common_usrOrPwd");
                }
            }, error: function() {
                openMessage(msgType.error, "common_usrOrPwd");
            }
        })
        $("#copyright").text("Copyright © "+(new Date()).getFullYear()+" ZKTECO CO., LTD. All rights reserved.");
        $(document.body).on("keyup", function(e) {
            if(e.keyCode == 13) {
                SystemTray.login(formId);
            }
        })
    }

    // 提交状态
    var submitStatus = "";

    /**
     * 验证提交状态，防止重复提交
     **/
    function checkSubmitStatus() {
        if(submitStatus === "pending") {
            return false;
        }
        submitStatus = "pending";
        setTimeout(function() {
            submitStatus = "";
        }, 1000);
        return true;
    }

    /**
     * 执行登录
     **/
    SystemTray.login = function(obj) {
        if(!checkSubmitStatus()) {
            return;
        }
        openMessage(msgType.loading);
        $(obj).submit();
    }

    /**
     * 执行退出登录
     **/
    SystemTray.logout = function(obj) {
        openMessage(msgType.loading);
        $.ajax({
            url:"/logoutUser",
            type:"post",
            dataType:"json",
            success: function(res) {
                if(res.ret === "ok") {
                   localStorage.removeItem("token");
                   window.location.href="/";
                } else {
                   openMessage(msgType.error, "common_con_failed");
                }
            }
        });
    }

    /*********** 数据库配置 ****************/

    /**
     * 测试数据库连接
     **/
    SystemTray.testConnect = function(obj, okBtn) {
        openMessage(msgType.loading);
        var data = parseQuery($(obj).serialize());
        $.ajax({
            url:"/databaseSetting.do?testConnect",
            type:"post",
            data:data,
            dataType:"json",
            success: function(res) {
                if(res.ret === "ok") {
                   openMessage(msgType.success, "common_con_succeed");
                   $(okBtn).removeAttr("disabled");
                } else {
                   openMessage(msgType.error, "common_con_failed");
                }
            }
        });
    }

    /**
     * 改变数据库类型
     **/
    SystemTray.changeType = function(obj) {
        if(obj.value === "postgre") {
            $("input[name='dbPort']").val("5442");
        } else if(obj.value === "oracle") {
             $("input[name='dbPort']").val("1521");
        }else if(obj.value === "mssql") {
            $("input[name='dbPort']").val("1433");
        }
    }

    /**
     * 重启服务
     **/
    SystemTray.rebootService = function() {
        openMessage(msgType.loading);
        $.ajax({
            url:"/databaseSetting.do?reboot",
            type:"post",
            dataType:"json",
            success: function(res) {
                if(res.ret === "ok") {
                   openMessage(msgType.success, "common_con_succeed");
                } else {
                   openMessage(msgType.error, "common_con_failed");
                }
            }
        });
    }

    /**
     * 提交数据库配置
     **/
    SystemTray.submitDB = function(obj) {
        SystemTray.submitForm(obj);
    }

    /**
     * 提交表单
     **/
    SystemTray.submitForm = function(obj) {
        if(!checkSubmitStatus()) {
            return;
        }
        openMessage(msgType.loading);
        $(obj).submit();
    }

    /**
     * 初始化数据同步
     **/
    SystemTray.initSync = function() {
        $(".radar").show();
        $.ajax({
            url:"/trayDbSync.do?list",
            type:"post",
            dataType:"json",
            success: function(res) {
                if(res.ret === "ok") {
                    res.data.forEach(function(item, index) {
                        setTimeout(function() {
                            addServerItem(item);
                        }, (index+1)* 500);
                    })
                    setTimeout(function() {
                        $(".radar").hide();
                        SystemTray.monitorServer();
                    }, res.data.length * 500 + 3000);
                }
            }
        });
    }

    var servers = {};
    var serverHostMap = {};

    /**
     * 添加同步服务器到页面
     **/
    function addServerItem(item) {
        var div = createElement("div", {className:"sync-item", id:"server" + item.id});
        var icon = createElement("span", {className:"sync-icon tray-icon-laptop"});
        var label = createElement("label", {className:"sync-item-txt", text:item.name});
        var delIcon = createElement("span", {className:"sync-icon-del tray-icon-cross"});
        var statusIcon = createElement("span", {className:"sync-status-icon tray-icon-clock"});
        servers[item.id] = item;
        serverHostMap[item.host] = item.id;
        delIcon.onclick = function() {
            msgBox("confirm", "common_confirm_del", function(ret) {
                if(ret === "ok") {
                    SystemTray.delServer(item.id);
                }
            })
        }
        div.title = i18n("sync_dbclick");
        div.appendChild(delIcon);
        div.appendChild(icon);
        div.appendChild(label);
        div.appendChild(statusIcon);
        $(".sync-left").prepend(div);
        attachDrag(div, $(".sync-left")[0]);
        div.style.opacity = 1;
        div.ondblclick = function() {
            SystemTray.createWindow({url:"/trayDbSync.do?edit&id=" + item.id,title:"common_edit"})
        }
        SystemTray.checkServer(item.id);
    }

    /**
     * 打开编辑服务器页面
     **/
    SystemTray.editServer = function(local) {
        var title = local ? "sync_server_local" : "common_add";
        SystemTray.createWindow({url:"/trayDbSync.do?edit" + (local?"&local=true":""),title:title});
    }

    /**
     * 打开数据同步配置
     **/
    SystemTray.syncSetting = function() {
        SystemTray.createWindow({url:"/trayDbSync.do?settings",title:"sync_settings"});
    }

    /**
     * 检测数据同步
     **/
    SystemTray.checkSync = function() {
        openMessage(msgType.loading);
        $.ajax({
           url:"/trayDbSync.do?checkSync",
           type:"post",
           dataType:"json",
           success: function(res) {
              openMessage(msgType.success);
           },
           error:function() {
              openMessage(msgType.error);
           }
        })
    }

    /**
     * 检测同步服务器网络状态
     **/
    SystemTray.checkServer = function(id) {
        $.ajax({
           url:"/trayDbSync.do?testConnect",
           type:"post",
           dataType:"json",
           data:{
                id:id
           },
           success: function(res) {
              if(res.ret !== "ok") {
                    $("#server" +id).addClass("sync-item-offline");
              } else {
                    changeStatus("wait", id);
              }
           },
           error:function() {
              openMessage(msgType.error);
           }
        })
    }

    //定时器
    var serverTimer;
    var serverClient;

    /**
     * 监控同步服务器状态
     **/
    SystemTray.monitorServer = function() {
        if(serverClient && serverClient.connected) {
            serverClient.disconnect();
        }
        var opts = {
            id:"monitorServer",
            url:"traySync/getSyncStatus",
            onMessage:function(res) {
                if(res.body) {
                    var resp = res.body.split("::");
                    if(resp[1] === "all") {
                        changeStatus("wait", "all");
                        return;
                    }
                    var id = servers[resp[1]] ? resp[1] : serverHostMap[resp[1]];
                    if(id && servers[id]) {
                        if($("#server" + id).hasClass("sync-item-offline")) {
                            return;
                        }
                        if(resp[0] === "Send" || resp[0] === "Check" || resp[0] === "Resolver" || resp[0] === "Receive") {
                            changeStatus("syncing", id);
                        } else {
                            changeStatus(servers[id].status, id);
                        }
                    }
                }
            }
        }
        serverClient = createSocket(opts);
    }

    function refreshArrow() {
        var obj = $(".sync-item[state='syncing']");
        if(obj.length > 0) {
            var loc = $(".sync-item-local");
            var p1 = loc.position();
            var p2 = obj.position();
            p1.left = p1.left + loc[0].clientWidth/2;
            p1.top = p1.top + loc[0].clientHeight/2;
            p2.left = p2.left + obj[0].clientWidth/2;
            p2.top = p2.top + obj[0].clientHeight/2;
            $(".sync-icon-arrow").css("offset-path", "path(\"M" + p1.left+","+p1.top+" L"+p2.left+","+p2.top+"\")");
            //$(".sync-icon-arrow").show();
        } else {
             $(".sync-icon-arrow").hide();
        }
    }

    SystemTray.afterSyncEnd = function() {
        var obj = $(".sync-item[state='syncing']");
        if(obj.length > 0) {
             obj.addClass("sync-item-in");
             obj[0].onanimationend=function() {
                obj.removeClass("sync-item-in");
             }
        }
    }

    /**
     * 改变服务器状态
     **/
    function changeStatus(status, id) {
        if(id === "all") {
            $("div[id^=server].sync-item").each(function(item) {
                var _id = this.id.substring("server".length);
                if(servers[_id] && servers[_id].status==="stop") {
                    return;
                }
                $(this).attr("state", status);
                $(this).find(".sync-status-icon").remove();
                $(this).append("<span title=\"" + i18n("sync_click_pause") + "\" onclick=\"SystemTray.stopServer('"+_id+"', 'stop')\" class='sync-status-icon tray-icon-clock'></span>");
            })
            return;
        }
        $("#server" + id).attr("state", status);
        if(status=="stop") {
            $("#server" + id).find(".sync-status-icon").remove();
            $("#server" + id).append("<span title=\"" + i18n("sync_click_wait") + "\" onclick=\"SystemTray.stopServer('"+id+"', 'wait')\" class='sync-status-icon tray-icon-pause2'></span>");
        } else if(status=="syncing") {
            if(!$("#server" + id).find(".sync-status-icon").hasClass("tray-icon-spinner9")) {
                $("#server" + id).find(".sync-status-icon").remove();
                $("#server" + id).append("<span class='sync-status-icon tray-icon-spinner9'></span>");
            }
        } else {
            $("#server" + id).find(".sync-status-icon").remove();
            $("#server" + id).append("<span title=\"" + i18n("sync_click_pause") + "\" onclick=\"SystemTray.stopServer('"+id+"', 'stop')\" class='sync-status-icon tray-icon-clock'></span>");
        }
        refreshArrow();
    }

    /**
     * 停止服务器同步
     **/
    SystemTray.stopServer=function(id, status) {
        openMessage(msgType.loading);
        id = id.startsWith("server") ? id.substring("server".length) : id;
        $.ajax({
            url:"/trayDbSync.do?stop",
            type:"post",
            dataType:"json",
            data:{
                id:id
            },
            success: function(res) {
                if(res.ret === "ok") {
                    changeStatus(status, id);
                    servers[id].status = status === "stop" ? "stop" :"wait";
                    openMessage(msgType.success);
                } else {
                    openMessage(msgType.error);
                }
            }
        });
    }

    /**
     * 删除服务器
     **/
    SystemTray.delServer = function(id) {
        id = id.startsWith("server") ? id : "server" + id;
        var serverId = id.substring("server".length);
        openMessage(msgType.loading);
        $.ajax({
           url:"/trayDbSync.do?del",
           type:"post",
           dataType:"json",
           data:{
             ids : serverId
           },
          success: function(res) {
              if(res.ret === "ok") {
                $("#" + id).remove();
                serverHostMap[servers[serverId].host] = null;
                servers[serverId] = null;
              }
              closeMessage();
          }, error:function() {
               closeMessage();
          }
        })
    }

    /**
     * 添加拖曳
     **/
    function attachDrag(obj, cont) {
        var o = $(obj)[0];
        cont = cont ? $(cont)[0] : document;
        o.style.left = Math.ceil(Math.random()*(cont.clientWidth - o.clientWidth))+ "px";
        o.style.top = Math.ceil(Math.random()*(cont.clientHeight - o.clientHeight)) + "px";
        //鼠标按下
        o.onmousedown = function (e) {
            if (o.setCapture) {   //IE低版本
                o.setCapture()
            }
            e = e || window.event;
            //鼠标相对于盒子的位置
            var offsetX = e.clientX - o.offsetLeft;
            var offsetY = e.clientY - o.offsetTop;
            //鼠标移动
            cont.onmousemove = function (e) {
                e = e || window.event;
                var l = Math.min(cont.clientWidth - o.clientWidth, Math.max(0, e.clientX - offsetX));
                var t = Math.min(cont.clientHeight - o.clientHeight, Math.max(0, e.clientY - offsetY));
                o.style.left = l + "px";
                o.style.top = t + "px";
                refreshArrow();
            }
            //鼠标抬起
            cont.onmouseup = function () {

                cont.onmousemove = null;
                cont.onmouseup = null;
                if (o.releaseCapture) {
                    o.releaseCapture();//释放全局捕获
                }
            }
            return false;//标准浏览器的默认行为
        }
    }

    /**
     * 选择文件
     **/
    SystemTray.chooseFile = function(id) {
        $(id).click();
    }

    /**
     * 初始化软件更新页面
     **/
    SystemTray.initUpdatePage = function(formId) {
        $(formId).ajaxForm({
            success:function(res) {
                if(typeof(res) === "string") {
                    res = JSON.parse(res);
                }
                $("#softUpdateBtn").attr("disabled",false);
                openMessage(msgType.success, "upgrade_success");
                SystemTray.openMenu();
            }, error: function() {
                openMessage(msgType.error,"upgrade_failed");
                $("#softUpdateBtn").attr("disabled",false);
            }
        })
        $(".update-file").on("change", function(e) {
            var files = e.currentTarget.files;
            if(files && files.length > 0) {
                var txt = [];
                for(var i=0; i < files.length; i++) {
                    txt.push(files[i].name);
                }
                $(e.currentTarget).siblings(".update-file-txt").html(txt.join("<br/>"));
            }
        })
        $(".update-table-icon").css("display", "none");
        $(".update-table-icon").last().css("display", "");

    }

    /**
     * 提交软件更新
     **/
    SystemTray.submitUpdate = function(formId) {
        if(!checkSubmitStatus()) {
            return;
        }
        //表单验证
        var inp = $("#" + formId + " input[name='jars']");
        if(inp[0].files.length == 0) {
            openMessage(msgType.error, "upgrade_tip");
            return;
        }
        $("#softUpdateBtn").attr("disabled",true);
        openMessage(msgType.loading);
        $("#" + formId).submit();
    }

    /**
     * 软件更新回滚
     **/
    SystemTray.rollback = function(obj, id) {
        msgBox("", i18n("upgrade_isRoll") + id, function(ret) {
            if(ret === "ok") {
                verifyLoginPwd(function() {
                    openMessage(msgType.loading);
                    $.ajax({
                        url:"/traySoftUpgrade.do?rollback",
                        type:"post",
                        dataType:"json",
                        data: {
                            id: id
                        },
                        success: function(res) {
                            if(res.ret === "ok") {
                               openMessage(msgType.success, "common_op_succeed");
                               SystemTray.openMenu();
                            } else {
                               openMessage(msgType.error, "common_op_failed");
                            }
                        }
                    });
                })
            }
        })
    }
	window.SystemTray = SystemTray;
})()

