var msgType = {
	info : "info",
	success : "success",
	warning : "warning",
	error : "error",
	loading : "loading"
};

var SingleCodeArray = new Array();//单字节字符列表
SingleCodeArray.push([ 0x0001, 0x007e ]);// [1, 126]
SingleCodeArray.push([ 0x0080, 0x02af ]);// [128, 687]
SingleCodeArray.push([ 0x0400, 0x052f ]);// [1024, 1327]
SingleCodeArray.push([ 0x0600, 0x06ff ]);// [1536, 1791]
SingleCodeArray.push([ 0x0e00, 0x0e7f ]);// [3584, 3711]
SingleCodeArray.push([ 0x1e00, 0x1eff ]);// [7680, 7935]
SingleCodeArray.push([ 0xff60, 0xff9f ]);// [65376, 65439]

/**
 * 是否单字节字符
 * @author: train.chen
 * @date: 2020年2月26日 下午5:45:49
 */
function isSingleCode(c) {
	for (var i = 0; i < SingleCodeArray.length; i++) {
		if (c >= SingleCodeArray[i][0] && c <= SingleCodeArray[i][1]) {
			return true;
		}
	}
	return false;
}

/**
 * @Description: 计算字符串长度(可同时字母和汉字，字母占一个字符，汉字占2个字符)
 * @Author: ob.huang 黄玲彬
 * @Modified By:
 * @Date: 2013-09-24
 * @param:
 */
function strlen(str) {
	var len = 0;
	if (str != null) {
		for (var i = 0; i < str.length; i++) {
			var c = str.charCodeAt(i);
			if (isSingleCode(c)) {
				len++;
			}
			else {
				len += 2;
			}
		}
	}
	return len;
}


/**
 * 转换请求参数串为对象
 * @author: train.chen
 * @date: 2018年7月10日 下午2:29:29
 */
function parseQuery(query) {
    var reg = /([^=&\s]+)[=\s]*([^&\s]*)/g;
    var obj = {};
    query = query.replace(/ /g, "%20");
    while (reg.exec(query)) {
        obj[RegExp.$1] = decodeURIComponent(RegExp.$2);
    }
    return obj;
}

function i18n(name) {
    if(localStorage && localStorage.getItem(name)) {
        return localStorage.getItem(name);
    }
    return name;
}

/**
 * @Description: 打开消息提示
 * @Author: lynn.chen 陈立
 * @Modified By:
 * @Date: 2013-07-29
 * @param: type 消息的类型(从msgType对象中获取)
 * @param: text 消息的文本
 */
function openMessage(type, text, ptimeout) {
	text = (text == "" ? null : text);
	var timeout = 1000;
	if (type == msgType.warning || type == msgType.info) {//警告
		timeout = 3000;
	}
	else if (type == msgType.success) {//成功
		text = (text && text != null ? text : "common_op_succeed");//common_op_succeed:操作成功
		var num = strlen(text) / 30;
		num = num > 8 ? 8 : num;
		timeout = Math.ceil(num) * timeout;//动态判断显示字符数的长度来延长显示时间
	}
	else if (type == msgType.error) {//失败
		text = (text && text != null) ? text : "common_op_failed";//common_op_failed:操作失败，程序出现异常
		timeout = 3000;
	}
	else if (type == msgType.loading) {//处理中
		timeout = 0;//当为'loading'时，timeout值会被设置为0，表示不会自动关闭。
		text = text && text != null ? text : "common_op_processing";//common_op_processing:处理中
	}
	text = i18n(text);
	var width = strlen(text) * 6.1 + 45;//按字符计算宽度
	timeout = ptimeout ? ptimeout : timeout;
	$.jBox.tip(text, type, {
	    id:"zkmsg",
		timeout : timeout,
		width : (width > 400 ? 400 : "auto")
	});//设定最大宽度为400

	$(".jbox-tip .jbox").css("z-index", "99999");
}

/**
 * @Description: 关闭消息提示
 * @Author: lynn.chen  陈立
 * @Modified By:Darcy Zhangc 给定默认关闭时最小等待时间为1s
 * @Date: 2013-07-31
 * @param: type 消息的类型
 * @param: text 消息的文本
 */
function closeMessage(timeout) {
	timeout = timeout ? timeout : 1000;
	window.setTimeout("$.jBox.closeTip();", timeout);//设定最小等待时间
}

if(localStorage.getItem("token")) {
    $.ajaxSetup({
        dataType : 'json',
        headers :{
            token:localStorage.getItem("token")
        }
    })
}

function msgBox(type, text, callback, title) {
    title = title || "common_prompt";
    title = i18n(title);
    type = type || "confirm";
    var html = "<div class='msg-box'>" + i18n(text) + "</div>";
    var opts = {
        title:title
    }
    opts.buttons = {};
    if(type === "alert") {
        opts.buttons[i18n("common_ok")]="ok";
    } else {
        opts.buttons[i18n("common_ok")]="ok";
        opts.buttons[i18n("common_cancel")]="cancel";
    }
    if(typeof(callback) === "function") {
        opts.submit = callback;
    }
    $.jBox(html, opts);
}

function verifyLoginPwd(callBackFun, funData, cancelFun) {
	var html = "<div style='padding:30px 0px;text-align: center;'>" + "<form id='userVerifyForm' action='/validAdmin' method='post'>" + i18n("common_userPwd")+"<span class='required'>*</span><input type='password' id='loginPwdTemp' name='password' style='margin-left:20px;'/></form></div>";
	//根据国际化语言改变宽度
	var jBoxWidth = 330;
	$.jBox(html, {
		title : i18n("common_securityVerify"),//"安全验证",
		width : jBoxWidth,
		submit : function(v, h, f) {
			if (v == "ok") {
				$("#userVerifyForm").submit();
				return false;
			} else {
				if(typeof(cancelFun) == "function"){
					cancelFun(v)
				}
			}
		}
	});
    jBoxToCenter();

	//添加回车提交表单
	$("#userVerifyForm input").bind("keydown", function(e) {
		if (e.keyCode == 13) {
			$("#userVerifyForm").submit();
		}
	});

	$("#userVerifyForm").ajaxForm({
        success:function(res) {
            if(typeof(res) === "string") {
                res = JSON.parse(res);
            }
            $.jBox.close();
            if(res.ret === "ok") {
                openMessage(msgType.success);
                if(typeof callBackFun === "function") {
                    callBackFun(res);
                }
            } else {
                openMessage(msgType.error);
            }
        }, error: function() {
            openMessage(msgType.error);
            $.jBox.close();
        }
    })
}

function verifyServerPwd(callBackFun, cancelFun) {
	var host = $("input[name='host']").val() || "";
	var html = "<div style='padding:30px 0px;text-align: center;'><form id='userVerifyForm' action='/validServer' method='post'>";
	html = html + i18n("common_userPwd") + "<span class='required'>*</span><input type='password' id='loginPwdTemp' autocomplete='new-password' name='password' style='margin-left:20px;'/>";
	html = html + "<input type='hidden' name='server' value='" + host + "'/></form></div>";
	//根据国际化语言改变宽度
	var jBoxWidth = 330;
	$.jBox(html, {
		title : i18n("sync_server_valid"),//"安全验证",
		width : jBoxWidth,
		submit : function(v, h, f) {
			if (v == "ok") {
				$("#userVerifyForm").submit();
				return false;
			} else {
				if(typeof(cancelFun) == "function"){
					cancelFun(v)
				}
			}
		}
	});
    jBoxToCenter();

	//添加回车提交表单
	$("#userVerifyForm input").bind("keydown", function(e) {
		if (e.keyCode == 13) {
			$("#userVerifyForm").submit();
			e.stopPropagation();
			e.preventDefault();
		}
	});

	$("#userVerifyForm").ajaxForm({
        success:function(res) {
            if(typeof(res) === "string") {
                res = JSON.parse(res);
            }
            $.jBox.close();
            if(res.ret === "ok") {
                openMessage(msgType.success);
                if(typeof callBackFun === "function") {
                    callBackFun(res);
                }
            } else {
                openMessage(msgType.error);
            }
        }, error: function() {
            openMessage(msgType.error);
            $.jBox.close();
        }
    })
}

function jBoxToCenter() {
    var w = $("#jbox").outerWidth();
    $("#jbox").css("margin-left", (-w/2) + "px");
    var t = ($(document.body).outerHeight() - $("#jbox").outerHeight())/2;
    $("#jbox").css("top", t + "px");
}

function createSocket(opts) {
    opts.id = opts.id || ("client"+Math.round(Math.random()*10000));
    opts.uri = (opts.uri || "") + "ws";
    var socket = new SockJS(opts.uri);
    var client = Stomp.over(socket);
    client.connect({}, function connectCallback(frame) {
        if (opts.url) {
            client.subscribe("/topic/"+opts.url, function(response) {
                if (typeof (opts.onMessage) == "function") {
                    opts.onMessage(response);
                }
            });
            setTimeout(function() {
                client.send("/app/"+opts.url, {}, opts.param||"{}")
            },50);
        }
        if (typeof (opts.complete) == "function") {
            opts.complete(client);
        }
    }, function errorCallBack(error) {
        if (typeof (opts.error) == "function") {
            opts.error(error);
        }
    });
    return client;
}

if(typeof(jBoxConfig) != "undefined"){
	var buttons = {
		buttons : {}
	};
	buttons.buttons[i18n("common_ok")] = "ok";
	buttons.buttons[i18n("common_cancel")] = "cancel";
	jBoxConfig.defaults = buttons;
	jBoxConfig.languageDefaults = {
	    close: i18n("common_close"),//'关闭', /* 窗口右上角关闭按钮提示 */
	    ok: i18n("common_ok"),//'确定', /* $.jBox.prompt() 系列方法的“确定”按钮文字 */
	    yes: i18n("common_yes"),//'是', /* $.jBox.warning() 方法的“是”按钮文字 */
	    no: i18n("common_no"),//'否', /* $.jBox.warning() 方法的“否”按钮文字 */
	    cancel: i18n("common_cancel")//'取消' /* $.jBox.confirm() 和 $.jBox.warning() 方法的“取消”按钮文字 */
	};
	$.jBox.setDefaults(jBoxConfig);
}