/*!
 * ol-contextmenu - v3.2.0
 * Custom Context Menu for Openlayers
 * https://github.com/jonataswalker/ol-contextmenu
 * Built: Thu Apr 05 2018 11:39:12 GMT-0300 (-03)
 */
!function(t, e) {
    "object" == typeof exports && "undefined" != typeof module ? module.exports = e(require("ol/control/control")) : "function" == typeof define && define.amd ? define(["ol/control/control"], e) : t.ContextMenu = e(t.ol.control.Control)
} (this,
function(t) {
    "use strict";
    t = t && t.hasOwnProperty("default") ? t.
default:
    t;
    var e = {
        namespace: "ol-ctx-menu",
        container_class: "-container",
        separator_class: "-separator",
        submenu_class: "-submenu",
        hidden_class: "-hidden",
        icon_class: "-icon",
        zoom_in_class: "-zoom-in",
        zoom_out_class: "-zoom-out",
        ol_unselectable_class: "ol-unselectable"
    };
    const n = Object.freeze({
        namespace: "ol-ctx-menu",
        container_class: "-container",
        separator_class: "-separator",
        submenu_class: "-submenu",
        hidden_class: "-hidden",
        icon_class: "-icon",
        zoom_in_class: "-zoom-in",
        zoom_out_class: "-zoom-out",
        ol_unselectable_class: "ol-unselectable",
    default:
        e
    }),
    s = "beforeopen",
    i = "open",
    o = "close",
    a = "contextmenu",
    r = {
        container: n.namespace + n.container_class,
        separator: n.namespace + n.separator_class,
        submenu: n.namespace + n.submenu_class,
        hidden: n.namespace + n.hidden_class,
        icon: n.namespace + n.icon_class,
        zoomIn: n.namespace + n.zoom_in_class,
        zoomOut: n.namespace + n.zoom_out_class,
        OL_unselectable: n.ol_unselectable_class
    },
    c = {
        width: 150,
        scrollAt: 4,
        eventType: a,
        defaultItems: !0
    },
    l = [{
        text: "Zoom In",
        classname: r.zoomIn + " " + r.icon,
        callback: function(t, e) {
            const n = e.getView();
            n.animate({
                zoom: +n.getZoom() + 1,
                duration: 700,
                center: t.coordinate
            })
        }
    },
    {
        text: "Zoom Out",
        classname: r.zoomOut + " " + r.icon,
        callback: function(t, e) {
            const n = e.getView();
            n.animate({
                zoom: +n.getZoom() - 1,
                duration: 700,
                center: t.coordinate
            })
        }
    }];
    function u(t, e) {
        if (void 0 === e && (e = "Assertion failed"), !t) {
            if ("undefined" != typeof Error) throw new Error(e);
            throw e
        }
    }
    function p(t) {
        return /^\d+$/.test(t)
    }
    function h(t, e) {
        return t.classList ? t.classList.contains(e) : f(e).test(t.className)
    }
    function d(t, e, n) {
        void 0 === e && (e = window.document);
        let s = /\./g,
        i = Array.prototype.slice,
        o = [];
        if (/^(#?[\w-]+|\.[\w-.]+)$/.test(t)) switch (t[0]) {
        case "#":
            o = [(a = t.substr(1), a = "#" === a[0] ? a.substr(1, a.length) : a, document.getElementById(a))];
            break;
        case ".":
            o = i.call(e.getElementsByClassName(t.substr(1).replace(s, " ")));
            break;
        default:
            o = i.call(e.getElementsByTagName(t))
        } else o = i.call(e.querySelectorAll(t));
        var a;
        return n ? o: o[0]
    }
    function m(t) {
        let e = document.createDocumentFragment(),
        n = document.createElement("div");
        for (n.innerHTML = t; n.firstChild;) e.appendChild(n.firstChild);
        return e
    }
    function f(t) {
        return new RegExp("(^|\\s+) " + t + " (\\s+|$)")
    }
    function y(t, e, n) {
        t.classList ? t.classList.add(e) : t.className = (t.className + " " + e).trim(),
        n && p(n) && window.setTimeout(function() {
            return b(t, e)
        },
        n)
    }
    function b(t, e, n) {
        t.classList ? t.classList.remove(e) : t.className = t.className.replace(f(e), " ").trim(),
        n && p(n) && window.setTimeout(function() {
            return y(t, e)
        },
        n)
    }
    var g = function(t) {
        return this.Base = t,
        this.map = void 0,
        this.viewport = void 0,
        this.coordinateClicked = void 0,
        this.pixelClicked = void 0,
        this.lineHeight = 0,
        this.items = {},
        this.opened = !1,
        this.submenu = {
            left: t.options.width - 15 + "px",
            lastLeft: ""
        },
        this.eventHandler = this.handleEvent.bind(this),
        this
    };
    g.prototype.init = function(t) {
        this.map = t,
        this.viewport = t.getViewport(),
        this.setListeners(),
        this.Base.Html.createMenu(),
        this.lineHeight = this.getItemsLength() > 0 ? this.Base.container.offsetHeight / this.getItemsLength() : this.Base.Html.cloneAndGetLineHeight()
    },
    g.prototype.getItemsLength = function() {
        var t = this;
        let e = 0;
        return Object.keys(this.items).forEach(function(n) {
            t.items[n].submenu || t.items[n].separator || e++
        }),
        e
    },
    g.prototype.getPixelClicked = function() {
        return this.pixelClicked
    },
    g.prototype.getCoordinateClicked = function() {
        return this.coordinateClicked
    },
    g.prototype.positionContainer = function(t) {
        var e = this;
        const n = this.Base.container,
        s = this.map.getSize(),
        i = s[1] - t[1],
        o = s[0] - t[0],
        a = n.offsetWidth,
        c = Math.round(this.lineHeight * this.getItemsLength()),
        l = d("li." + r.submenu + ">div", n, !0);
        o >= a ? (n.style.right = "auto", n.style.left = t[0] + 5 + "px") : (n.style.left = "auto", n.style.right = "15px"),
        i >= c ? (n.style.bottom = "auto", n.style.top = t[1] - 10 + "px") : (n.style.top = "auto", n.style.bottom = 0),
        function t(e, n, s) {
            if (Array.isArray(e)) return void e.forEach(function(e) {
                return t(e, n, s)
            });
            const i = Array.isArray(n) ? n: n.split(/\s+/);
            let o = i.length;
            if (e.children[0].childElementCount != 0){
                for (; o--;) h(e, i[o]) && b(e, i[o], s)
            }
        } (n, r.hidden),
        l.length && (this.submenu.lastLeft = o < 2 * a ? "-" + a + "px": this.submenu.left, l.forEach(function(t) {
            const n = {
                w: window.innerWidth || document.documentElement.clientWidth,
                h: window.innerHeight || document.documentElement.clientHeight
            },
            s = function(t) {
                const e = t.getBoundingClientRect(),
                n = document.documentElement;
                return {
                    left: e.left + window.pageXOffset - n.clientLeft,
                    top: e.top + window.pageYOffset - n.clientTop,
                    width: t.offsetWidth,
                    height: t.offsetHeight
                }
            } (t),
            o = s.height;
            let a = i - o;
            a < 0 && (a = o - (n.h - s.top), t.style.top = "-" + a + "px"),
            t.style.left = e.submenu.lastLeft
        }))
    },
    g.prototype.openMenu = function(t, e) {
        this.Base.dispatchEvent({
            type: i,
            pixel: t,
            coordinate: e
        }),
        this.opened = !0,
        this.positionContainer(t)
    },
    g.prototype.closeMenu = function() {
        this.opened = !1,
        function t(e, n, s) {
            if (Array.isArray(e)) return void e.forEach(function(e) {
                return t(e, n)
            });
            const i = Array.isArray(n) ? n: n.split(/\s+/);
            let o = i.length;
            for (; o--;) h(e, i[o]) || y(e, i[o], s)
        } (this.Base.container, r.hidden),
        this.Base.dispatchEvent({
            type: o
        })
    },
    g.prototype.setListeners = function() {
        this.viewport.addEventListener(this.Base.options.eventType, this.eventHandler, !1)
    },
    g.prototype.removeListeners = function() {
        this.viewport.removeEventListener(this.Base.options.eventType, this.eventHandler, !1)
    },
    g.prototype.handleEvent = function(t) {
        const e = this;
        this.coordinateClicked = this.map.getEventCoordinate(t),
        this.pixelClicked = this.map.getEventPixel(t),
        this.Base.dispatchEvent({
            type: s,
            pixel: this.pixelClicked,
            coordinate: this.coordinateClicked
        }),
        this.Base.disabled || (this.Base.options.eventType === a && (t.stopPropagation(), t.preventDefault()), this.openMenu(this.pixelClicked, this.coordinateClicked), t.target.addEventListener("mousedown", {
            handleEvent: function(n) {
                e.closeMenu(),
                t.target.removeEventListener(n.type, this, !1)
            }
        },
        !1))
    },
    g.prototype.setItemListener = function(t, e) {
        const n = this;
        var s;
        t && "function" == typeof this.items[e].callback && (s = this.items[e].callback, t.addEventListener("click",
        function(t) {
            t.preventDefault();
            const i = {
                coordinate: n.getCoordinateClicked(),
                data: n.items[e].data || null
            };
            n.closeMenu(),
            s(i, n.map)
        },
        !1))
    };
    var v = function(t) {
        return this.Base = t,
        this.Base.container = this.container = this.createContainer(),
        this
    };
    return v.prototype.createContainer = function(t) {
        const e = document.createElement("div"),
        n = document.createElement("ul"),
        s = [r.container, r.OL_unselectable];
        return t && s.push(r.hidden),
        e.className = s.join(" "),
        e.style.width = parseInt(this.Base.options.width, 10) + "px",
        e.appendChild(n),
        e
    },
    v.prototype.createMenu = function() {
        let t = [];
        if ("items" in this.Base.options ? t = this.Base.options.defaultItems ? this.Base.options.items.concat(l) : this.Base.options.items: this.Base.options.defaultItems && (t = l), 0 === t.length) return ! 1;
        t.forEach(this.addMenuEntry, this)
    },
    v.prototype.addMenuEntry = function(t) {
        var e, n = this;
        if (t.items && Array.isArray(t.items)) {
            t.classname = t.classname || "",
            e = r.submenu,
            ~t.classname.indexOf(e) || (t.classname = t.classname.length ? " " + r.submenu: r.submenu);
            let s = this.generateHtmlAndPublish(this.container, t),
            i = this.createContainer();
            i.style.left = this.Base.Internal.submenu.lastLeft || this.Base.Internal.submenu.left,
            s.appendChild(i),
            t.items.forEach(function(t) {
                n.generateHtmlAndPublish(i, t, !0)
            })
        } else this.generateHtmlAndPublish(this.container, t)
    },
    v.prototype.generateHtmlAndPublish = function(t, e, n) {
        let s,
        i,
        o,
        a = !1;
        const c = "_" + Math.random().toString(36).substr(2, 9);
        return "string" == typeof e && "-" === e.trim() ? (i = m(s = ['<li id="', c, '" class="', r.separator, '">', "<hr></li>"].join("")), o = [].slice.call(i.childNodes, 0)[0], t.firstChild.appendChild(i), a = !0) : (e.classname = e.classname || "", i = m(s = "<span>" + e.text + "</span>"), o = document.createElement("li"), e.icon && ("" === e.classname ? e.classname = r.icon: -1 === e.classname.indexOf(r.icon) && (e.classname += " " + r.icon), o.setAttribute("style", "background-image:url(" + e.icon + ")")), o.id = c, o.className = e.classname, o.appendChild(i), t.firstChild.appendChild(o)),
        this.Base.Internal.items[c] = {
            id: c,
            submenu: n || 0,
            separator: a,
            callback: e.callback,
            data: e.data || null
        },
        this.Base.Internal.setItemListener(o, c),
        o
    },
    v.prototype.removeMenuEntry = function(t) {
        const e = d("#" + t, this.container.firstChild);
        e && this.container.firstChild.removeChild(e),
        delete this.Base.Internal.items[t]
    },
    v.prototype.cloneAndGetLineHeight = function() {
        const t = this.container.cloneNode(),
        e = m("<span>Foo</span>"),
        n = m("<span>Foo</span>"),
        s = document.createElement("li"),
        i = document.createElement("li");
        s.appendChild(e),
        i.appendChild(n),
        t.appendChild(s),
        t.appendChild(i),
        this.container.parentNode.appendChild(t);
        const o = t.offsetHeight / 2;
        return this.container.parentNode.removeChild(t),
        o
    },
    function(t) {
        function e(e) {
            void 0 === e && (e = {}),
            u("object" == typeof e, "@param `opt_options` should be object type!"),
            this.options = function(t, e) {
                let n = {};
                for (let e in t) n[e] = t[e];
                for (let t in e) n[t] = e[t];
                return n
            } (c, e),
            this.disabled = !1,
            this.Internal = new g(this),
            this.Html = new v(this),
            t.call(this, {
                element: this.container
            })
        }
        return t && (e.__proto__ = t),
        e.prototype = Object.create(t && t.prototype),
        e.prototype.constructor = e,
        e.prototype.clear = function() {
            Object.keys(this.Internal.items).forEach(this.Html.removeMenuEntry, this.Html)
        },
        e.prototype.close = function() {
            this.Internal.closeMenu()
        },
        e.prototype.enable = function() {
            this.disabled = !1
        },
        e.prototype.disable = function() {
            this.disabled = !0
        },
        e.prototype.getDefaultItems = function() {
            return l
        },
        e.prototype.countItems = function() {
            return Object.keys(this.Internal.items).length
        },
        e.prototype.extend = function(t) {
            u(Array.isArray(t), "@param `arr` should be an Array."),
            t.forEach(this.push, this)
        },
        e.prototype.isOpen = function() {
            return this.Internal.opened
        },
        e.prototype.updatePosition = function(t) {
            u(Array.isArray(t), "@param `pixel` should be an Array."),
            this.isOpen() && this.Internal.positionContainer(t)
        },
        e.prototype.pop = function() {
            const t = Object.keys(this.Internal.items);
            this.Html.removeMenuEntry(t[t.length - 1])
        },
        e.prototype.push = function(t) {
            u(null != t, "@param `item` must be informed."),
            this.Html.addMenuEntry(t)
        },
        e.prototype.shift = function() {
            this.Html.removeMenuEntry(Object.keys(this.Internal.items)[0])
        },
        e.prototype.setMap = function(e) {
            t.prototype.setMap.call(this, e),
            e ? this.Internal.init(e, this) : this.Internal.removeListeners()
        },
        e
    } (t)
});