function zoom(mask, bigimg, smallimg) {
    this.bigimg = bigimg;
    this.smallimg = smallimg;
    this.mask = mask
}
zoom.prototype = {
    /**
    * partInit 局部初始化, 用于js动态添加的对象
    */
    init: function(partInit) {
        var that = this;
        this.smallimgClick();
        if(!partInit){
            this.maskClick();
            this.mouseWheel();
        }
    },
    smallimgClick: function() {
        var that = this;
        $("." + that.smallimg).off("click").click(function() {
            if($(this).attr("src") != "" && $(this).attr("src").startsWith("data:")){
                $("." + that.bigimg).css({
                    height: $(this).height() * 4,
                    width: $(this).width() * 4
                });
                $("." + that.mask).fadeIn();
                $("." + that.bigimg).attr("src", $(this).attr("src")).fadeIn();
            }
        })
    },
    maskClick: function() {
        var that = this;
        $("." + that.mask).off("click").click(function() {
            $("." + that.bigimg).fadeOut();
            $("." + that.mask).fadeOut()
        })
    },
    mouseWheel: function() {
        function mousewheel(obj, upfun, downfun) {
            if (document.attachEvent) {
                obj.attachEvent("onmousewheel", scrollFn);
            } else {
                if (document.addEventListener) {
                    obj.addEventListener("mousewheel", scrollFn, false);
                    obj.addEventListener("DOMMouseScroll", scrollFn, false);
                }
            }
            function scrollFn(e) {
                var ev = e || window.event;
                var dir = ev.wheelDelta || ev.detail;
                if (ev.preventDefault) {
                    ev.preventDefault()
                } else {
                    ev.returnValue = false
                }
                if (dir == -3 || dir == 120) {
                    upfun()
                } else {
                    downfun()
                }
            }
        }
        var that = this;
        mousewheel($("." + that.bigimg)[0], function() {
            if ($("." + that.bigimg).innerWidth() > $("body").width() - 40) {
                //alert("不能再放大了");
                return
            }
            if ($("." + that.bigimg).innerHeight() > $("body").height() - 100) {
                //alert("不能再放大");
                return
            }
            var zoomHeight = $("." + that.bigimg).innerHeight() * 1.2;
            var zoomWidth = $("." + that.bigimg).innerWidth() * 1.2;
            $("." + that.bigimg).css({
                height: zoomHeight + "px",
                width: zoomWidth + "px"
            })
        }, function() {
            if ($("." + that.bigimg).innerWidth() < 200) {
                //alert("不能再缩小了哦！");
                return
            }
            if ($("." + that.bigimg).innerHeight() < 200) {
                //alert("不能再缩小了哦！");
                return
            }
            var zoomHeight = $("." + that.bigimg).innerHeight() / 1.2;
            var zoomWidth = $("." + that.bigimg).innerWidth() / 1.2;
            $("." + that.bigimg).css({
                height: zoomHeight + "px",
                width: zoomWidth + "px"
            })
        })
    }
};