
/**
 * 直接搜索人员轨迹
 * @param Data
 */
function getPersonFaceTrack(Data){
    if(Data.objType != "0" || undefined == Data.objKey || "" == Data.objKey){
        openMessage(msgType.info, I18n.getValue("map_track_personnel_empty"));
        return false;
    }
    convertImgToBase64(Data.captureImgURL, function(base64Img){
        mapTree.refreshItem();
        var startDate;
        var endDate;
        var mapIdStr = mapId == undefined ? "" : mapId;
        if(undefined!=Data.eventTime&&""!=Data.eventTime){
            var timestamp = Data.eventTime;
            startDate = new Date((parseInt(timestamp) -parseInt(12*60*60)* 1000 ));
            endDate = new Date((parseInt(timestamp) + parseInt(12*60*60) * 1000));
        }else{
            var timestamp = new Date().getTime();
            startDate = new Date((parseInt(timestamp) -parseInt(12*60*60)* 1000));
            endDate = new Date((parseInt(timestamp) + parseInt(12*60*60) * 1000));
        }
        var startTime = (startDate.getFullYear()) + "-" +
            (startDate.getMonth() + 1) + "-" +
            (startDate.getDate()) + " " +
            (startDate.getHours()) + ":" +
            (startDate.getMinutes()) + ":" +
            (startDate.getSeconds());
        var endTime = (endDate.getFullYear()) + "-" +
            (endDate.getMonth() + 1) + "-" +
            (endDate.getDate()) + " " +
            (endDate.getHours()) + ":" +
            (endDate.getMinutes()) + ":" +
            (endDate.getSeconds());
        var postData={
            mapId:mapIdStr,
            startTime:startTime,
            endTime:endTime,
            confidenceThreshold:"80",
            personPhoto:base64Img,
            algorithmCode:Data.algorithmIds,//算法
            visVisitPinId:Data.objKey,
            personnelType:"1",
        };
        onLoading(function(){
            getPersonFaceTrackHttp(postData,function (data) {
                closeMessage(msgType.loading);
                mapMainBase.addlocusToMap(data);
                renderlistPersonFaceTrackData(data);
            });
        })
    });
}



/**
 * 直接搜索车辆轨迹
 * @param Data
 */
function getVehicleTrack(Data){
    mapTree.refreshItem();
    var startDate;
    var endDate;
    if(undefined!=Data.alarmTime&&""!=Data.alarmTime){
        var date = Data.alarmTime;
        date = date.substring(0,19);
        date = date.replace(/-/g,'/');
        var timestamp = new Date(date).getTime();
        startDate = new Date((parseInt(timestamp) -parseInt(12*60*60)* 1000 ));
        endDate = new Date((parseInt(timestamp) + parseInt(12*60*60) * 1000));
    }else{
        var timestamp = new Date().getTime();
        startDate = new Date((parseInt(timestamp) -parseInt(12*60*60)* 1000));
        endDate = new Date((parseInt(timestamp) + parseInt(12*60*60) * 1000));
    }
    var startTime = (startDate.getFullYear()) + "-" +
        (startDate.getMonth() + 1) + "-" +
        (startDate.getDate()) + " " +
        (startDate.getHours()) + ":" +
        (startDate.getMinutes()) + ":" +
        (startDate.getSeconds());
    var endTime = (endDate.getFullYear()) + "-" +
        (endDate.getMonth() + 1) + "-" +
        (endDate.getDate()) + " " +
        (endDate.getHours()) + ":" +
        (endDate.getMinutes()) + ":" +
        (endDate.getSeconds());
    var postData={
        mapId:mapId,
        startTime:startTime,
        endTime:endTime,
        confidenceThreshold:"80",
        pnr:Data.alertNo,
        algorithmCode:Data.algorithmIds,//算法
        personPhoto:""
    };
    onLoading(function(){
        getVehicleTrackHttp(postData,function (data) {
            openMessage(msgType.success);
            mapMainBase.addlocusToMap(data);
            renderlistVehicleTrackData(data);

        });
    })
}


 /**
 * 渲染车辆轨迹图片列表
 */
function renderlistVehicleTrackData(result){
        var dataList = result.data.dataList;
        var $html="";
        var resultData="";
        var alarmLevelColor="";
        for(var i=0;i<dataList.length;i++){
            resultData= dataList[i];
            resultData.picUrl;
            resultData.thumPicUrl;
            resultData.cameraCNCode;
            resultData.cameraSn;
            var repeat="?t="+i;
            $html+="<div class=\"comment\"  >\n" +
                "                            <div class=\"comment-header\" style='background-color: "+alarmLevelColor+"'></div>\n" +
                "                            <div class=\"comment-header-left\">\n" +
                "                                <img  style='width: 90%;height: 100%'     onclick=\"getShowPic(\'"+resultData.thumPicUrl+"\');\" onerror=\"imgeTrackErrorfun(\'"+resultData.thumPicUrl+"\','/images/blacklistaddCarphoto_2.png');\" src=\'"+ resultData.thumPicUrl+"\'  class=\"left-title track-img\" />"+
                "                            </div>\n" +
                "                            <div class=\"comment-header-right\"  >\n" +
                "                               <div class=\"right-title\" style='background-color: "+alarmLevelColor+"'>\n" +
                "                                	<div class=\"left-info\">" +
                "										<p>"+resultData.cameraName+"</p>\n" +
                "										<span class=\"right-span\" onclick=\"videoRePlay('track',this)\"   data-devicename='"+resultData.cameraName+"'  data-id='"+resultData.id+"' data-type='personFaceTrack'  data-recordtime='"+resultData.imageTimestamp+"' data-camerasn='"+resultData.cameraSn+"'  data-cameracncode='"+resultData.cameraCNCode+"' >\n" +
                "                                  	     <img src=\"/images/alarm/icons_replay_1.png\" title=\"" + I18n.getValue('map_navigation_replay') + "\"  class=\"right-img\" />\n" +
                "                                 	  	</span>\n" +
                "						     		 </div>\n" +
                "                            	 </div>\n" +
                "                                <div class=\"right-info\" style=\"\">\n" +
                "                                  <span>"+transformTime(+resultData.imageTimestamp)+"</span>\n"+
                "                                </div>\n" +
                "                            </div>\n" +
                "    </div>";
        }
        if(""!=$html){
            $("#vehicleTrackConversation").append($html);
        }else{
            $html+=""
            $("#vehicleTrackConversation").append($html);
        }

        if( $("#vehicleTrackPrompt").hasClass("displayCss")){
            $("#vehicleTrackPrompt").removeClass("displayCss");
            $("#vehicleTrackPrompt").css("left","");
            $("#vehicleTrackPrompt").css("top","7px");
            $(function () {
                $("#vehicleTrackPrompt").stop().animate({
                    width: "391px"
                },300,function () {
                    // $("#vehicleTrackPrompt" ).draggable({draggable:false});
                    var title= I18n.getValue("map_bulkOperations");
                    var $html="<li><a onclick=\"showPopuppanel('vehicleTrackPrompt')\" tabindex=\"-1\" href=\"#\">"+title+"</a></li>";
                    $("#bookmark_content").append($html);
                    $("#bookmark").removeClass("displayCss");
                })
            })
        }

}


/**
 * 渲染人员轨迹图片列表
 */
function renderlistPersonFaceTrackData(result){
        var dataList = result.data.dataList;
        if(dataList){
            var $html="";
            var resultData="";
            var alarmLevelColor="";
            for(var i=0;i<dataList.length;i++){
                resultData= dataList[i];
                var newRecordTime = dhx4.date2str(new Date(resultData.recordTime), sysCfg.dhxLongDateFmt);
                resultData.picUrl;
                resultData.thumPicUrl;
                resultData.cameraCNCode;
                resultData.cameraSn;
                var repeat="?t="+i;
                $html+="<div class=\"comment\"  >\n" +
                    "            <div class=\"comment-header\" style='background-color: "+alarmLevelColor+"'></div>\n" +
                    "                  <div class=\"comment-header-left\">\n" +
                    "                        <img  style='width: 90%;height: 100%' class='zoom-smallimg' onerror=\"imgeTrackErrorfun(\'"+resultData.thumPicUrl+"\','/images/" +systemSkin + "defaultImg/defaultPers.png');\"  src=\'"+ resultData.thumPicUrl+"\' class=\"left-title\" />"+
                    "            </div>\n" +
                    "            <div class=\"comment-header-right\"  >\n" +
                    "                 <div class=\"right-title\" style='background-color: "+alarmLevelColor+"'>\n" +
                    "                        <div class=\"left-info\">" +
                    "								<p>"+resultData.cameraName+"</p>\n";
                    if(resultData.sourceModule == "vid"){
                            $html +=    "<span class=\"right-span\" onclick=\"videoRePlay('track',this)\"  data-devicename='"+resultData.cameraName+"'   data-id='"+resultData.id+"' data-type='personFaceTrack'  data-recordtime='"+resultData.recordTime+"' data-camerasn='"+resultData.cameraSn+"'  data-cameracncode='"+resultData.nvrCode+"' >\n" +
                                        " <img src=\"/images/alarm/icons_replay_1.png\" title=\"" + I18n.getValue('map_navigation_replay') + "\"  class=\"right-img\" />\n" +
                                        "</span>\n";

                    }

                    $html += "</div>\n" +
                    "       </div>\n" +
                    "       <div class=\"right-info\" style=\"\">\n" +
                    "           <span>" + newRecordTime + "</span>\n"+
                    "       </div>\n" +
                    "   </div>\n" +
                    "</div>";
            }
            if(""!=$html){
                $("#personFaceTrackConversation").append($html);
            }else{
                $html+=""
                $("#personFaceTrackConversation").append($html);
            }

            if($("#personFaceTrackPrompt").hasClass("displayCss")){
                $("#personFaceTrackPrompt").removeClass("displayCss");
                $("#personFaceTrackPrompt").css("left","");
                $("#personFaceTrackPrompt").css("top","7px");
                $(function () {
                    $("#personFaceTrackPrompt").stop().animate({
                        width: "391px"
                    },300,function () {
                        // $("#personFaceTrackPrompt" ).draggable({draggable:false});
                        var title= I18n.getValue("map_personLocus");
                        var $html="<li><a onclick=\"showPopuppanel('personFaceTrackPrompt')\" tabindex=\"-1\" href=\"#\">"+title+"</a></li>";
                        $("#bookmark_content").append($html);
                        $("#bookmark").removeClass("displayCss");
                    })
                })
            }
            //图片放大控件初始化, init传入true为局部初始化
            var zoomObj = new zoom('zoom-mask', 'zoom-bigimg','zoom-smallimg');
            zoomObj.init(true);
        }
}