I18n.load([
    "map_eventLevel_normal",
    "map_eventLevel_warning",
    "map_eventLevel_emergency",
    "map_eventLevel_common",
    "map_manual_alarm",
    "map_personnel_alert",
    "map_car_alert",
    "map_access_alert",
    "map_camera_alert",
    "acc_eventNo_8",
    "acc_eventNo_9",
    "park_deviceErrorCode_1020",
    "common_target",
    "common_open",
    "common_second",
    "common_devMonitor_msgTip",
    "common_prompt_executeOperate",
    "vid_Text_Similarity",
    "map_alarm_taskGroup",
    "vid_vcm_face_alerts_alarm_source",
    "map_trigger_conditions",
    "acc_leftMenu_verifyModeRule",
    "acc_wiegand_inputCard",
    "att_common_id",
    "vid_carList_masterName",
    "map_alarm_stranger",
    "map_alarm_platformName",
    "map_alarm_taskName",
    "map_alarm_time",
    "map_alarm_area",
    "map_alarm_source",
    "map_eventType_person",
    "map_eventType_vehicle",
    "map_eventType_stuff",
    "map_eventType_device",
    "acc_doorEventLatestHappen",
    "event_center_eventName",
    "event_center_eventTime",
    "event_center_sourceName",
    "event_center_areaName",
    "event_center_eventRemark"
], true);

/**
 * 初始化全局变量
 */
{
    /*针对阿拉伯页面*/
    //var mapMain_left = $("#mapMain_left").val();
    var mapMain_left = $("#accMapMain_left").val();
    var systemSkin = sysCfg.skin == "default" ? "" : ("skins/" + sysCfg.skin + "/");
    var moduleNameMap = new Map();
    moduleNameMap.set("acc", I18n.getValue("map_access_alert"));
    moduleNameMap.set("vid", I18n.getValue("map_camera_alert"));

    var definedLevelMap = new Map();
    var definedLevelColorArray = new Array();
    definedLevelColorArray.push('#5fd97a');
    definedLevelColorArray.push('#e3e044');
    definedLevelColorArray.push('#FD960B');
    definedLevelColorArray.push('#ff4d4f');
    definedLevelColorArray.push('#B22222');
    definedLevelColorArray.push('#FFC0CB');
    definedLevelColorArray.push('#B03060');
    definedLevelColorArray.push('#20B2AA');
    definedLevelColorArray.push('#0D33FF');
    definedLevelColorArray.push('#9370DB');
    $.ajax({
        type: "post",
        url: "/mapMonitoring.do?getAllAlarmLevelI18n",
        dataType: "json",
        async: false,
        success: function(result)
        {
            if(result.ret == "ok") {
                for (var key in result.data){
                    definedLevelMap.set(key, result.data[key]);
                }
            }else{
                messageBox({messageType:"alert",text: result.msg});
            }
        }
    });

    var eventTypeDefined = new Map();
     //0：人员 1：车辆 2：物 3:设备（事件点） 4：部件
    eventTypeDefined.set("0", I18n.getValue("map_eventType_person"));
    eventTypeDefined.set("1", I18n.getValue("map_eventType_vehicle"));
    eventTypeDefined.set("2", I18n.getValue("map_eventType_stuff"));
    eventTypeDefined.set("3", I18n.getValue("map_eventType_device"));
    eventTypeDefined.set("4", I18n.getValue("map_eventType_subset"));
}

/**
* 门禁实时事件
*/
{
    //播放实时事件产生的音频文件
    function loadAudioEventData() {
        window.clearTimeout(eventAudioTimeout);
        // 添加对象判断，修复前端报错
        var audioCheckboxObj = document.getElementById("audioCheckbox");
        if(audioCheckboxObj && audioCheckboxObj.checked)
        {
            if(eventAudioTimeout >0)
            {
                closeAudio("alert_sound");
                //使用定时器3秒钟判断资源数，如果该资源数>0,则停止当前声音，并播放下一个声音，如果资源数=0，则不做任何操作
                if(audioArray.length>0)
                {
                    $("#myplay").remove();
                    var sound = audioArray.shift();
                    loadAndPlayAudio("alert_sound" , sound);
                }
            }
        } else {
            while(audioArray.length>0) {
                audioArray.pop();
            }
        }
        eventAudioTimeout = window.setTimeout("loadAudioEventData()" , 3000);
    }

    //获取实时事件数据
    function accMapLoadEventData() {
        try {
            var clientId = Math.round(Math.random() * 10000)+"${uuid!}";
            var client = Web.getSocket({
                id : "accMapEventClient",
                url : "accMapMonitor/getEventData",
                param:JSON.stringify({"clientId" : clientId}),
                onMessage:function(resp) {
                    var data = JSON.parse(resp.body);
                    if(data.clientId && clientId!=data.clientId) {
                        return;
                    }
                    if(data != null && typeof(eventGrid.setSizes) == "function") {
                        var rows = data.rows;
                        for(var index in rows) {
                            var doorIdArry = doorIds.toString().split(",");
                            //遍历地图上所有的门
                            for(var doorId in doorIdArry) {
                                //判断门事件，所对应的门是否在该地图上
                                if(doorIdArry[doorId] == rows[index].data[10]) {
                                    var id = rows[index].id;
                                    var maxEventCount = parseInt($("#maxEventCount").html());
                                    if(eventGrid.getRowsNum() >= maxEventCount) {
                                        eventGrid.deleteRow(eventGrid.getRowId(eventGrid.getRowsNum()-1));
                                    }
                                    if(rows[index].data[4] == "acc_eventNo_7")
                                    {
                                        $("#alarm_sound").html("");
                                        closeAlarmSound();//取消报警操作，停止音频
                                        audioArray = new Array();//重新设置为空
                                    }
                                    rows[index].data[4] = I18n.getValue(rows[index].data[4]);
                                    rows[index].data[8] = I18n.getValue(rows[index].data[8]);
                                    eventGrid.addRow(id, rows[index].data, 0);
                                    eventGrid.setRowTextStyle(id, rows[index].style);
                                    for(var key in rows[index].userdata) {
                                        eventGrid.setUserData(id, key, rows[index].userdata[key]);
                                    }
                                    //弹出视频
                                    if(typeof(rows[index].vidDevices) != "undefined") {
                                        global_vidDevices.push({vidDescription:rows[index].vidDescription,vidDevices:rows[index].vidDevices});
                                    }
                                    //消息提示
                                    accMapEventMsg(id);
                                    //事件声音提醒
                                    var tempAudio = data.audios;
                                    if(tempAudio.length>0 && tempAudio[index]!=null) {
                                        audioArray.push(tempAudio[index]);
                                        var arrLen = audioArray.length;
                                        //当音频列表中的播放路径大于50时，移除超出50部分旧数据，保留最多50条音频路径__modifyBy qingj.qiu
                                        for(var j = 0; arrLen >= 50 && j < (arrLen-50);j++)
                                        {
                                            audioArray.shift();
                                        }
                                    }

                                }
                            }
                        }
                        eventGrid.setSizes(false);
                    }
                }
            });
        } catch(err) {
            if(typeof(console) != "undefined") {
                console.log("Error name: " + err.name + "");
                console.log("Error message: " + err.message);
            }

        }
    }

    //事件消息提示
    function accMapEventMsg(id) {
        // var gridName = eventGrid.entBox.id;
        var photoPath = eventGrid.getUserData(id, "photoBase64");
        var personPinName = eventGrid.cells(id, eventGrid.getColIndexById("pinName")).getValue();
        var eventTime = eventGrid.cells(id, eventGrid.getColIndexById("eventTime")).getValue();
        var eventName = eventGrid.cells(id, eventGrid.getColIndexById("eventName")).getValue();
        var msgObj = document.getElementById("msgCheckbox");

        if(eventGrid.getUserData(id, "globalLinkageEvent") == null)
        {
            if(msgObj.checked && photoPath != "")//选中时开启
            {
                var nowTime = new Date().getTime();
                var text = "<div align='center' style='padding: 0px 15px 0px 15px;'>" +
                    "<img src='" + photoPath + "' onerror='this.src=\"/images/userImage.gif\"' style='max-height: 140px;border: 1px solid #a4bed4;'/>" +
                    "<p>" + personPinName + "</p>" +
                    "<p style='margin-top: 3px; text-overflow:ellipsis; overflow: hidden; width: 150px; white-space:nowrap;'>" + eventName + "</p>" +
                    "<p>" + eventTime + "</p>" +
                    "</div>";
                $.jBox.messager(text, I18n.getValue("common_devMonitor_msgTip"), 0, {
                    width: 'auto',
                    showType: 'fade',
                    timeout: 5000/*,
                    buttons: {"<@i18n 'common_devMonitor_doTotPrompt'/>": "ok"},
                    submit: function (v, h, f) {
                        msgObj.checked = false;
                        enableMsg(msgObj);
                        return true;
                    }*/
                });
            }
        } else {
            var vidLinkageHandle = eventGrid.getUserData(id, "globalLinkageEvent").vidLinkageHandle;
            if(vidLinkageHandle != undefined && vidLinkageHandle != '')
            {
                var split = vidLinkageHandle.split('_');
                var type = split[0];
                if((type & 2) != 0 && split.length > 1)//包含抓图
                {
                    accPopUpCapture(id, split[1],I18n.getValue("acc_eventNo_8"), gridName);//弹出抓拍图
                }
            }
        }
    }
}


/**
 * 工具
 */
{
    /**
     * 刷新列表
     */
    function RefreshAlarmList() {
        $("#conversation").html("");
        renderAlarmData();
        /*右边详情隐藏*/
        if(!$("#rightDivPrompt").hasClass("displayCss")){
        	if(mapMain_left == "left"){
        		$("#rightDivPrompt").stop().animate({right: "-20%"},500,function () {
                	$("#rightDivPrompt").addClass("displayCss")
                });
            }else{
            	$("#rightDivPrompt").stop().animate({left: "-20%"},500,function () {
                	$("#rightDivPrompt").addClass("displayCss")
                });
            }
        }
    }

    /**
     * 删除
     */
    function delDevice(source) {
        $(source).parent().remove();
        var deviceListcount=$("#bulkOperations_deviceList_count").val()-1;
        if(0==deviceListcount){
            var $html="<p style='color: white;font-size: 24px;margin-top:200px'>"+I18n.getValue("map_alarm_no_device")+"</p>";
            $("#bulkOperationsConversation").append($html).css("background","none");
        }
        $("#bulkOperations_deviceList_count").html("("+deviceListcount+")");
        $("#bulkOperations_deviceList_count").val(deviceListcount);
    }

    /**
     * 设备详情
     */
    function infoDevice(source) {
        var entityId= $(source).parent().parent().find('.bulkOperationsDeviceId').val();
        var type= $(source).parent().parent().find('.bulkOperationsDeviceId').data("type");
        mapPosDeviceInfoPopup(entityId,type);
    }

    /**
     * 设备播放和停止的按钮事件
     */
    function playDevice(source) {

        var cameraId= $(source).parent().parent().find('.bulkOperationsDeviceId').val();
        var cameraCode= $(source).parent().parent().find('.bulkOperationsDeviceId').data("sn");
        var cameraName= $(source).parent().parent().find('.bulkOperationsDeviceId').data("name");
        $(source).parent().find("img").attr("src","/images/alarm/icons_play_2.png");
        /**/
        var postData={
            cameraCode:cameraCode,
            cameraName:cameraName,
            cameraId:cameraId,
        }
        vidIvsOCX.getLivePlay(postData,function (resultMap) {
            map_LivePlay.set(resultMap["wnd"],resultMap["cameraId"]);
            $(".operating-span_play img").attr("src","/images/alarm/icons_play_1.png");
            map_LivePlay.forEach(function(value, key) {
                $("#play_"+value).find("img").attr("src","/images/alarm/icons_play_2.png");
            })

        })
    }

    /**开始订阅事件中心推送的事件*/
    function subscribeEvent(){
        var clientId = Math.round(Math.random() * 10000) + new Date().getTime() + "";
        var client = Web.getSocket({
            id : "mapAllEventMonitoring",
            url : "mapSubscription/allEvents",
            param:JSON.stringify({"clientId" : clientId}),
            onMessage:function(resp) {
                var data = JSON.parse(resp.body);
                renderAlarmDataList(data);
                if (eChartCountRefreshHandler == null){
                    eChartCountRefreshHandler = setInterval(renderAlramEcharsPie, 10000);
                }
            }
        });
        return client;
    }

    /**停止订阅事件中心的推送*/
    function unsubscribeEvent(client){
        Web.closeClient("mapAllEventMonitoring");
    }

    //实现将项目的图片转化成base64
    function convertImgToBase64(url, callback, outputFormat){
        // url为空时不转化,后端用人员编号查询
        if (!url) {
            callback();
            return;
        }
        var canvas = document.createElement('CANVAS'),
            ctx = canvas.getContext('2d'),
            img = new Image;
        img.crossOrigin = 'Anonymous';
        img.onload = function(){
            canvas.height = img.height;
            canvas.width = img.width;
            ctx.drawImage(img,0,0);
            var dataURL = canvas.toDataURL(outputFormat || 'image/png');
            callback.call(this, dataURL);
            canvas = null;
        };
        img.src = url;
    }
    /**
     * 回填告警详情
     */
    function renderAlarmDetail(Data) {
    	// header
        $("#rightDivPromptDataDiv-title-eventName").html("");
        $("#rightDivPromptDataDiv-title-eventName").css("background","none");
        //$("#rightDivPromptDataDiv-title").html("");
        $("#rightDivPromptDataDiv-persName").hide().html("");
        $("#rightDivPromptDataDiv-persPin").hide().html("");
        $("#rightDivPromptDataDiv-serverName").hide().html("");
        $("#rightDivPromptDataDiv-licenseplate").hide().html("");// 车牌

        // detail data
        $("#alarmTime").html("");
        $("#camera").html("");
        $("#alarmArea").html("");
        $("#alarmTaskGroup").html("").hide();
        $("#alarmSimilar").html("").hide();//人脸告警
        $("#alarmMatch").html("").hide();
        $("#alarmAccVerMode").html("").hide();//门禁告警
        $("#alarmAccCardNo").html("").hide();
        $("#alertAccId").html("").hide();
        $(".rightPreview-line").show();
        $(".rightPreview-track").show();
        $("#serverName").html("").hide();
        $("#controlTaskName").html("").hide();
        $("#cameraType").val("");
        $("#cameraName").val("");
        $("#cameraCode").val("");
        $("#eventTimePlayBackStartStr").val("");
        $("#eventTimePlayBackEndStr").val("");

        $("#event_remark").val("");
        $("#eventCaptureImg").attr("src","");
        $("#eventCaptureImg").attr("onclick","");
        $(".rightPreview-track").attr("onclick","");

        $("#rightDivPromptDataDiv-title-eventName").html("<span id= 'eventName' style='padding: 0 3px;'>"+Data.eventName+"</span>");
        $("#rightDivPromptDataDiv-title-eventName").css("color","#FFF");
        $("#rightDivPromptDataDiv-title-eventName").css("background-color",Data.eventLevelColor);

        //设值前先将其置为空，防止取到旧数据
        $("#specificInformation").html("");
        $("#specificInformation").show();
        $("#cameraCode").val(Data.cameraCode);
        $("#cameraName").val(Data.cameraName);
        $("#cameraType").val("FIX");
        // 原始的数据值
        $("#eventTimePlayBackStartStr").val(Data.eventTimePlayBackStartStr);
        $("#eventTimePlayBackEndStr").val(Data.eventTimePlayBackEndStr);
        $("#channelId").val(Data.channelId);
        //objType：0 为人相关事件  objType：1 为车辆相关事件  objType：3 为设备相关事件
        $("#specificInformation").html("<span style='white-space: nowrap;font-weight:bold;display: inline-block;'>"+I18n.getValue(eventTypeDefined.get(Data.objType))+":</span><span style='padding: 0 3px;font-weight:bold;display: inline-block;word-break: break-all;' title='" +Data.objKey+"("+Data.objName+")"+"'>"+Data.objKey+"("+Data.objName+")"+"</span>");
        $("#eventTime").html("<span>"+I18n.getValue("event_center_eventTime")+":</span><span style='padding: 0 3px;'>"+Data.eventTimeStr+"</span><input type='hidden' value='"+ dhx4.date2str(new Date(Data.eventTime), sysCfg.dhxLongDateInitFmt) + "'/>");
        $("#eventArea").html("<span>"+I18n.getValue("event_center_areaName")+":</span><span style='padding: 0 3px;'>"+Data.areaName+"</span>");
        $("#sourceName").html("<span>"+I18n.getValue("event_center_sourceName")+":</span><span style='padding: 0 3px;' title='" + Data.sourceName + "'>"+Data.sourceName+"</span>");
        $("#event_remark").val(Data.eventRemark);
        if (sysCfg.skin == "techblue" || sysCfg.skin == "default") {
            $("#event_remark").css("color","#FFF");
        } else {
            $("#event_remark").css("color","#000");
        }
        var photoURL = Data.captureImgURL || Data.panoramaImgURL;
        if (null != photoURL && "" != photoURL && undefined != photoURL && photoURL.indexOf("data:image/jpg;base64") == -1) {
            photoURL = "";
        }
        //对比图展示，判断是否有人员对比率，没有的话隐藏，只显示单图
        if (0 == Data.objType && null != Data.faceRate && "" != Data.faceRate) {
            $("#rightDivPromptDataDiv-faceRate").css("display","");
            $("#faceRateValue").html(Math.round(Data.faceRate) + "%");
            Data.faceRate = Math.round(Data.faceRate);
            if (0 <= Data.faceRate && Data.faceRate <= 50) {
                // 防止 Data.faceRate == 0 时也符合 Data.faceRate == "" 条件，因此设为 "0"
                if (0 == Data.faceRate) {
                    Data.faceRate = "0";
                }
                $("#faceRatePhotoUrl").attr("src","/images/" +systemSkin + "/map/faceRateImg/map_faceRate_ban.png");
                $("#faceRateValue").css("color","#F32D19");
            } else if (50 < Data.faceRate && Data.faceRate <= 75) {
                $("#faceRatePhotoUrl").attr("src","/images/" +systemSkin + "/map/faceRateImg/map_faceRate_stranger.png");
                $("#faceRateValue").css("color","#FC5F21");
            } else {
                $("#faceRatePhotoUrl").attr("src","/images/" +systemSkin + "/map/faceRateImg/map_faceRate_allow.png");
                if (sysCfg.skin == "techblue") {
                    $("#faceRateValue").css("color","#91d0ff");
                } else {
                    $("#faceRateValue").css("color","#7BC145");
                }
            }
        } else {
            $("#rightDivPromptDataDiv-faceRate").css("display","none");
        }

        //抠图及原图展示
        $("#PickPhotoUrl").css("display","");
        $("#localBlkUrl").css("display","");
        if (0 == Data.objType) {
            // 当为人员事件，但对比值为空时
            if (null == Data.faceRate || "" == Data.faceRate) {
                if(null != photoURL && "" != photoURL && undefined != photoURL){
                    $("#PickPhotoUrl").css("cursor","pointer");
                    $("#PickPhotoUrl").attr("src", photoURL);
                    $("#PickPhotoUrl").css("margin-left","90px");
                    $("#localBlkUrl").css("display","none");
                } else if (null != Data.localBlkUrl&& "" != Data.localBlkUrl&& undefined != Data.localBlkUrl) {
                    $("#localBlkUrl").css("cursor","pointer");
                    $("#localBlkUrl").attr("src",Data.localBlkUrl);
                    $("#localBlkUrl").css("margin-left","90px");
                    $("#PickPhotoUrl").css("display","none");
                } else {
                    //当为人员相关事件时，没有原图且没有抓拍图时则展示默认头像
                    $("#localBlkUrl").attr("src","/images/" +systemSkin + "defaultImg/defaultPers.png");
                    $("#localBlkUrl").css("margin-left","90px");
                    $("#PickPhotoUrl").css("display","none");
                }
            // 当为人员事件且对比值不为空时
            } else {
                $("#PickPhotoUrl").css("cursor","pointer");
                $("#localBlkUrl").css("cursor","pointer");
                // 当为人员对比事件，但摄像机未上传图片时，抓拍图将采用默认图
                if (null == photoURL || "" == photoURL) {
                    $("#PickPhotoUrl").attr("src","/images/" +systemSkin + "defaultImg/defaultPers.png");
                } else {
                    $("#PickPhotoUrl").attr("src", photoURL);
                }
                $("#localBlkUrl").css("margin-left","");
                $("#PickPhotoUrl").css("margin-left","");
                //没有原图则展示默认头像
                if(null != Data.localBlkUrl&& "" != Data.localBlkUrl&& undefined != Data.localBlkUrl){
                    $("#localBlkUrl").attr("src",Data.localBlkUrl);
                } else {
                    $("#localBlkUrl").css("cursor","");
                    $("#localBlkUrl").attr("src","/images/" +systemSkin + "defaultImg/defaultPers.png");
                }
            }
        // 当为非人员事件，但有抓拍图时
        } else if (0 != Data.objType && null != photoURL && "" != photoURL && undefined != photoURL) {
            $("#localBlkUrl").css("display","none");
            $("#PickPhotoUrl").css("margin-left","90px");
            $("#PickPhotoUrl").attr("src", photoURL);
        // 当为非人员事件且无抓拍图时
        } else {
            $("#localBlkUrl").css("display","none");
            $("#PickPhotoUrl").css("display","none");
        }
        $("#recordId").val(Data.id);
        $("#alarmId").val(Data.alarmId);
        $("#alarmType").val(Data.type);
        var  localBlkUrl=Data.localBlkUrl!=undefined?Data.localBlkUrl:"1";
        var  imageUrl;
        if(Data.imageUrl){
        	imageUrl = Data.imageUrl.split(";")[0]!=undefined?Data.imageUrl.split(";")[0]:"1";
        }
        //初始默认不展示预览、回放及轨迹功能
        $(".rightPreview").hide();
        //若是门禁人员相关告警，则显示头像，否则隐藏
        $("#rightDivPromptDataDiv .promptDataDivDetail").css("margin-top","0px");
        $("#rightDivPromptDataDiv .rightDivPromptDataDiv-header").css("min-height","260px");

        var panoramaImg = Data.panoramaImgURL;
        if (Data.channelId) {
            //全景图
            $("#eventCaptureImg").attr("onerror","imgeTrackErrorfun(\'"+panoramaImg+"\','/images/" +systemSkin + "defaultImg/defaultPers.png')");
            $(".rightPreview-track").attr("onclick","getPersonFaceTrack("+JSON.stringify(Data)+")");
            $(".rightPictureDivTitle").show();
            $(".rightPreview").show();
        } else {
            $(".rightPictureDivTitle").hide();
            $(".rightPreview").hide();
            if(Data.objType != null && Data.objType != undefined && Data.objType != 0) {
                $("#rightDivPromptDataDiv .rightDivPromptDataDiv-header").css("min-height","160px");
                $("#rightDivPromptDataDiv .promptDataDivDetail").css("margin-top","-105px");
            }
        }
        if (Data.objType == "3" || Data.objType == "4"){
            // 设备事件或组件事件
            $("#specificInformation").html("").hide();
            $("#rightDivPromptDataDiv .rightDivPromptDataDiv-header").css("min-height","115px");
            if (null != photoURL && "" != photoURL && undefined != photoURL) {
                $("#rightDivPromptDataDiv .promptDataDivDetail").css("margin-top","");
                $("#rightDivPromptDataDiv .rightDivPromptDataDiv-header").css("min-height","220px");
            }
        } else if (panoramaImg) {
            $("#rightDivPromptDataDiv .promptDataDivDetail").css("margin-top","0px");
            $("#rightDivPromptDataDiv .rightDivPromptDataDiv-header").css("min-height","260px");
        }
    }

    function getShowPic(photo, title) {
        if(title == null || title == ""){
            title = I18n.getValue('map_track_capturePhoto');
        }
        var capturePhotoHtml = "";
        capturePhotoHtml += "<div style='width: 100%; height: 99.5%; float: left; text-align: center; background-color: black;'>" +
            "<img src='"+ photo + "' onerror=\"this.src='/images/vid_capture_failed.png'\" style='height: 100%; width: 100%' /></div>";
        $.jBox.open(capturePhotoHtml, "&nbsp;&nbsp;"+title, 580, 450, {
            id:"capturePhoto${uuid!}",
            opacity: 0.3,
            top: 'calc(50% - 225px)',
            showIcon: 'jbox-title-icon-video',
            buttons: { }
        });
    }

    /**
     * 添加告警级别颜色和国际化
     */
    function translateEvent(eventObj) {
        var eventLevel="";
        var eventLevelColor="";
        var levelValue = eventObj.eventLevelVal;
        //告警级别 1:紧急 2:严重 3:一般 4:提示
        eventObj.eventLevel = definedLevelMap.get(levelValue + "");
        eventObj.eventLevelColor = definedLevelColorArray[levelValue % 10];
        // 模块名称转换
        eventObj.sourceModuleName = moduleNameMap.get(eventObj.sourceModule);
    }


    /**
     * 过千处理
     * @param time
     * @returns {string}
     */
    function million(value){
        let num;
        //大于9999显示x.xx千
        if(value>999999){
            num ="999K+"
        }else if(value > 999||value==999){
            num=(Math.floor(value/100)/10) + 'K';
        }else if( value < 999 && value>-999){
            num=value
        }else if(value<-999||value==-999){//小于-9999显示-x.xx万
            num = -(Math.floor(Math.abs(value)/100)/10)+'K'
        }
        return num;
    }

    /**
     * 时间戳转时间
     * @param time
     * @returns {string}
     */
    function transformTime(inputTime) {
        var date = new Date(inputTime);
        var y = date.getFullYear();
        var m = date.getMonth() + 1;
        m = m < 10 ? ('0' + m) : m;
        var d = date.getDate();
        d = d < 10 ? ('0' + d) : d;
        var h = date.getHours();
        h = h < 10 ? ('0' + h) : h;
        var minute = date.getMinutes();
        var second = date.getSeconds();
        minute = minute < 10 ? ('0' + minute) : minute;
        second = second < 10 ? ('0' + second) : second;
        return y + '-' + m + '-' + d+' '+h+':'+minute+':'+second;
    };

    /**
     * entityId 获取最近事件
     */
    function openDoorEventWindow(entityId){
        var id="/skip.do?page=acc_rtMonitor_accTransactionsTodayLast&eventPointType=0&eventPointId="+entityId;
        var opts = {//弹窗配置对象
        path: id,//设置弹窗路径
        width: 1000,//设置弹窗宽度
        height: 300,//设置弹窗高度
        title: I18n.getValue('acc_doorEventLatestHappen'),//设置弹窗标题
        gridName: "gridbox"//设置grid
        };
        DhxCommon.createWindow(opts);
    }

    function openGateEventWindow(entityId) {
        var id="/skip.do?page=psg_rtMonitor_psgTransactionsTodayLast&eventPointType=0&eventPointId="+entityId;
        var opts = {//弹窗配置对象
            path: id,//设置弹窗路径
            width: 1000,//设置弹窗宽度
            height: 300,//设置弹窗高度
            title: I18n.getValue('psg_gateEventLatestHappen'),//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        DhxCommon.createWindow(opts);
    }

    /**iclient弹出预览窗口的中心计算*/
    function getCenterTop(){
        return (window.innerWidth - 480) / 2;
    }
    function getCenterLeft(){
        return (window.innerHeight - 350) / 2;
    }

    /**
     * 根据vidChannelId 获取视频预览
     */
    function getVideoPreviewByVidChannelId(entityId, deviceName){
        var offlineObj = $("#" + entityId + "_image").attr("class");
        // 设备离线
        if (offlineObj && offlineObj.indexOf("gray") != -1) {
            openMessage(msgType.error, "common_dev_offlinePrompt")
            return;
        }
        /**getDeviceByChannelId(entityId, function (result) {
            var resultData = result.data;
            var domainCode=resultData.domainCode;
            var channelCode=resultData.channelCode;
            var deviceName=resultData.deviceName;
            var channelType=resultData.channelType;
            showLiveVideo(deviceName, channelType, channelCode + "#" + domainCode, getCenterTop(), getCenterLeft(), 'center');
        })*/
        loadPlayVideo(entityId);
    }



    /**
     * 根据vidChannelId 获取视频回放
     */
    function getVideoReplayByVidChannelId(vidChannelId){
        getDeviceByChannelId(vidChannelId,function (result) {
            var resultData = result.data;
            var nvrCode=resultData.nvrCode;
            var cameraCode=resultData.deviceSn;
            var startTime=20200429010201;
            var endTime=20200429173506;
            videoReplayPopup(startTime,endTime,cameraCode,nvrCode);
        })
    }

    /**
     * 根据CameraId 获取告警的详情
     * @param vidChannelId
     */
    function getAlarmDetailByCameraId(cameraId) {
        var postData= {
                "pageNo" :0,
                "pageSize" :10,
                "elementEntityId":cameraId,
                "eventLevelValIn" :$("#echartsPie_legend").val()
        }
        listAlarmItemByPage(postData,function (result) {
            if(result.data.length>0){
                var resultData = result.data[0];
                var type=resultData.sourceModule;
                var id=resultData.id;
                // 可能是左边点击或者右键点击地图上的元素查询数据
                var cameraId=resultData.entityId || resultData.sourceKey;
                commentInfo(id,type,cameraId);
            }else{
               //暂无数据
                openMessage(msgType.warning, I18n.getValue('map_alarm_noWarning'));
            }

        })
    }

    /**
     * 地图点位设备详情界面
     * @param startTime
     * @param endTime
     * @param cameraCode
     * @param nvrCode
     */
    function mapPosDeviceInfoPopup(entityId,type) {
        var  width=450;
        var  height=500;
        switch (type) {
            case "AccDoor":
                  width=450;
                  height=300;
                break;
            case "VidChannel":
                  width=650;
                  height=340;
                break;
        }
        var opts = {//弹窗配置对象
            path: "/mapElement.do?getElementDeviceInfoView&entityId="+entityId,
            //设置弹窗路径
            width: width,//设置弹窗宽度
            height: height,//设置弹窗高度
            title: I18n.getValue("map_title_info"),//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        w1 =  DhxCommon.createWindow(opts);
    }

}


/**
 * 远程数据操作
 */
 {

    /**
     * 请求告警记录
     * @param callback
     */
    function listAlarmItemByPage(postData,callback) {
        $.ajax({
            type: "post",
            url: "/mapMonitoring.do?listAlarmItemByPage",
            dataType: "json",
            data: postData,
            async: true,
            success: function(result)
            {
                if(result.ret == "ok") {
                    return callback(result);
                }else{
                    messageBox({messageType:"alert",text: result.msg});
                }
            }
        });
    }

    /**
     * 请求告警统计
     * @param callback
     */
    function totalAlarmLevelCount(postData,callback) {
        $.ajax({
            type: "post",
            url: "/mapMonitoring.do?getAlarmEventCount",
            dataType: "json",
            data: postData,
            async: true,
            success: function(result)
            {
                if(result.ret == "ok") {
                    return callback(result);
                }else{
                    messageBox({messageType:"alert",text: result.msg});
                }
            }
        });
    }

     /**
      * 确认告警
      * @param callback
      */
     function confirmAlarmReq(recordId,remark,callback) {
        //检查非法字符
        var checkUnChar = false;
        var unchar = [ '&', '<', '>', '`', '~', '!', '@', '#', '$', '%', '^', '*', '?', '/', '|', '\\', ':', ';', '=', '"', '\'', ',','--', '+'];
        for (var i = 0; i < unchar.length; i++) {
            if (remark.indexOf(unchar[i]) >= 0) {
                checkUnChar = true;
            }
        }
        if(checkUnChar){
            messageBox({messageType:"alert",text: I18n.getValue("common_prompt_unIncludeChar")});
            return false;
        }
         $.ajax({
             type: "post",
             url: "/mapMonitoring.do?confirmAlarm",
             dataType: "json",
             data: {
                 "recordId" :recordId,
                 "eventRemark":remark
             },
             async: true,
             success: function(result)
             {
                 if(result.ret == "ok") {
                     return callback(result);
                 }else{
                     messageBox({messageType:"alert",text: result.msg});
                 }
             }
         });
     }


     /**
      * 批量操作设备
      * @param callback
      */
     function bulkOperationsReq(postData,callback) {
         $.ajax({
             type: "post",
             url: "/mapMonitoring.do?bulkOperations",
             dataType: "json",
             data:postData,
             async: true,
             success: function(result)
             {
                 if(result.ret == "ok") {
                     return callback(result);
                 }else{
                     messageBox({messageType:"alert",text: result.msg});
                 }
             }
         });
     }

     /**
      * 通过摄像机名称查channelId
      * @param callback
      */
     function getChannelIdByName(CameraName,callback) {
         $.ajax({
             type: "GET",
             url:  "/vidChannel.do?getChannelIdByName&CameraName="+CameraName,
             dataType: "json",
            /* data: {"CameraName" :CameraName},*/
             async: true,
             success: function(result)
             {
                 if(result.ret == "ok") {
                     return callback(result);
                 }else{
                     messageBox({messageType:"alert",text: result.msg});
                 }
             }
         });
     }
     /**
      * 通过channelId 查询设备详情
      * @param callback
      */
     function getDeviceByChannelId(channelId,callback) {
         $.ajax({
             type: "GET",
             url:  "/mapMonitoring.do?getDeviceByChannelId&channelId="+channelId,
             dataType: "json",
             async: true,
             success: function(result)
             {
                 if(result.ret == "ok") {
                     return callback(result);
                 }else{
                     messageBox({messageType:"alert",text: result.msg});
                 }
             }
         });
     }

};


/**
 * 远程数据操作
 */
{


    /**
     * 获取告警详情
     * @param id
     */
    function getAlertsAlarmDetail(id,type,callback){
        /*id 为空提示，不显示*/
        if(id == null ||id == "" || id == undefined){
            return;
        }else{
            $.ajax({
                type: "GET",
                url: "/mapMonitoring.do?getAlarmDetail&id="+id,
                dataType: "json",
                async: false,
                success: function(data)
                {
                    if(data.success) {
                        return callback(data.data);
                    }else{
                        messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
                    }
                },
                error:function (XMLHttpRequest, textStatus, errorThrown)
                {
                    messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
                }
            });
        }

    }


    /**
     *播放视频事件
     * @param e
     */
    function vidPreview(channelId){
        //请求后端获取摄像机数据 channelId, channelName
        onLoading(function(){
            //请求后端
            $.ajax({
                type: "POST",
                url: "/vidChannel.do?getVidPreviewParam&channelId="+channelId,
                dataType: "json",
                async: true,
                success: function(retData) {
                    closeMessage();
                    if(retData[sysCfg.ret] == sysCfg.success)//成功
                    {

                        if(retData.data == null || retData.data.length == 0){
                            openMessage(msgType.warning, I18n.getValue('vid_vidRtPatrol_info') );
                            return;
                        }
                        $.popUpVideo(retData.data,"vid","vid");
                    }
                    else {
                        openMessage(msgType.warn, retData.msg, 1800);
                    }

                }
            });
        });
    }
}


/**
 * 渲染
 */

{
var currentEchartsNameValueMap = new Map();
var currentEchartsNameList = [];
    function alramEcharsPie(divId, names, brower, total, nameValueMap, selectedNames, callback){
        map_alramEcharsPie_Data.set("names",names);
        map_alramEcharsPie_Data.set("brower",brower);
        map_alramEcharsPie_Data.set("total",total);
        currentEchartsNameValueMap = nameValueMap;
        currentEchartsNameList = names;
        // var names = [1,2,3,4]; //类别数组（用于存放饼图的类别）
        // var brower = [{name:1,value:100},{name:2,value:200},{name:3,value:300},{name:4,value:400}];
        // 基于准备好的dom，初始化echarts实例
        // $(document.getElementById('echartsPie')).html('');
        var myChart = echarts.init(document.getElementById(divId));
        myChartsObj = myChart;
        // 解决点击事件调用n次的问题
        // 1、清除画布
        myChart.clear();
        // 2、调用setOption
        myChart.setOption({ //加载数据图表
            title : {
                text:million(total),
                x:'center',
                y:'center',
                top:'center',
                textStyle:{
                    fontSize:14,
                    color: echarsWordColor,
                    fontWeight:'800'
                }
            },
            legend: {
                orient: 'horizontal',
                /*type: 'scroll',*/
                left: 'center',
                bottom: 0,
                itemWidth: 10,
                itemHeight: 10,
                inactiveColor: '#a4adb4',
                icon: 'circle',
                textStyle: {
                	color: echarsWordColor,
                	fontSize: 12
                },
                data: names,
                selected: selectedNames
            },
            // color:['#ff4d4f', '#ff8c4d','#d5c300','#5fd97a'],
            series: [
                {
                    type: 'pie',
                    selectedMode: 'single',
                    radius: [0, '30%'],
                    label: {
                        position: 'inner'
                    },
                    labelLine: {
                        show: false
                    },
                    color: 'rgba(0, 0, 0, 0)',
                    data: [
                        {value: 1, name: ''}
                    ]
                },{
                name: 'MapMonitorEcharts',
                type: 'pie',
                radius: ['40%', '60%'], //图的大小
                center: ['50%', '50%'], //图的位置，距离左跟上的位置
                data: brower,
                labelLine:{
                    normal:{
                        length:0
                    }
                },
                selectedMode: 'single',
                selectedOffset: 0,
                itemStyle: {
                    emphasis: {
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowColor: 'rgba(0, 0, 0, 0.5)'
                    },
                    normal: {
                        label:{
                            show: true,
                            color: echarsWordColor,
                            formatter: '{c}'
                        },
                        color: function(params) {
                            return new echarts.graphic.LinearGradient(1, 0, 0, 0, [{ //颜色渐变函数 前四个参数分别表示四个位置依次为左、下、右、上
                                offset: 0,
                                color: definedLevelColorArray[params.data.levelIndex % 10]
                            }, {
                                offset: 1,
                                color: definedLevelColorArray[params.data.levelIndex % 10]
                            }])
                        }
                    }
                }

            }]
        });

        ///3、在渲染点击事件之前先清除点击事件
        myChart.off('click');
        myChart.off('legendselectchanged');

        myChart.on('legendselectchanged', function (params) {
            var name = params.name;
            var selected = params.selected;
            // myChart.setOption(option);
            var postData="";
            $.each(selected,function(key,values){
                if(values){
                    postData+=currentEchartsNameValueMap.get(key)+",";
                }
            });
            createCookie("echartsLevelSelected", postData == ""? "empty" : postData);
            $("#echartsPie_legend").val(postData);
            $("#conversation").html("");
            renderAlarmData();
        });

        myChart.on('click', 'series.pie.label', function (params) {
            if(""==params.name){
                var name="";
                for(var i=0;i<currentEchartsNameList.length;i++){
                    if(i==0){
                        name=currentEchartsNameList[i];
                        myChart.dispatchAction({
                            type: 'legendUnSelect',
                            name: currentEchartsNameList[i],
                        })
                    }else{
                        myChart.dispatchAction({
                            type: 'legendSelect',
                            name: currentEchartsNameList[i],
                        })
                    }
                }
                myChart.dispatchAction({
                    type: 'legendToggleSelect',
                    name: name,
                })
            }else{
                for(var i=0;i<currentEchartsNameList.length;i++){
                    myChart.dispatchAction({
                        type: 'legendUnSelect',
                        name: currentEchartsNameList[i],
                    })
                }
                myChart.dispatchAction({
                    type: 'legendToggleSelect',
                    name: params.name,
                })
            }

        });
        myChart.on('click', function (params) {
        });
        if(undefined!=callback){
            return callback(myChart);
        }
        //
        // myChart.on('rendered', function () {
        //       console.log("rendered")
        // });
        //
        // myChart.on('finished', function () {
        //         console.log("finished")
        // });


    }

    /**
     * 渲染饼图，并且在饼图渲染之后根据事件类型进行数据加载
     */
    function renderAlramEcharsPie(callback) {
        if (CONST.getValue("MonitorCenter_menuId") != "mapMonitoring.do") {
            clearInterval(eChartCountRefreshHandler);
            eChartCountRefreshHandler = null;
            return;
        }
        var alarmType='';
        if(undefined!=ZKUI.Combo.get("selectAlarmType")){
            alarmType=ZKUI.Combo.get("selectAlarmType").getValue()
        }
        var postData={
            "eventType" :alarmType,
        }
        /*初始化饼图*/
        totalAlarmLevelCount(postData,function (data) {
            var names=[];
            var selectedNames = {};
            var brower=[];
            var nameValueMap = new Map();
            var total=0;
            var eventLevelValIn = [];
            // var names = [1,2,3,4]; //类别数组（用于存放饼图的类别）
            // var brower = [{name:1,value:100},{name:2,value:200},{name:3,value:300},{name:4,value:400}];
            if(data.success) {
                var result = data.data;
                var levelSelected = getCookie("echartsLevelSelected");
                for(var i=0;i<result.length;i++){
                    var counter = result[i];
                    names.push(counter.eventLevelName);
                    if(levelSelected == null || levelSelected.indexOf(counter.eventLevel) != -1){
                        brower.push({
                            name: counter.eventLevelName,
                            value: counter.eventLevelCount,
                            levelIndex: parseInt(counter.eventLevel)
                        });
                        total += parseInt(counter.eventLevelCount);
                        selectedNames[counter.eventLevelName] = true;
                        eventLevelValIn.push(counter.eventLevel);
                    }else{
                        brower.push({
                            name: counter.eventLevelName,
                            value: 0,
                            levelIndex: parseInt(counter.eventLevel)
                        });
                        selectedNames[counter.eventLevelName] = false;
                    }
                    nameValueMap.set(counter.eventLevelName, counter.eventLevel)
                }
                // 饼图初始化查询所有级别的报警
                $("#echartsPie_legend").val(eventLevelValIn);
                alramEcharsPie('echartsPie',names,brower, total, nameValueMap, selectedNames);
                if (callback) {
                    callback();
                }
            }

        })
    }


    /**
     * 渲染告警列表，每次拿20条数据，由于滚动刷新是根据最后一条数据的时间进行过滤的，所以每次获取前20条即可
     * 如果同一秒内有超过20条记录，下拉刷新的数据可能缺失
     */
    var mapScrollAvailablePageNo = 0;
    function renderAlarmData(isScroll) {
    	var selectAlarmType = "";
    	var selectAlarmTypeId = "selectAlarmType";
    	if(ZKUI.Combo.get(selectAlarmTypeId) != null && ZKUI.Combo.get(selectAlarmTypeId) != "" && ZKUI.Combo.get(selectAlarmTypeId) != undefined){
    		selectAlarmType = ZKUI.Combo.get(selectAlarmTypeId).combo.getSelectedValue();
    	}
        var postData={
            "pageNo" :mapScrollAvailablePageNo,
            "pageSize" :20,
            "sourceModuleIn" :selectAlarmType,
            "eventLevelValIn" :$("#echartsPie_legend").val()
        }
        // 如果是滚动更新，查询最底部的一条记录之后的数据
        if (isScroll){
            postData.endTime = $(".comment:last").data("eventtime");

            // 60s后限制左侧列表的数据，如果超过限制条数，后续推送来的数据将会清除原先的数据
            mapEventListLengthLimitSwitch = false;
            if (mapEventListSwitchTimeout != null){
                clearTimeout(mapEventListSwitchTimeout);
            }
            mapEventListSwitchTimeout = setTimeout(function(){
                mapEventListLengthLimitSwitch = true;
                // 滚动条复位
                $("#conScroll")[0].scrollTop = 0 ;
            }, 60000);
        }
        listAlarmItemByPage(postData,function (result) {
            if(result.ret == "ok") {
                if(result.data){
                    var $html="";
                    var eventData="";
                    var skipEventTimes = 0;
                    //告警级别 1:紧急 2:严重 3:一般 4:提示
                    for(var i=0;i<result.data.length;i++){
                        eventData= result.data[i];
                        translateEvent(eventData);
                        var eventTimeStamp = new Date(eventData.eventTime).getTime();
                        if (!eventTimeStamp) {
                            eventTimeStamp = eventData.eventTime;
                        }
                        // 每次刷新获取的时候，如果左侧列表没有这个报警事件才加上，防止重复展示
                        if ($(".comment[data-id='"+eventData.id+"']").length == 1){
                            skipEventTimes ++;
                            continue;
                        }
                        $html+="<div class=\"comment\" data-eventtime='"+eventTimeStamp+"' data-id='"+eventData.id+"' style='background-color: rgba(51, 60, 66, 0.5)' >\n" +
                            "    <div class=\"comment-header\" style='background-color: "+eventData.eventLevelColor+"'></div>\n" +
                            "    <div class=\"comment-header-left\">\n" +
                            "        <div class=\"left-title\" title=\"" + eventData.eventName + "\" >"+eventData.eventName+"</div>\n"+
                            "        <div class=\"left-info\" data-id='"+eventData.id+"' data-cameraname='"+eventData.sourceName+"' data-cameraid='"+eventData.sourceKey+"' data-type='"+eventData.alarmType+"' title='" + eventData.sourceName + "'>" +
                            "           <span class=\"right-span icv-mapcenter_devLocation\" data-cameraname='"+eventData.sourceName+"' data-cameraid='"+eventData.sourceKey+"' onclick=\"alarmDeviceMapLocation(this)\" style=\"display: inline;font-size: 14px;cursor: pointer;\" title=\"" + I18n.getValue('map_gis_location') + "\">" + "</span>"+eventData.sourceName+"</div>\n" +
                            "        <div class=\"left-info\">"+eventData.eventTimeStr+"</div>\n" +
                            "    </div>\n" +
                            "    <div class=\"comment-header-right\"  >\n" +
                            "        <div class=\"right-title\" style='background-color: "+eventData.eventLevelColor+"'>\n" + eventData.eventLevel +
                            "        </div>\n" +
                            "        <div class=\"right-info\" style=\"\">\n" +
                            "            <span class=\"right-span icv-system_detail\" title=\"" + I18n.getValue('map_detail') + "\" style=\"font-size: 18px;cursor: pointer;\" onclick=\"commentInfo('" + eventData.id+"','"+eventData.sourceModule +"','"+eventData.sourceKey+"')\" >\n" +
                            "            </span>\n" +
                            "        </div>\n" +
                            "    </div>\n" +
                            "</div>";
                    }
                    if(""!=$html){
                        $("#conversation").append($html);
                    }
                    if (skipEventTimes == 20){
                        mapScrollAvailablePageNo ++;
                        renderAlarmData(isScroll);
                    } else {
                        mapScrollAvailablePageNo = 0;
                    }
                }
            }else{
                messageBox({messageType:"alert",text: result.msg});
            }

            $("#conversation .comment").off("click").click(function(){
                $("#conversation .comment").removeClass("active");
                $(this).addClass("active");
            })
        })

    }

    /**
     * 渲染图片
     * @param src
     */
    function imgeTrackErrorfun(url,defaultUrl){
        var imgElement=event.srcElement;
        imgElement.src=defaultUrl;
        if(""== url){
            imgElement.onerror=null;
            return;
        }
        var repeat = 3;  // 限制执行次数为3次
        var timer= window.setInterval(function () {
            if (repeat == 0) {
                //去掉定时器的方法
                window.clearInterval(timer);
            } else {
                repeat--;
                var img =new Image();
                if (url.indexOf("data:image/jpg;base64") == -1) {
                    img.src = url+"?="+(Math.random()*1000);
                    $("#eventCaptureImg").css("cursor","pointer");
                }else{
                    img.src = url;
                    $("#eventCaptureImg").css("cursor","pointer");
                }
                // 如果图片已经存在于浏览器缓存，直接调用回调函数
                img.onload = function () {
                    if(img.complete) {// 如果图片已经存在于浏览器缓存，直接调用回调函数   
                        imgElement.src=img.src;
                        window.clearInterval(timer);
                    }
                }
            }
        },1000);
        imgElement.onerror=null;
    }

}




/**
 * 页面事件
 */
{


/*
js由毫秒数得到年月日
使用： (new Date(data[i].creationTime)).Format("yyyy-MM-dd hh:mm:ss.S")
*/
Date.prototype.Format = function (fmt) { //author: meizz
    var o = {
        "M+": this.getMonth() + 1, //月份
        "d+": this.getDate(), //日
        "h+": this.getHours(), //小时
        "m+": this.getMinutes(), //分
        "s+": this.getSeconds(), //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds() //毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
};

    /**
     * 显示弹窗面板
     */
    function showPopuppanel(id) {
        $("#"+id).css("left","");
        $("#"+id).css("top","7px");
        $("#"+id).removeClass("displayCss");
        $("#"+id).stop().animate({
            width: "391px"
        },300,function () {

        })
    }

    /**
     * 下拉选择选择刷新列表
     */
    function selectAlarmType() {
        //$("#echartsPie_legend").val("");
        renderAlramEcharsPie(RefreshAlarmList);
        //RefreshAlarmList();
    }

    /**
     * 确认告警的事件
     */
    function confirmAlarm() {
        var alertsAlarmId=$("#recordId").val();
        var eventRemark = $("#event_remark").val();
        confirmAlarmReq(alertsAlarmId,eventRemark,function (result) {
            /*刷新列表并关闭*/
            //RefreshAlarmList();
            renderAlramEcharsPie(RefreshAlarmList);
            openMessage(msgType.success, result.msg, 2000);
        });
    }



    //点击查详情
    function commentInfo(eventId, eventType, cameraId) {
    	if("undefined" != typeof mapMainBase){
    		mapMainBase.deviceMapLocation(cameraId);
    	}
        $(".rightPictureDivTitle").show();
        $(".rightPreview").show();
        getAlertsAlarmDetail(eventId, eventType, function(eventData){
            translateEvent(eventData);
            renderAlarmDetail(eventData);
        })
        /*右边详情显示*/
        if($("#rightDivPrompt").hasClass("displayCss")){
            $("#rightDivPrompt").removeClass("displayCss");
            if(mapMain_left == "left"){
            	$("#rightDivPrompt").stop().animate({right: "10px"},500);
            }else{
            	$("#rightDivPrompt").stop().animate({left: "20px"},500);
            }
        }
        var alertDataHeight,reportHeight;
        if($(".rightPictureDivTitle").is(":hidden")){
        	alertDataHeight = -20;
        }else{
        	alertDataHeight = $(".rightDivTitle ").height() + $(".rightPictureDivTitle").height() + $(".rightPreview").height();
        }
        reportHeight = $(".rightDivPromptDataDiv-content").height() - alertDataHeight - 25;
        $("#event_remarkDiv").css("height",reportHeight);
        window.addEventListener("resize", function() {
        	if($(".rightPictureDivTitle").is(":hidden")){
            	alertDataHeight =  -20;
            }else{
            	alertDataHeight = $(".rightDivTitle ").height() + $(".rightPictureDivTitle").height() + $(".rightPreview").height();
            }
            reportHeight = $(".rightDivPromptDataDiv-content").height() - alertDataHeight - 25;
            $("#event_remarkDiv").css("height",reportHeight);
        });
    }
}


/**
 * 视频播放的事件
 */
{
    /** IE不支持日期字符串转成日期对象,用这个函数转换一下 */
    function strFormatDate(str){
        return new Date(Date.parse(str.replace(/-/g, "/")));
    }
    /**
     * 点击视频播放的事件
     * souce: 点击来源 1:列表 2：详情
     */
    function videoRePlay(source,e) {
        var cameraName;
        var cameraType;
        var cameraCode;
        var parentDeviceId;
        var channelCode;
        var eventTime;
        var endTime;
        if (source == "track"){
            var id = $(e).attr("data-camerasn");
            var recordtime = $(e).attr("data-recordtime");
            startTime = new Date(parseInt(recordtime) - 10000).format("yyyy-MM-dd HH:mm:ss");
            endTime = new Date(parseInt(recordtime) + 10000).format("yyyy-MM-dd HH:mm:ss");
            /**getDeviceByChannelId(id, function(result){
                var Data = result.data;
                cameraName = Data.deviceName;
                cameraType = Data.channelType;
                cameraCode = Data.channelCode + "#" + Data.domainCode;
                showReplayVideo (cameraCode, eventTime);
            })*/
            loadPlaybackVideo(startTime, endTime, id);
        } else if (source == "detail"){
            channelId = $("#channelId").val();
            // 取yyyy-mm-dd hh:mm:ss 格式事件时间
            eventTime = $("#eventTime").find("input").eq(0).val();
            startTime = new Date(new Date(strFormatDate(eventTime)).getTime() - 10000).format("yyyy-MM-dd HH:mm:ss");
            endTime = new Date(new Date(strFormatDate(eventTime)).getTime() + 10000).format("yyyy-MM-dd HH:mm:ss");
            loadPlaybackVideo(startTime, endTime, channelId);
        }
    }
    /**
     * 点击视频播放的事件
     * souce: 点击来源 1:列表 2：详情
     */
    function videoPlay(souce,e,videoParams) {
        var channelId = $("#channelId").val();
        loadPlayVideo(channelId);
        // getChannelIdByName(alramCameraName,function (result) {
        //     var channelId=result.data[0].id
        //     vidPreview(channelId);
        // })
    }

    /**
    * 告警列表定位地图和设备
    */
    function alarmDeviceMapLocation(e) {
        var name = $(e).data("cameraname");
        var cameraid = $(e).data("cameraid");
        if(cameraid != undefined && cameraid != "" && cameraid != "undefined"){
            $.ajax({
                type: "POST",
                url: "/mapElement.do?getDeviceMapLocation",
                dataType: "json",
                data:{"entityId" : cameraid},
                async: true,
                success: function(result)
                {
                    if(result.ret == "ok") {
                        loadMapAndDeviceLocation(result.data["mapId"], result.data["entityId"]);
                    }else{
                        openMessage(msgType.warning, I18n.getValue("map_no_search_device"));
                    }
                }
            });
        }
    }
}

/**
 *
 * @param id
 * @param nScrollHight //滚动距离总长(注意不是滚动条的长度)
 * @param nScrollTop  //滚动到的当前位置
 * @param nDivHight  //滚动到的当前位置
 *
 * @param callback
 */
var mapEventLastScrollTime = 0 ;
function scrollInit(id,nScrollHight,nScrollTop,nDivHight,callback) {
    /*初始化滚动事件*/
    $("#"+id).scroll(function(){
        nDivHight = $("#"+id).height();
        nScrollHight = $(this)[0].scrollHeight;
        nScrollTop = $(this)[0].scrollTop;
        var paddingBottom = parseInt( $(this).css('padding-bottom') ),paddingTop = parseInt( $(this).css('padding-top') );
        if(nScrollTop + paddingBottom + paddingTop + nDivHight + 1>= nScrollHight && (new Date().getTime() > mapEventLastScrollTime + 300)){
            callback();
            mapEventLastScrollTime = new Date().getTime();
        }
    });
}

/*初始化告警页面弹窗*/
function initPrompt(){

        /*关闭设备搜索弹窗*/
        if(!$("#searchMarkerToMapPrompt").hasClass("displayCss")){
            if(mapMain_left == "left"){
                $("#searchMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                    $("#searchMarkerToMapPrompt").addClass("displayCss")
                });
            }else{
                $("#searchMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                    $("#searchMarkerToMapPrompt").addClass("displayCss")
                });
            }
        }

        /*关闭批量弹窗*/
        if(!$("#bulkOperationsDivPrompt").hasClass("displayCss")){
            $('#bulkOperations_deviceList_clear').click();
            if(mapMain_left == "left"){
                $("#bulkOperationsDivPrompt").stop().animate({right: "-360px"},500,function () {
                    $("#bulkOperationsDivPrompt").addClass("displayCss")
                });
            }else{
                $("#bulkOperationsDivPrompt").stop().animate({left: "-360px"},500,function () {
                    $("#bulkOperationsDivPrompt").addClass("displayCss")
                });
            }
             /*1普通地图 2gis地图 3google地图*/
           switch(window.tempMapType){
               case "1":
                    break;
               case "2":
                    ol.Observable.unByKey(mapKeyBoxend);
                    ol.Observable.unByKey(mapKeyBoxstart);
                    // 还原鼠标样式
                    mapMainGis.modificarEstiloDeMouse("auto");
                    if (dragBox != null){
                        //移除交互绘制控件
                        gisMap.removeInteraction(dragBox);
                    }
                   break;
               case "3":
                    // 还原鼠标样式
                    mapMainGoogle.modificarEstiloDeMouse("auto");
                    google.maps.event.removeListener(mapMouseDownEvent);
                    google.maps.event.removeListener(mapMouseUpEvent);
                   break;
           }
        }

        /*打开告警弹窗*/
        $("#leftDivPromptDataDiv").removeClass("displayCss");
        $("#leftDivPrompt").removeClass("displayCss");
        if(mapMain_left == "left"){
            $(".ol-scale-line").stop().animate({marginRight:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icon-arrow").removeClass("icon-increase");
                $("#icon-arrow").addClass("icon-decrease");
                $("#leftDivPrompt").addClass("map_alarm_activation");
            });
        }else{
            $(".ol-scale-line").stop().animate({marginLeft:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icon-arrow").removeClass("icon-decrease");
                $("#icon-arrow").addClass("icon-increase");
                $("#leftDivPrompt").addClass("map_alarm_activation");
            });
        }
         /*情况弹窗界面*/
        $("#peopleFaveDiv").hide();
        $("#vehicleTrackPrompt").addClass("displayCss");
        $("#personFaceTrackPrompt").addClass("displayCss");
        $("#bookmark").addClass("displayCss");
        $("#vehicleTrackConversation").html("");
        $("#personFaceTrackConversation").html("");
        $("#bookmark_content").html("");

}

//新增的节点需要重新绑定click
$("#conversation .comment").off("click").click(function(){
    $("#conversation .comment").removeClass("active");
    $(this).addClass("active");
})

/**
 * 初始化事件
 */
var _initEvent = function() {

    //滚动监听事件
    scrollInit("conScroll",0,0,0,function () {
        renderAlarmData(true);
    });


    scrollInit("bulkOperationsConScroll",0,0,0,function () {
    });
    //滚动监听事件
    $('#conScroll').on('scroll', function(){
    });

    /*是否开启自动推送的事件*/

    $("#toggle-button").off('click').on('click',function(){
        if($('#toggle-button').is(':checked')){
            //数据初始化
            selectAlarmType();
            subscribeEvent();
        }else{
            unsubscribeEvent();
        }
    });

    /*开启自动推送*/
    setTimeout(function(){
        $("#toggle-button").click();
    },600);


    /*详情确认告警提交事件*/
    $("#confirm").off('click').on('click',function(){
        confirmAlarm();
    });

    /*详情确认告警取消事件*/
    $("#cancel").off('click').on('click',function(){
        if(!$("#rightDivPrompt").hasClass("displayCss")){
        	if(mapMain_left == "left"){
        		$("#rightDivPrompt").stop().animate({right: "-20%"},500,function () {
            		$("#rightDivPrompt").addClass("displayCss")
            	});
            }else{
            	$("#rightDivPrompt").stop().animate({left: "-20%"},500,function () {
            		$("#rightDivPrompt").addClass("displayCss")
            	});
            }
        }
    });

     $('.device-nav-tabs li').off('click').on('click',function(){
        // 优化之前多个if写法渲染，type类型：门、摄像机或其他(地图/防区等),label名称
        var type = $(this).find('a').data("type");
        var label = $('#searchDeviceTab').find(".active a").html();
        if ("AccDoor" == type || "VidChannel" == type) {
            label = "";
        } else if ("other" == type) {
            type = $('#dropdownContent').data("type");
            if (!type) {
                return;
            }
            label = $("a[href='#" + type + "Tab']").html();
        }
        mapMainBase.renderDeviceZtree(type + "ZTree", type, false);
        $("#dropdownContent").html(label);
        $("#dropdownContent").data("type", type);
    });

    /*设备列表添加点位关闭*/
    $('#searchMarkeCloseButton').off('click').on('click',function(){
        if(!$("#searchMarkerToMapPrompt").hasClass("displayCss")){
            if(mapMain_left == "left"){
                $("#searchMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                    $("#searchMarkerToMapPrompt").addClass("displayCss")
                });
            }else{
                $("#searchMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                    $("#searchMarkerToMapPrompt").addClass("displayCss")
                });
            }
        }
        $("#leftDivPromptDataDiv").removeClass("displayCss");
        $("#leftDivPrompt").removeClass("displayCss");
        if(mapMain_left == "left"){
            $(".ol-scale-line").stop().animate({marginRight:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icons_left_side").attr("src","/public/images/icons-open.png");
                $("#leftDivPrompt").addClass("map_alarm_activation");
            });
        }else{
            $(".ol-scale-line").stop().animate({marginLeft:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icons_left_side").attr("src","/public/images/icons-close.png");
                $("#leftDivPrompt").addClass("map_alarm_activation");
            });
        }
    });

    /**
     * 关闭视频预览弹窗的事件
     */
    $('#modal_2').on('hide.bs.modal', function(result) {
        try{
            vidIvsOCX.setCleanUp(function () {
                $("#modal_2_device").html("");
                $("#modal_2_ocx").html("");
            });
        }catch (e) {
            $("#modal_2_device").html("");
            $("#modal_2_ocx").html("");
        }finally {

        }
    })


    /**
     * 视频设备列表视频预览
     */
     $('#modal_2_device_hide').off('click').on('click',function(){
        if($('#modal_2_device_hide').hasClass("modal_activation")){
            $('#modal_2_device_hide').removeClass("modal_activation");
            if(mapMain_left == "left"){
            	$("#modal_2_device_content").stop().animate({
            		right: 0
            	},300,function () {
            		$("#modal_2_device_hide").find("img").attr("src","/public/images/icons-close.png");
            		$("#modal_2_content").css({
            			"border-top-right-radius": "0",
            			"border-bottom-right-radius": "0",
            		})
            	});
            	$("#modal_2_content_title").stop().animate({right:"-70px"},300);
            }else{
            	$("#modal_2_device_content").stop().animate({
            		left: 0
            	},300,function () {
            		$("#modal_2_device_hide").find("img").attr("src","/public/images/icons-open.png");
            		$("#modal_2_content").css({
            			"border-top-left-radius": "0",
            			"border-bottom-left-radius": "0",
            		})
            	});
            	$("#modal_2_content_title").stop().animate({left:"-70px"},300);
            }
        }else{
            $('#modal_2_device_hide').addClass("modal_activation");
            if(mapMain_left == "left"){
            	$("#modal_2_device_content").stop().animate({
            		right: 200
            	},300,function () {
            		$("#modal_2_device_hide").find("img").attr("src","/public/images/icons-open.png");
            		$("#modal_2_content").css({
            			"border-top-right-radius": "3px",
            			"border-bottom-right-radius": "3px",
            		})
            	});
            	$("#modal_2_content_title").stop().animate({right:0},300);
            }else{
            	$("#modal_2_device_content").stop().animate({
            		left: 200
            	},300,function () {
            		$("#modal_2_device_hide").find("img").attr("src","/public/images/icons-close.png");
            		$("#modal_2_content").css({
            			"border-top-left-radius": "3px",
            			"border-bottom-left-radius": "3px",
            		})
            	});
            	$("#modal_2_content_title").stop().animate({left:0},300);
            }
        }
    });

    /**
     * 关闭视频预览弹窗的事件
     */
    $('#modal_1').on('hide.bs.modal', function(result) {
        try{
            $("#bulkOperations_deviceList_check").removeClass("displayCss");
            $("#bulkOperations_deviceList_clear").removeClass("displayCss");
            $("#confirmBulkOperations").removeClass("displayCss");
            $("#cancelBulkOperations").removeClass("displayCss");
            $("#bulkOperationsConversation .operating-span").removeClass("displayCss");
            $("#bulkOperationsConversation .operating-span_play").addClass("displayCss");
            vidIvsOCX.setCleanUp(function () {
                $("#modal_1_ocx").html("");
            });
        }catch (e) {

        }finally {

        }
    })

    $('#modal_1_close').off('click').on('click',function(){
        //手动关闭
        $("#modal_1").modal('hide');
        $('#cancelBulkOperations').click();
    });

   $('#modal_1_op_close').off('click').on('click',function(){
        //手动关闭
        $("#modal_1").modal('hide');
        $('#cancelBulkOperations').click();
    });

    $("#bookmark").mouseover(function(){
        $(this).stop().animate({
            width: "140px",
        },300,function () {

        }).mouseout(function(){
            $(this).stop().animate({
                width:"10px"
            });
        });
    });
};

/**
 * 初始化视图
 */
var mapMainMonitor_initView = function() {
    /**
     * 左侧边栏 显示或隐藏
     */
     $('#leftDivPromptImgDiv').off('click').on('click',function(){
        if($("#leftDivPrompt").hasClass("map_alarm_activation")){
        	if(mapMain_left == "left"){
        		$(".ol-scale-line").stop().animate({marginRight:"0%"},500);
        	}else{
        		$(".ol-scale-line").stop().animate({marginLeft:"0%"},500);
        	}
            $('#leftDivPrompt').stop().animate({
                width: "10px"
            },500,function(){
            	if(mapMain_left == "left"){
            		$("#icon-arrow").removeClass("icon-decrease");
                    $("#icon-arrow").addClass("icon-increase");
            	}else{
            	    $("#icon-arrow").removeClass("icon-increase");
                    $("#icon-arrow").addClass("icon-decrease");
            	}
                $("#leftDivPrompt").removeClass("map_alarm_activation");
                $("#leftDivPromptDataDiv").addClass("displayCss");

            });
        }else{
            $("#leftDivPromptDataDiv").removeClass("displayCss");
            if(mapMain_left == "left"){
        		$(".ol-scale-line").stop().animate({marginRight:"26%"},500);
        	}else{
        		$(".ol-scale-line").stop().animate({marginLeft:"26%"},450);
        	}
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
            	if(mapMain_left == "left"){
            		$("#icon-arrow").removeClass("icon-increase");
                    $("#icon-arrow").addClass("icon-decrease");
            	}else{
            	    $("#icon-arrow").removeClass("icon-decrease");
                    $("#icon-arrow").addClass("icon-increase");
            	}
                $("#leftDivPrompt").addClass("map_alarm_activation");
            });
            //饼图自适应
            if(myChartsObj != null){
                myChartsObj.resize();
            }
        }
    })

    /**
     * 显示或隐藏
     */
    $('#rightDivPrompButton').off('click').on('click',function(){
        if($("#rightDivPrompt").hasClass("displayCss")){
        	if(mapMain_left == "left"){
        		$("#rightDivPrompt").removeClass("displayCss").stop().animate({left: "20px"},500);
            }else{
            	$("#rightDivPrompt").removeClass("displayCss").stop().animate({right: "10px"},500);
            }
        }else{
        	if(mapMain_left == "left"){
        		$("#rightDivPrompt").stop().animate({left: "-20%"},500,function () {
                	$("#rightDivPrompt").addClass("displayCss")
                });
        	}else{
        		$("#rightDivPrompt").stop().animate({right: "-20%"},500,function () {
        			$("#rightDivPrompt").addClass("displayCss")
        		});
        	}
        }

    })
    /**
     * 显示或隐藏
     */
    $('#personFacePrompButton').off('click').on('click',function(){
        $(function () {
            $("#personFaceTrackPrompt").stop().animate({
                width: "0px"
            },500,function(){
                $("#personFaceTrackPrompt").addClass("displayCss");
            })
        })
    })

    /**
     * 人员轨迹关闭
     */
    $('#personFaceTrackPrompt_close').off('click').on('click',function(){
        $("#peopleFaveDiv").hide();
        $(function () {
            $("#personFaceTrackPrompt").stop().animate({
                width: "0px"
            },500,function(){
                $("#personFaceTrackPrompt").addClass("displayCss");
                $("#bookmark").addClass("displayCss");
                $("#personFaceTrackConversation").html("");
                $("#bookmark_content").html("");
                mapTree.refreshItem();
            })
        })

    })

    /**
     * 车辆轨迹关闭
     */
    $('#vehicleTrackPrompt_close').off('click').on('click',function(){
        $("#peopleFaveDiv").hide();
        $(function () {
            $("#vehicleTrackPrompt").stop().animate({
                width: "0px"
            },500,function(){
                $("#vehicleTrackPrompt").addClass("displayCss");
                $("#bookmark").addClass("displayCss");
                $("#vehicleTrackConversation").html("");
                $("#bookmark_content").html("");
                mapTree.refreshItem();
            })
        })
    })

    /**
     * 显示或隐藏
     */
    $('#vehiclePrompButton').off('click').on('click',function(){
        $(function () {
            $("#vehicleTrackPrompt").stop().animate({
                width: "0px"
            },500,function(){
                $("#vehicleTrackPrompt").addClass("displayCss");
            })
        })

    })

    /*初始化饼图*/
    renderAlramEcharsPie();
    /*初始化告警列表*/
    //renderAlarmData();
};


/**
 * 初始化
 */
$(function() {
    //数据初始化
    mapMainMonitor_initView();
    //事件初始化
    _initEvent();

});














