I18n.load([
    "base_map_delEntity",
    "map_alarm_queryRecord",
    "map_show_photo",
    "map_manual_alarm",
    "acc_eventNo_8",
    "acc_eventNo_9",
    "acc_newEventNo_233",
    "acc_newEventNo_234",
    "acc_eventNo_7",
    "acc_rtMonitor_remoteNormalOpen",
    "common_rtMonitor_enableIntradayTZ",
    "common_rtMonitor_disableIntradayTZ",
    "acc_map_gis_input_device_name",
    "map_navigation_preview",
    "map_marker_add_prompt"
], true);

//保存地图门的数据
var doorIds = "";

/**
 * 本地方法弹框
 */
var popup= {

    /**
     * 新增弹窗
     * @param path
     * @param dataObjData
     */
    addMapPosPoPup:function (path,dataObjData) {
        path = path + "&width=" +dataObjData;
        var title;
        if(path.indexOf("AccDoor")>0){
            title = I18n.getValue("map_addDoor");
        }else{
            title = I18n.getValue("map_addChannel");
        }
        var opts = {
            path: path,
            width: 880,
            height: 510,
            title: title,
            gridName: "gridbox"

        };
        DhxCommon.createWindow(opts);
    },
};

/**
 * 远程数据操作
 */
var remoteHttp = {



};



/**
 * 事件
 */
var _initEvent = function(mapMainGoogle) {


    /*** 地图放大 */
     mapMainGoogle.zoomInGeneralMap = function zoomInGeneralMap(){
        googleMap.setZoom(googleMap.getZoom()+1);
    }

      /**  * 地图缩小  */
    mapMainGoogle.zoomOutGeneralMap = function zoomOutGeneralMap(){
            googleMap.setZoom(googleMap.getZoom()-1);
    }

    /*开启修改视野的功能*/
    mapMainGoogle.modifyView = function modifyView(){
        var srcImg;
        if(undefined==$("#modifyViewImg").html()){
            /*开启*/
            var markWidth= parseFloat($(tempMapId).width())/2-parseFloat(90);
            var markHeight= parseFloat($(tempMapId).height())/2-parseFloat(90);
            centerXNum=24.611016,
            centerYNum=118.049005;
            var imgHtml='<div id="modifyViewImg"  class="center-arrow" style="left: '+markWidth+'px; top: '+markHeight+'px;" >'+
                        '<img  src="/images/googleMap/positioning.svg" width="182" height="182"  >'+
                        '</div>';
             $(tempMapId).append(imgHtml);
             $("#modifyView").addClass("saveButton");
             $("#modifyView span").removeClass("icv-mapcenter_modifyView").addClass("icv-mapcenter_saveView");
        }else{
            //关闭保存视野
            var  lat= parseFloat(googleMap.getCenter().lat());
            var  lng= parseFloat(googleMap.getCenter().lng());
            var  Zoom= parseInt(googleMap.getZoom());
            var postData={
                "id":mapId,
                "googleCenterX":lat,
                "googleCenterY":lng,
                "googleInitialLevel":Zoom,
                "mapType": "Google"
            }
            mapMainBase.saveAccMapMain(postData,function(result){
                openMessage(msgType.success,result.msg);
                $("#modifyViewImg").remove();
                $("#modifyView").removeClass("saveButton");
            })
             $("#modifyView span").removeClass("icv-mapcenter_saveView").addClass("icv-mapcenter_modifyView");
        }
        $("#modifyView").css("background-image","url("+srcImg+")");
    }


     /*移除点位到地图*/
    mapMainGoogle.delEntityToMap = function delEntityToMap(marker){
       var mapId = mapTree.getAllChecked();
       if(mapId != "" && mapId != "0" && mapId.indexOf("_")<0){
            var getData="&ids="+marker.mapElementId+"&name="+marker.deviceName;;
            mapMainBase.delGisMapPos(getData,marker,function(result,marker){
                 marker.setMap(null);
                 googleMapPosMap.delete(marker);
                 if(typeof(deleteZtreeNode) == 'function'){
                      deleteZtreeNode(marker.entityId);
                 }
                 $(".contextmenu").hide();
                 openMessage(msgType.success, result.msg);
            })
       }else{
           messageBox({messageType:"alert",text: I18n.getValue("base_map_plSelMap")});//${base_map_plSelMap}://请选择地图
       }
    }

    /** 修改图标 */
     mapMainGoogle.modifyEntityIcon = function modifyEntityIcon(marker) {
        mapId = mapTree.getAllChecked();
        if(mapId != "" && mapId != "0" && mapId.indexOf("_") < 0) {
            var path = "/mapElement.do?getModifyElementIconView&id=" + marker.mapElementId + "&entityType=" + marker.entityType
                + "&name=" + marker.deviceName;
            var opts = {//弹窗配置对象
                path: path,//设置弹窗路径
                width: 400,//设置弹窗宽度
                height: 200,//设置弹窗高度
                title: I18n.getValue("base_map_modifyIcon"),//设置弹窗标题
                gridName: "gridbox"//设置grid

            };
            DhxCommon.createWindow(opts);
            // 菜单隐藏
            $(".contextmenu").hide();
        } else {
            // 请选择地图
            messageBox({messageType:"alert",text: I18n.getValue("base_map_plSelMap")});
        }
     }

    /*搜索标记点位*/
    mapMainGoogle.searchMarker = function searchMarker(id){
            try{
                googleMapPosMap.forEach(function(marker,key){
                        if(id==marker.mapElementId){
                            if(undefined!=infoBubble){
                                  infoBubble.close();
                            }
                            var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                                        "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                                            "<span aria-hidden='true'>×</span>"+
                                           " <span class='sr-only'>Close</span>"+
                                       " </button>"+
                                        "<div style='border-radius: 15px;height: 40px;'>" +
                                        "</br>"+marker.title+"</div></div>";
                            infoBubble = new InfoBubble({
                                  map: googleMap,
                                  content: content,
                                  minWidth: 120,
                                  minHeight: 50,
                                  position: mapMainGoogle.getInfoPosition(marker),
                                  shadowStyle: 1,
                                  padding: 0,
                                  backgroundColor: 'rgba(0, 0, 0,.4)',
                                  borderRadius: 15,
                                  arrowSize: 10,
                                  borderWidth: 1,
                                  borderColor: 'rgba(0, 0, 0,.4)',
                                  disableAutoPan: true,
                                  hideCloseButton: true,
                                  arrowPosition: 30,
                                  backgroundClassName: 'phoney',
                                  borderStyle: 'none',
                                  arrowStyle: 2
                            });
                            if(marker.entityType == "DefendArea"){
                                infoBubble.open(googleMap);
                            }else{
                                infoBubble.open(googleMap, marker);
                            }
                           googleMap.panTo(marker.getPosition());
                           throw new Error("ending");//报错，就跳出循环
                        }
                });
            }catch(e){
            }
    }


    /*搜索标记点位*/
    mapMainGoogle.searchMarkerByDeviceId = function searchMarkerByDeviceId(deviceId,name){
        try{
                    if(undefined!=deviceId&&null!=deviceId&&""!=deviceId){
                          googleMapPosMap.forEach(function(marker,key){
                                    if(deviceId==marker.entityId){
                                            if(undefined!=infoBubble){
                                                  infoBubble.close();
                                            }
                                            var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                                                        "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                                                            "<span aria-hidden='true'>×</span>"+
                                                           " <span class='sr-only'>Close</span>"+
                                                       " </button>"+
                                                        "<div style='border-radius: 15px;height: 40px;'>" +
                                                        "</br>"+marker.title+"</div></div>";
                                            infoBubble = new InfoBubble({
                                                  map: googleMap,
                                                  content: content,
                                                  minWidth: 120,
                                                  minHeight: 50,
                                                  position: mapMainGoogle.getInfoPosition(marker),
                                                  shadowStyle: 1,
                                                  padding: 0,
                                                  backgroundColor: 'rgba(0, 0, 0,.4)',
                                                  borderRadius: 15,
                                                  arrowSize: 10,
                                                  borderWidth: 1,
                                                  borderColor: 'rgba(0, 0, 0,.4)',
                                                  disableAutoPan: true,
                                                  hideCloseButton: true,
                                                  arrowPosition: 30,
                                                  backgroundClassName: 'phoney',
                                                  borderStyle: 'none',
                                                  arrowStyle: 2
                                            });
                                            if(marker.entityType == "DefendArea"){
                                                infoBubble.open(googleMap);
                                            }else{
                                                infoBubble.open(googleMap, marker);
                                            }
//                                        infowindow.close(googleMap, marker);
//                                        infowindow = new google.maps.InfoWindow();
//                                        infowindow.setContent("<div class='detail-info poPupImage ' style='color:black;'>"+marker.title+"</div>");
//                                        infowindow.open(googleMap, marker);
                                        // googleMap.setZoom(14);
                                       googleMap.panTo(marker.getPosition());
                                        throw new Error("ending");//报错，就跳出循环
                                    }
                          });
                    }
                    if(undefined!=name&&null!=name&&""!=name){
                        googleMapPosMap.forEach(function(marker,key){
                                  if(name==marker.deviceName){

                                      if(undefined!=infoBubble){
                                            infoBubble.close();
                                      }
                                      var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                                                  "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                                                      "<span aria-hidden='true'>×</span>"+
                                                     " <span class='sr-only'>Close</span>"+
                                                 " </button>"+
                                                  "<div style='border-radius: 15px;height: 40px;'>" +
                                                  "</br>"+marker.title+"</div></div>";
                                      infoBubble = new InfoBubble({
                                            map: googleMap,
                                            content: content,
                                            minWidth: 120,
                                            minHeight: 50,
                                            position: mapMainGoogle.getInfoPosition(marker),
                                            shadowStyle: 1,
                                            padding: 0,
                                            backgroundColor: 'rgba(0, 0, 0,.4)',
                                            borderRadius: 15,
                                            arrowSize: 10,
                                            borderWidth: 1,
                                            borderColor: 'rgba(0, 0, 0,.4)',
                                            disableAutoPan: true,
                                            hideCloseButton: true,
                                            arrowPosition: 30,
                                            backgroundClassName: 'phoney',
                                            borderStyle: 'none',
                                            arrowStyle: 2
                                      });
                                      if(marker.entityType == "DefendArea"){
                                          infoBubble.open(googleMap);
                                      }else{
                                          infoBubble.open(googleMap, marker);
                                      }
                                       googleMap.panTo(marker.getPosition());
                                         throw new Error("ending");//报错，就跳出循环
                                   }
                        });
                    }
                   //openMessage(msgType.warning, I18n.getValue("map_no_search_device"), 1000);
        }catch(e){

        }
    }


    /*浮动信息关闭*/
    mapMainGoogle.closePoPupInfoNews = function closePoPupInfoNews(e){
           if(undefined!=infoBubble){
                 infoBubble.close();
           }
    }

    /*根据设备点位entityId地图定位*/
    mapMainGoogle.searchMarkerByEntityId = function searchMarkerByEntityId(entityId){
        try{
                    if(undefined!=entityId&&null!=entityId&&""!=entityId){
                        googleMapPosMap.forEach(function(marker,key){
                                  if(entityId==marker.entityId){
                                        if(undefined!=infoBubble){
                                              infoBubble.close();
                                        }
                                        var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                                                    "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                                                        "<span aria-hidden='true'>×</span>"+
                                                       " <span class='sr-only'>Close</span>"+
                                                   " </button>"+
                                                    "<div style='border-radius: 15px;height: 40px;'>" +
                                                    "</br>"+marker.title+"</div></div>";
                                        infoBubble = new InfoBubble({
                                          map: googleMap,
                                          content: content,
                                          minWidth: 120,
                                          minHeight: 50,
                                          position: mapMainGoogle.getInfoPosition(marker),
                                          shadowStyle: 1,
                                          padding: 0,
                                          backgroundColor: 'rgba(0, 0, 0,.4)',
                                          borderRadius: 15,
                                          arrowSize: 10,
                                          borderWidth: 1,
                                          borderColor: 'rgba(0, 0, 0,.4)',
                                          disableAutoPan: true,
                                          hideCloseButton: true,
                                          arrowPosition: 30,
                                          backgroundClassName: 'phoney',
                                          borderStyle: 'none',
                                          arrowStyle: 2
                                        });
                                        if(marker.entityType == "DefendArea"){
                                            infoBubble.open(googleMap);
                                        }else{
                                            infoBubble.open(googleMap, marker);
                                        }
                                       googleMap.panTo(marker.getPosition());
                                         throw new Error("ending");//报错，就跳出循环
                                   }
                        });
                 }
        }catch(e){

        }
    }



    /** 开启点位拖动功能*/
    mapMainGoogle.saveDrag = function saveDrag(){
        mapId = mapTree.getAllChecked();
        if($("#drag").hasClass("saveButton")){
                /*关闭拖动保存*/
               mapMainBase.saveMapPos();
               //srcImg="/public/gis/images/adjustTheCoordinate_1.png";
               $("#drag span").removeClass("icv-mapcenter_saveCoordinate").addClass("icv-mapcenter_adjustCoordinate");
               $("#drag").removeClass("saveButton");
        }else{
              googleMapPosMap.forEach(function(marker,key){
                   marker.setDraggable(true);
                   if(marker.entityType == "DefendArea"){
                       marker.setEditable(true);
                   }
              });
             //srcImg="/public/gis/images/adjustTheCoordinateFinish_1.png";
             $("#drag span").removeClass("icv-mapcenter_adjustCoordinate").addClass("icv-mapcenter_saveCoordinate");
             $("#drag").addClass("saveButton");
        }
    }

    /*开启轨迹的功能*/
    mapMainGoogle.addLocusToMap = function addLocusToMap(cameraSnList,cameraDataList){
            //动画结束
            function showinfomessage(marker, personImage, listPicData) {
                var $html = "<div align=\"center\" id='popup-"+marker.mapElementId+"'  onclick=\"showMorePicByPersonTrack(\'"+listPicData+"\');\"   class=\"picview\" style='width: 120px;height: 120px;' >" +
            				"<img src='"+personImage+"'  onerror=\"mapMainBase.imgeTrackErrorfun(\'"+personImage+"\','/images/" +systemSkin + "defaultImg/defaultPers.png');\"  style='width: 100%;height: 100%'>"+
            				"</div>"
                // 创建信息窗口对象
                var infoWindow = new google.maps.InfoWindow({
                    content: $html
                });
                infoWindow.open(googleMap, marker);
                google.maps.event.addListener(marker,"click", function () {
                    // 打开信息窗口
                    mapMainGoogle.getInfoPosition(marker)
                    infoWindow.open(googleMap,marker);
                });
            }

//            function animateCircle() {
//                var count = 0;
//                window.setInterval(function() {
//                    count = (count + 1) % 200;
//
//                    var icons = line.get('icons');
//                    icons[0].offset = (count / 2) + '%';
//                    line.set('icons', icons);
//                }, 20);
//            }
//
//              var trackPoints = []
//             // Google地图轨迹坐标集   纬度，经度  或使用ajax后台读取
//              googleMapPosMap.forEach(function(marker,key){
////                    if(cameraSnList.includes(marker.mapElementId)){
//                    if(cameraSnList.indexOf (marker.mapElementId)!=-1){
//                        var cameraData=cameraDataList[cameraSnList.indexOf (marker.mapElementId)];
//                        var listPicData=cameraData.listPicData;
//                        var  personImage;
//                        for (var key in listPicData[0]) {
//                            if("downloadPhoto" != key){
//                                var da = listPicData[0][key]; //获取对应的value值
//                                var url = da.split("_and_"); //new Date(key).format("yyyy-MM-dd HH:mm:ss")
//                                personImage=url[0];
//                                break;
//                            }
//                        }
//                        var lat=marker.getPosition().lat();
//                        var Lng=marker.getPosition().lng();
//                        trackPoints.push(new google.maps.LatLng(lat, Lng))
//                        //创建标注窗口
//                        showinfomessage(marker, personImage);
//                        googleMap.panTo(marker.getPosition());
//                    }
//              });
//
//            var trackPath = new google.maps.Polyline({
//                path: trackPoints,
//                strokeColor: "#FF0000", // 线条颜色
//                strokeOpacity: 1.0,     // 线条透明度
//                strokeWeight: 2         // 线条粗细
//            });
//            trackPath.setMap(googleMap);
//            //动画开始
//            var lineSymbol = {
//                path: google.maps.SymbolPath.CIRCLE,
//                scale: 8,
//                strokeColor: '#393'
//            };
//            line = new google.maps.Polyline({
//                path: trackPoints,
//                icons: [{
//                    icon: lineSymbol,
//                    offset: '100%'
//                }],
//                map: googleMap
//            });
//            animateCircle();

            var directionsService = new google.maps.DirectionsService;
           	var directionsDisplay = new google.maps.DirectionsRenderer;
           	directionsDisplay.setMap(googleMap);
            directionsDisplay.setOptions( { suppressMarkers: true } );

            var googleLatLng=[];
            var deviceMapLocationMark=false;
           	 googleMapPosMap.forEach(function(marker,key){
                    if(cameraSnList.indexOf (marker.entityId)!=-1){
                        var cameraData=cameraDataList[cameraSnList.indexOf (marker.entityId)];
                        var lat=marker.getPosition().lat();
                        var Lng=marker.getPosition().lng();
                        googleLatLng.push(new google.maps.LatLng(lat, Lng));
                        //创建标注窗口
                        if(cameraData.coverPicUrl != "" && undefined != cameraData.listPicData && cameraData.listPicData.length > 0){
                            var listPicDataStr = window.btoa(JSON.stringify(cameraData.listPicData));
                            var personImage = cameraData.listPicData[0].thumPicUrl;
                            //创建标注窗口
                            showinfomessage(marker, cameraData.coverPicUrl, listPicDataStr);
                        }
                        /*划线的同时定位*/
                        if(!deviceMapLocationMark){
                              deviceMapLocationMark=true;
                              var deviceId = marker.entityId;
                              try{
                                     if(undefined!=deviceId&&null!=deviceId&&""!=deviceId){
                                          googleMapPosMap.forEach(function(marker,key){
                                                    if(deviceId==marker.entityId){
                                                       googleMap.panTo(marker.getPosition());
                                                        throw new Error("ending");//报错，就跳出循环
                                                    }
                                          });
                                    }
                              }catch(e){

                              }
                        }
                    }
              });

           	calculateAndDisplayRoute(directionsService, directionsDisplay);
            function calculateAndDisplayRoute(directionsService, directionsDisplay) {
                    var waypts = [];
                    var request = {
                           origin: "",
                           destination:"",
                           optimizeWaypoints: true,
                           waypoints: waypts,
                           travelMode: google.maps.DirectionsTravelMode.DRIVING
                    };
                    if(googleLatLng.length<2){
                            return;
                    }
                    for(var i=0;i<googleLatLng.length;i++){
                        if(i==0){
                            request["origin"]=googleLatLng[i];
                            continue;
                        }
                        if(i==googleLatLng.length-1){
                            request["destination"]=googleLatLng[i];
                             continue;
                        }
                         waypts.push({
                            location: googleLatLng[i],
                            stopover: true
                        });
                    }
                    request["waypoints"]=waypts;
                    directionsService.route(request, function(response, status) {
                        if (status === google.maps.DirectionsStatus.OK) {
                            directionsDisplay.setDirections(response);
                        } else {
                            messageBox({messageType: "alert", text: I18n.getValue("map_track_googleApiFail")});
                        }
                   });
            }
    }



    /*批量功能面板开启*/
    mapMainGoogle.bulkOperations = function bulkOperations(thisHtml){
            var title=$(thisHtml).html();
            var bulkOperations=$(thisHtml).attr("value");
            var bulkOperationsType=$(thisHtml).data("type");
            $("#bulkOperationsConversation").html("");
            var $html="<p style='color: white;font-size: 24px;margin-top:200px'>"+I18n.getValue("map_alarm_no_device")+"</p>";
            $("#bulkOperationsConversation").append($html).css("background","none");
            $("#bulkOperations_deviceList_count").html("");
            $("#bulkOperations_deviceList_count").val(0);
            var mark=false;
            try{
                googleMapPosMap.forEach(function(marker,key){
                             if(bulkOperationsType==marker.entityType){
                                   mark=true;
                                    throw new Error("ending");//报错，就跳出循环
                             }
                 });
            }catch(e){
            }

            $("#popupbuttonMenu .dropdown").css("overflow","hidden");
            $('.dropdown').stop().animate({
                width: "0px"
            },300,function(){
                $("#popupbuttonMenu").html("");
            });
            if(!mark){
                messageBox({messageType:"alert",text: I18n.getValue("map_bulkOperations_prompt_2")});
                return;
            }
            $("#bulkOperationsDivPrompt-title").html(title);
            $("#bulkOperationsDivPrompt-title").data("val",bulkOperations);
            $("#bulkOperationsDivPrompt-title").data("type",bulkOperationsType);

            $("#dropLeft-menu").addClass("displayCss");

             if(!$("#searchMarkerToMapPrompt").hasClass("displayCss")){
                 if(mapMain_left == "left"){
                     $("#searchMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                         $("#searchMarkerToMapPrompt").addClass("displayCss")
                     });
                 }else{
                     $("#searchMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                         $("#searchMarkerToMapPrompt").addClass("displayCss")
                     });
                 }
             }

            if(mapMain_left == "left"){
                $('#leftDivPrompt').stop().animate({
                    width: "0px"
                },500,function(){
                    $("#icon-arrow").removeClass("icon-increase");
                    $("#icon-arrow").addClass("icon-decrease");
                    $("#leftDivPrompt").removeClass("map_alarm_activation");
                    $("#leftDivPromptDataDiv").addClass("displayCss");
                });
                $("#icon-arrow").removeClass("icon-increase");
                $("#icon-arrow").addClass("icon-decrease");
                $(".ol-scale-line").css("margin-right","0%");
                $("#bulkOperationsDivPrompt").removeClass("displayCss").stop().animate({left: 0},500);
                $("#bulkOperationsConversation").css("text-align","center");
            }else{
                $('#leftDivPrompt').stop().animate({
                    width: "0px"
                },500,function(){
                    $("#icon-arrow").removeClass("icon-decrease");
                    $("#icon-arrow").addClass("icon-increase");
                    $("#leftDivPrompt").removeClass("map_alarm_activation");
                    $("#leftDivPromptDataDiv").addClass("displayCss");
                });
                $("#icon-arrow").removeClass("icon-decrease");
                $("#icon-arrow").addClass("icon-increase");
                $(".ol-scale-line").css("margin-left","0%");
                $("#bulkOperationsDivPrompt").removeClass("displayCss").stop().animate({right: 0},500);
            }
            // 修改鼠标样式
            mapMainGoogle.modificarEstiloDeMouse("crosshair");

            //开启框选功能
            var gribBoundingBox = null;
            var mapMouseEvent;
            mapMouseDownEvent = google.maps.event.addListener(googleMap, 'mousedown', function (e) {
                if(e.nb.button==0){
                        //左键禁止拖动
                        googleMap.setOptions({
                            draggable: false,
                            scrollwheel: true
                        });
                }
                 if(e.nb.button==2){
                        //右键开启拖动
                        googleMap.setOptions({
                            draggable: true,
                            scrollwheel: true
                        });
                }
                gribBoundingBox = new google.maps.Rectangle({
                    map: googleMap,
                    bounds: new google.maps.LatLngBounds(e.latLng,e.latLng),
                    fillOpacity: 0.15,
                    strokeWeight: 0.9,
                    strokeColor:"#0078D7",
                    fillColor:"#AACCEE",
                    clickable: false
                });
                mapMouseEvent= google.maps.event.addListener(googleMap, 'mousemove', function (e) {
                    gribBoundingBox.setBounds(gribBoundingBox.getBounds().extend(e.latLng));
                });
            });
             mapMouseUpEvent = google.maps.event.addListener(googleMap, 'mouseup', function (e) {
                       //开启拖动
                      googleMap.setOptions({
                          draggable: true,
                          scrollwheel: true
                      });
                     gribBoundingBox.setMap(null);
                     google.maps.event.removeListener(mapMouseEvent);
                      /*获取坐在坐标矩阵中的标记点并添加到批量设备中*/
                     var type=$("#bulkOperationsDivPrompt-title").data("type");
                     googleMapPosMap.forEach(function(marker,key){
                             if(null!=marker&&gribBoundingBox.getBounds().contains(marker.getPosition())){
                                 mapMainGoogle.addDeviceDivForBulkOperations(marker,type);
                             }
                     });
            });

    }

     /*添加点位到批量面板上*/
    mapMainGoogle.addDeviceDivForBulkOperations = function addDeviceDivForBulkOperations(marker,type){
         var $html="";
         var deviceId=marker.entityId;
         var mark=true;
         var deviceListcount=1;
         var bulkOperationsDeviceId_count_mark=false;
         $("#bulkOperationsConversation .bulkOperationsDeviceId").each(function(){
             bulkOperationsDeviceId_count_mark=true;
             if(deviceId==$(this).val()){
                 mark=false;
                 return false;
             }else{
                 deviceListcount++;
             }
         })
         if(mark){
             if(type==marker.entityType){
                 //var imgPath=marker.icon;
                 var imgPath = "/images/"+ systemSkin +"/map/acc_door.png";
                 var deviceName=marker.deviceName;
                 var sn=marker.SN;
                 var detailStr = I18n.getValue("map_detail");
                 $html+="<div class=\"comment\" >\n" +
                     "                        <span class=\"right-span\"  style='position:relative;' onclick=\"deviceMapLocation(null,\'"+deviceName+"')\">\n" +
                     "                            <img src='"+imgPath+"'  class=\"right-icon \" />\n" +
                     "                            <i id='play_i_"+deviceId+"' class=\"tip displayCss\"></i>"+
                     "                        </span>\n" +
                     "                        <span class=\"info-span\"  title='"+deviceName+"'>\n" +
                     deviceName +
                     "                        </span>\n" +
                     "                        <span class=\"operating-span_infoDevice icv-system_detail\" title='"+detailStr+"' style='font-size: 18px;margin: calc(50% - 136px);' onclick='mapMainBase.infoDevice(this)'>\n" +
                     "                        </span>\n" +
                     "                        <span class=\"operating-span_delDevice icv-common_op_del\" onclick='delDevice(this)' style='font-size: 18px;margin: calc(50% - 136px);'>\n" +
                     "                        </span>\n" +
                     "                        <span  id='play_"+deviceId+"'  class=\"operating-span_play displayCss\" >\n" +
                     "                            <img  src='/images/alarm/icons_play_1.png' onclick='playDevice(this)' style='padding-left:2px;width: 20px;height: 20px'/>\n" +
                     "                        </span>\n" +
                     "<input style='display: none;' id='"+deviceId+"' class='bulkOperationsDeviceId' data-type='"+type+"' data-name='"+deviceName+"' data-sn='"+sn+"' value='"+deviceId+"'/>" +
                     "</div>";
             }
             if(""!=$html){
                 if(!bulkOperationsDeviceId_count_mark){
                     $("#bulkOperationsConversation").html("");
                 }
                 $("#bulkOperationsConversation").prepend($html);
                 $("#bulkOperations_deviceList_count").html("("+deviceListcount+")");
                 $("#bulkOperations_deviceList_count").val(deviceListcount);
             }
         }
    }
};

/**
 * 初始化视图
 */
var _initView = function(mapMainGoogle) {


        /**  更新地图上门的全局变量*/
        mapMainGoogle.updateDoorIds =  function updateDoorIds() {
                  doorIds = "";
                  googleMapPosMap.forEach(function(marker,key){
                        if(marker.entityType == "AccDoor" ){
                                var doorId =marker.entityId;
                                doorIds += "," +doorId;
                        }
                  });
        }
        //处理Gis地图设备状态数据
        mapMainGoogle.dealGoogleMapDevStateData =function dealGoogleMapDevStateData() {
                var doorStates = mapClient.devData;
                var iconImage;
                var iconFolderName;
                if(doorStates == "" || doorStates == null || doorStates == undefined){
                    return;
                }
                if (sysCfg.skin == "techblue") {
                    iconImage = "/public/skins/techblue/imgs/doorState.png";
                } else {
                    iconImage = "/images/doorState/doorState.png";
                }
                for(var i = 0; i < doorStates.length; i++){
                    var id = doorStates[i].uniqueKey;
                    iconFolderName = doorStates[i].iconFolderName;
                    // 偏移获取所有门禁图标，修改图标状态
                     googleMapPosMap.forEach(function(marker,key){
                        var entityId = marker.entityId;
                        var entityType = marker.entityType;
                         if(entityId == id) {
                            var icon;
                            if (entityType == "AccDoor") {
                                var offsetCss = mapMainBase.doorIconChange("googleMap", iconFolderName, doorStates[i].image);
                                var offsetCssX = offsetCss[0].replace(/-/,"");
                                var offsetCssY = offsetCss[1].replace(/-/,"");
                                icon = {
                                    url: iconImage,
                                    size: new google.maps.Size(40, 40),
                                    origin: new google.maps.Point(offsetCssX, offsetCssY)
                                };
                            } else if (entityType == "PsgGate") {
                                iconImage = "/images/gateState/" + sysCfg.skin + "/icon/" + iconFolderName + "/gate_" + doorStates[i].image +".png";
                                icon = {
                                    url: iconImage,
                                    size: new google.maps.Size(40, 40),
                                }
                            }
                            marker.setIcon(icon);
                            if ((undefined == accMapDeviceAlarmMap.get(doorStates[i].devSn) || doorStates[i].image != accMapDeviceAlarmMap.get(doorStates[i].devSn))
                                                                                             && ("alarm_nosensor_old" == doorStates[i].image || "alarm_nosensor" == doorStates[i].image)) {
                                 var color = '#ff4d4f';
                                 //更改告警状态前，去除旧的告警状态效果
                                 $("#circle_" + doorStates[i].devSn).remove();
                                 /*改变点位的状态*/
                                 var contentHtml='<div id="circle_'+doorStates[i].devSn+'" style="width: 100px;height: 100px; position: absolute; left: -51px;  top: -72px;"  class="wave ripple danger">'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'"></div>'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                                '</div>'
                                 richMarker =new RichMarker({
                                          position: marker.getPosition(),
                                          map: googleMap,
                                          content:contentHtml,
                                          shadow:"none",
                                 });
                                 googleMap_richMarker_Map.set(marker.entityId,richMarker);
                            }
                            if(doorStates[i].image.indexOf("alarm_nosensor") == -1 && $("#circle_" + doorStates[i].devSn).length > 0) {
                                 $("#circle_" + doorStates[i].devSn).remove();
                            }
                        }
                     });
                }
        }

     /*告警监控google地图改变点位状态*/
      mapMainGoogle.googleMapAlarms =function googleMapAlarms(index,alarmLevel,deviceState, exEntityId){
             if(null==googleMapPosMap||googleMapPosMap.size<1){
                        return;
             }
             var entityId = index;
             if (!entityId) {
                 entityId = exEntityId;
             }
             googleMapPosMap.forEach(function(marker,key){
                       if(entityId == marker.entityId){
                              /*判断是否改变*/
                             try{
                                 var deviceAlarm = alarmLevel;
                                 if ("undefined" != typeof accMapDeviceAlarmMap) {
                                     deviceAlarm = accMapDeviceAlarmMap.get(entityId);
                                 }
                                  if(undefined == deviceAlarm || deviceState != deviceAlarm["status"]){
                                          if("VidChannel" == marker.entityType){
                                               mapMainGoogle.updateCameraStatus(deviceState,marker);
                                          }
                                  }
                                  if(undefined == deviceAlarm || alarmLevel != deviceAlarm["alarmLevel"]){
                                      // 地图展示告警信息
                                      mapMainGoogle.googleMapAlarmsState(entityId,alarmLevel,marker);
                                  }

                             }catch (e) {

                             }
                       }

                       $("#circle_"+marker.entityId).parent().parent().css("box-shadow","none");
             });
      }


        /*告警监控google地图改变点位状态*/
      mapMainGoogle.googleMapDeviceState =function googleMapDeviceState(index,deviceState){

             if(null==googleMapPosMap||googleMapPosMap.size<1){
                        return;
             }
             googleMapPosMap.forEach(function(marker,key){
                       if(index == marker.SN){
                              /*判断是否改变*/
                             try{
                                 var deviceAlarm= accMapDeviceAlarmMap.get(index);
                                  var deviceAlarm= accMapDeviceAlarmMap.get(index);
                                  if(undefined==deviceAlarm||deviceState != deviceAlarm["deviceState"]){
                                          if("VidChannel" ==marker.entityType){
                                               mapMainGoogle.updateCameraStatus(deviceState,marker);
                                          }
                                  }
                             }catch (e) {

                             }
                       }

                       $("#circle_"+marker.entityId).parent().parent().css("box-shadow","none");
             });
      }


        /**修改摄像机图标状态显示*/
      mapMainGoogle.updateCameraStatus = function updateCameraStatus(deviceState,marker){
                if("undefined" != typeof googleMap_richMarker_Map && undefined != googleMap_richMarker_Map.get(marker.entityId)) {
                       $("#circle_"+marker.entityId+"_status").remove();
                       richMarker=googleMap_richMarker_Map.get(marker.entityId);
                       var content=richMarker.getContent();
                      var contentHtml='<div id="circle_'+marker.entityId+'_status" style="position: absolute; left: -20px;top: -40px;width:40px;height:40px" ';
                                        if(deviceState == 0){
                                              contentHtml+='class="wave ripple danger circle_gray">';
                                         }else{
                                              //在线
                                              contentHtml+='class="wave ripple danger">';
                                        }
                          contentHtml+='</div>';
                          content = content.replace(contentHtml, "");
                       richMarker.setContent(contentHtml+content);
                }else{
                        var contentHtml='<div id="circle_'+marker.entityId+'_status" style="position: absolute; left: -20px;top: -40px;width:40px;height:40px" ';
                        if(deviceState == 0){
                            contentHtml+='class="wave ripple danger circle_gray">';
                            contentHtml+='</div>';
                            richMarker =new RichMarker({
                                 position: marker.getPosition(),
                                 map: googleMap,
                                 content:contentHtml,
                                 shadow:"none",
                            });
                            richMarker.setContent(contentHtml);
                        } else {
                            //在线
                            var statusObj = $("#circle_" + marker.entityId + "_status");
                            if (statusObj) {
                                $(statusObj).attr("class", "wave ripple danger");
                            }
                        }
                        //googleMap_richMarker_Map.set(marker.entityId,richMarker);
                }

      }

     /*实时修改谷歌地图上告警状态*/
      mapMainGoogle.googleMapAlarmsState =function googleMapAlarmsState(index,alarmLevel,marker){
                  var richMarker;
                  if("undefined" != typeof googleMap_richMarker_Map &&  undefined!=googleMap_richMarker_Map.get(marker.entityId)){
                         //先清除原先的告警波浪效果，防止效果叠加
                         $("#circle_"+marker.entityId).remove();
                         richMarker=googleMap_richMarker_Map.get(marker.entityId);
                         var content=richMarker.getContent();
                         //判断没有告警记录，直接就退出此次循环
                          if(alarmLevel == "" || alarmLevel == null || alarmLevel == undefined || alarmLevel == "0"){
                              return false;
                          }
                          var color = '#ff4d4f';
                          if (alarmLevel == 2) {
                              color = '#FD960B';
                          } else if (alarmLevel == 3) {
                              color = '#ff4d4f';
                          }
                         /*改变点位的状态*/
                        var contentHtml='<div id="circle_'+marker.entityId+'" style="width: 100px;height: 100px; position: absolute; left: -51px;  top: -72px;"  class="wave ripple danger">'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'"></div>'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                       ' </div>'
                        richMarker.setContent(contentHtml+content);
                  }else{
                        //先清除原先的告警波浪效果，防止效果叠加
                        $("#circle_"+marker.entityId).remove();
                        //判断没有告警记录，直接修改在线状态就退出此次循环
                        if(alarmLevel == "" || alarmLevel == null || alarmLevel == undefined || alarmLevel == "0"){
                            return false;
                        }
                        if (alarmLevel == 2) {
                            color = '#FD960B';
                        } else {
                            color = '#ff4d4f';
                        }
                         /*改变点位的状态*/
                        var contentHtml='<div id="circle_'+marker.entityId+'" style="width: 100px;height: 100px; position: absolute; left: -52px;  top: -73px;"  class="wave ripple danger">'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'"></div>'+
                                          '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                       ' </div>'
                         richMarker =new RichMarker({
                                 position: marker.getPosition(),
                                 map: googleMap,
                                 content: contentHtml,
                                 shadow:"none",
                        });
                        richMarker.setContent(contentHtml);
                        //googleMap_richMarker_Map.set(marker.entityId,richMarker);
                  }
      }



        /*添加或移动地图点位*/
      mapMainGoogle.addMarkerToMap = function addMarkerToMap(allChildrenNodes,addMarker_leftX,addMarker_topY){
                  var msg="";
                  var count=0;
                  // var addMarkerLength= Math.ceil(Math.sqrt(allChildrenNodes.length));
                  var mapZoom=Number(googleMap.getZoom());
                  var  scalingFactor=0.0040;
                  for(var i=0;i<allChildrenNodes.length;i++){
                         var  childrenNode= allChildrenNodes[i];
                         var  entityType= childrenNode.entityType;
                         if("Area"==entityType){
                                  addDeviceZTree.setChkDisabled(childrenNode, false);
                                  addDeviceZTree.checkNode(childrenNode, true, false);
                                  addDeviceZTree.setChkDisabled(childrenNode, true);
                                  continue;
                         }
                        if(""==childrenNode.icon){
                                msg+= childrenNode.name+I18n.getValue("map_marker_add_prompt_3");
                                continue;
                         }
                         var mapElementId = "";
                         if (childrenNode.mapElementId) {
                            mapElementId = childrenNode.mapElementId;
                         }
                         try{
                             googleMapPosMap.forEach(function(marker,key){
                                       if(marker.entityId==childrenNode.entityId){
                                              marker.setMap(null);
                                              mapElementId=marker.mapElementId;
                                              googleMapPosMap.delete(marker);
                                              throw new Error("ending");//报错，就跳出循环
                                       }
                             });
                         }catch(e){

                         }
                         addDeviceZTree.setChkDisabled(childrenNode,false);
                         addDeviceZTree.checkNode(childrenNode,true,false);
                         addDeviceZTree.setChkDisabled(childrenNode, true);

                         if(allChildrenNodes.length>1){
                            // 每6个一排，超出换行
                           var addMarkerRowCount = 6;
                           if (count == addMarkerRowCount) {
                                  addMarker_topY=Number(addMarker_topY)-(scalingFactor*(addMarkerRowCount-1));
                                  addMarker_leftX=Number(addMarker_leftX)-(scalingFactor);
                                  count=1;
                            }else{
                                 if(i!=0){
                                       addMarker_topY=Number(addMarker_topY)+(scalingFactor);
                                 }
                                 count++;
                            }
                         }

                        var marker;
                        if(childrenNode.entityType == "DefendArea"){
                            marker = new google.maps.Polygon({
                                map: googleMap,
                                paths: [
                                   { lat: addMarker_leftX, lng: addMarker_topY },
                                   { lat: addMarker_leftX, lng: addMarker_topY + 0.01 },
                                   { lat: addMarker_leftX + 0.008, lng: addMarker_topY + 0.01 },
                                   { lat: addMarker_leftX + 0.008, lng: addMarker_topY }
                                 ],
                                strokeColor: "#474b4f",
                                strokeOpacity: 0.8,
                                strokeWeight: 2,
                                fillColor: "#7AFF42",
                                fillOpacity: 0.35,
                                draggable: true,
                                geodesic: false,
                                editable: true,
                                draggable: true,
                                //自定义信息
                                title: childrenNode.name,
                                mapElementId:mapElementId,
                                entityType:childrenNode.entityType,
                                deviceName:childrenNode.name,
                                entityId:childrenNode.entityId,
                                SN:childrenNode.deviceSn
                              });
                        }else{
                            marker = new google.maps.Marker({
                                  position: new google.maps.LatLng(addMarker_leftX,addMarker_topY),
                                  map: googleMap,
                                  title: childrenNode.name,
                                  draggable:false,
                                  icon: childrenNode.icon,
                                  mapElementId:mapElementId,
                                  entityType:childrenNode.entityType,
                                  deviceName:childrenNode.name,
                                  entityId:childrenNode.entityId,
                                  SN:childrenNode.deviceSn
                            });
                        }

                         var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                            "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                                "<span aria-hidden='true'>×</span>"+
                               " <span class='sr-only'>Close</span>"+
                           " </button>"+
                            "<div style='border-radius: 15px;height: 40px;'>" +
                            "</br>"+marker.title+"</div></div>";
                        mapMainGoogle.markerMouseover(marker,content);
                        mapMainGoogle.markerRightclick(marker);
                        googleMapPosMap.set(marker,marker);

                         /*如果开启点位移动，为后续点位开启*/
                        if($("#drag").hasClass("saveButton")){
                            marker.setDraggable(true);
                        }
                  }
                 if(""!=msg){
                         openMessage(msgType.info,msg);
                 }


      }




    /*标注划过信息提示*/
     mapMainGoogle.markerMouseover = function markerMouseover(marker,googleContent){
        var infoBubble;
        google.maps.event.addListener(marker, 'mouseover', function() {
            infoBubble = googleInfoBubbleMap.get(marker.mapElementId);
             if (undefined!=infoBubble) {
                infoBubble.close();
                infoBubble.setPosition(mapMainGoogle.getInfoPosition(marker));
             }else{
                //把这个infoWindow绑定在选定的marker上面
                 infoBubble = new InfoBubble({
                    map: googleMap,
                    content: googleContent,
                    minWidth: 120,
                    minHeight: 50,
                    position: mapMainGoogle.getInfoPosition(marker),
                    shadowStyle: 1,
                    padding: 0,
                    backgroundColor: 'rgba(0, 0, 0,.4)',
                    borderRadius: 15,
                    arrowSize: 10,
                    borderWidth: 1,
                    borderColor: 'rgba(0, 0, 0,.4)',
                    disableAutoPan: true,
                    hideCloseButton: true,
                    arrowPosition: 30,
                    backgroundClassName: 'phoney',
                    borderStyle: 'none',
                    arrowStyle: 2
                });
             }
            if(marker.entityType == "DefendArea"){
                infoBubble.open(googleMap);
            }else{
                infoBubble.open(googleMap, marker);
            }
            googleInfoBubbleMap.set(marker.mapElementId,infoBubble);
        });
        google.maps.event.addListener(marker, 'mouseout', function() {
            if(infoBubble != undefined){
                infoBubble.close();
            }
            infoBubble = googleInfoBubbleMap.get(marker.mapElementId);
            if (undefined!=infoBubble) {
                window.setTimeout(function() {
                    infoBubble.close();
                    googleInfoBubbleMap.delete(marker.mapElementId);
                }, 50);
            }
        });

     }

    /*增加左键事件监听*/
    mapMainGoogle.markerLeftclick = function markerLeftclick(marker){
        google.maps.event.addListener(marker, 'dblclick', function (event) {
            if("Map" == marker.entityType){
                goSubMap(marker.entityId);
            }
        })
    }

    /*增加右键事件监听*/
     mapMainGoogle.markerRightclick = function markerRightclick(marker){
                google.maps.event.addListener(marker, "rightclick", function(event){

                    // 获取窗口尺寸
                    var winWidth = $(document).width();
                    var winHeight = $(document).height();
                    // 鼠标点击位置坐标
                    var mouseX = googleMap_map_x;
                    var mouseY = googleMap_map_y;
                    // ul标签的宽高
                    var menuWidth = $(".contextmenu").width();
                    var menuHeight = $(".contextmenu").height();
                    // 最小边缘margin(具体窗口边缘最小的距离)
                    var minEdgeMargin = 10;
                    // 以下判断用于检测ul标签出现的地方是否超出窗口范围
                    // 第一种情况：右下角超出窗口
                    if(mouseX + menuWidth + minEdgeMargin >= winWidth &&
                        mouseY + menuHeight + minEdgeMargin >= winHeight) {
                        menuLeft = mouseX - menuWidth - minEdgeMargin + "px";
                        menuTop = mouseY - menuHeight - minEdgeMargin + "px";
                    }
                    // 第二种情况：右边超出窗口
                    else if(mouseX + menuWidth + minEdgeMargin >= winWidth) {
                        menuLeft = mouseX - menuWidth - minEdgeMargin + "px";
                        menuTop = mouseY + minEdgeMargin + "px";
                    }
                    // 第三种情况：下边超出窗口
                    else if(mouseY + menuHeight + minEdgeMargin >= winHeight) {
                        menuLeft = mouseX + minEdgeMargin + "px";
                        menuTop = mouseY - menuHeight - minEdgeMargin + "px";
                    }
                    // 其他情况：未超出窗口
                    else {
                        menuLeft = mouseX + minEdgeMargin + "px";
                        menuTop = mouseY + minEdgeMargin + "px";
                    };

                    var $html="";
                    $("#googleMap_contextmenu").html($html);
                    if("mapMainMonitor"==pageSource){
                        var channelIds = marker.channelIds;
                        /*设备右键菜单内容*/
                        if("AccDoor"==marker.entityType){
                                var reqUrl;
                                 var name;
                                 var deviceId = marker.entityId;
                                 var deviceName = marker.deviceName;
                                   //远程开门
                                 reqUrl = "/mapMonitoring.do?openDoor";
                                 name = I18n.getValue("acc_eventNo_8");
                                 $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                             '<img src="" />'+ name+
                                         '</li>';
                                 //远程关门
                                  reqUrl = "/mapMonitoring.do?closeDoor";
                                  name = I18n.getValue("acc_eventNo_9");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                            '<img src="" />'+ name+
                                        '</li>';
                                 //远程锁定
                                  reqUrl = "/mapMonitoring.do?lockDoor";
                                   name = I18n.getValue("acc_newEventNo_233");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                           '<img src="" />'+ name+
                                       '</li>';
                                 //远程解锁
                                  reqUrl = "/mapMonitoring.do?unLockDoor";
                                  name = I18n.getValue("acc_newEventNo_234");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                          '<img src="" />'+ name+
                                      '</li>';
                                  //取消报警
                                   reqUrl = "/mapMonitoring.do?cancelAlarm";
                                     name = I18n.getValue("acc_eventNo_7");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                             '<img src="" />'+ name+
                                         '</li>';
                                  //远程常开
                                    reqUrl = "/mapMonitoring.do?normalOpenDoor";
                                        name = I18n.getValue("acc_rtMonitor_remoteNormalOpen");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                          '<img src="" />'+ name+
                                      '</li>';

                                 //启用当天常开时间段
                                   reqUrl = "/mapMonitoring.do?enableNormalOpenDoor";
                                     name = I18n.getValue("common_rtMonitor_enableIntradayTZ");
                              $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                         '<img src="" />'+ name+
                                     '</li>';
                                //禁用当天常开时间段
                                  reqUrl = "/mapMonitoring.do?disableNormalOpenDoor";
                                    name = I18n.getValue("common_rtMonitor_disableIntradayTZ");
                              $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                         '<img src="" />'+ name+
                                     '</li>';
                               //查阅最近发生事件
                                    name = I18n.getValue("map_doorEventLatestHappen");
                               $html+='<li  onclick="openDoorEventWindow( \''+deviceId+'\');" >'+
                                          '<img src="" />'+ name+
                                      '</li>';
                              if (channelIds) {
                                name = I18n.getValue("system_module_videoPreview");
                                $html+='<li  onclick="mapRTMonitorChannelPreview( \''+channelIds+'\');" >'+'<img src="" />' + name + '</li>';
                              }
                        } else if ("PsgGate" == marker.entityType) {
                            // TODO 后续优化
                            var deviceId = marker.entityId;
                            var deviceName = marker.deviceName;
                            // 远程开闸进
                            var reqUrl = "/psgRTMonitor.do?openInGate";
                            var name = I18n.getValue("psg_gate_remoteOpenIn");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                   '<img src="" />'+ name+
                               '</li>';
                            // 远程开闸出
                            reqUrl = "/psgRTMonitor.do?openOutGate";
                            name = I18n.getValue("psg_gate_remoteOpenOut");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                  '<img src="" />'+ name+
                              '</li>';
                            // 取消报警
                            reqUrl = "/psgRTMonitor.do?cancelAlarm";
                            name = I18n.getValue("psg_eventNo_7");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                  '<img src="" />'+ name+
                              '</li>';
                            // 远程常开
                            reqUrl = "/psgRTMonitor.do?normalOpenGate";
                            name = I18n.getValue("psg_rtMonitor_remoteNormalOpen");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                  '<img src="" />'+ name+
                              '</li>';
                            // 启用当天常开时间段
                            reqUrl = "/psgRTMonitor.do?enableNormalOpenGate";
                            name = I18n.getValue("common_rtMonitor_enableIntradayTZ");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                  '<img src="" />'+ name+
                              '</li>';
                            // 禁用当天常开时间段
                            reqUrl = "/psgRTMonitor.do?disableNormalOpenGate";
                            name = I18n.getValue("common_rtMonitor_disableIntradayTZ");
                            $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                  '<img src="" />'+ name+
                              '</li>';
                            // 查询最近发生事件
                            name = I18n.getValue("psg_gateEventLatestHappen");
                            $html+='<li  onclick="openGateEventWindow( \''+deviceId+'\');" >'+
                              '<img src="" />' + name + '</li>';
                            if (channelIds) {
                                name = I18n.getValue("system_module_videoPreview");
                                $html+='<li  onclick="mapRTMonitorChannelPreview( \''+channelIds+'\');" >'+'<img src="" />' + name + '</li>';
                            }
                        }
                        if("VidChannel"==marker.entityType){
                             // 右键视频预览
                             $html+='<li id="googleMap_preview" onclick="getVideoPreviewByVidChannelId(\''+marker.entityId+'\',\'' +marker.deviceName+'\')" >'+
                                         '<img src="" />'+ I18n.getValue("map_navigation_preview")+
                                     '</li>';
                              // 获取告警详情点击按钮
                              $html+='<li id="googleMap_alarm_record" onclick="getAlarmDetailByCameraId(\''+marker.entityId+'\')" >'+
                                         '<img src="" />'+ I18n.getValue("map_alarm_queryRecord")+
                                     '</li>';
                        }

                    }else if("mapMain"==pageSource){
                         $html+='<li id="googleMap_del_icon" >'+
                                     '<img src="/public/images/opToolbar/comm_del.png" />'+  I18n.getValue("base_map_delEntity")+
                                '</li>';
                         // 正在添加不允许修改图标
                        if(("VidChannel" == marker.entityType || "EsdcDevice" == marker.entityType)
                            && $("#addMarkerToMapPrompt.displayCss").length > 0) {
                             // 修改图标
                             $html+='<li id="googleMap_modify_icon" >'+
                                  '<img src="/public/images/opToolbar/comm_edit.png" />'+  I18n.getValue("base_map_modifyIcon")+
                             '</li>';
                        }
                    }

                    if(""!=$html){
                        $("#googleMap_contextmenu").append($html);
                    }
                    // ul菜单出现
                    $(".contextmenu").css({
                        "left": menuLeft,
                        "top": menuTop
                    }).show();
                    $("#googleMap_contextmenu").find("li").off('click').on('click',function(){
                            // ul菜单隐藏
                             $(".contextmenu").css({
                                 "left": menuLeft,
                                 "top": menuTop
                             }).hide();
                    });
                    $("#googleMap_del_icon").off('click').on('click',function(){
                           mapMainGoogle.delEntityToMap(marker);
                    });
                    $("#googleMap_modify_icon").off('click').on('click',function(){
                        mapMainGoogle.modifyEntityIcon(marker);
                    });
               });
     }

    /*初始化点位到地图*/
    mapMainGoogle.findPathProcess = function findPathProcess(callback){
      if(mapPosListJson == "" || mapPosListJson==null || mapPosListJson == undefined){
          return;
      }
      var mapPosList = JSON.parse(mapPosListJson);
      if(mapPosList.length <= 0){
          return;
      }
      var x=0,y=0;
      //创建一个InfoWindow
      infowindow = new google.maps.InfoWindow();
      RichMarkerInit();
      for(var i = 0 ; i< mapPosList.length;i++){
          var imgPath = "";
          var sn = "";
          var entityType = mapPosList[i].entityType;
          if(entityType == "AccDoor"){
              imgPath = "/images/"+ systemSkin +"/map/acc_door.png";
                sn= mapPosList[i].entityName;
          }else if(entityType == "VidChannel"){
                sn= mapPosList[i].deviceAlarmSN;
              if(mapPosList[i].vidEntityType == 0 || mapPosList[i].vidEntityType == 1){
                imgPath = "/images/gisMap/camera_icons-15.png";
              }else if(mapPosList[i].vidEntityType == 2){
                imgPath = "/images/gisMap/camera_icons-19.png";
              }else if(mapPosList[i].vidEntityType == 3){
                imgPath = "/images/gisMap/camera_icons-17.png";
              }else if(mapPosList[i].vidEntityType == 4){
                imgPath = "/images/gisMap/camera_icons-18.png";
              }else{
                imgPath = mapPosList[i].entityIcon;
              }
          }else if(entityType == "BolidDevice"){
                imgPath = "/images/map/bolid_dev_normal.png";
                sn= mapPosList[i].deviceAlarmSN;
         } else{
                imgPath = mapPosList[i].entityIcon;
         }
            if (entityType != "DefendArea") {
                var marker = new google.maps.Marker({
                  position: new google.maps.LatLng(mapPosList[i].points[0].positionX,mapPosList[i].points[0].positionY),
                  map: googleMap,
                  title: mapPosList[i].entityName,
                  draggable:false,
                  icon: imgPath,
                  mapElementId:mapPosList[i].id,
                  entityType:entityType,
                  deviceName:mapPosList[i].entityName,
                  entityId:mapPosList[i].entityId,
                  zIndex:999,
                  SN:sn,
                  channelIds:mapPosList[i].channelIds
                });

            } else {
                // 防区图逻辑
                var pointData = mapPosList[i].points.map(function(point){
                    return {
                       lat: point.positionX,
                       lng: point.positionY
                    }
                });
                marker = new google.maps.Polygon({
                    map: googleMap,
                    paths: pointData,
                    strokeColor: "#474b4f",
                    strokeOpacity: 0.8,
                    strokeWeight: 2,
                    fillColor: "#7AFF42",
                    fillOpacity: 0.35,
                    draggable: false,
                    geodesic: false,
                    editable: false,
                    //自定义信息
                    title: mapPosList[i].entityName,
                    mapElementId:mapPosList[i].id,
                    entityType:mapPosList[i].entityType,
                    deviceName:mapPosList[i].entityName,
                    entityId:mapPosList[i].entityId,
                    SN:mapPosList[i].deviceSn
                });
            }

            var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='border-radius: 15px;z-index: -1;color: white;' >" +
                "<button type='button' onclick='mapMainGoogle.closePoPupInfoNews(this)' class='close' style='color: #fff; opacity: 1;margin-top: 3px;margin-right: 5px'>" +
                    "<span aria-hidden='true'>×</span>"+
                   " <span class='sr-only'>Close</span>"+
                " </button>"+
                "<div style='border-radius: 15px;height: 40px;'>" +
                "</br>"+marker.title+"</div></div>";
                mapMainGoogle.markerMouseover(marker,content);
                mapMainGoogle.markerRightclick(marker);
                mapMainGoogle.markerLeftclick(marker);
                googleMapPosMap.set(marker,marker);
      }
        return callback();

    }

    /**
     * 修改鼠标样式
     * 默认箭头样式	cursor:default	系统默认 箭头样式
    	手型	cursor: pointer	系统自带 手型
    	手型	cursor:hand	系统自带 手型    提示 只有ie5支持这种手型也只支持这种
    	移动十字箭头	cursor: move	系统自带 移动十字箭头
    	帮助问号	cursor: help	系统自带 帮助问号
    	十字准心	cursor:crosshair	系统自带 十字准心
    	文字/编辑	cursor: text	系统自带 编辑或者框选文字时 竖线型
    	无法释放(禁用)	cursor:no-drop	系统自带 当不可编辑时禁用型
    	禁用	cursor:not-allowed	系统自带 当不可编辑时禁用型
    	自动	cursor:auto	就是由系统根据当前元素自动设置
    	处理中	cursor: progress	win7为一个圆环，xp为一个沙漏，等待处理中样式
    	向上改变大小	cursor: n-resize	系统自带
    	向下改变大小	cursor: s-resize	系统自带
    	向左改变大小	cursor: w-resize	系统自带
    	向右改变大小	cursor: e-resize	系统自带
    	向上左改变大小	cursor: nw-resize	系统自带
    	向下左改变大小	cursor: sw-resize	系统自带
    	向上右改变大小	cursor: ne-resize	系统自带
    	向下右改变大小	cursor: se-resize	系统自带
     * @param type
     */
    mapMainGoogle.modificarEstiloDeMouse =  function modificarEstiloDeMouse(type) {
    	$(".ol-unselectable").mouseover(function(filename){
    		$(this).css("cursor",type);
    	});
    }

    /**
    * 开启防区报警闪烁
    * entityIds 开启报警闪烁的防区ids,不在指定ids内的其他防区都会被关闭闪烁
    */
    mapMainGoogle.updateDefendAreaStatus = function updateDefendAreaStatus(entityIds){
        var enableCount = 0;
        //预处理
        googleMapPosMap.forEach(function(marker, key){
            if(marker.entityType == "DefendArea"){
               if(entityIds != null && entityIds.length > 0 && entityIds.indexOf(marker.entityId) != -1){
                   mapFlashEntityMap.set(marker.entityId, marker);
                   enableCount++;
               }else{
                   mapFlashEntityMap.delete(marker.entityId, marker);
                   marker.setOptions({"fillColor": "#7AFF42"});
               }
            }
        });
        if(enableCount == 0){
            window.clearInterval(mapFlashHandle);
            mapFlashHandle = null;
        }else if(mapFlashHandle == null){
            mapFlashHandle = window.setInterval(function(){
                mapFlashEntityMap.forEach(function(marker, entityId){
                    if(marker.fillColor == "#ff9999"){
                        marker.setOptions({"fillColor":"red"});
                    }else{
                        marker.setOptions({"fillColor":"#ff9999"});
                    }
                });
            }, 500);
        }
    }

    /**
    * 更新地图上设备元素状态
    */
    mapMainGoogle.updateDeviceElementStatus = function updateDeviceElementStatus(devData) {
        var devStates = devData.data;
        for (var i = 0; i < devStates.length; i++) {
            var entityId = devStates[i].uniqueKey;
            var status = devStates[i].status;
            googleMapPosMap.forEach(function(marker, key) {
                if (marker.entityId == entityId) {
                    var oldImgSrc = marker.getIcon().url ? marker.getIcon().url : marker.getIcon();
                    var photoName = oldImgSrc.substring(oldImgSrc.lastIndexOf("/"), oldImgSrc.lastIndexOf("."));
                    $("#circle_" + marker.entityId+"_status").remove();
                    var newImgSrc;
                    // 在线
                    if (status == 1) {
                        // 变更为在线图标
                        if (oldImgSrc.indexOf("_offline") != -1) {
                            newImgSrc = oldImgSrc.replace(photoName, photoName.replace("_offline", ""));
                        }
                    } else if (status == 0) {
                        // 设置离线图标
                        if (oldImgSrc.indexOf("_offline") == -1) {
                            newImgSrc = oldImgSrc.replace(photoName, photoName + "_offline");
                        }
                    } else if (status == 2) {
                        // 禁用
                        var richMarker;
                        var contentHtml='<div id="circle_'+marker.entityId+'_status" style="position: absolute; left: -20px;top: -40px;' +
                            'width:40px;height:40px" class="wave ripple danger circle_gray"></div>';
                        if (undefined != googleMap_richMarker_Map.get(marker.entityId)) {
                            richMarker = googleMap_richMarker_Map.get(marker.entityId);
                            var content= richMarker.getContent();
                            content = content.replace(contentHtml, "");
                            richMarker.setContent(contentHtml+content);
                        } else {
                            richMarker =new RichMarker({
                                position: marker.getPosition(),
                                map: googleMap,
                                content:contentHtml,
                                shadow:"none",
                            });
                            googleMap_richMarker_Map.set(marker.entityId,richMarker);
                        }
                    }
                    // 新图标路径为空表示状态未发生变化,不做更新
                    if (!newImgSrc) {
                        newImgSrc = oldImgSrc;
                    }
                    var icon = {
                        url: newImgSrc,
                        size: new google.maps.Size(40, 40),
                    }
                    marker.setIcon(icon);
                }
            });
        }
    }

    /**
    * 获取地图元素的名称气泡显示的坐标
    */
    mapMainGoogle.getInfoPosition = function getInfoPosition(marker){
        var markerPoint;
        if(marker.entityType == "DefendArea"){
            var maxLat,minLng,maxLng;
            var polygonPoints = marker.getPath();
            for(var tempIndex = 0; tempIndex < polygonPoints.getLength(); tempIndex++){
                if(maxLat == null || Math.max(polygonPoints.getAt([tempIndex]).lat(), maxLat) > maxLat){
                    maxLat = polygonPoints.getAt([tempIndex]).lat();
                }
                if(minLng == null || Math.min(polygonPoints.getAt([tempIndex]).lng(), minLng) < minLng){
                    minLng = polygonPoints.getAt([tempIndex]).lng();
                }
                if(maxLng == null || Math.max(polygonPoints.getAt([tempIndex]).lng(), maxLng) > maxLng){
                    maxLng = polygonPoints.getAt([tempIndex]).lng();
                }
            }
            markerPoint = new google.maps.LatLng(maxLat, (minLng + maxLng)/2.0);
        }else{
          markerPoint = marker.getPosition();
        }
        return markerPoint;
    }
};

/**
 * 初始化
 */
(function (mapMainGoogle) {
        //数据初始化
        _initView(mapMainGoogle);
        /*初始化渲染页面样式*/
        _initEvent(mapMainGoogle);
        _render(mapMainGoogle);

    window.mapMainGoogle = mapMainGoogle;
})(window.mapMainGoogle || {});


