
I18n
    .load(
        [   "base_map_delEntity",
            "map_alarm_queryRecord",
            "map_show_photo",
            "map_manual_alarm",
            "acc_eventNo_8",
              "acc_eventNo_9",
            "acc_newEventNo_233",
            "acc_newEventNo_234",
            "acc_eventNo_7",
            "acc_rtMonitor_remoteNormalOpen",
            "common_rtMonitor_enableIntradayTZ",
            "common_rtMonitor_disableIntradayTZ",
            "acc_map_gis_input_device_name",
            "map_navigation_preview",
            "map_marker_add_prompt",
        ], true);

//百度地图防区多边形样式
var baiduPolygonStyle = {
    strokeColor: '#474B4F',
    strokeWeight: 2,
    strokeOpacity: 0.5,
    fillColor: '#7AC142',
    fillOpacity: 0.5
}
/**
 * 事件
 */
var _initEvent = function(mapMainBaidu) {

              /*开启轨迹的功能*/
            mapMainBaidu.addLocusToMap = function addLocusToMap(cameraSnList,cameraDataList){
                    function showinfomessage(marker, personImage, listPicData) {
                          var content = "<div class='infoBoxContent' id='popup-"+marker.customData.mapElementId+"'   onclick=\"showMorePicByPersonTrack(\'"+listPicData+"\');\"   >" +
                                                "<img src='"+personImage+"'  onerror=\"mapMainBase.imgeTrackErrorfun(\'"+ personImage +"\','/images/" +systemSkin + "defaultImg/defaultPers.png');\"  style='width: 100%;height:120px'>"+
                                         "</div>";
                          var infoBox = new BMapLib.InfoBox(baiduMap,content,{
                               boxStyle:{
                                 background: "#333333",
                                 width: "120px",
                                 height: "120px"
                               },
                               closeIconUrl:"images/googleMap/close.png",//关闭图标的图片路径
                               closeIconMargin: "1px 1px 0 0",//关闭图标距离右上角的间距
                               enableAutoPan: true,
                               align: INFOBOX_AT_TOP,//infobox显示位置，目前只有上和下
                               offset: new BMap.Size(10, 20) //infobox偏移量
                             });
                          infoBox.open(marker);
                          marker.addEventListener("click", function(){
                                    infoBox.open(marker);
                          });
                    }

                         //清除地图上所有的覆盖物
                      // baiduMap.clearOverlays();
                       //创建驾车实例
                       var driving = new BMap.DrivingRoute(baiduMap);
                       var trackPoint = [];
                       var allOverlay = baiduMap.getOverlays();
                       var deviceMapLocationMark=false;
                       for(var j = 0;j<allOverlay.length;j++) {
                             if(undefined!=allOverlay[j].customData&&cameraSnList.indexOf (allOverlay[j].customData.entityId)!=-1){
                                    var cameraData=cameraDataList[cameraSnList.indexOf (allOverlay[j].customData.entityId)];
                                    if(cameraData.coverPicUrl != "" && undefined != cameraData.listPicData && cameraData.listPicData.length > 0){
                                        var listPicDataStr = window.btoa(JSON.stringify(cameraData.listPicData));
                                        //创建标注窗口
                                        showinfomessage(allOverlay[j], cameraData.coverPicUrl, listPicDataStr);
                                    }
                                    var lat=allOverlay[j].getPosition().lat;
                                    var Lng=allOverlay[j].getPosition().lng;
                                      // 生成坐标点
                                    trackPoint.push(new BMap.Point(Lng,lat));
                                    /*划线的同时定位*/
                                    if(!deviceMapLocationMark){
                                        deviceMapLocationMark=true;
                                        var deviceId=allOverlay[j].customData.entityId;
                                        var allOverlay = baiduMap.getOverlays();
                                        if(undefined!=deviceId&&null!=deviceId&&""!=deviceId){
                                                for(var j = 0;j<allOverlay.length;j++) {
                                                      if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==deviceId){
                                                         baiduMap.panTo(allOverlay[j].getPosition());
                                                         break;
                                                      }
                                                }
                                        }
                                    }

                             }
                       }
                      for (var i = 0; i < trackPoint.length; i++) {
                            if(i != trackPoint.length -1 ){
                                driving.search(trackPoint[i], trackPoint[i+1]);
                            }
                      }
                      driving.setSearchCompleteCallback(function(){
                                 //通过驾车实例，获得一系列点的数组
                                var plan = driving.getResults().getPlan(0);
                                if (plan) {
                                    var pts = plan.getRoute(0).getPath();
                                    var polyline = new BMap.Polyline(pts);
                                    baiduMap.addOverlay(polyline);
    //                                 baiduMap.panTo(trackPoint[0].getPosition());
                                    baiduMap.setViewport(trackPoint);
                                }
                      });

            }
            /*实时修改百度地图上告警状态*/
            mapMainBaidu.baiduMapAlarmsState =function baiduMapAlarmsState(index,alarmLevel,marker){
                      //先清除原先的告警波浪效果，防止效果叠加
                      $("#circle_"+marker.customData.entityId).remove();
                      //判断没有告警记录，直接就退出此次循环
                      if(alarmLevel == "" || alarmLevel == null || alarmLevel == undefined || alarmLevel == "0"){
                          return false;
                      }
                      var color = '#ff4d4f';
                      if (alarmLevel == 2) {
                          color = '#FD960B';
                      } else if (alarmLevel == 3) {
                          color = '#ff4d4f';
                      }
                      /*改变点位的状态*/
                      var contentHtml='<div id="circle_'+marker.customData.entityId+'" style="width: 100px;height: 100px; position: absolute; left: -33px;  top: -34px;"  class="wave ripple danger">'+
                                      '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                      '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'"></div>'+
                                      '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                   ' </div>'
                      $(marker.Yc).parent().append(contentHtml);
            }
            /**修改摄像机图标状态显示*/
            mapMainBaidu.updateCameraStatus = function updateCameraStatus(deviceState,marker){
                     //判断没有告警记录
                     $("#circle_"+marker.customData.entityId+"_status").remove();
                     var contentHtml='<div id="circle_'+marker.customData.entityId+'_status" style="position: absolute;width:40px;height:40px" ';
                                  if(deviceState == 0){
                                        contentHtml+='class="wave ripple danger circle_gray">';
                                   }else{
                                        //在线
                                        contentHtml+='class="wave ripple danger">';
                                   }
                     contentHtml+='</div>';
                    $(marker.Yc).parent().append(contentHtml);
            }

            /*告警监控百度地图改变点位状态*/
          mapMainBaidu.baiduMapAlarms =function baiduMapAlarms(index,alarmLevel,deviceState, exEntityId) {
                var entityId = index;
                if (!entityId) {
                    entityId = exEntityId;
                }
                var allOverlay = baiduMap.getOverlays();
                 for(var j = 0;j<allOverlay.length;j++) {
                       if(undefined!=allOverlay[j].customData){
                          if(entityId == allOverlay[j].customData.entityId){
                                /*判断是否改变*/
                               try{
                                    var deviceAlarm = alarmLevel;
                                    if ("undefined" != typeof accMapDeviceAlarmMap) {
                                        deviceAlarm = accMapDeviceAlarmMap.get(entityId);
                                    }
                                    if(undefined==deviceAlarm||deviceState != deviceAlarm["status"]){
                                            if("VidChannel" ==allOverlay[j].customData.entityType){
                                                 mapMainBaidu.updateCameraStatus(deviceState,allOverlay[j]);
                                            }
                                    }
                                    if(undefined==deviceAlarm||alarmLevel != deviceAlarm["alarmLevel"]){
                                            // 地图展示告警信息
                                            mapMainBaidu.baiduMapAlarmsState(entityId,alarmLevel,allOverlay[j]);
                                    }
                               }catch (e) {

                               }
                         }

                         $("#circle_"+allOverlay[j].customData.entityId).parent().parent().css("box-shadow","none");
                       }
                 }
          }


          mapMainBaidu.baiduMapDeviceState =function baiduMapDeviceState(index,deviceState){
                  var allOverlay = baiduMap.getOverlays();
                   for(var j = 0;j<allOverlay.length;j++) {
                         if(undefined!=allOverlay[j].customData){
                            if(index == allOverlay[j].customData.entityId){
                                  /*判断是否改变*/
                                 try{
                                      var deviceAlarm= accMapDeviceAlarmMap.get(index);
                                      if(undefined==deviceAlarm||deviceState != deviceAlarm["deviceState"]){
                                              if("VidChannel" ==allOverlay[j].customData.entityType){
                                                   mapMainBaidu.updateCameraStatus(deviceState,allOverlay[j]);
                                              }
                                      }

                                 }catch (e) {

                                 }
                           }

                           $("#circle_"+allOverlay[j].customData.entityId).parent().parent().css("box-shadow","none");
                         }
                   }
            }

            //开启框选功能
            let a1 = "";
            let b1 = "";
            let a2 = "";
            let b2 = "";
            let polygon = null;

            // 鼠标拖动事件监听
            let huafang = function (e) {
               if (polygon) {
                 baiduMap.removeOverlay(polygon);
                 polygon = null;
               }
               a2 = e.point.lng
               b2 = e.point.lat
               polygon = new BMap.Polygon([
                     new BMap.Point(a1, b1),
                     new BMap.Point(a2, b1),
                     new BMap.Point(a2, b2),
                     new BMap.Point(a1, b2)
               ], baiduPolygonStyle);
               baiduMap.addOverlay(polygon);
            }

            baiduMouseDown = function(e){
                a1 = e.point.lng;
                b1 = e.point.lat;
                baiduMap.addEventListener("mousemove", huafang);
            }

            baiduMouseUp = function(e){
                a1 = ''
                a2 = ''
                b1 = ''
                b2 = ''
                baiduMap.removeEventListener('mousemove', huafang);
                var allOverlay = baiduMap.getOverlays();
                var type=$("#bulkOperationsDivPrompt-title").data("type");
                for(var j=0;j<allOverlay.length;j++){
                 //判断 覆盖物为标注的并且是在多边形区域内部的,过滤地图上的防区设备
                  if(undefined!=allOverlay[j].customData && allOverlay[j].customData.entityType != "DefendArea"){
                     //判断marker是否在多边形内
                       if(BMapLib.GeoUtils.isPointInPolygon(allOverlay[j].getPosition(), polygon)){
                             mapMainBaidu.addDeviceDivForBulkOperations(allOverlay[j],type);
                       }
                 }
                }
                baiduMap.removeOverlay(polygon);
                polygon = null;
            }
            /*批量功能面板开启*/
            mapMainBaidu.bulkOperations = function bulkOperations(thisHtml){
                    var title=$(thisHtml).html();
                    var bulkOperations=$(thisHtml).attr("value");
                    var bulkOperationsType=$(thisHtml).data("type");
                    $("#bulkOperationsConversation").html("");
                    var $html="<p style='color: white;font-size: 24px;margin-top:200px'>"+I18n.getValue("map_alarm_no_device")+"</p>";
                    $("#bulkOperationsConversation").append($html).css("background","none");
                    $("#bulkOperations_deviceList_count").html("");
                    $("#bulkOperations_deviceList_count").val(0);
                    var mark=false;
                    var allOverlay = baiduMap.getOverlays();
                    for(var j = 0;j<allOverlay.length;j++) {
                           if(undefined!=allOverlay[j].customData&&bulkOperationsType==allOverlay[j].customData.entityType){
                                mark=true;
                                break;
                           }
                    }

                    $("#popupbuttonMenu .dropdown").css("overflow","hidden");
                    $('.dropdown').stop().animate({
                        width: "0px"
                    },300,function(){
                        $("#popupbuttonMenu").html("");
                    });
                    if(!mark){
                        messageBox({messageType:"alert",text: I18n.getValue("map_bulkOperations_prompt_2")});
                        return;
                    }
                    $("#bulkOperationsDivPrompt-title").html(title);
                    $("#bulkOperationsDivPrompt-title").data("val",bulkOperations);
                    $("#bulkOperationsDivPrompt-title").data("type",bulkOperationsType);

                    $("#dropLeft-menu").addClass("displayCss");

                     if(!$("#searchMarkerToMapPrompt").hasClass("displayCss")){
                         if(mapMain_left == "left"){
                             $("#searchMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                                 $("#searchMarkerToMapPrompt").addClass("displayCss")
                             });
                         }else{
                             $("#searchMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                                 $("#searchMarkerToMapPrompt").addClass("displayCss")
                             });
                         }
                     }

                    if(mapMain_left == "left"){
                        $('#leftDivPrompt').stop().animate({
                            width: "0px"
                        },500,function(){
                            $("#icon-arrow").removeClass("icon-increase");
                            $("#icon-arrow").addClass("icon-decrease");
                            $("#leftDivPrompt").removeClass("map_alarm_activation");
                            $("#leftDivPromptDataDiv").addClass("displayCss");
                        });
                        $("#icon-arrow").removeClass("icon-increase");
                        $("#icon-arrow").addClass("icon-decrease");
                        $(".ol-scale-line").css("margin-right","0%");
                        $("#bulkOperationsDivPrompt").removeClass("displayCss").stop().animate({left: 0},500);
                        $("#bulkOperationsConversation").css("text-align","center");
                    }else{
                        $('#leftDivPrompt').stop().animate({
                            width: "0px"
                        },500,function(){
                            $("#icon-arrow").removeClass("icon-decrease");
                            $("#icon-arrow").addClass("icon-increase");
                            $("#leftDivPrompt").removeClass("map_alarm_activation");
                            $("#leftDivPromptDataDiv").addClass("displayCss");
                        });
                        $("#icon-arrow").removeClass("icon-decrease");
                        $("#icon-arrow").addClass("icon-increase");
                        $(".ol-scale-line").css("margin-left","0%");
                        $("#bulkOperationsDivPrompt").removeClass("displayCss").stop().animate({right: 0},500);
                    }
                    // 修改鼠标样式
                    mapMainBaidu.modificarEstiloDeMouse("crosshair");

                     // 开启拉框
                     function openBut() {
                           baiduMap.setDefaultCursor('crosshair');
                           baiduMap.disableDragging();
                     }
                     // 关闭拉框
                     function closeBut() {
                           baiduMap.setDefaultCursor("url('bird.cur')");
                           baiduMap.enableDragging();
                     }
                     // 鼠标按下
                     baiduMap.addEventListener("mousedown", baiduMouseDown);
                     // 鼠标释放
                     baiduMap.addEventListener("mouseup", baiduMouseUp);
                     // 启用拖动事件监听
                     function beginMove() {
                       baiduMap.addEventListener("mousemove", huafang);
                     }
                     openBut();
            }




             /*添加点位到批量面板上*/
            mapMainBaidu.addDeviceDivForBulkOperations = function addDeviceDivForBulkOperations(marker,type){
                 var $html="";
                 var deviceId=marker.customData.entityId;
                 var mark=true;
                 var deviceListcount=1;
                 var bulkOperationsDeviceId_count_mark=false;
                 $("#bulkOperationsConversation .bulkOperationsDeviceId").each(function(){
                     bulkOperationsDeviceId_count_mark=true;
                     if(deviceId==$(this).val()){
                         mark=false;
                         return false;
                     }else{
                         deviceListcount++;
                     }
                 })
                 if(mark){
                     if(type==marker.customData.entityType){
                         //var imgPath=marker.getIcon().imageUrl;
                         var imgPath = "/images/"+ systemSkin +"/map/acc_door.png";
                         var deviceName=marker.customData.deviceName;
                         var sn=marker.customData.SN;
                         var detailStr = I18n.getValue("map_detail");
                         $html+="<div class=\"comment\" >\n" +
                             "                        <span class=\"right-span\"  style='position:relative;' onclick=\"deviceMapLocation(null,\'"+deviceName+"')\">\n" +
                             "                            <img src='"+imgPath+"'  class=\"right-icon \" />\n" +
                             "                            <i id='play_i_"+deviceId+"' class=\"tip displayCss\"></i>"+
                             "                        </span>\n" +
                             "                        <span class=\"info-span\"  title='"+deviceName+"'>\n" +
                             deviceName +
                             "                        </span>\n" +
                             "                        <span class=\"operating-span_infoDevice icv-system_detail\" title='"+detailStr+"' style='font-size: 18px;margin: calc(50% - 136px);' onclick='mapMainBase.infoDevice(this)'>\n" +
                             "                        </span>\n" +
                             "                        <span class=\"operating-span_delDevice icv-common_op_del\" onclick='delDevice(this)' style='font-size: 18px;margin: calc(50% - 136px);'>\n" +
                             "                        </span>\n" +
                             "                        <span  id='play_"+deviceId+"'  class=\"operating-span_play displayCss\" >\n" +
                             "                            <img  src='/images/alarm/icons_play_1.png' onclick='playDevice(this)' style='padding-left:2px;width: 20px;height: 20px'/>\n" +
                             "                        </span>\n" +
                             "<input style='display: none;' id='"+deviceId+"' class='bulkOperationsDeviceId' data-type='"+type+"' data-name='"+deviceName+"' data-sn='"+sn+"' value='"+deviceId+"'/>" +
                             "</div>";
                     }
                     if(""!=$html){
                         if(!bulkOperationsDeviceId_count_mark){
                             $("#bulkOperationsConversation").html("");
                         }
                         $("#bulkOperationsConversation").prepend($html);
                         $("#bulkOperations_deviceList_count").html("("+deviceListcount+")");
                         $("#bulkOperations_deviceList_count").val(deviceListcount);
                     }
                 }
            }


            /** 开启点位拖动功能*/
            mapMainBaidu.saveDrag = function saveDrag(){
                mapId = mapTree.getAllChecked();
                if($("#drag").hasClass("saveButton")){
                        /*关闭拖动保存*/
                        mapMainBase.saveMapPos();
                       //srcImg="/public/gis/images/adjustTheCoordinate_1.png";
                       $("#drag span").removeClass("icv-mapcenter_saveCoordinate").addClass("icv-mapcenter_adjustCoordinate");
                       $("#drag").removeClass("saveButton");
                }else{
                     var allOverlay = baiduMap.getOverlays();
                     for(var j = 0;j<allOverlay.length;j++) {
                           //可拖拽
                           if(undefined!=allOverlay[j].customData){
                                if(allOverlay[j].customData.entityType == "DefendArea"){
                                    allOverlay[j].enableEditing();
                                }else{
                                    allOverlay[j].enableDragging();
                                }
                           }
                     }
                     //srcImg="/public/gis/images/adjustTheCoordinateFinish_1.png";
                     $("#drag span").removeClass("icv-mapcenter_adjustCoordinate").addClass("icv-mapcenter_saveCoordinate");
                     $("#drag").addClass("saveButton");
                  }
            }


            /*开启修改视野的功能*/
            mapMainBaidu.modifyView = function modifyView(){
                var srcImg;
                if(undefined==$("#modifyViewImg").html()){
                    /*开启*/
                    var markWidth= parseFloat($(tempMapId).width())/2-parseFloat(90);
                    var markHeight= parseFloat($(tempMapId).height())/2-parseFloat(90);
                    centerXNum=24.611016,
                    centerYNum=118.049005;
                    var imgHtml='<div id="modifyViewImg"  class="center-arrow" style="position: absolute;left: '+markWidth+'px; top: '+markHeight+'px;" >'+
                                '<img  src="/images/googleMap/positioning.svg" width="182" height="182"  >'+
                                '</div>';
                     $(tempMapId).append(imgHtml);
                     $("#modifyView").addClass("saveButton");
                     $("#modifyView span").removeClass("icv-mapcenter_modifyView").addClass("icv-mapcenter_saveView");
                }else{
                    //关闭保存视野

                    var  lat= parseFloat(baiduMap.getCenter().lat);
                    var  lng= parseFloat(baiduMap.getCenter().lng);
                    var  Zoom= parseInt(baiduMap.getZoom());
                    var postData={
                        "id":mapId,
                        "baiduCenterX":lng,
                        "baiduCenterY":lat,
                        "baiduInitialLevel":Zoom,
                        "mapType": "Baidu"
                    }
                    mapMainBase.saveAccMapMain(postData,function(result){
                        openMessage(msgType.success,result.msg);
                        $("#modifyViewImg").remove();
                        $("#modifyView").removeClass("saveButton");
                    })
                    $("#modifyView span").removeClass("icv-mapcenter_saveView").addClass("icv-mapcenter_modifyView");
                }
                $("#modifyView").css("background-image","url("+srcImg+")");
            }

        /*增加左键事件监听*/
        mapMainBaidu.markerLeftclick = function markerLeftclick(marker){
            marker.addEventListener('dblclick', function (event) {
                   if("Map" == marker.customData.entityType){
                        goSubMap(marker.customData.entityId);
                   }
            })
        }

          /*增加右键事件监听*/
         mapMainBaidu.markerRightclick = function markerRightclick(marker){

                    marker.addEventListener('rightclick', function (event) {
                        // 获取窗口尺寸
                        var winWidth = $(document).width();
                        var winHeight = $(document).height();
                        // 鼠标点击位置坐标
                        var mouseX = baiduMap_map_x;
                        var mouseY = baiduMap_map_y;
                        // ul标签的宽高
                        var menuWidth = $(".contextmenu").width();
                        var menuHeight = $(".contextmenu").height();
                        // 最小边缘margin(具体窗口边缘最小的距离)
                        var minEdgeMargin = 10;
                        // 以下判断用于检测ul标签出现的地方是否超出窗口范围
                        // 第一种情况：右下角超出窗口
                        if(mouseX + menuWidth + minEdgeMargin >= winWidth &&
                            mouseY + menuHeight + minEdgeMargin >= winHeight) {
                            menuLeft = mouseX - menuWidth - minEdgeMargin + "px";
                            menuTop = mouseY - menuHeight - minEdgeMargin + "px";
                        }
                        // 第二种情况：右边超出窗口
                        else if(mouseX + menuWidth + minEdgeMargin >= winWidth) {
                            menuLeft = mouseX - menuWidth - minEdgeMargin + "px";
                            menuTop = mouseY + minEdgeMargin + "px";
                        }
                        // 第三种情况：下边超出窗口
                        else if(mouseY + menuHeight + minEdgeMargin >= winHeight) {
                            menuLeft = mouseX + minEdgeMargin + "px";
                            menuTop = mouseY - menuHeight - minEdgeMargin + "px";
                        }
                        // 其他情况：未超出窗口
                        else {
                            menuLeft = mouseX + minEdgeMargin + "px";
                            menuTop = mouseY + minEdgeMargin + "px";
                        };

                        var $html="";
                        $("#baiduMap_contextmenu").html($html);
                        if("mapMainMonitor"==pageSource){
                            var channelIds = marker.customData.channelIds;
                            /*设备右键菜单内容*/
                            if("AccDoor"==marker.customData.entityType){
                                    var reqUrl;
                                     var name;
                                     var deviceId = marker.customData.entityId;
                                     var deviceName = marker.customData.deviceName;
                                       //远程开门
                                     reqUrl = "/mapMonitoring.do?openDoor";
                                     name = I18n.getValue("acc_eventNo_8");
                                     $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                                 '<img src="" />'+ name+
                                             '</li>';
                                     //远程关门
                                      reqUrl = "/mapMonitoring.do?closeDoor";
                                      name = I18n.getValue("acc_eventNo_9");
                                    $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                                '<img src="" />'+ name+
                                            '</li>';
                                     //远程锁定
                                      reqUrl = "/mapMonitoring.do?lockDoor";
                                       name = I18n.getValue("acc_newEventNo_233");
                                    $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                               '<img src="" />'+ name+
                                           '</li>';
                                     //远程解锁
                                      reqUrl = "/mapMonitoring.do?unLockDoor";
                                      name = I18n.getValue("acc_newEventNo_234");
                                    $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                              '<img src="" />'+ name+
                                          '</li>';
                                      //取消报警
                                       reqUrl = "/mapMonitoring.do?cancelAlarm";
                                         name = I18n.getValue("acc_eventNo_7");
                                    $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                                 '<img src="" />'+ name+
                                             '</li>';
                                      //远程常开
                                        reqUrl = "/mapMonitoring.do?normalOpenDoor";
                                            name = I18n.getValue("acc_rtMonitor_remoteNormalOpen");
                                    $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                              '<img src="" />'+ name+
                                          '</li>';

                                     //启用当天常开时间段
                                       reqUrl = "/mapMonitoring.do?enableNormalOpenDoor";
                                         name = I18n.getValue("common_rtMonitor_enableIntradayTZ");
                                  $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                             '<img src="" />'+ name+
                                         '</li>';
                                    //禁用当天常开时间段
                                      reqUrl = "/mapMonitoring.do?disableNormalOpenDoor";
                                        name = I18n.getValue("common_rtMonitor_disableIntradayTZ");
                                  $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                             '<img src="" />'+ name+
                                         '</li>';
                                   //查阅最近发生事件
                                        name = I18n.getValue("map_doorEventLatestHappen");
                                   $html+='<li  onclick="openDoorEventWindow( \''+deviceId+'\');" >'+
                                              '<img src="" />'+ name+
                                          '</li>';
                                  if (channelIds) {
                                    name = I18n.getValue("system_module_videoPreview");
                                    $html+='<li  onclick="mapRTMonitorChannelPreview( \''+channelIds+'\');" >'+'<img src="" />' + name + '</li>';
                                  }
                            } else if ("PsgGate" == marker.customData.entityType) {
                                // TODO 后续优化
                                var deviceId = marker.customData.entityId;
                                var deviceName = marker.customData.deviceName;
                                // 远程开闸进
                                var reqUrl = "/psgRTMonitor.do?openInGate";
                                var name = I18n.getValue("psg_gate_remoteOpenIn");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                         '<img src="" />'+ name+
                                     '</li>';
                                // 远程开闸出
                                reqUrl = "/psgRTMonitor.do?openOutGate";
                                name = I18n.getValue("psg_gate_remoteOpenOut");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                        '<img src="" />'+ name+
                                    '</li>';
                                // 取消报警
                                reqUrl = "/psgRTMonitor.do?cancelAlarm";
                                name = I18n.getValue("psg_eventNo_7");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                        '<img src="" />'+ name+
                                    '</li>';
                                // 远程常开
                                reqUrl = "/psgRTMonitor.do?normalOpenGate";
                                name = I18n.getValue("psg_rtMonitor_remoteNormalOpen");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                        '<img src="" />'+ name+
                                    '</li>';
                                // 启用当天常开时间段
                                reqUrl = "/psgRTMonitor.do?enableNormalOpenGate";
                                name = I18n.getValue("common_rtMonitor_enableIntradayTZ");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                        '<img src="" />'+ name+
                                    '</li>';
                                // 禁用当天常开时间段
                                reqUrl = "/psgRTMonitor.do?disableNormalOpenGate";
                                name = I18n.getValue("common_rtMonitor_disableIntradayTZ");
                                $html+='<li  onclick="mapRemoteOperate(\''+reqUrl+'\', \''+deviceId+'\',\''+deviceName+'\',\''+name+'\');" >'+
                                        '<img src="" />'+ name+
                                    '</li>';
                                // 查询最近发生事件
                                name = I18n.getValue("psg_gateEventLatestHappen");
                                $html+='<li  onclick="openGateEventWindow( \''+deviceId+'\');" >'+
                                    '<img src="" />' + name + '</li>';
                                if (channelIds) {
                                    name = I18n.getValue("system_module_videoPreview");
                                    $html+='<li  onclick="mapRTMonitorChannelPreview( \''+channelIds+'\');" >'+'<img src="" />' + name + '</li>';
                                }
                            }
                            if("VidChannel"==marker.customData.entityType){
                                 // 右键视频预览
                                 $html+='<li id="baiduMap_preview" onclick="getVideoPreviewByVidChannelId(\''+marker.customData.entityId+'\',\'' +marker.customData.deviceName+'\')" >'+
                                             '<img src="" />'+ I18n.getValue("map_navigation_preview")+
                                         '</li>';
                                  // 获取告警详情点击按钮
                                  $html+='<li id="baiduMap_alarm_record" onclick="getAlarmDetailByCameraId(\''+marker.customData.entityId+'\')" >'+
                                             '<img src="" />'+ I18n.getValue("map_alarm_queryRecord")+
                                         '</li>';
                            }

                        }else if("mapMain"==pageSource){
                             $html+='<li id="baiduMap_del_icon" >'+
                                         '<img src="/public/images/opToolbar/comm_del.png" />'+  I18n.getValue("base_map_delEntity")+
                                    '</li>';
                             // 正在添加不允许修改图标
                             if("VidChannel" == marker.customData.entityType && $("#addMarkerToMapPrompt.displayCss").length > 0) {
                                 // 修改图标
                                 $html+='<li id="baiduMap_modify_icon" >'+
                                      '<img src="/public/images/opToolbar/comm_edit.png" />'+  I18n.getValue("base_map_modifyIcon")+
                                 '</li>';
                             }
                        }

                        if(""!=$html){
                            $("#baiduMap_contextmenu").append($html);
                        }
                        // ul菜单出现
                        $(".contextmenu").css({
                            "left": menuLeft,
                            "top": menuTop
                        }).show();
                        $("#baiduMap_contextmenu").find("li").off('click').on('click',function(){
                                // ul菜单隐藏
                                 $(".contextmenu").css({
                                     "left": menuLeft,
                                     "top": menuTop
                                 }).hide();
                        });
                        $("#baiduMap_del_icon").off('click').on('click',function(){
                               mapMainBaidu.delEntityToMap(marker);
                        });
                        $("#baiduMap_modify_icon").off('click').on('click',function(){
                            mapMainBaidu.modifyEntityIcon(marker);
                        });
                   });
         }


           /*移除点位到地图*/
         mapMainBaidu.delEntityToMap = function delEntityToMap(marker){
            mapId = mapTree.getAllChecked();
            if(mapId != "" && mapId != "0" && mapId.indexOf("_")<0){
                 var getData="&ids="+marker.customData.mapElementId+"&name="+marker.customData.deviceName;
                 mapMainBase.delGisMapPos(getData,marker,function(result,marker){
                        var allOverlay = baiduMap.getOverlays();
                        for(var j = 0;j<allOverlay.length;j++) {
                            if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==marker.customData.entityId){
                               baiduMap.removeOverlay(allOverlay[j]);
                               break;
                            }
                        }
                      if(typeof(deleteZtreeNode) == 'function'){
                           deleteZtreeNode(marker.customData.entityId);
                      }
                      $(".contextmenu").hide();
                      openMessage(msgType.success, result.msg);
                 })
            }else{
                messageBox({messageType:"alert",text: I18n.getValue("base_map_plSelMap")});//${base_map_plSelMap}://请选择地图
            }
         }

         /** 修改地图图标 */
         mapMainBaidu.modifyEntityIcon = function modifyEntityIcon(marker) {
            mapId = mapTree.getAllChecked();
            if(mapId != "" && mapId != "0" && mapId.indexOf("_") < 0) {
                var path = "/mapElement.do?getModifyElementIconView&id=" + marker.customData.id + "&name=" + marker.customData.deviceName;
                var opts = {//弹窗配置对象
                    path: path,//设置弹窗路径
                    width: 400,//设置弹窗宽度
                    height: 200,//设置弹窗高度
                    title: I18n.getValue("base_map_modifyIcon"),//设置弹窗标题
                    gridName: "gridbox"//设置grid

                };
                DhxCommon.createWindow(opts);
                // 菜单隐藏
                $(".contextmenu").hide();
            } else {
                // 请选择地图
                messageBox({messageType:"alert",text: I18n.getValue("base_map_plSelMap")});
            }
         }



          /*搜索标记点位*/
          mapMainBaidu.searchMarkerByDeviceId = function searchMarkerByDeviceId(deviceId,name){
                 var opts = {
                      width: 80,
                      height: 30,
                      title: ''
                 };
                 var allOverlay = baiduMap.getOverlays();
                 if(undefined!=deviceId&&null!=deviceId&&""!=deviceId){
                        var marker;
                        for(var j = 0;j<allOverlay.length;j++) {
                              if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==deviceId){
                                  if(undefined!=infoBoxWindow){
                                    infoBoxWindow.close(baiduMap,allOverlay[j]);
                                  }
                                  var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='max-width: 700px;border-radius: 10px;background-color: rgba(0, 0, 0,.7);position:relative;z-index: -1;color: white;border: 1px dotted rgba(0, 0, 0, 0);min-width: 150px;height: 43px;' >" +
                                              "<div id='title_" + allOverlay[j].customData.entityId + "' style='border-radius: 15px;height: 40px;'>" +
                                             "</br>"+allOverlay[j].customData.title+"</div> <div class=\"arrow-down\" style='top: 44px;border-top: 10px solid rgba(0, 0, 0,.7);margin-left: 62px;' ></div></div>";
                                  infoBoxWindow = new BMapLib.InfoBox(baiduMap,content,{
                                     boxStyle:{
                                          width: "150px",
                                          height: "55px"
                                        },
                                     closeIconUrl:"images/googleMap/close.png",//关闭图标的图片路径
                                     closeIconMargin: "1px 1px 0 0",//关闭图标距离右上角的间距
                                     enableAutoPan: true,
                                     align: INFOBOX_AT_TOP,//infobox显示位置，目前只有上和下
                                     offset: new BMap.Size(10, 20) //infobox偏移量
                                  });
                                  infoBoxWindow.open(mapMainBaidu.getInfoPosition(allOverlay[j]));
                                  marker=allOverlay[j];
                                 return;
                              }
                        }
                        if(undefined!=marker){
                              baiduMap.panTo(marker);
                        }
                 }
                 if(undefined!=name&&null!=name&&""!=name){
                      var marker;
                      for(var j = 0;j<allOverlay.length;j++) {
                            if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.deviceName==name){
                                if(undefined!=infoBoxWindow){
                                   infoBoxWindow.close(baiduMap,allOverlay[j]);
                                 }
                                var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='max-width: 700px;border-radius: 10px;background-color: rgba(0, 0, 0,.7);position:relative;z-index: -1;color: white;border: 1px dotted rgba(0, 0, 0, 0);min-width: 150px;height: 43px;' >" +
                                              "<div id='title_" + allOverlay[j].customData.entityId + "' style='border-radius: 15px;height: 40px;'>" +
                                             "</br>"+allOverlay[j].customData.title+"</div> <div class=\"arrow-down\" style='top: 44px;border-top: 10px solid rgba(0, 0, 0,.7);margin-left: 62px;'</div></div>";
                                  infoBoxWindow = new BMapLib.InfoBox(baiduMap,content,{
                                     boxStyle:{
                                          width: "150px",
                                          height: "55px"
                                        },
                                     closeIconUrl:"images/googleMap/close.png",//关闭图标的图片路径
                                     closeIconMargin: "1px 1px 0 0",//关闭图标距离右上角的间距
                                     enableAutoPan: true,
                                     align: INFOBOX_AT_TOP,//infobox显示位置，目前只有上和下
                                     offset: new BMap.Size(10, 20) //infobox偏移量
                                  });
                                  infoBoxWindow.open(mapMainBaidu.getInfoPosition(allOverlay[j]));
                                  marker=allOverlay[j];
                                 return;
                            }
                      }
                      if(undefined!=marker){
                            baiduMap.panTo(marker);
                      }
                }
                //openMessage(msgType.warning, I18n.getValue("map_no_search_device"), 1000);
          }

              /*根据设备点位entityId地图定位*/
          mapMainBaidu.searchMarkerByEntityId = function searchMarkerByEntityId(entityId){
               var opts = {
                    width: 80,
                    height: 30,
                    title: ''
               };
               var allOverlay = baiduMap.getOverlays();
               if(undefined!=entityId&&null!=entityId&&""!=entityId){
                      var marker;
                      for(var j = 0;j<allOverlay.length;j++) {
                            if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==entityId){
                              if(undefined!=infoBoxWindow){
                                infoBoxWindow.close(baiduMap,allOverlay[j]);
                              }
                              var marker = allOverlay[j];
                              var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='max-width: 700px;border-radius: 10px;background-color: rgba(0, 0, 0,.7);position:relative;z-index: -1;color: white;border: 1px dotted rgba(0, 0, 0, 0);min-width: 150px;height: 43px;' >" +
                                          "<div id='title_" + allOverlay[j].customData.entityId + "' style='border-radius: 15px;height: 40px;'>" +
                                         "</br>"+allOverlay[j].customData.title+"</div> <div class=\"arrow-down\" style='top: 44px;border-top: 10px solid rgba(0, 0, 0,.7);margin-left: 62px;'</div></div>";
                              infoBoxWindow = new BMapLib.InfoBox(baiduMap,content,{
                                 boxStyle:{
                                      width: "150px",
                                      height: "55px"
                                    },
                                 closeIconUrl:"images/googleMap/close.png",//关闭图标的图片路径
                                 closeIconMargin: "1px 1px 0 0",//关闭图标距离右上角的间距
                                 enableAutoPan: true,
                                 align: INFOBOX_AT_TOP,//infobox显示位置，目前只有上和下
                                 offset: new BMap.Size(0, 20) //infobox偏移量
                              });
                              infoBoxWindow.open(mapMainBaidu.getInfoPosition(marker));
                               return;
                            }
                      }
                       if(undefined!=marker){
                               baiduMap.panTo(marker);
                       }

               }

        }

};

/**
 * 初始化视图
 */
var _initView = function(mapMainBaidu) {


        //处理Gis地图设备状态数据
        mapMainBaidu.dealBaiduMapDevStateData =function dealBaiduMapDevStateData() {
                var doorStates = mapClient.devData;
                var iconImage;
                var iconFolderName;
                if(doorStates == "" || doorStates == null || doorStates == undefined){
                    return;
                }
                if (sysCfg.skin == "techblue") {
                    iconImage = "/public/skins/techblue/imgs/doorState.png";
                } else {
                    iconImage = "/images/doorState/doorState.png";
                }
                var allOverlay = baiduMap.getOverlays();
                for(var i = 0; i < doorStates.length; i++){
                    // elementId是元素在设备中心的id
                    var id = doorStates[i].uniqueKey;
                    iconFolderName = doorStates[i].iconFolderName;
                    var entityType = doorStates[i].entityType;
                    // 偏移获取所有门禁图标，修改图标状态
                     for(var j = 0;j<allOverlay.length;j++) {
                         if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==id){
                            var myIcon;
                            var entityType = allOverlay[j].customData.entityType;
                            if (entityType == "AccDoor") {
                                var offsetCss = mapMainBase.doorIconChange("baiduMap", iconFolderName, doorStates[i].image);
                                var offsetCssX = offsetCss[0];
                                var offsetCssY = offsetCss[1];
                                myIcon = new BMap.Icon(iconImage, new BMap.Size(40, 40), {
                                   imageOffset: new BMap.Size(offsetCssX, offsetCssY)// 设置图片偏移来更换门状态图标
                                });
                            } else if (entityType == "PsgGate") {
                                iconImage = "/images/gateState/" + sysCfg.skin + "/icon/" + doorStates[i].iconFolderName + "/gate_" + doorStates[i].image +".png";
                                myIcon = new BMap.Icon(iconImage, new BMap.Size(40, 40));
                            }
                             if (doorStates[i].image != accMapDeviceAlarmMap.get(doorStates[i].devSn)) {
                                allOverlay[j].setIcon(myIcon)
                             }
                             if ((undefined == accMapDeviceAlarmMap.get(doorStates[i].devSn) || doorStates[i].image != accMapDeviceAlarmMap.get(doorStates[i].devSn))
                                                                                             && ("alarm_nosensor_old" == doorStates[i].image || "alarm_nosensor" == doorStates[i].image)) {
                                var color = '#ff4d4f';
                                //更改告警状态前，去除旧的告警状态效果
                                $("#circle_" + allOverlay[j].customData.entityId).remove();
                                /*改变点位的状态*/
                                var contentHtml='<div id="circle_'+allOverlay[j].customData.entityId+'" style="width: 100px;height: 100px; position: absolute; left: -33px;  top: -34px;"  class="wave ripple danger">'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'"></div>'+
                                                '<div class="circle" style="background:'+color+';border-color:'+color+';color:'+color+'" ></div>'+
                                                '</div>'
                                $(allOverlay[j].Yc).parent().append(contentHtml);
                            }
                            if (doorStates[i].image.indexOf("alarm_nosensor") == -1 && $("#circle_" + allOverlay[j].customData.entityId).length > 0) {
                                $("#circle_" + allOverlay[j].customData.entityId).remove();
                            }
                            break;
                         }
                     }
                }
        }

            /*添加或移动地图点位*/
          mapMainBaidu.addMarkerToMap = function addMarkerToMap(allChildrenNodes,addMarker_leftX,addMarker_topY){
                      var allOverlay = baiduMap.getOverlays();
                      var msg="";
                      var count=0;
                      // var addMarkerLength= Math.ceil(Math.sqrt(allChildrenNodes.length));
                      var mapZoom=Number(baiduMap.getZoom());
                      var scalingFactor;
                      try{
                                switch(mapZoom%3){
                                      case 0:
                                          scalingFactor=1;
                                      break;
                                      case 1:
                                          scalingFactor=4;
                                      break;
                                      case 2:
                                          scalingFactor=2;
                                      break;
                              }
                              if(Math.ceil(mapZoom/3)>2){
                                    scalingFactor= (2.5/Math.pow(10,(Math.ceil(mapZoom/3)-2)))*scalingFactor;
                              }else if(Math.ceil(mapZoom/3)==2){
                                    scalingFactor=(1.25)*scalingFactor
                              }else{
                                   scalingFactor=0.01;
                              }
                      }catch (e) {
                            scalingFactor=0.01;
                      }

                      for(var i=0;i<allChildrenNodes.length;i++){
                             var  childrenNode= allChildrenNodes[i];
                             var  entityType= childrenNode.entityType;
                             if("Area"==entityType){
                                      addDeviceZTree.setChkDisabled(childrenNode, false);
                                      addDeviceZTree.checkNode(childrenNode, true, false);
                                      addDeviceZTree.setChkDisabled(childrenNode, true);
                                      continue;
                             }
                             if(""==childrenNode.icon){
                                    msg+= childrenNode.name+I18n.getValue("map_marker_add_prompt_3");
                                    continue;
                             }

                             var mapElementId="";
                             for(var j = 0;j<allOverlay.length;j++) {
                                 if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityId==childrenNode.entityId){
                                    mapElementId=allOverlay[j].customData.mapElementId;
                                    baiduMap.removeOverlay(allOverlay[j]);
                                    break;
                                 }
                             }
                             addDeviceZTree.setChkDisabled(childrenNode,false);
                             addDeviceZTree.checkNode(childrenNode,true,false);
                             addDeviceZTree.setChkDisabled(childrenNode, true);

                            // 创建图标
                            var myIcon = new BMap.Icon(childrenNode.icon, new BMap.Size(40, 40));
                            if(allChildrenNodes.length>1){
                               // 每6个一排，超出换行
                               var addMarkerRowCount = 6;
                               if(count==addMarkerRowCount){
                                     addMarker_topY=Number(addMarker_topY)-(scalingFactor*(addMarkerRowCount-1));
                                     addMarker_leftX=Number(addMarker_leftX)-(scalingFactor);
                                     count=1;
                               }else{
                                    if(i!=0){
                                          addMarker_topY=Number(addMarker_topY)+(scalingFactor);
                                    }
                                    count++;
                               }
                            }
                            var marker;
                            if(entityType == "DefendArea"){
                                //防区创建多边形, 默认创建一个正方形
                                marker = new BMap.Polygon([
                                    new BMap.Point(addMarker_topY, addMarker_leftX),
                                    new BMap.Point(addMarker_topY + 0.01, addMarker_leftX),
                                    new BMap.Point(addMarker_topY + 0.01, addMarker_leftX + 0.008),
                                    new BMap.Point(addMarker_topY, addMarker_leftX + 0.008),
                                ], baiduPolygonStyle);
                                marker.enableEditing(true);
                            }else{
                                // 创建Marker标注，使用图标
                                var pt = new BMap.Point(addMarker_topY,addMarker_leftX);
                                marker = new BMap.Marker(pt, {
                                          enableDragging: false,
                                          icon: myIcon
                                });
                                marker.enableDragging();
                            }
                            marker.customData = {
                                    'title': childrenNode.name,
                                    'mapElementId': mapElementId,
                                    'entityType': childrenNode.entityType,
                                    'deviceName': childrenNode.name,
                                    'entityId': childrenNode.entityId,
                                    'SN': childrenNode.deviceSn,
                             }
                            // 将标注添加到地图
                            baiduMap.addOverlay(marker);

                            /*如果开启点位移动，为后续点位开启*/
                            if($("#drag").hasClass("saveButton")){
                                 marker.enableDragging();
                            }
                            /*添加右键事件*/
                            mapMainBaidu.markerRightclick(marker);
                            var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='max-width: 700px;border-radius: 10px;background-color: rgba(0, 0, 0,.7);position:relative;z-index: -1;color: white;border: 1px dotted rgba(0, 0, 0, 0);min-width: 150px;height: 43px;' >" +
                                          "<div id='title_" + childrenNode.entityId + "' style='border-radius: 15px;height: 40px;'>" +
                                         "</br>"+marker.customData.title+"</div> <div class=\"arrow-down\" style='top: 44px;border-top: 10px solid rgba(0, 0, 0,.7);margin-left: 62px;'</div></div>";
                            mapMainBaidu.markerMouseover(marker,content);


                      }
                     if(""!=msg){
                            openMessage(msgType.info,msg);
                     }
          }

          /*标注划过信息提示*/
          mapMainBaidu.markerMouseover = function markerMouseover(marker,content){
                       var infoBox = new BMapLib.InfoBox(baiduMap,content,{
                            boxStyle:{
                                width: "150px",
                                height: "55px"
                            },
                            closeIconUrl:"images/googleMap/close.png",//关闭图标的图片路径
                            closeIconMargin: "1px 1px 0 0",//关闭图标距离右上角的间距
                            enableAutoPan: true,
                            align: INFOBOX_AT_TOP,//infobox显示位置，目前只有上和下
                            offset: new BMap.Size(10, 20) //infobox偏移量
                          });

                      marker.addEventListener("mouseover",function(content){
                            //计算信息窗口展示点位
                            infoBox.open(mapMainBaidu.getInfoPosition(marker));
                           // 信息div的原始高度
                           var infoOriginHeight = 40;
                           var entityId = marker.customData.entityId;
                           // 当前信息div的高度,用于判断是否溢出
                           var titleObj = document.getElementById("title_" + entityId);
                           var infoHeight = titleObj.scrollHeight;
                           var arrowDownObj = $(titleObj).next();
                           var arrowDownTop = arrowDownObj.position().top;
                           // 当前信息高度大于原始高度,重新计算浮动信息位置并设置
                           if (infoHeight > infoOriginHeight) {
                               var height = infoHeight- infoOriginHeight;
                               $("#poPupInfo").css("height", (infoHeight+3) + "px");
                               arrowDownObj.css("top", arrowDownTop + height);
                               $("#poPupInfo").parent().css("height", 55 + height + "px");
                           }
                      });
                      marker.addEventListener("mouseout",function(event){
                            infoBox.close();
                      });

          }

          /*初始化点位到地图*/
          mapMainBaidu.findPathProcess = function findPathProcess(callback){
                if(mapPosListJson == "" || mapPosListJson==null || mapPosListJson == undefined){
                    return;
                }
                var mapPosList = JSON.parse(mapPosListJson);
                if(mapPosList.length <= 0){
                    return;
                }
                var x=0,y=0;
                for(var i = 0 ; i< mapPosList.length;i++){
                    var imgPath = "";
                    var sn="";
                    var entityType = mapPosList[i].entityType
                    if(entityType == "AccDoor"){
                         imgPath = "/images/"+ systemSkin +"/map/acc_door.png";
                         sn= mapPosList[i].entityName;
                    }else if(entityType == "VidChannel"){
                        sn= mapPosList[i].deviceAlarmSN;
                        if(mapPosList[i].vidEntityType == 0 || mapPosList[i].vidEntityType == 1){
                            imgPath = "/images/gisMap/camera_icons-15.png";
                        }else if(mapPosList[i].vidEntityType == 2){
                            imgPath = "/images/gisMap/camera_icons-19.png";
                        }else if(mapPosList[i].vidEntityType == 3){
                            imgPath = "/images/gisMap/camera_icons-17.png";
                        }else if(mapPosList[i].vidEntityType == 4){
                            imgPath = "/images/gisMap/camera_icons-18.png";
                        }else{
                            imgPath = mapPosList[i].entityIcon;
                        }
                    }else if(entityType == "BolidDevice"){
                         imgPath = "/images/map/bolid_dev_normal.png";
                          sn= mapPosList[i].deviceAlarmSN;
                     } else {
                        imgPath = mapPosList[i].entityIcon;
                     }
                    // 创建图标
                    var myIcon = new BMap.Icon(imgPath, new BMap.Size(40, 40));
                    var marker;
                    // 创建Marker标注，使用图标
                    if (entityType != "DefendArea") {
                        var pt = new BMap.Point(mapPosList[i].points[0].positionY,mapPosList[i].points[0].positionX);
                        marker = new BMap.Marker(pt, {
                                    enableDragging: false,
                                    icon: myIcon
                        });
                    } else {
                        //防区创建多边形
                        var pointArray = mapPosList[i].points.map(function(point, i){
                            return new BMap.Point(point.positionY, point.positionX);
                        });
                        marker = new BMap.Polygon(pointArray, baiduPolygonStyle);
                    }
                    //自定义数据
                    marker.customData = {
                              'id': mapPosList[i].id,
                              'title': mapPosList[i].entityName,
                              'mapElementId': mapPosList[i].id,
                              'entityType': entityType,
                              'deviceName': mapPosList[i].entityName,
                              'entityId': mapPosList[i].entityId,
                              'SN':sn,
                              'channelIds': mapPosList[i].channelIds,
                    }
                    // 将标注添加到地图
                   baiduMap.addOverlay(marker);
                    var content="<div class='poPupInfo_news' id='poPupInfo' align='left' style='max-width: 700px;border-radius: 10px;background-color: rgba(0, 0, 0,.7);position:relative;z-index: -1;color: white;border: 1px dotted rgba(0, 0, 0, 0);min-width: 150px;height: 43px;' >" +
                             "<div id='title_" + mapPosList[i].entityId + "' style='border-radius: 15px;height: 40px;'>" +
                            "</br>"+marker.customData.title+"</div> <div class=\"arrow-down\" style='top: 44px;border-top: 10px solid rgba(0, 0, 0,.7);margin-left: 62px;'</div></div>";
                    mapMainBaidu.markerMouseover(marker,content);
                    mapMainBaidu.markerRightclick(marker);
                    mapMainBaidu.markerLeftclick(marker);
                }
                return callback();

          }

          /**  更新地图上门的全局变量*/
          mapMainBaidu.updateDoorIds =  function updateDoorIds() {
                    doorIds = "";
                    var allOverlay = baiduMap.getOverlays();
                    for(var j = 0;j<allOverlay.length;j++) {
                         if(undefined!=allOverlay[j].customData&&allOverlay[j].customData.entityType=="AccDoor"){
                                var doorId =allOverlay[j].customData.entityId;
                                doorIds += "," +doorId;
                         }
                    }
          }



          /**
           * 修改鼠标样式
           * 默认箭头样式	cursor:default	系统默认 箭头样式
            手型	cursor: pointer	系统自带 手型
            手型	cursor:hand	系统自带 手型    提示 只有ie5支持这种手型也只支持这种
            移动十字箭头	cursor: move	系统自带 移动十字箭头
            帮助问号	cursor: help	系统自带 帮助问号
            十字准心	cursor:crosshair	系统自带 十字准心
            文字/编辑	cursor: text	系统自带 编辑或者框选文字时 竖线型
            无法释放(禁用)	cursor:no-drop	系统自带 当不可编辑时禁用型
            禁用	cursor:not-allowed	系统自带 当不可编辑时禁用型
            自动	cursor:auto	就是由系统根据当前元素自动设置
            处理中	cursor: progress	win7为一个圆环，xp为一个沙漏，等待处理中样式
            向上改变大小	cursor: n-resize	系统自带
            向下改变大小	cursor: s-resize	系统自带
            向左改变大小	cursor: w-resize	系统自带
            向右改变大小	cursor: e-resize	系统自带
            向上左改变大小	cursor: nw-resize	系统自带
            向下左改变大小	cursor: sw-resize	系统自带
            向上右改变大小	cursor: ne-resize	系统自带
            向下右改变大小	cursor: se-resize	系统自带
           * @param type
           */
          mapMainBaidu.modificarEstiloDeMouse =  function modificarEstiloDeMouse(type) {
                baiduMap.setDefaultCursor(type);
          }

          /**
          * 开启防区报警闪烁
          * entityIds 开启报警闪烁的防区ids,不在指定ids内的其他防区都会被关闭闪烁
          */
          mapMainBaidu.updateDefendAreaStatus = function updateDefendAreaStatus(entityIds){
                var enableCount = 0;
                //预处理
                var allOverlay = baiduMap.getOverlays();
                for(var j = 0;j<allOverlay.length;j++) {
                    if(undefined!=allOverlay[j].customData && allOverlay[j].customData.entityType == "DefendArea"){
                        if(entityIds != null && entityIds.length > 0 && entityIds.indexOf(allOverlay[j].customData.entityId) != -1){
                            mapFlashEntityMap.set(allOverlay[j].customData.entityId, allOverlay[j]);
                            enableCount++;
                        }else{
                            mapFlashEntityMap.delete(allOverlay[j].customData.entityId, allOverlay[j]);
                            allOverlay[j].setFillColor("#7AC142");
                        }
                    }
                }
                if(enableCount == 0){
                    window.clearInterval(mapFlashHandle);
                    mapFlashHandle = null;
                    mapFlashEntityMap.clear();
                }else if(mapFlashHandle == null){
                    mapFlashHandle = window.setInterval(function(){
                        mapFlashEntityMap.forEach(function(marker, entityId){
                            if(marker.getFillColor() == "#ff9999"){
                              marker.setFillColor("red");
                            }else{
                              marker.setFillColor("#ff9999");
                            }
                        });
                    }, 500);
                }
          }

        /**
        * 更新地图上设备元素状态
        */
        mapMainBaidu.updateDeviceElementStatus = function updateDeviceElementStatus(devData) {
            var devStates = devData.data;
            // 百度地图上所有元素
            var allOverlay = baiduMap.getOverlays();
            for (var i = 0; i < devStates.length; i++) {
                var entityId = devStates[i].uniqueKey;
                var status = devStates[i].status;
                for (var j = 0; j < allOverlay.length; j++) {
                    var customData = allOverlay[j].customData;
                    if(undefined != customData && customData.entityId == entityId) {
                        var oldImgSrc = allOverlay[j].getIcon().imageUrl;
                        var photoName = oldImgSrc.substring(oldImgSrc.lastIndexOf("/"), oldImgSrc.lastIndexOf("."));
                        var newImgSrc;
                        // 先去除禁用的标记
                        $("#circle_" + entityId + "_status").remove();
                        // 在线
                        if (status == 1) {
                            // 变更为在线图标
                            if (oldImgSrc.indexOf("_offline") != -1) {
                                newImgSrc = oldImgSrc.replace(photoName, photoName.replace("_offline", ""));
                            }
                        } else if (status == 0) {
                            // 设置离线图标
                            if (oldImgSrc.indexOf("_offline") == -1) {
                                newImgSrc = oldImgSrc.replace(photoName, photoName + "_offline");
                            }
                        } else if (status == 2) {
                            // 禁用
                            var contentHtml = "<div id='circle_" + entityId + "_status' style='position: absolute;width:40px;height:40px' class='circle_gray'></div>";
                            $(allOverlay[j].Yc).parent().append(contentHtml);
                        }
                        // 新图标路径为空表示状态未发生变化,不做更新
                        if (!newImgSrc) {
                            return;
                        }
                        var myIcon = new BMap.Icon(newImgSrc, new BMap.Size(40, 40));
                        allOverlay[j].setIcon(myIcon);
                    }
                }
            }
        }

          /**
          * 获取地图元素的名称气泡显示的坐标
          */
          mapMainBaidu.getInfoPosition = function getInfoPosition(marker){
                var markerPoint;
                if(marker.customData != undefined && marker.customData.entityType == "DefendArea"){
                    var maxLat,minLng,maxLng;
                    for(var tempIndex = 0; tempIndex < marker.getPath().length; tempIndex++){
                        if(maxLat == null || Math.max(marker.getPath()[tempIndex].lat, maxLat) > maxLat){
                            maxLat = marker.getPath()[tempIndex].lat;
                        }
                        if(minLng == null || Math.min(marker.getPath()[tempIndex].lng, minLng) < minLng){
                            minLng = marker.getPath()[tempIndex].lng;
                        }
                        if(maxLng == null || Math.max(marker.getPath()[tempIndex].lng, maxLng) > maxLng){
                            maxLng = marker.getPath()[tempIndex].lng;
                        }
                    }
                    markerPoint = new BMap.Point((minLng + maxLng)/2.0, maxLat);
                }else{
                    markerPoint = marker.getPosition();
                }
                return markerPoint;
          }
};

/**
 * 初始化
 */
(function (mapMainBaidu) {
        //数据初始化
        _initView(mapMainBaidu);
        /*初始化渲染页面样式*/
        _initEvent(mapMainBaidu);

    window.mapMainBaidu = mapMainBaidu;
})(window.mapMainBaidu || {});


