//更新监控地图上元素的状态和更新新的事件到左侧列表



/*存放点位状态*/
var accMapDeviceAlarmMap = new Map();
var listenerKeyMap = new Map();
var vid_channel_SN = new Map();
var googleMap_richMarker_Map = new Map();

$(function() {
	accMapDeviceAlarmMap.clear();
	listenerKeyMap.clear();
	vid_channel_SN.clear();
	googleMap_richMarker_Map.clear();

})

function initMapAlarm() {
	accMapDeviceAlarmMap.clear();
	listenerKeyMap.clear();
	vid_channel_SN.clear();
	googleMap_richMarker_Map.clear();

}

//订阅事件推送时候调用的方法
function renderAlarmDataList(eventData) {
	var $html = "";
	var alarmType = "";
	//告警级别
	var alarmLevel = "";
	var alarmLevelColor = "";
	var levelValue = "";
	levelValue = eventData.eventLevelVal;
	// 配置了日期格式，对原来时间格式进行替换
	eventData.eventTimeStr = dhx4.date2str(new Date(eventData.eventTimeStr.replace(/-/g, "/")), sysCfg.dhxLongDateFmt);
	var echartsPie_legend = $("#echartsPie_legend").val();

	var selectAlarmType = "";
	var selectAlarmTypeId = "selectAlarmType";
	if (ZKUI.Combo.get(selectAlarmTypeId) != null && ZKUI.Combo.get(selectAlarmTypeId) != "" && ZKUI.Combo.get(selectAlarmTypeId) != undefined) {
		selectAlarmType = ZKUI.Combo.get(selectAlarmTypeId).combo.getSelectedValue();
	}
	if ("" != selectAlarmType && eventData.sourceModule != selectAlarmType) {
		return false;
	}
	if ("" != echartsPie_legend && echartsPie_legend.indexOf(levelValue) != -1) {
		eventData = eventData;
		translateEvent(eventData);
		$html += "<div class=\"comment\" data-eventtime='" + eventData.eventTime + "' data-id='" + eventData.id + "' style='background-color: rgba(51, 60, 66, 0.5)' >\n" +
			"    <div class=\"comment-header\" style='background-color: " + eventData.eventLevelColor + "'></div>\n" +
			"    <div class=\"comment-header-left\">\n" +
			"        <div class=\"left-title\" title=\"" + eventData.eventName + "\" >" + eventData.eventName + "</div>\n" +
			"        <div class=\"left-info\" data-id='" + eventData.id + "' data-cameraname='" + eventData.sourceName + "' data-cameraid='" + eventData.sourceKey + "' data-type='" + eventData.alarmType + "' title='" + eventData.sourceName + "' >" +
			"           <span class=\"right-span icv-mapcenter_devLocation\" data-cameraname='" + eventData.sourceName + "' data-cameraid='" + eventData.sourceKey + "' onclick=\"alarmDeviceMapLocation(this)\" style=\"display: inline;font-size: 14px;cursor: pointer;\" title=\"" + I18n.getValue('map_gis_location') + "\">" +
			"           </span>" + eventData.sourceName + "</div>\n" +
			"        <div class=\"left-info\">" + eventData.eventTimeStr + "</div>\n" +
			"    </div>\n" +
			"    <div class=\"comment-header-right\"  >\n" +
			"        <div class=\"right-title\" style='background-color: " + eventData.eventLevelColor + "'>\n" + eventData.eventLevel +
			"        </div>\n" +
			"        <div class=\"right-info\" style=\"\">\n" +
			"            <span class=\"right-span icv-system_detail\" title=\"" + I18n.getValue('map_detail') + "\" style=\"font-size: 18px;cursor: pointer;\" onclick=\"commentInfo('" + eventData.id + "','" + eventData.sourceModule + "','" + eventData.sourceKey + "')\" >\n" +
			"            </span>\n" +
			"        </div>\n" +
			"    </div>\n" +
			"</div>";

		if ("" != $html) {
			$("#conversation").prepend($html);
		} else {
			$html += "";
			$("#conversation").prepend($html);
		}
	}
    $("#conversation .comment").off("click").click(function(){
        $("#conversation .comment").removeClass("active");
        $(this).addClass("active");
    })
    if (mapEventListLengthLimitSwitch){
        $("#conversation .comment:gt("+mapEventListMaxLength+")").remove();
    }

}

/**
 *初始化告警更新点位告警状态
 */
function initAlarmDevClient(pageSource) {
	try {
		initMapAlarm();
		var divs = $("div[id^=VidChannel_]");
		var devIds = [];
		if (window.tempMapType == "GIS") {
			// gis 地图获取摄像机列表
			var features = source.getFeatures();
			if (features == null || features.length < 1) {
				return;
			}
			for (var i = 0; i < features.length; i++) {
				var entityId = features[i].getProperties().POP.split("_")[1];
				var SN = features[i].getProperties().SN;
				devIds.push(SN);
			}
		} else if (window.tempMapType == "Normal") {
			if (divs.length > 0) {
				for (var i = 0; i < divs.length; i++) {
					var id = divs[i].id;
					// 先将图标还原
					var img = $("#" + id + " img")[0];
					var imgSrc = img.src;
					if (imgSrc.indexOf(".gif") != -1) {
						imgSrc = imgSrc.replace('_Prompt', '');
						imgSrc = imgSrc.replace('_General', '');
						imgSrc = imgSrc.replace('_Important', '');
						imgSrc = imgSrc.replace('_Exigency', '');
						img.src = imgSrc.replace(".gif", ".png");
					}
					var SN = $('#' + id).attr("data-sn");
					devIds.push(SN);
					id = id.replace("VidChannel_", "");
					vid_channel_SN.set(SN, id);
				}
			}
		} else if (window.tempMapType == "Google") {
			googleMapPosMap.forEach(function(marker, key) {
				devIds.push(marker.entityId);
			});
		} else if (window.tempMapType == "Baidu") {
			var allOverlay = baiduMap.getOverlays();
			for (var j = 0; j < allOverlay.length; j++) {
				if (undefined != allOverlay[j].customData) {
					devIds.push(allOverlay[j].customData.entityId);
				}
			}
		}
		if (pageSource == "mapMainMonitor") {
			if (devIds.length < 1) {
				return;
			}
			updateCameraStatus(devIds);
			if (cameraPullingHandler == null) {
				cameraPullingHandler = setInterval(function(devIds) {
					updateCameraStatus(devIds);
				}, 5000, devIds);
			}
		}
	} catch (err) {
		// console.log("Error name: " + err.name + "");
		// console.log("Error message: " + err.message);
	}
}
// 立即获取摄像头的当前状态
function updateCameraStatus(devIds) {
	$.ajax({
		type: 'post',
		url: 'mapMonitoring.do?getElementStatus',
		dataType: 'json',
		async: true,
		data: {
			"devIds": devIds.join(","),
			"elementType": "Vid"
		},
		success: function(result) {
			if (result.success) {
				var statusData = result.data;
				var sn;
				var alarmLevel;
				var deviceState;
				for (var i = 0; i < statusData.length; i++) {
					sn = statusData[i]["uniqueKey"];
					alarmLevel = statusData[i]["alarmLevel"];
					deviceState = statusData[i]["status"];
					if ("mapMainMonitor" == pageSource) {
						switch (window.tempMapType) {
							case "Normal":
								mapMainGeneral.generalMapAlarms(sn, alarmLevel, deviceState);
								break;
							case "GIS":
								mapMainGis.gisMapAlarms(sn, alarmLevel, deviceState);
								break;
							case "Google":
								mapMainGoogle.googleMapAlarms(sn, alarmLevel, deviceState);
								break;
							case "Baidu":
								mapMainBaidu.baiduMapAlarms(sn, alarmLevel, deviceState);
								break;
						}

					} else if ("mapMain" == pageSource) {
						switch (window.tempMapType) {
							case "Normal":
								mapMainGeneral.generalMapDeviceState(sn, deviceState);
								break;
							case "GIS":
								mapMainGis.gisMapDeviceState(sn, deviceState);
								break;
							case "Google":
								mapMainGoogle.googleMapDeviceState(sn, deviceState);
								break;
							case "Baidu":
								mapMainBaidu.baiduMapDeviceState(sn, deviceState);
								break;
						}
					}
					accMapDeviceAlarmMap.set(sn, statusData[i]);
				}
			}
		},
		error: function() {
			console.error("Map get element status error!")
		}
	});
}

//初始化门状态的监听事件，定时15s更新一次
function loadMapDevStateData() {
	try {
		if (doorIds == "") {
			return;
		}
		updateDoorStatus();
		if (!accDoorPullingHandler) {
			accDoorPullingHandler = setInterval(function() {
				updateDoorStatus();
			}, 5000);
		}
	} catch (err) {
		console.log("loadMapDevStateData Error name: " + err.name + "");
		console.log("loadMapDevStateData Error message: " + err.message);
	}
}

//立即更新门的当前状态
function updateDoorStatus() {
	$.ajax({
		type: 'post',
		url: 'mapMonitoring.do?getElementStatus',
		dataType: 'json',
		async: true,
		data: {
			"devIds": doorIds,
			"elementType": "Acc"
		},
		success: function(result) {
			mapClient.devData = result.data;
			if (window.tempMapType == "Normal") {
				mapMainGeneral.dealGeneralMapStateData();
			} else if (window.tempMapType == "GIS") {
				mapMainGis.dealGisMapDevStateData();
			} else if (window.tempMapType == "Google") {
				mapMainGoogle.dealGoogleMapDevStateData();
			} else if (window.tempMapType == "Baidu") {
				mapMainBaidu.dealBaiduMapDevStateData();
			}
			for (var i = 0; i < mapClient.devData.length; i++) {
                devSn = mapClient.devData[i].devSn;
                devStatusImage = mapClient.devData[i].image;
                accMapDeviceAlarmMap.set(devSn, devStatusImage);
            }
		},
		error: function(result) {

		}
	});
}

//初始化防区报警状态的监听事件，定时15s更新一次
function loadMapDefendAreaState() {
	try {
	    //清理旧的防区定时器
	    if (defendAreaPullingHandler) {
	        window.clearInterval(defendAreaPullingHandler);
	        defendAreaPullingHandler = null;
	    }
	    if (mapFlashHandle){
	        window.clearInterval(mapFlashHandle);
            mapFlashHandle = null;
	    }
        var defendAreaIds = [];
        //获取防区ids
        if (window.tempMapType == "GIS") {
            // gis 地图获取摄像机列表
            var features = source.getFeatures();
            if (features == null || features.length < 1) {
                return;
            }
            for (var i = 0; i < features.length; i++) {
                var entityId = features[i].getProperties().entityType;
                var SN = features[i].getProperties().SN;
                if(entityType == "DefendArea"){
                    defendAreaIds.push(SN);
                }
            }
        } else if (window.tempMapType == "Normal") {
            if(polygonEditor){
                var polygonsData = polygonEditor.getPolygonsData();
                if(polygonsData.length > 0){
                    polygonsData.forEach(function(p){
                        defendAreaIds.push(p.entityId);
                    })
                }
            }
        } else if (window.tempMapType == "Google") {
            googleMapPosMap.forEach(function(marker, key) {
                if(marker.entityType == "DefendArea"){
                    defendAreaIds.push(marker.entityId);
                }
            });
        } else if (window.tempMapType == "Baidu") {
            var allOverlay = baiduMap.getOverlays();
            for (var j = 0; j < allOverlay.length; j++) {
                if (undefined != allOverlay[j].customData
                    && allOverlay[j].customData.entityType == "DefendArea") {
                    defendAreaIds.push(allOverlay[j].customData.entityId);
                }
            }
        }
        if (defendAreaIds.length == 0) {
            return;
        }
        updateDefendAreaStatus(defendAreaIds);
        if (!defendAreaPullingHandler) {
            defendAreaPullingHandler = setInterval(function() {
                updateDefendAreaStatus(defendAreaIds);
            }, 5000);
        }
	} catch (err) {
		console.log("loadMapDefendAreaState Error name: " + err.name + "");
		console.log("loadMapDefendAreaState Error message: " + err.message);
	}
}

//立即更新防区的报警状态
function updateDefendAreaStatus(defendAreaIds) {
	$.ajax({
		type: 'post',
		url: 'mapMonitoring.do?getElementStatus',
		dataType: 'json',
		async: true,
		data: {
			"devIds": defendAreaIds.join(","),
			"elementType": "DefendArea"
		},
		success: function(result) {
			if (result.ret === sysCfg.success){
			    if (window.tempMapType == "Normal") {
                    mapMainGeneral.updateDefendAreaStatus(result.data);
                } else if (window.tempMapType == "GIS") {
                    mapMainGis.updateDefendAreaStatus(result.data);
                } else if (window.tempMapType == "Google") {
                    mapMainGoogle.updateDefendAreaStatus(result.data);
                } else if (window.tempMapType == "Baidu") {
                    mapMainBaidu.updateDefendAreaStatus(result.data);
                }
			}
		},
		error: function(result) {

		}
	});
}

/** 加载更新地图上元素状态 */
function loadMapElementStatus() {
    initMapAlarm();
    updateMapElementStatus();
    if (!window.mapElementPullingHandler) {
        window.mapElementPullingHandler = setInterval(function() {
            updateMapElementStatus();
        }, 5000);
    }
}

/** 获取地图上元素的实体类型和对应ID */
function getMapElementEntityInfo() {
    var dataJson = {};
    if (window.tempMapType == "Normal") {
        var mapElements = $("div[id^='item_']");
        if (mapElements.length > 0) {
            for (var i = 0; i < mapElements.length; i++) {
                var entityType = $(mapElements[i]).attr("entity_type")
                // 实体ID
                var entityId = $(mapElements[i]).find("[id$='_image']").attr("value");
                var entityIds = "";
                if (dataJson[entityType]) {
                    entityIds = dataJson[entityType];
                }
                dataJson[entityType] =  entityId + "," + entityIds;
                // 元素ID
                var elementId = $(mapElements[i]).attr("id").replace("item_", "");
                vid_channel_SN.set(entityId, elementId);
            }
        }
        var defendAreaIds = getMapDefendAreaIds();
        if (defendAreaIds) {
            dataJson["DefendArea"] =  defendAreaIds.join(",");
        }
    } else if (window.tempMapType == "Google") {
        googleMapPosMap.forEach(function(marker, key) {
            var entityId = marker.entityId;
            var entityType = marker.entityType;
            var entityIds = "";
            if (dataJson[entityType]) {
                entityIds = dataJson[entityType];
            }
            dataJson[entityType] =  entityId + "," + entityIds;
        });
    } else if (window.tempMapType == "Baidu") {
        var allOverlay = baiduMap.getOverlays();
        for (var j = 0; j < allOverlay.length; j++) {
            var customData = allOverlay[j].customData;
            if (undefined != customData) {
                var entityId = customData.entityId;
                var entityType = customData.entityType;
                var entityIds = "";
                if (dataJson[entityType]) {
                    entityIds = dataJson[entityType];
                }
                dataJson[entityType] =  entityId + "," + entityIds;
            }
        }
    }
    return dataJson;
}

/** 获取地图上防区ID */
function getMapDefendAreaIds() {
    var defendAreaIds = [];
    //获取防区ids
    if (window.tempMapType == "Normal") {
        if(polygonEditor){
            var polygonsData = polygonEditor.getPolygonsData();
            if(polygonsData.length > 0){
                polygonsData.forEach(function(p){
                    defendAreaIds.push(p.entityId);
                })
            }
        }
    } else if (window.tempMapType == "Google") {
        googleMapPosMap.forEach(function(marker, key) {
            if(marker.entityType == "DefendArea"){
                defendAreaIds.push(marker.entityId);
            }
        });
    } else if (window.tempMapType == "Baidu") {
        var allOverlay = baiduMap.getOverlays();
        for (var j = 0; j < allOverlay.length; j++) {
            if (undefined != allOverlay[j].customData
                && allOverlay[j].customData.entityType == "DefendArea") {
                defendAreaIds.push(allOverlay[j].customData.entityId);
            }
        }
    }
    return defendAreaIds;
}

/** 更新地图元素状态 */
function updateMapElementStatus() {
    if (CONST.getValue("MonitorCenter_menuId") != "mapMonitoring.do") {
        clearInterval(window.mapElementPullingHandler);
        window.mapElementPullingHandler = null;
        return;
    }
    // 元素实体类型
    var entityInfo = getMapElementEntityInfo();
    $.ajax({
        type: 'post',
        url: 'mapMonitoring.do?getElementStatus',
        dataType: 'json',
        async: true,
        data: {
            "entityInfo": JSON.stringify(entityInfo)
        },
        success: function(result) {
            if (result.ret === sysCfg.success) {
                var dataMap = result.data;
                if (!dataMap) {
                    return;
                }
                if (dataMap.VidChannel) {
                    updateVidElementStatus(dataMap.VidChannel);
                }
                if (dataMap.AccDoor) {
                    updateSubsetElementStatus(dataMap.AccDoor);
                }
                if (dataMap.PsgGate) {
                    updateSubsetElementStatus(dataMap.PsgGate);
                }
                if (dataMap.DefendArea != undefined) {
                    updateIasElementStatus(dataMap.DefendArea);
                }
                if (dataMap.AttDevice) {
                    updateDeviceElementStatus(dataMap.AttDevice);
                }
                if (dataMap.ParkDevice) {
                    updateDeviceElementStatus(dataMap.ParkDevice);
                }
                if (dataMap.InsDevice) {
                    updateDeviceElementStatus(dataMap.InsDevice);
                }
                if (dataMap.EsdcDevice) {
                    updateDeviceElementStatus(dataMap.EsdcDevice);
                }
            }
        }
    });
}

/** 更新视频摄像机状态 */
function updateVidElementStatus(data) {
    var sn;
    var alarmLevel;
    var deviceState;
    for (var i = 0; i < data.length; i++) {
        sn = data[i]["uniqueKey"];
        alarmLevel = data[i]["alarmLevel"];
        deviceState = data[i]["status"];
        switch (window.tempMapType) {
            case "Normal":
                mapMainGeneral.generalMapAlarms(sn, alarmLevel, deviceState);
                break;
            case "Google":
                mapMainGoogle.googleMapAlarms(sn, alarmLevel, deviceState);
                break;
            case "Baidu":
                mapMainBaidu.baiduMapAlarms(sn, alarmLevel, deviceState);
                break;
        }
        accMapDeviceAlarmMap.set(sn, data[i]);
    }
}

/** 更新门禁门/闸机状态 */
function updateSubsetElementStatus(data) {
    mapClient.devData = data;
    if (window.tempMapType == "Normal") {
        mapMainGeneral.dealGeneralMapStateData();
    } else if (window.tempMapType == "Google") {
        mapMainGoogle.dealGoogleMapDevStateData();
    } else if (window.tempMapType == "Baidu") {
        mapMainBaidu.dealBaiduMapDevStateData();
    }
    for (var i = 0; i < mapClient.devData.length; i++) {
        devSn = mapClient.devData[i].devSn;
        devStatusImage = mapClient.devData[i].image;
        accMapDeviceAlarmMap.set(devSn, devStatusImage);
    }
}

/** 更新入侵防区状态 */
function updateIasElementStatus(data) {
    if (window.tempMapType == "Normal") {
        mapMainGeneral.updateDefendAreaStatus(data);
    } else if (window.tempMapType == "Google") {
        mapMainGoogle.updateDefendAreaStatus(data);
    } else if (window.tempMapType == "Baidu") {
        mapMainBaidu.updateDefendAreaStatus(data);
    }
}

/** 更新设备状态 */
function updateDeviceElementStatus(data) {
    if (window.tempMapType == "Normal") {
        mapMainGeneral.updateDeviceElementStatus(data);
    } else if (window.tempMapType == "Google") {
        mapMainGoogle.updateDeviceElementStatus(data);
    } else if (window.tempMapType == "Baidu") {
        mapMainBaidu.updateDeviceElementStatus(data);
    }
}