
/**
 * 获取地图元素树
 * @param callback
 */
function getMapElementZtree(type,mapId,showAll,callback){
    $("#key").val("");
    $.ajax({
       type: "POST",
       url: "/mapElement.do?getEntityTreeByType",
       dataType: "json",
       data: {
            "type" : type,
            "mapId" : mapId,
            "showAll" : showAll,
       },
       async: true,
       success: function(result)
       {
           if(result.ret == "ok") {
               return callback(result.data);
           }else{
               messageBox({messageType:"alert",text: result.msg});
           }
       }
   });
}

/**
 * 获取默认区域树
 * @param callback
 */
function getServerAreaZtree(type,callback){
    $.ajax({
       type: "POST",
       url: "/accMap.do?getServerAreaZtree",
       dataType: "json",
       data: {
            "type" : type,
       },
       async: true,
       success: function(result)
       {
           if(result.ret == "ok") {
               return callback(result.data);
           }else{
               messageBox({messageType:"alert",text: result.msg});
           }
       }
   });
}

/**
 * 保存点位
 * @param callback
 */
function saveMapElement(postData,callback){
    $.ajax({
       type : "post",
       url: "/mapBaseMap.do?saveMapElement",
 	   contentType : 'application/json; charset=UTF-8',
       dataType: "json",
       data : JSON.stringify(postData),
       async: true,
       success: function(result){
           if(result.ret == "ok") {
               return callback(result.data);
           }else{
               messageBox({messageType:"alert",text: result.msg});
           }
       }
   });
}


/**
 * 初始化设备列表()
 * @param callback
 */
function renderDeviceZtree(zTreeId,type,showAll) {

	var setting = {
			view: {
				showLine: false
			},
			data: {
				simpleData: {
					enable: true,
					idKey: "id",
					pIdKey: "parentId",
		        }
		    },
			callback: {
				onMouseDown: zTreeOnMouseDown,
			}
	};

	function zTreeOnMouseDown(event, treeId, treeNode) {
        if(treeNode != null && "Area" != treeNode.entityType){
            deviceZTree.selectNode(treeNode);
            /*定位在地图的位置*/
            var entityId;
            if(undefined!=treeNode.entityId){
            	entityId=treeNode.entityId;
            }
            mapMainBase.deviceMapLocationByEntityId(entityId);
        }
    };
     getMapElementZtree(type,sessionStorage.getItem("mapTreeId"),showAll,function(data){
            var zNodes = data;
            deviceZTree =  $.fn.zTree.init($("#"+zTreeId+""), setting, zNodes);
            var treeObj = $.fn.zTree.getZTreeObj(""+zTreeId+"");
            fuzzySearch(zTreeId,'#key',null,true); //初始化模糊搜索方法
            treeObj.expandAll(true);
     });

}


/**
 * 初始化添加设备点位列表
 * @param callback
 */
function renderAddDeviceZtree(zTreeId,type,showAll) {
    var setting = {
        check: {
			enable: true,
    	},
        view: {
            showLine: false,
        },
        data: {
            simpleData: {
                enable: true,
                idKey: "id",
                pIdKey: "parentId",
            }
        },
       callback: {
//                onCollapse: collapseNode,
            onExpand: zTreeOnExpand,
            onMouseDown: zTreeOnMouseDown,
            onDblClick: zTreeOnDblClick,
        }
    };
     /*用于捕获 zTree 上鼠标双击之后的事件回调函数*/
      function zTreeOnDblClick(event, treeId, treeNode) {
             /*定位在地图的位置*/
            if("Area"!=treeNode.entityType){
                var entityId;
                if(undefined!=treeNode.entityId){
                  entityId=treeNode.entityId;
                }
                mapMainBase.deviceMapLocationByEntityId(entityId);
            }else{
            }
      };
    /*用于捕获 zTree 上鼠标按键按下后的事件回调函数*/
    function zTreeOnMouseDown(event, treeId, treeNode) {
        addDeviceZTree.selectNode(treeNode);
    };

    function zTreeOnExpand(){
        $("#"+zTreeId+" a").draggable({
            helper:"clone",
            cursorAt:{top:-3,left:-5},
        });
    }

    getMapElementZtree(type,sessionStorage.getItem("mapTreeId"), showAll, function(data){
        var zNodes =data;
        addDeviceZTree=  $.fn.zTree.init($("#"+zTreeId+""), setting, zNodes);
        var treeObj = $.fn.zTree.getZTreeObj(""+zTreeId+"");
        fuzzySearch(zTreeId,'#addMarkerKey',null,true); //初始化模糊搜索方法
        treeObj.expandAll(true);
        var node = treeObj.getNodes(); //可以获取所有的父节点
        for(var i=0;i<node.length;i++){
              addDeviceZTree.setChkDisabled(node[i], true, true, true);
        }
        $("#"+zTreeId+" a").draggable({
                helper:"clone",
                cursorAt:{top:-3,left:-5},
        });
    });
}


/**
 * 初始化设备列表
 * @param callback
 */
function renderAsyncDeviceZtree(zTreeId,type,showAll) {
    var zTreeType=type;
    var zTreeShowAll=showAll;
	var setting = {
            async: {
                enable: true,
                url: getUrl,
                contentType: "application/json"
            },
			view: {
				showLine: false
			},
			data: {
				simpleData: {
					enable: true,
					idKey: "id",
					pIdKey: "parentId",
		        }
		    },
			callback: {
				onMouseDown: zTreeOnMouseDown,
			}
	};

	function zTreeOnMouseDown(event, treeId, treeNode) {
        if("Area"!=treeNode.entityType){
            deviceZTree.selectNode(treeNode);
            /*定位在地图的位置*/
            var entityId;
            if(undefined!=treeNode.entityId){
            	entityId=treeNode.entityId;
            }
            mapMainBase.deviceMapLocationByEntityId(entityId);
        }
    };
    function getUrl(treeId, treeNode) {
            var url="accMap.do?getCheckDeviceZtreeByPCode";
            var mapTreeId=getCookie("mapTreeId");
            var type=zTreeType;
            var showAll=zTreeShowAll;
            var PCode=treeNode.id;
            return url+"&mapId="+mapTreeId+"&type="+type+"&PCode="+PCode+"&showAll="+showAll
    }
     getServerAreaZtree(type,function(data){
               var zNodes =data;
               deviceZTree=  $.fn.zTree.init($("#"+zTreeId+""), setting, zNodes);
               var treeObj = $.fn.zTree.getZTreeObj(""+zTreeId+"");
               fuzzySearch(zTreeId,'#key',null,true); //初始化模糊搜索方法
    });

}
/**
* 初始化设备添加列表
*/
function renderAsyncAddDeviceZtree(zTreeId,type) {
        //菜单树配置
        var zTreeType=type;
        var settingInit = {
            async: {
                enable: true,
                url: getUrl,
                contentType: "application/json"
            },
            check: {
                enable: true,
            },
            view: {
                showLine: false,
            },
            data: {
                simpleData: {
                    enable: true,
                    idKey: "id",
                    pIdKey: "parentId",
                }
            },
           callback: {
                onExpand: zTreeOnExpand,
                onAsyncSuccess: zTreeOnAsyncSuccess,
                onMouseDown: zTreeOnMouseDown,
                onDblClick: zTreeOnDblClick,
            }

        };
        /*展开当前选中节点的所有子节点*/
        function onExpandSelectedNodes(){
            var node = addDeviceZTree.getSelectedNodes()[0];
            addDeviceZTree.expandNode(node,true,true,true);
        }
        /*用于捕获 zTree 上鼠标双击之后的事件回调函数*/
        function zTreeOnDblClick(event, treeId, treeNode) {
             /*定位在地图的位置*/
            if("Area"!=treeNode.entityType){
                var entityId;
                if(undefined!=treeNode.entityId){
                  entityId=treeNode.entityId;
                }
                mapMainBase.deviceMapLocationByEntityId(entityId);
            }else{
            }
        };
        /*用于捕获 zTree 上鼠标按键按下后的事件回调函数*/
        function zTreeOnMouseDown(event, treeId, treeNode) {
            addDeviceZTree.selectNode(treeNode);
        };
        function zTreeOnAsyncSuccess(){
            $("#"+zTreeId+" a").draggable({
                helper:"clone",
                cursorAt:{top:-3,left:-5},
                 start:onExpandSelectedNodes,
            });
            /* 获取所有树节点 */
            var node = addDeviceZTree.getNodes(); //可以获取所有的父节点
            for(var i=0;i<node.length;i++){
                  addDeviceZTree.setChkDisabled(node[i], true, true, true);
            }
        }
        function zTreeOnExpand(){
            $("#"+zTreeId+" a").draggable({
                helper:"clone",
                cursorAt:{top:-3,left:-5},
                 start:onExpandSelectedNodes,
            });
        }
        function getUrl(treeId, treeNode) {
              var url="accMap.do?getCheckDeviceZtreeByPCode";
              var mapTreeId=getCookie("mapTreeId");
              var type=zTreeType;
              var showAll=true;
              var PCode=treeNode.id;
              return url+"&mapId="+mapTreeId+"&type="+type+"&PCode="+PCode+"&showAll="+showAll
        }
        getServerAreaZtree(type,function(data){
                var zNodes =data;
                addDeviceZTree=  $.fn.zTree.init($("#"+zTreeId+""), settingInit, zNodes);
                var treeObj = $.fn.zTree.getZTreeObj(""+zTreeId+"");
                fuzzySearch(zTreeId,'#addMarkerKey',null,true); //初始化模糊搜索方法
                $("#"+zTreeId+" a").draggable({
                        helper:"clone",
                        cursorAt:{top:-3,left:-5},
                        start:onExpandSelectedNodes,
                });
                /* 获取所有树节点 */
                var node = addDeviceZTree.getNodes(); //可以获取所有的父节点
                for(var i=0;i<node.length;i++){
                      addDeviceZTree.setChkDisabled(node[i], true, true, true);
                }
        });

}


/**
*获取当前节点的叶子节点
*/
function getAllChildrenNodes(treeNode,resultMap){
      allChildrenNodes=resultMap.get("allChildrenNodes")!=undefined?resultMap.get("allChildrenNodes"):[];
      allChildrenCheckNodes=resultMap.get("allChildrenCheckNodes")!=undefined?resultMap.get("allChildrenCheckNodes"):[];
      allChildrenNoCheckNodes=resultMap.get("allChildrenNoCheckNodes")!=undefined?resultMap.get("allChildrenNoCheckNodes"):[];
      if (treeNode.isParent) {
        var childrenNodes = treeNode.children;
        if (childrenNodes) {
            for (var i = 0; i < childrenNodes.length; i++) {
                var childrenNode= childrenNodes[i];
                   allChildrenNodes.push(childrenNode);
                   if(childrenNode.checked){
                        allChildrenCheckNodes.push(childrenNode);
                   }else{
                        allChildrenNoCheckNodes.push(childrenNode);
                   }
                resultMap.set("allChildrenNodes",allChildrenNodes);
                resultMap.set("allChildrenCheckNodes",allChildrenCheckNodes);
                resultMap.set("allChildrenNoCheckNodes",allChildrenNoCheckNodes);
                resultMap = getAllChildrenNodes(childrenNode,resultMap);
            }
        }
    }
    return resultMap;
}

/*初始化告警页面弹窗*/
function initPrompt(callback){

    if(!$("#addMarkerToMapPrompt").hasClass("displayCss")){
        if(mapMain_left == "left"){
            $("#addMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                $("#addMarkerToMapPrompt").addClass("displayCss");
                if(undefined!=callback&&typeof callback === "function"){
                    return callback();
                }
            });
        }else{
            $("#addMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                $("#addMarkerToMapPrompt").addClass("displayCss");
                if(undefined!=callback&&typeof callback === "function"){
                     return callback();
                }
            });
        }
    }
    $("#leftDivPromptDataDiv").removeClass("displayCss");
    $("#leftDivPrompt").removeClass("displayCss");
    if(mapMain_left == "left"){
        $(".ol-scale-line").stop().animate({marginRight:"25%"},450);
        $('#leftDivPrompt').stop().animate({
            width: "338px"
        },500,function(){
            $("#icon-arrow").removeClass("icon-increase");
            $("#icon-arrow").addClass("icon-decrease");
            $("#leftDivPrompt").addClass("map_alarm_activation");
        });
    }else{
        $(".ol-scale-line").stop().animate({marginLeft:"25%"},450);
        $('#leftDivPrompt').stop().animate({
            width: "338px"
        },500,function(){
            $("#icon-arrow").removeClass("icon-decrease");
            $("#icon-arrow").addClass("icon-increase");
            $("#leftDivPrompt").addClass("map_alarm_activation");
        });
    }

}

/*删除树节点*/
function deleteZtreeNode(entityId){
    if(typeof(deviceZTree.getNodesByParam) == 'function'){
         var deviceNode=  deviceZTree.getNodesByParam("entityId",entityId, null);
         deviceZTree.removeNode(deviceNode[0]);
    }
   if(typeof(addDeviceZTree.getNodesByParam) == 'function'){
        var addDeviceNode= addDeviceZTree.getNodesByParam("entityId",entityId, null)[0];
        if(addDeviceNode != undefined){
            addDeviceZTree.setChkDisabled(addDeviceNode, false);
            addDeviceZTree.checkNode(addDeviceNode, false, false);
            addDeviceZTree.setChkDisabled(addDeviceNode, true);
        }
    }

}

var mapMain_initView = function() {

    $("#leftDivPrompt").width($("#mapTreeI").width()+20);

    //$(".dhxtoolbar_text").html("");
    // 语法$('selector').hover(fn1, fn2); fn1鼠标经过时的处理  fn2鼠标离开时的处理

    /*$('#mapTreeI').find("img").hover(function(){
        var srcImg=$(this).attr("src");
        var index = srcImg.lastIndexOf("\_");
        srcImg  = srcImg.substring(0, index+1);
        $(this).attr("src",srcImg+"2.png");
    }, function() {
        var srcImg=$(this).attr("src");
        var index = srcImg.lastIndexOf("\_");
        srcImg  = srcImg.substring(0, index+1);
        $(this).attr("src",srcImg+"1.png");
    });*/


     var mark=true;
     $("#addMarkerToMapPrompt").droppable({
         out : function (e, source) {
        	 // 在被拖拽元素离开放置区的时候触发
        	 mark=true;
         },
         drop : function (e, source) {
	         //在被拖拽元素放入到放置区的时候触发
	         mark=false;
         }
    });


        /*添加点位放下的事件*/
     $("#id_mapMain_"+tempMapId).droppable({
            drop:function(event,ui){
                    if(mark){
                        if("Normal"==window.tempMapType){
                             var addMarker_leftX=general_map_x1;
                             var addMarker_topY=general_map_y1;
                        }else if("GIS"==window.tempMapType){
                             var addMarker_leftX=Number($(".custom-mouse-position").text().split(",")[0]);
                             var addMarker_topY=Number($(".custom-mouse-position").text().split(",")[1]);
                        }else if("Google"==window.tempMapType){
                             var addMarker_leftX=googleMapCenterPosition.lat();
                             var addMarker_topY=googleMapCenterPosition.lng();
                        }else if("Baidu"==window.tempMapType){
                              var addMarker_leftX=baiduMapCenterPosition.lat;
                              var addMarker_topY=baiduMapCenterPosition.lng;
                        }
                        var sourceElement = $(ui.helper.context);
                        var targetElement = $(this);
                        /*获取选中的节点*/
                        var selectedNodes = addDeviceZTree.getSelectedNodes();
                       var entityType=selectedNodes[0].entityType;
                       var entityId=selectedNodes[0].entityId;
                       if("Area"==entityType){
                          /*拖拽的是区域，获取区域下的叶子节点*/
                          var allChildrenNodes =[] ;
                          var allChildrenCheckNodes =[] ;
                          var allChildrenNoCheckNodes =[] ;
                          var resultMap = new Map();

                          resultMap = getAllChildrenNodes(selectedNodes[0],resultMap);
                          //所有的子节点设备
                          allChildrenNodes=resultMap.get("allChildrenNodes") ? resultMap.get("allChildrenNodes") : new Array();
                           //所有选中的子节点
                          allChildrenCheckNodes=resultMap.get("allChildrenCheckNodes") ? resultMap.get("allChildrenCheckNodes") : new Array();
                          //所有没选中的子节点
                          allChildrenNoCheckNodes=resultMap.get("allChildrenNoCheckNodes") ? resultMap.get("allChildrenNoCheckNodes") : new Array();

                           if(allChildrenCheckNodes && allChildrenCheckNodes.length>0){
                                  messageBox({messageType: "confirm", text: I18n.getValue("map_marker_add_prompt"),
                                          callback: function(res){
                                              if(res){
                                                   selectedMapAddMarker(allChildrenNodes);
                                              }else{
                                                   selectedMapAddMarker(allChildrenNoCheckNodes);
                                              }
                                          }
                                  });
                          }else{
                                selectedMapAddMarker(allChildrenNoCheckNodes);
                          }
                          addDeviceZTree.setChkDisabled(selectedNodes[0],false);
                          addDeviceZTree.checkNode(selectedNodes[0],true,false);
                          addDeviceZTree.setChkDisabled(selectedNodes[0], true);
                       }else{
                          if (undefined != selectedNodes[0].oldname) {
                              selectedNodes[0].name  = selectedNodes[0].oldname;
                          }
                          selectedMapAddMarker(selectedNodes);
                       }

                       /*选择添加点位的方式*/
                       function selectedMapAddMarker(selectedNodes){
                                 switch(window.tempMapType){
                                     case "Normal":
                                            mapMainGeneral.addMarkerToMap(selectedNodes,addMarker_leftX,addMarker_topY);
                                          break;
                                     case "GIS":
                                             mapMainGis.addMarkerToMap(selectedNodes,addMarker_leftX,addMarker_topY);
                                         break;
                                     case "Google":
                                            mapMainGoogle.addMarkerToMap(selectedNodes,addMarker_leftX,addMarker_topY);
                                            break;
                                     case "Baidu":
                                            mapMainBaidu.addMarkerToMap(selectedNodes,addMarker_leftX,addMarker_topY);
                                         break;
                                 }
                       }
                    }else{
                        openMessage(msgType.info,I18n.getValue("map_marker_add_prompt_2") );
                    }
            }
    });
};




var mapMain_initEvent = function() {

		$('.device-nav-tabs li').off('click').on('click',function(){
		    // 优化之前多个if写法渲染，type类型：门、摄像机或其他(地图/防区等),label名称
			var type = $(this).find('a').data("type");
			var label = $('#searchDeviceTab').find(".active a").html();
			if ("other" == type) {
                type = $('#dropdownContent').data("type");
                if (!type) {
                    return;
                }
                label = $("a[href='#" + type + "Tab']").html();
			}
			if ("AccDoor" == type || "VidChannel" == type) {
                label = "";
            }
			renderDeviceZtree(type + "ZTree", type, false);
            $("#dropdownContent").html(label);
            $("#dropdownContent").data("type", type);
            $("#myTabDrop1").attr("title", label);
		});
        /**
         * 左侧边栏 显示或隐藏
         */
        $('#leftDivPromptImgDiv').off('click').on('click',function(){
            if($("#leftDivPrompt").hasClass("map_alarm_activation")){
            	if(mapMain_left == "left"){
            		$(".ol-scale-line").stop().animate({marginRight:"0%"},500);
            	}else{
            		$(".ol-scale-line").stop().animate({marginLeft:"0%"},500);
            	}
                $('#leftDivPrompt').stop().animate({
                    width: "10px"
                },500,function(){
                	if(mapMain_left == "left"){
                		$("#icon-arrow").removeClass("icon-decrease");
                        $("#icon-arrow").addClass("icon-increase");
                	}else{
                		$("#icon-arrow").removeClass("icon-increase");
                        $("#icon-arrow").addClass("icon-decrease");
                	}
                    $("#leftDivPrompt").removeClass("map_alarm_activation");
                    $("#leftDivPromptDataDiv").addClass("displayCss");

                });
            }else{
                $("#leftDivPromptDataDiv").removeClass("displayCss");
                if(mapMain_left == "left"){
            		$(".ol-scale-line").stop().animate({marginRight:$("#mapTreeI").width()+20},500);
            	}else{
            		$(".ol-scale-line").stop().animate({marginLeft:$("#mapTreeI").width()+20},450);
            	}
                $('#leftDivPrompt').stop().animate({
                    width: $("#mapTreeI").width()+20
                },500,function(){
                	if(mapMain_left == "left"){
                        $("#icon-arrow").removeClass("icon-increase");
                        $("#icon-arrow").addClass("icon-decrease");
                	}else{
                		$("#icon-arrow").removeClass("icon-decrease");
                        $("#icon-arrow").addClass("icon-increase");
                	}
                    $("#leftDivPrompt").addClass("map_alarm_activation");
                });
            }
        })



    /*设备列表添加点位取消事件*/
    $('#cancelAddMarker').off('click').on('click',function(){
        if(!$("#addMarkerToMapPrompt").hasClass("displayCss")){
            if(mapMain_left == "left"){
                $("#addMarkerToMapPrompt").stop().animate({right: "-360px"},500,function () {
                    $("#addMarkerToMapPrompt").addClass("displayCss");
                     /*刷新地图初始化点位*/
                        refreshMap();
                });
            }else{
                $("#addMarkerToMapPrompt").stop().animate({left: "-360px"},500,function () {
                    $("#addMarkerToMapPrompt").addClass("displayCss");
                     refreshMap();
                });
            }
        }
        $("#leftDivPromptDataDiv").removeClass("displayCss");
        $("#leftDivPrompt").removeClass("displayCss");
        if(mapMain_left == "left"){
            $(".ol-scale-line").stop().animate({marginRight:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icon-arrow").removeClass("icon-increase");
                $("#icon-arrow").addClass("icon-decrease");
                $("#leftDivPrompt").addClass("map_alarm_activation");

            });
        }else{
            $(".ol-scale-line").stop().animate({marginLeft:"25%"},450);
            $('#leftDivPrompt').stop().animate({
                width: "338px"
            },500,function(){
                $("#icon-arrow").removeClass("icon-decrease");
                $("#icon-arrow").addClass("icon-increase");
                $("#leftDivPrompt").addClass("map_alarm_activation");

            });
        }

    });


    /*设备列表添加点位保存事件*/
    $('#confirmAddMarker').off('click').on('click',function(){
         mapMainBase.saveMapPos();
    });


};

/**
 * 初始化
 */
$(function() {
    var  deviceZTree;
    var  addDeviceZTree;
     //数据初始化
    mapMain_initView();
    mapMain_initEvent();

});










