$(function () {
	// 地图对象
	var mapObj = {
		// 地图节点ID,根据需要配置，目前先写死
		mapDomId: "id_map_box",
		$mapDom: null,
		// 定时器变量
		mapTimer: null,
		vidTimer: null,
		// 放大地图按钮节点ID, 根据需要配置，目前先写死
		zoomInBtnId: "zoom_in",
		// 缩小地图按钮节点ID, 根据需要配置，目前先写死
		zoomOutBtnId: "zoom_out",
		// 摄像头设备父节点ID后缀,根据需要可配置，目前先写死
		vidDomIdSuffix: "_VidChannel",
		// 摄像头设备子节点ID前缀,根据需要可配置，目前先写死
		vidItemIdPrefix: "item_",
		// 摄像头img标签ID后缀
		vidImgIdSuffix: "_image",
		// 第一个摄像头设备节点位置是否改变的变量
		positionChange: false,
		// 实现地图的放大缩小;当前倍数，只能在-10至10这个倍数范围缩放，初始化为1倍，当前的节点大小
		multiple: 1,
		primaryColor: sysCfg.skin == "techblue" ? "#0091F9" : "#7ac143",
		errorColor: "#ff4d4f",
		icon: $("#map_arrowIcon").get(0),
		/**
		 * 获取元素到窗口顶部的距离
		 * @author james.zhang
		 * @date 2019.04.11
		 * @param {Element} element DOM元素节点
		 * @return elementViewTop
		 */
		getElementViewTop: function (element) {
			var actualTop = element.offsetTop;
			// var current = element.offsetParent;
			// while (current !== null) {
			// 	actualTop += current.offsetTop;
			// 	current = current.offsetParent;
			// }

			// var actualTop = $(element).position().top;
			var elementScrollTop;
			if (document.compatMode == "BackCompat") {
				elementScrollTop = document.body.scrollTop;
			} else {
				elementScrollTop = document.documentElement.scrollTop;
			}
			return actualTop - elementScrollTop;
		},
		/**
		 * 获取元素到窗口左边的距离
		 * @author james.zhang
		 * @date 2019.04.11
		 * @param {Element} element DOM元素节点
		 * @return elementViewLeft
		 */
		getElementViewLeft: function (element) {
			var actualLeft = element.offsetLeft;
			// var current = element.offsetParent;

			// while (current !== null) {
			// 	actualLeft += current.offsetLeft;
			// 	current = current.offsetParent;
			// }
			if (document.compatMode == "BackCompat") {
				var elementScrollLeft = document.body.scrollLeft;
			} else {
				var elementScrollLeft = document.documentElement.scrollLeft;
			}
			return actualLeft - elementScrollLeft;
		},
		/**
		 * 获取摄像头ID
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		getVidChannels: function () {
			// 这边应该发请求获取摄像头ID, 先用假数据代替, 需要重新配置
			// 设备数据格式处理成这样： [[{id: [], color: ""}], [{id: [], color: ""}]]
			var _vidChannels = [];
			var trackCameraIdList = window.trackCameraIdList;
			if(trackCameraIdList && trackCameraIdList.length) {
				var ids = [];
				for (var i = 0, len = trackCameraIdList.length; i < len; i++) {
					if(Array.isArray(trackCameraIdList[i])) {
						var _ids = [];
						for (var j = 0, _len = trackCameraIdList[i]; j < _len; j++) {
							_ids.push(trackCameraIdList[i][j]);
						}
						ids.push(_ids);
					}else {
						ids.push(trackCameraIdList[i]);
					}
				}
				_vidChannels.push([{
					id: ids,
					// color: this.createRandomColor()
					color: this.primaryColor
				}])
			}
			return _vidChannels;
		},
		createRandomColor: function () {
			return '#' + Math.floor(Math.random() * 0xffffff).toString(16);
		},
		/**
		 * 获取视频设备DOM节点位置
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		getVidChannelsPos: function () {
			var points = [],
				vidDom = null,
				vidDomId = "",
				// 设置偏移值(根据需要调整)
				offsetX = 0,
				offsetY = 0;
			for (var i in this.vidChannels) {
				// vidDomId = this.vidChannels[i] + this.vidDomIdSuffix;
				var _points = [];
				for (var j in this.vidChannels[i][0].id) {
				    var imgObj = $("#" + this.vidChannels[i][0].id[j] + this.vidImgIdSuffix);
					vidDomId = this.vidItemIdPrefix + imgObj.attr("data");
					vidDom = document.getElementById(vidDomId);
					if (vidDom) {
						var x = Number(this.getElementViewLeft(vidDom) + vidDom.getBoundingClientRect().width / 2 - offsetX),
							y = Number(this.getElementViewTop(vidDom) + vidDom.getBoundingClientRect().height / 2 - offsetY),
							dom = vidDom;
						_points.push({
							pos: {
								x: x,
								y: y,
								dom: dom
							},
							color: this.vidChannels[i][0].color
						});
					}
				}
				points.push(_points);
			}
			return points;
		},
		/**
		 * 初始化画线
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		initRenderLine: function () {
			var points = this.getVidChannelsPos();
			if (points.length) {
				var canvas = document.getElementById("basicCanvas");
				 if(canvas != null && canvas != "" && canvas != undefined){
					 ctx = canvas.getContext("2d");
					 if (this.positionChange) {
						 points = this.getVidChannelsPos();
						 // 位置更新后清空画布, 重新画线
						 ctx.clearRect(0, 0, canvas.getBoundingClientRect().width, canvas.getBoundingClientRect().height);
					 }
					 // 清空画布, 重新画线
					 ctx.clearRect(0, 0, canvas.getBoundingClientRect().width, canvas.getBoundingClientRect().height);
					 // 画线
					 this.renderLine(points);
				 }
			}
		},
		/**
		 * 绘制线条
		 * @author james.zhang
		 * @date 2019.04.11
		 * @param points DOM节点位置数据(摄像头设备)
		 * @return
		 */
		renderLine: function (points) {
			// 获得画布元素
			var canvas = document.getElementById("basicCanvas");
			//获得2维绘图对象
			var ctx = canvas.getContext("2d");
			//设置线宽
			ctx.lineWidth = 1 + this.multiple * 0.1;
			//颜色
			ctx.strokeStyle = this.primaryColor;
			ctx.beginPath();
			var arrow = {
				theta: 30,
				headlen: 2 + this.multiple * 15,
				width: 1 + this.multiple * 1.5
			};
			for (var i = 0, len = points.length; i <= len; i++) {
				if (!points[i]) return;
				for (var j = 0, length = points[i].length; j < length; j++) {
					var x1 = points[i][j] && Number(points[i][j].pos.x) || 0,
						y1 = points[i][j] && Number(points[i][j].pos.y) || 0,
						x2 = points[i][j + 1] && Number(points[i][j + 1].pos.x),
						y2 = points[i][j + 1] && Number(points[i][j + 1].pos.y);
					var offsetWidth = points[i][j + 1] && points[i][j + 1].pos.dom.getBoundingClientRect().width / 2 || 0,
						offsetHeight = points[i][j + 1] && points[i][j + 1].pos.dom.getBoundingClientRect().height / 2 || 0;
					/*if((x2 - x1) > 0) {
						x2 -= offsetWidth;
					}else {
						x2 += offsetWidth;
					}*/
					/*if((y2 - y1) > 0) {
						y2 += offsetHeight;
					}else {
						y2 -= offsetHeight;
					}*/
					//颜色
					ctx.strokeStyle = points[i][j].color;
					//this.drawArrow(ctx, x1, y1, x2, y2, arrow.theta, arrow.headlen, arrow.width, points[i][j].color)
					//this.drawLine(ctx, x1, y1, x2, y2, arrow.width);
					this.paintArrayRoad(x1, y1, x2, y2, 10, 25, points[i][j].color);
				}
			}
		},
		/**
		 * 绘制箭头
		 * @author james.zhang
		 * @date 2019.04.12
		 * @param {HTMLCanvasElement} ctx 画布对象
		 * @param {Number} fromX 起点的横坐标
		 * @param {Number} fromY 起点的纵坐标
		 * @param {Number} toX 终点的横坐标
		 * @param {Number} toY 终点的纵坐标
		 * @param {Number} theta 三角斜边一直线夹角
		 * @param {Number} headlen 三角斜边长度
		 * @param {Number} width 箭头线宽度
		 * @param {Number} color 箭头颜色
		 */
		drawArrow: function (ctx, fromX, fromY, toX, toY, theta, headlen, width, color) {
			var theta = theta || 30,
				headlen = headlen || 10,
				width = width || 1,
				color = color || '#000',
				angle = Math.atan2(fromY - toY, fromX - toX) * 180 / Math.PI,
				angle1 = (angle + theta) * Math.PI / 180,
				angle2 = (angle - theta) * Math.PI / 180,
				topX = headlen * Math.cos(angle1),
				topY = headlen * Math.sin(angle1),
				botX = headlen * Math.cos(angle2),
				botY = headlen * Math.sin(angle2);
			ctx.save();
			ctx.beginPath();
			var arrowX, arrowY;
			ctx.moveTo(fromX, fromY);
			ctx.lineTo(toX, toY);
			arrowX = toX + topX;
			arrowY = toY + topY;
			ctx.moveTo(arrowX, arrowY);
			ctx.lineTo(toX, toY);
			arrowX = toX + botX;
			arrowY = toY + botY;
			ctx.lineTo(arrowX, arrowY);
			ctx.strokeStyle = color;
			ctx.lineWidth = width;
			ctx.stroke();
			ctx.restore();
		},
		/**
		 * 绘制直线
		 * @author james.zhang
		 * @date 2019.04.11
		 * @param {HTMLCanvasElement} ctx 画布对象
		 * @param {Number} x1 起点的横坐标
		 * @param {Number} y1 起点的纵坐标
		 * @param {Number} x2 终点的横坐标
		 * @param {Number} y2 终点的纵坐标
		 */
		drawLine: function (ctx, x1, y1, x2, y2, width) {
			ctx.moveTo(x1, y1);
			ctx.lineTo(x1, y1);
			ctx.lineTo(x2, y2);
			ctx.lineWidth = width;
			ctx.stroke(); //执行  线条
		},
		/**
		 * 绘制实心圆
		 * @author james.zhang
		 * @date 2019.04.11
		 * @param {HTMLCanvasElement} ctx 画布对象
		 * @param {Number} x 横坐标
		 * @param {Number} y 纵坐标
		 * @return
		 */
		drawCircle: function (ctx, x, y) {
			// 圆的半径
			var r = 6;
			ctx.beginPath();
			ctx.fillStyle = this.primaryColor;
			ctx.arc(x, y, r, 0, 360 * Math.PI / 180, true);
			ctx.fill();
		},
		/**
		 * 初始化操作
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		init: function () {
			//$('#id_map_box').prepend('<canvas id="canvas" width="'+window.canvasWdith+'" height="'+window.canvasHeight+'"></canvas>');
			if(!window.trackCameraIdList || !window.trackCameraIdList.length) {
				/*var canvas = document.getElementById("canvas"),
				ctx = canvas.getContext("2d");
				// 清空画布
				document.getElementById("canvas").getContext("2d").canvas.width=document.getElementById("canvas").getContext("2d").canvas.width;
				ctx.clearRect(0, 0, canvas.getBoundingClientRect().width, canvas.getBoundingClientRect().height);
				console.log("clearRect");*/
				$('#canvas').remove();
				return;
			};
            var canvas = document.getElementById("basicCanvas");
            if(canvas != null && canvas != "" && canvas != undefined){
            	ctx = canvas.getContext("2d");
            	// 清空画布, 重新画线
            	document.getElementById("basicCanvas").getContext("2d").canvas.width=document.getElementById("basicCanvas").getContext("2d").canvas.width;
            	ctx.clearRect(0, 0, canvas.getBoundingClientRect().width, canvas.getBoundingClientRect().height);

            	var self = this;
            	self.initData();
            	// self.initListener();
            	self.initLine();
            }
		},
		/**
		 * 初始化通用数据
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		initData: function () {
			this.$mapDom = document.getElementById(this.mapDomId);
			this.vidChannels = this.getVidChannels();
		},
		/**
		 * 初始化监听地图的放大缩小事件
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		initListener: function () {
			//this.handleHover();
			//this.handleZoomIn();
			//this.handleZoomOut();
		},
		/**
		 * 初始化画线
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		initLine: function () {
			var self = this;
			self.initRenderLine();
			self.updateLineForMap();
			if (self.positionChange) return;
			self.updateLineForVid();
		},
		handleHover: function() {
			var $mapBox = $("#id_map_box")[0];
			if($mapBox.addEventListener) {
				$mapBox.addEventListener("mouseover", function (){
					$($mapBox).find(".map").css("display", "block");
	           }, false);
				$mapBox.addEventListener("mouseout", function (){
					$($mapBox).find(".map").css("display", "none");
	           }, false);
			}
		},
		/**
		 * 定时器监听第一个摄像头设备的位置变动来重新画线(前提是第一个设置位置变动才会触发重新画线)
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		updateLineForVid: function() {
			// 保存第一个摄像头设备的位置初始值
			var self = this;
			var _vidChannels;
			if(self.vidChannels.length === 1) {
				_vidChannels = self.vidChannels[0][0].id[0];
			}else if(self.vidChannels.length === 2) {
				_vidChannels = self.vidChannels[1][0].id[0];
			}
			var $firstVidDom = document.getElementById(self.vidItemIdPrefix + _vidChannels);
			var	firstVidTop, firstVidLeft, _firstVidTop, _firstVidLeft;
			var firstVidWidth, firstVidHeight, _firstVidWidth, _firstVidHeight;
			// 问题
			if(!$firstVidDom) return;
			firstVidTop = self.getElementViewTop($firstVidDom) + ($firstVidDom.getBoundingClientRect().height) / 2;
			firstVidLeft = self.getElementViewLeft($firstVidDom) + $firstVidDom.getBoundingClientRect().width / 2;
			firstVidWidth = $firstVidDom.getBoundingClientRect().width;
			firstVidHeight = $firstVidDom.getBoundingClientRect().height;
			//	用定时器之前需要清除定时器
			if (!!self.vidTimer) {
				clearInterval(self.vidTimer);
			}
			self.vidTimer = setInterval(function () {
			// 只根据第一个摄像头设备的位置变动来重新画线
			_firstVidTop = self.getElementViewTop($firstVidDom) + $firstVidDom.getBoundingClientRect().height / 2;
			_firstVidLeft = self.getElementViewLeft($firstVidDom) + $firstVidDom.getBoundingClientRect().width / 2;
			// 只根据第一个摄像头设备的大小变动来重新画线
			_firstVidWidth = $firstVidDom.getBoundingClientRect().width;
			_firstVidHeight = $firstVidDom.getBoundingClientRect().height;
			if (_firstVidTop !== firstVidTop || _firstVidLeft !== firstVidLeft) {
				self.multiple = Number(_firstVidWidth/firstVidWidth);
				firstVidTop = _firstVidTop;
			 		firstVidLeft = _firstVidLeft;
			 		self.positionChange = true;
			 		self.initRenderLine();
			 	}
			}, 10);
		},
		/**
		 * 定时器监听地图的大小变动来重新画线
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		updateLineForMap: function () {
			var self = this;
			var $mapDom = this.$mapDom,
				mapDomWidth = mapDomHeight = _mapDomWidth = _mapDomHeight = 0;
			mapDomWidth = $mapDom.getBoundingClientRect().width;
			mapDomHeight = $mapDom.getBoundingClientRect().height;


			self.mapTimer = setInterval(function () {//	用定时器之前需要清除定时器
				if (!!self.mapTimer) {
					clearInterval(self.mapTimer);
				}
				_mapDomWidth = $mapDom.getBoundingClientRect().width;
				_mapDomHeight = $mapDom.getBoundingClientRect().height;
				if (_mapDomWidth !== mapDomWidth || _mapDomHeight !== mapDomHeight) {
					mapDomWidth = _mapDomWidth;
					mapDomHeight = _mapDomHeight;
					self.positionChange = true;
					self.initRenderLine();
				}
			}, 10);
		},
		/**
		 * 点击放大按钮放大地图(项目中已经写好,测试用)
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		handleZoomIn: function () {
			if(!this.vidChannels.length || !this.vidChannels[0] || !this.vidChannels[1]) return;
			var self = this,
				$mapDom = self.$mapDom,
				$zoomInBtn = document.getElementById(self.zoomInBtnId),
				$firstVidDom = document.getElementById(self.vidItemIdPrefix + self.vidChannels[0][0]),
				$secondVidDom = document.getElementById(self.vidItemIdPrefix + self.vidChannels[1][0]);
			// 这边只要有点击放大了就触发重新画线
			self.positionChange = true;
			self.initRenderLine();
			$zoomInBtn.addEventListener("click", function () {
				var mapDomWidth = $mapDom.getBoundingClientRect().width,
					mapDomHeight = $mapDom.getBoundingClientRect().height;
				if (self.multiple >= 10) {
					alert("Map width exceeds the limit, cannot be enlarged!"); //地图宽度到达上限(倍数超过10倍)，不能再放大！
				} else {
					self.multiple++; //放大
					$mapDom.style.width = mapDomWidth + 10 + "px";
					$mapDom.style.height = mapDomHeight + 10 + "px";
					$firstVidDom.style.top = self.getElementViewTop($firstVidDom) + 2 + "px";
					$firstVidDom.style.left = self.getElementViewLeft($firstVidDom) + 2 + "px";
					$secondVidDom.style.top = self.getElementViewTop($secondVidDom) + 2 + "px";
					$secondVidDom.style.left = self.getElementViewLeft($secondVidDom) + 2 + "px";
				}
			});
		},
		/**
		 * 点击缩小按钮缩小地图(项目中已经写好,测试用)
		 * @author james.zhang
		 * @date 2019.04.11
		 * @return
		 */
		handleZoomOut: function () {
			if(!this.vidChannels.length || !this.vidChannels[0] || !this.vidChannels[1]) return;
			var self = this,
				$mapDom = self.$mapDom,
				$zoomOutBtn = document.getElementById(self.zoomOutBtnId),
				$firstVidDom = document.getElementById(self.vidItemIdPrefix + self.vidChannels[0][0]),
				$secondVidDom = document.getElementById(self.vidItemIdPrefix + self.vidChannels[1][0]);
			// 这边只要有点击缩小了就触发重新画线
			self.positionChange = true;
			self.initRenderLine();
			$zoomOutBtn.addEventListener("click", function () {
				var mapDomWidth = $mapDom.getBoundingClientRect().width,
					mapDomHeight = $mapDom.getBoundingClientRect().height;
				if (self.multiple <= -10) {
					alert("Map width exceeds limit, cannot narrow!"); //地图宽度到达上限(倍数小于1/10倍)，不能再放大！
				} else {
					self.multiple--; //缩小
					$mapDom.style.width = mapDomWidth - 10 + "px";
					$mapDom.style.height = mapDomHeight - 10 + "px";
					$firstVidDom.style.top = self.getElementViewTop($firstVidDom) - 2 + "px";
					$firstVidDom.style.left = self.getElementViewLeft($firstVidDom) - 2 + "px";
					$secondVidDom.style.top = self.getElementViewTop($secondVidDom) - 2 + "px";
					$secondVidDom.style.left = self.getElementViewLeft($secondVidDom) - 2 + "px";
				}
			});
		},
		/** 计算旋转画布的角度*/
		computingAngle: function (x1, y1, x2, y2, bool) {
            if (bool) {
                y1 = -y1;
                y2 = -y2;
            }

            if (x2 - x1 == 0) {
                return y2 - y1 > 0 ? Math.PI / 2 : -Math.PI / 2;
            }

            var angle = Math.atan((y2 - y1) / (x2 - x1));
            if (x2 - x1 > 0) {
                return angle;
            } else {
                return angle + Math.PI;
            }
        },
        /**
         * 画一条带箭头的线
         *
         * @param {Number} x1  起始点X坐标
         * @param {Number} y1  起始点Y坐标
         * @param {Number} x2  终点X坐标
         * @param {Number} y2  终点Y坐标
         * @param {Number} lineSize  路线宽度
         * @param {Number}  interval 箭头间隔 建议等于宽度*3
         * @param {String} [lineColor] 线的颜色>>可选填
         * @return void
        */
        paintArrayRoad: function (x1, y1, x2, y2, lineSize, interval, lineColor) {
            ctx.beginPath();
            ctx.save(); //保存画布状态

            ctx.strokeStyle = lineColor;
            ctx.lineWidth = lineSize;
            // 线条末端样式
            ctx.lineCap = "round"; //butt、round和square，默认为butt。
            // 线条转折样式
            ctx.lineJoin = "round"; //round、bevel和miter，默认值为miter

            ctx.moveTo(x1, y1);
            ctx.lineTo(x2, y2);
            ctx.stroke(); //先画好线

            ctx.translate(x1, y1); //基于缓存画布的左上角
            ctx.rotate(this.computingAngle(x1, y1, x2, y2, false));//旋转画布,用于画箭头
            for (let length = 0; length < Math.sqrt(Math.pow(y2 - y1, 2) + Math.pow(x2 - x1, 2)) - interval / 2; length +=
             interval) {//在线上按图片画箭头,由于画布已经旋转 ,可紧贴画布X轴线一直画, 结果映射到真实画布上就是斜线
             ctx.drawImage(this.icon, length, -lineSize / 2, lineSize, lineSize);
            }

            ctx.beginPath(); //结束绘画
            ctx.restore(); //读取画布状态
        }

	}
	// 初始化画线
	// mapObj.init();
	window.mapObj = mapObj;
});

/*浮动信息关闭*/
function closeMask(e) {
	$(e).parent().parent().css("visibility","hidden");
}
function addMask(cameraDataList){
	//通过class获取元素
	/*var paras = document.getElementsByClassName('poPupInfo');
	for(var i=0;i<paras.length;i++){
	     //删除元素 元素.parentNode.removeChild(元素);
	    if (paras[i] != null)
	          paras[i].parentNode.removeChild(paras[i]);
	}*/
	$(document).find("div[name='poPupInfoImgDiv']").remove();
	if(cameraDataList != null && cameraDataList != "" && cameraDataList !=undefined){
		if(cameraDataList.length > 0){
			var lastDeviceId = "";
			var childDiv = "";
			for(var i = 0 ; i<cameraDataList.length;i++){
				try{
				    var imgObj = $("#" + cameraDataList[i].deviceId + "_image");
				    var itemId = imgObj.attr("data");
				    // 优化兼容取元素
				    var parentDiv = $($(imgObj)[0]).parent();
					var itemDiv = $("#item_" + itemId)[0];
					if(parentDiv != "" && parentDiv != "" && parentDiv != undefined){
						if(lastDeviceId == "" || childDiv == "" || lastDeviceId != cameraDataList[i].deviceId){
							lastDeviceId = cameraDataList[i].deviceId;
							childDiv = document.createElement('div');
						}
						childDiv.setAttribute("name","poPupInfoImgDiv");
						childDiv.className = "poPupInfo map-menuContext-color";
                        //childDiv.style = "position:fixed;z-index: 99;visibility: hidden;";
						var cssText = "position:relative;z-index: 10;right:28px;margin-top:-155px;visibility: visible;border: none;min-width: auto;";
						childDiv.setAttribute("style",cssText);
						childDiv.align = "left";
						var listPicData = cameraDataList[i].listPicData;
						if(listPicData != null && listPicData != "" && listPicData != undefined){
                            var eventTime = dhx4.date2str(new Date(listPicData[0].eventTime), sysCfg.dhxLongDateFmt);;
                            var listPicDataStr = window.btoa(JSON.stringify(listPicData));
                            var html = "<div><button type='button' onclick='closeMask(this)' class='close' style='color: #fff; opacity: 1;position: absolute;top: -3px; right: 1px;z-index: 10;'>" +
                            "<span aria-hidden='true'>&times;</span></button>" +
                            "<img style='width:100px;height:105px'"+ ' onclick="javascript:showMorePicByPersonTrack(' + "\'"+ listPicDataStr + "\'"+ ')"' +
                                "src='"+cameraDataList[i].coverPicUrl+"' onerror=\"imgeTrackErrorfun(\'"+cameraDataList[i].coverPicUrl+"\','/images/" +systemSkin + "defaultImg/defaultPers.png');\"  />";
                            html += '</br><div class="arrow-down" ></div>';
							childDiv.innerHTML = html;
							itemDiv.appendChild(childDiv);
							window.poPupImageIsMove = false;
						}
					}else{
						continue;
					}
				}catch (e) {
					continue;
				}

			}
		}
	}
}

/**
 * 弹出框展示更多图片
 */
function showMorePic(data){
	 var opts = {//弹窗配置对象
		        path: "/skip.do?page=map_monitoring_opShowMorePic&listPicData=" + data + "&message=map_viewPhotos",//设置弹窗路径
		        width: 500,//设置弹窗宽度
		        height: 500,//设置弹窗高度
		        title: "<i18n 'map_viewPhotos'/>",//设置弹窗标题
		        gridName: "gridbox"//设置grid
		    };
    DhxCommon.createWindow(opts);
}
