/**
 * 加载被访人选择框
 *
 * @author <a href=mailto:oujunxiao.ou@zkteco.com>欧骏骁</a>
 * @since 2015年5月27日 下午2:42:04
 */
function initHostSelectLine() {
	dhtmlXCombo.prototype.modes.hostSelectLine = {

		render: function(item, data) {

			item._conf = {value: data.value, css: ""};
			item.className = "dhxcombo_option_multiline"; // point (1)

			item.innerHTML = "<div class='dhxcombo_option_text'>&nbsp;</div>";
			$(".dhxcombolist_dhx_web").css('height','310px');
			this.setText(item, data.text);
			return this;
		},

		setSelected: function(item, state) {
			item.className = "dhxcombo_option_multiline"+(state?" dhxcombo_option_selected":""); // point (1)
		},

		getExtraData: function(item) {
			return {type: "hostSelectLine"};
		},

		getText: function(g, a, c) {
			var result = dhtmlXCombo.prototype.modes.option.getText.call(this,g,a,c);
			if(a && typeof result == 'string')
			{
				return (new Function(String(result)))();

			}
			return result;
		}

	};
	dhtmlXComboExtend("hostSelectLine", "option");
	initHostSelectLine = function(){};
}

//选人控件回调事件
function selectCallback(opts)
{
	if(!opts){
		opts = this.opts;
	}
	var sid = $(this.cell).find(".select_layout_box")[0];
	if(sid)
	{
		DhxCommon.initEvents(ZKUI.Select.get(sid.id), ZKUI.Select.suport_evts, opts);
		if(!opts.onSure)
		{
			ZKUI.Select.get(sid.id).attachEvent("onSure", selectEmployeeCallback)
		}
	}

}

//选人控件回调事件
function selectEmployeeCallback(value, text, event) {
	employeeCombo.conf.f_cache = false;
	employeeCombo.clearAll();
	employeeCombo.load("/visEmployeeSelect.do?filterEmployee&hostId="+value,function(){
		employeeCombo.selectOption(0, true, true);
		$("[name='personIds']").attr("dataId", value);
	});
}

/**
 *  加载被访人选择框
 */
function loadHost() {



	initHostSelectLine();
	employeeCombo = new dhtmlXCombo("visEmployeeRegis", "personIds", 150, "hostSelectLine");
	employeeCombo.allowFreeText(true);
	if(sysCfg.language == "zh_CN")
	{
		employeeCombo.setTemplate({
			input:"if('(#name#)'=='()') return '#pin#'; return '#pin#(#name#)'",
			option: "<div style='position:relative;'>"+
			"<div style='position: relative; margin-left: 30px; left: 0px;'>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("vis_common_visPin")+"：#pin#</span>" +
			"<br>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("vis_common_name")+"：#name#</span>"+
			"<br>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("pers_dept_entity")+"：#deptName#</span></div>"+
			"<img height='30px' width='24px' border='0' style='position: absolute; left: 2px; top: 6px;' src=#photo#>"+
			"</div>"
		});
	} else {
		employeeCombo.setTemplate({
			input:"if('(#name# #lastName#)'=='( )') return '#pin#'; return '#pin#(#name# #lastName#)'",
			option: "<div style='position:relative;'>"+
			"<div style='position: relative; margin-left: 30px; left: 0px;'>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("vis_common_visPin")+"：#pin#</span>" +
			"<br>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("vis_export_name")+"：#name#</span>"+
			"<br>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("vis_export_lastname")+"：#lastName#</span>"+
			"<br>" +
			"<span style='color:#dceffc;'>"+I18n.getValue("pers_dept_entity")+"：#deptName#</span></div>"+
			"<img height='30px' width='24px' border='0' style='position: absolute; left: 2px; top: 6px;' src=#photo#>"+
			"</div>"
		});
	}
	employeeCombo.enableFilteringMode(true, "/visEmployeeSelect.do?filterEmployee", false, true);
	employeeCombo.attachEvent("onChange", function(){
		$("#visVisitPinId").data("isClear",false);
		/*$("#visVisitNameId").val(employeeCombo.getSelectedText().name);
		$("#visVisitPinId").val(employeeCombo.getSelectedText().pin);*/
		$("#visVisitPinId").val(employeeCombo.getComboText());
		/*判断如果pin不为空则查询详细信息*/
		if(""!=employeeCombo.getSelectedText().pin){
			getPeopleInfo(employeeCombo.getSelectedText().pin,function (result) {
				$("#id_reserve_email").val(result.data[0].email);
			})
		}
	});
	employeeCombo.setPlaceholder(I18n.getValue("map_track_queryConditions"));
}


/**
 * 查询人员信息
 * @param pin
 * @param callBack
 */
function getPeopleInfo(pin,callBack) {
	$.ajax({
		type: "POST",
		url: '/persPerson.do?getPersPersonItemInfo',
		data : {
			"pin" : pin,
		},
		dataType: "json",
		async: false,
		success: function(data) {
			callBack(data);
		}
	});
}







