//以svg的jquery对象调用DrawPolygon(),svg内的图片需要设置为background；
//因为jquery的append方法和原生js的creactElement方法只能创建双标签，但path标签无法再双标签下输出样式，所以每次图形完成后讲svg内的path存储，再次绘制时以jquery的html方法创建新的path标签，再读取存储的path添加到svg内部
//返回的顶点参数是相对于svg的top和left的百分比
//在双击取消绘制时可能会触发user-select属性，需自行设置取消
$.extend({
    stopDefault:function(e) {
    //阻止默认浏览器动作(W3C)
        if (e && e.preventDefault){
            e.preventDefault();
        } else{
            window.event.returnValue = false;
            return false;
        }
    },
    //阻止浏览器的默认行为
    stopDefault:function (e) {
        if (e && e.preventDefault ){
            e.preventDefault();
        }else{
            window.event.returnValue = false;
            return false;
        }
    },
    // 讲顶点的坐标换算成相对应的百分比并存入PointPosition中
    DealArr:function(arr,origin,ContainerWidth,ContainerHeight){
        var arr=arr;
        var Oarr=$.PercentPoint(origin.split(' ').splice(1,2),ContainerWidth,ContainerHeight);
        console.warn(origin.split(' ').splice(1,2));
        var Larr=$.PercentPoint(arr,ContainerWidth,ContainerHeight);
        var Last=Oarr.concat(Larr)
        $.PointPosition.push(Last);
    },
    //计算百分比函数
    PercentPoint:function(arr,ContainerWidth,ContainerHeight){
        for(var i=0;i<arr.length;i++){
            if(i%2==1){
                arr[i]=(arr[i]/ContainerHeight).toFixed(3);
            }else {
                arr[i]=(arr[i]/ContainerWidth).toFixed(3);
            }
        };
        return arr
    },
    //储存点坐标的数组
    PointPosition:[],
    //每次双击后酱svg内的path存入数组cloneDOM
    cloneDOM:[]
})

$.fn.extend({
    DrawPolygon:function(color,FillColor,StrokeWidth){
        var ClickTimes=0;  //记录是否是第一次点击
        var self=$(this);
        var origin;
        var ClickPoint;
        var color='red' || color;   //线条颜色
        var StrokeWidth='3' || StrokeWidth;     //线条宽度
        var FillColor='red' || FillColor;       //填充颜色
        var arr;
        var length;
        var ContainerWidth=self.width();
        var ContainerHeight=self.height();

        //设置默认属性
        var DefaultValue="stroke='"+color+"' stroke-width='"+StrokeWidth+"' stroke-linejoin='round'stroke-linecap='round'fill-rule='evenodd'stroke-opacity='0.8'stroke-dasharray='none'fill-opacity='0.4' fill='"+FillColor+"'stroke-dasharray='none'";

        self.on('click',function(e){
            ClickTimes++;
            if(ClickTimes == 1){
                origin=' '+e.offsetX+' '+e.offsetY+' ';
                self.html('<path d="M -9999 -9999"'+DefaultValue+' />');
                if($.cloneDOM.length){
                    $.cloneDOM.map(function(v,i){
                        self.prepend(v)
                    })
                }
            }else{
                arr=self.find('path').last().attr('d').split(' ');
                length=arr.length;
                ClickPoint=arr.slice(3,length-3).join(' ');
            };
        });
        self.on('mousemove',function(e){
            if(ClickTimes>=1){
                $.stopDefault(e);
                var path=self.find('path').last();
                var MovePoint=' '+e.offsetX+' '+e.offsetY;
                if(ClickTimes == 1){
                    path.attr('d','M'+origin+'L'+MovePoint+origin);
                } else{
                    path.attr('d','M'+origin+ ClickPoint+MovePoint+origin);
                };
            }
        });
        self.dblclick(function(e){
            if(ClickTimes>2){
                $.stopDefault(e);
                self.unbind();
                $.DealArr(arr.slice(4,length-3),origin,ContainerWidth,ContainerHeight);
                $.cloneDOM.push(self.find('path').last().clone())
                self.unbind();
                self.DrawPolygon()
            } else {
                self.find('path').last().remove();
            }
        });
    }
})