
I18n.load(
    [ "base_map_delEntity",
        "map_alarm_queryRecord",
        "map_show_photo",
        "map_manual_alarm",
        "acc_eventNo_8",
        "acc_eventNo_9",
        "acc_newEventNo_233",
        "acc_newEventNo_234",
        "acc_eventNo_7",
        "acc_rtMonitor_remoteNormalOpen",
        "common_rtMonitor_enableIntradayTZ",
        "common_rtMonitor_disableIntradayTZ",
        "acc_map_gis_input_device_name",
        "map_navigation_preview"
    ], true);


/**
 *  右键添加操作按钮
 * @param evt
 */
{
    /**
     *  右键添加操作按钮
     * @param evt
     */
    function addShowMorePic(evt){
        var feature = gisMap.forEachFeatureAtPixel(evt.pixel, function(ft, l) {
            return ft;
        });
        selectFeature = null;
        selectFeature = feature;
        contextmenu.clear();
        if(feature == undefined){
            return false;
        }
        /*根据页面添加图标右键功能*/
        if("mapMainMonitor"==pageSource){
                /*摄像机*/
            if(feature.getProperties().entityType == "VidChannel"){
                contextmenu.extend(videoPreviewMarkerItem);
                // contextmenu.extend(videoReplayMarkerItem);
                contextmenu.extend(showAlarmMarkerItem);
                /*查看更多图片
                if(window.cameraSnList != null && window.cameraSnList != [] && window.cameraSnList.length > 0){
                    for(var i =0 ; i<window.cameraSnList.length;i++){
                        if(window.cameraSnList[i] == feature.getProperties().POP.split("_")[1]){
                            contextmenu.extend(showMorePicMarkerItem);
                        }
                    }
                }
                */
            }
                /*门*/
             if(feature.getProperties().entityType == "AccDoor"){
                 // 门禁图标添加右键操作按钮
                 //远程开门
                 contextmenu.extend(remoteOpenMarkerItem);
                 //远程关门
                 contextmenu.extend(remoteCloseMarkerItem);
                 //远程锁定
                 contextmenu.extend(activateLockdownMarkerItem);
                 //远程解锁
                 contextmenu.extend(deactivateLockdownMarkerItem);
                 //取消报警
                 contextmenu.extend(cancelAlarmMarkerItem);
                 //远程常开
                 contextmenu.extend(remoteNormalOpenMarkerItem);
                 //启用当天常开时间段
                 contextmenu.extend(enableIntradayTZMarkerItem);
                 //禁用当天常开时间段
                 contextmenu.extend(disableIntradayTZMarkerItem);
                 //查阅最近发生事件
                 contextmenu.extend(doorEventLatestHappenMarkerItem);
             }
        }else if("mapMain"==pageSource){
            /*右键删除*/
            contextmenu.extend(removeMarkerItem);
            if(feature.getProperties().entityType == "VidChannel"){
                /*查看更多图片
                if(window.cameraSnList != null && window.cameraSnList != [] && window.cameraSnList.length > 0){
                    for(var i =0 ; i<window.cameraSnList.length;i++){
                        if(window.cameraSnList[i] == feature.getProperties().POP.split("_")[1]){
                            contextmenu.extend(showMorePicMarkerItem);
                        }
                    }
                }
                */
            }
            if(feature.getProperties().entityType == "AccDoor"){
            }
        }else{
            contextmenu.extend(contextmenu.getDefaultItems());
        }
        // if(feature && feature.get('type') === 'removable') {
        //
        // }else if(feature && feature.get('type') === 'gisCamera') {
        //
        // } else {
        //
        // }
        return feature;
    }





}


/**
 *
 * 地图右键菜单的实现
 */
{

    /** 远程操作回调（不验证密码） */
    function mapRemoteOperateNotVerify(itemId, id, name, titleText) {
        var data = {itemId: itemId, title: titleText, id: id, opObj: name};
        // 远程操作结果处理
        mapRemoteOperateDealRetFun(data);

    }

    /**
     *远程开门回调
     * @param itemId
     * @param id
     * @param name
     * @param titleText
     */
    function mapRemoteOperate(itemId, id, name, titleText) {
        var data = {itemId: itemId, title: titleText, id: id, opObj: name};

        //用户验证
        verifyLoginPwd(function(data){
            mapRemoteOperateDealRetFun(data);
        }, data);
    }

    /** 远程操作结果处理 */
    function mapRemoteOperateDealRetFun(data) {

        function dealRetFun(result)//处理操作结果函数
        {
            if(result[sysCfg.ret] == sysCfg.success)
            {
                closeMessage();
                openMessage(msgType.success);
                $(".jbox-icon").addClass("jbox-rtBeforeIcon");
            } else if (result[sysCfg.ret] == sysCfg.error) {
                var msgArray = result[sysCfg.msg].split(";");
                var msg = "";
                for (i in msgArray) {
                    if (msgArray[i] != "") {
                        msg += msgArray[i] + "<br>";
                    }
                }
                openMessage(msgType.error, msg);
            } else {
                openMessage(msgType.error);
            }
        }
        window.setTimeout(function(){
            if(data.itemId.indexOf("open") != -1 && data.itemId.indexOf("psg") == -1)
            {
                var html = "<div style='padding:10px;margin-left:30px;'>" +
                    "<div>"+I18n.getValue("common_target")+":&nbsp;&nbsp;" + data.opObj + "</div>" +
                    "<form id='openDoorForm' action='" + data.itemId + "' method='post'>" +
                    I18n.getValue("common_open")+":&nbsp;&nbsp;<input type='text' name='openInterval' size='8' value='5'/>" +
                    I18n.getValue("common_second")+"<span class='form_note'>(1-254)</span>" +
                    "</form>" +
                    "</div>";
                $.jBox(html, {
                    title: data.title,
                    loaded: function() {
                        $("input[name=openInterval]").focus();
                        //setFocus($("input[name=openInterval]")[0]);
                    },
                    submit: function (v, h, f) {
                        if (v == "ok")
                        {
                            $("#openDoorForm").submit();
                            return false;
                        }
                    }
                });
                //setFocus($("input[name=openInterval]")[0]);
                //$("input[name=openInterval]").focus();
                var alreadySubmit = false;
                $("#openDoorForm").validate({
                    rules : {
                        "openInterval" : {
                            required : true,
                            range: [1, 254]
                        }
                    },
                    submitHandler: function(form)
                    {
                        $(".jbox-button-focus").addClass("jbox-button-hover");
                        if(alreadySubmit)
                        {
                            return;
                        }
                        alreadySubmit = true;
                        $.jBox.close();
                        onLoading(function(){
                            $(form).ajaxSubmit({
                                async : true,
                                dataType : 'json',
                                data: {
                                    name: data.opObj,
                                    ids: data.id
                                },
                                success: function(result)
                                {
                                    dealRetFun(result);
                                }
                            });
                        });
                    }
                });
            }
            else
            {
                var html = "<div style='margin-top: -3px'>" +
                    "<div>"+I18n.getValue("common_target")+": "+ data.opObj + "</div>" +
                    "<div>"+ I18n.getValue("common_prompt_executeOperate").format(data.title) + "</div>" +
                    "</div>";
                var alreadySubmit = false;
                var akeyCode = 0;  //用于获取单击键盘的键值
                $.jBox.confirm(html, data.title,
                    function (v, h, f) {
                        if (v == "ok")
                        {
                            $(".jbox-button-focus").addClass("jbox-button-hover");
                            if(alreadySubmit)
                            {
                                return;
                            }
                            alreadySubmit = true;
                            $.jBox.close();
                            onLoading(function(){
                            $(".jbox-icon").addClass("jbox-rtBeforeIcon");
                                $.ajax({
                                    type: "POST",
                                    url: data.itemId,
                                    async : true,
                                    data: {
                                        ids: data.id
                                    },
                                    success: function(result)
                                    {
                                        dealRetFun(result);
                                    }
                                });
                            });
                            return false;
                        }
                        return true;
                    }
                );
                $(".jbox-content").children().addClass("jbox-rtContent");
                $(".jbox-icon").addClass("jbox-rtIcon");
                //leo 解决实时监控->远程关门，弹出的提示框，按回车键不会进入下一步(浏览器focus兼容性问题)
                function keyDownForEnter(e)
                {
                    akeyCode = e.keyCode;
                    if($(".jbox-button-focus") && akeyCode == '13' && alreadySubmit == false)
                    {
                        $(".jbox-button-focus").click();
                    }
                }
                document.onkeydown = keyDownForEnter;
                $(".jbox-button-focus").css("border", "1px solid #888888");
                $(".jbox-button-focus").focus();
            }
        },10);
    }

    /**
     *查询门最近发生事件弹窗
     * @param itemId
     * @param id
     * @param name
     * @param titleText
     */
    function openTransactionTodayLastWindow(entityId){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
            return;
        }
        var entityId = selectFeature.getProperties().entityId;
        openDoorEventWindow(entityId);
    }



    /**
     * 弹出框展示更多图片
     */
    function showMorePic(data){
        var opts = {//弹窗配置对象
            path: "/skip.do?page=map_monitoring_opShowMorePic&listPicData=" + data + "&message=map_viewPhotos",//设置弹窗路径
            width: 500,//设置弹窗宽度
            height: 500,//设置弹窗高度
            title: "<i18n 'map_viewPhotos'/>",//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        DhxCommon.createWindow(opts);
    }

    /**
    * 获取绑定的视频通道后调用预览
    */
    function mapRTMonitorChannelPreview(channelIds) {
        if (channelIds) {
            // 调用ivs多窗口视频预览,目前最多支持4路
            loadPlayMultiVideo(channelIds);
        }
    }

}





/**
 * 右键菜单的回调
 */
{
    // 删除图标
    function removeMarker(obj) {
        if(selectFeature != null){
            source.removeFeature(selectFeature);
            var itemId = selectFeature.getProperties().POP.split("_")[1];
            var name = selectFeature.getProperties().CAPITAL;
            var path = "/mapElement.do?deleteElements&ids="+itemId;
            $.get(path, function(result){
                dealRetResult(eval(result),function(){
                      if(typeof(deleteZtreeNode) == 'function'){
                             deleteZtreeNode(selectFeature.getProperties().entityId);
                      }
                     mapMainGis.updateDoorIds();
                     mapMainGis.popupCloser(selectFeature.getProperties().CAPITAL);
                });
            }, "json");
        }
    }

    // 视频预览
    function videoPreview(obj) {
        if(selectFeature != null){
            var vidChannelId=selectFeature.getProperties().POP.split("_")[0];
            getVideoPreviewByVidChannelId(vidChannelId);

        }
    }

    // 视频回放
    function videoReplay(obj) {
        if(selectFeature != null){
            var vidChannelId=selectFeature.getProperties().POP.split("_")[0];
            getVideoReplayByVidChannelId(vidChannelId);
        }
    }

    // 远程开门回调
    function accMapRemoteOpen(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?openDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL,  I18n.getValue("acc_eventNo_8"));
    }

    // 远程关门回调
    function accMapRemoteClose(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?closeDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("acc_eventNo_9"));
    }

    // 远程锁定回调
    function accMapActivateLockdown(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?lockDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("acc_newEventNo_233"));
    }

    // 远程解锁回调
    function accMapDeactivateLockdown(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?unLockDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("acc_newEventNo_234"));
    }

    // 取消报警回调
    function accMapCancelAlarm(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?cancelAlarm";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("acc_eventNo_7"));
    }

    // 远程常开回调
    function accMapRemoteNormalOpen(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?normalOpenDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("acc_rtMonitor_remoteNormalOpen"));
    }

    // 启用当天常开时间段回调
    function accMapEnableIntradayTZ(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?enableNormalOpenDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("common_rtMonitor_enableIntradayTZ"));
    }

    // 禁用当天常开时间段回调
    function accMapDisableIntradayTZ(){
        if(selectFeature == null || selectFeature == "" || selectFeature == undefined){
        }
        var deviceId = selectFeature.getProperties().entityId;
        var reqUrl = "/mapMonitoring.do?disableNormalOpenDoor";
        mapRemoteOperate(reqUrl, deviceId, selectFeature.getProperties().CAPITAL, I18n.getValue("common_rtMonitor_disableIntradayTZ"));
    }

    // 查看图片你方法
    function showMoreOperation(e){
        if(selectFeature != null){
            var deviceId = selectFeature.getProperties().POP.split("_")[1];
            showMorePic(deviceId);
        }
    }

    //左键单击获取告警详情
    function showOperation(e){
        if(selectFeature != null){
            var cameraId = selectFeature.getProperties().entityId;
            getAlarmDetailByCameraId(cameraId);
        }
    }
}


/**
 *  右键弹出框
 * @param evt
 */
{
    // 右键删除弹出框
    var removeMarkerItem = [{
        text: I18n.getValue("base_map_delEntity"),
        classname: 'marker',
        callback: removeMarker
    }];


    // 右键视频预览
    var videoPreviewMarkerItem = [{
        text: I18n.getValue("map_navigation_preview"),
        classname: 'marker',
        callback: videoPreview
    }];

    // 右键视频回放
    var videoReplayMarkerItem = [{
        text: I18n.getValue("acc_navigation_replay"),
        classname: 'marker',
        callback: videoReplay
    }];

    // 获取告警详情点击按钮
    var showAlarmMarkerItem = [{
        text: I18n.getValue("map_alarm_queryRecord"),
        classname: 'marker',
        callback: showOperation
    }];

    //获人员轨迹图片按钮
    var showMorePicMarkerItem = [{
        text: I18n.getValue("map_show_photo"),
        classname: 'marker',
        callback: showMoreOperation
    }];

    //远程开门
    var remoteOpenMarkerItem = [{
        text: I18n.getValue("acc_eventNo_8"),
        classname: 'marker',
        callback: accMapRemoteOpen
    }];

    //远程关门
    var remoteCloseMarkerItem = [{
        text: I18n.getValue("acc_eventNo_9"),
        classname: 'marker',
        callback: accMapRemoteClose
    }];

    //远程锁定
    var activateLockdownMarkerItem = [{
        text: I18n.getValue("acc_newEventNo_233"),
        classname: 'marker',
        callback: accMapActivateLockdown
    }];

    //远程解锁
    var deactivateLockdownMarkerItem = [{
        text: I18n.getValue("acc_newEventNo_234"),
        classname: 'marker',
        callback: accMapDeactivateLockdown
    }];

    //取消报警
    var cancelAlarmMarkerItem = [{
        text: I18n.getValue("acc_eventNo_7"),
        classname: 'marker',
        callback: accMapCancelAlarm
    }];

    //远程常开
    var remoteNormalOpenMarkerItem = [{
        text: I18n.getValue("acc_rtMonitor_remoteNormalOpen"),
        classname: 'marker',
        callback: accMapRemoteNormalOpen
    }];

    //启用当天常开时间段
    var enableIntradayTZMarkerItem = [{
        text: I18n.getValue("common_rtMonitor_enableIntradayTZ"),
        classname: 'marker',
        callback: accMapEnableIntradayTZ
    }];

    //禁用当天常开时间段
    var disableIntradayTZMarkerItem = [{
        text:  I18n.getValue("common_rtMonitor_disableIntradayTZ"),
        classname: 'marker',
        callback: accMapDisableIntradayTZ
    }];

    //查阅最近发生事件
    var doorEventLatestHappenMarkerItem = [{
        text: I18n.getValue("map_doorEventLatestHappen"),
        classname: 'marker',
        callback: openTransactionTodayLastWindow
    }];

}




