I18n
		.load(
				[ "acc_ivs_alarm_level_value_1",
						"acc_ivs_alarm_level_value_50",
						"acc_ivs_alarm_level_value_80",
						"map_manual_alarm",
						"acc_ivs_alarm_level_value_100" ], true);

function getAlarmDataNum(){
	$.ajax({
		type: "POST",
		url: "/accIvsAlarmNotify.do?getAllDataNum",
		dataType: "json",
		async: true,
		success: function(data)
		{
			if(data.success){
				var result = data.data;
				$("#emergencyAlarm1").text(result.emergencyAlarm);
				$("#importantAlarm1").text(result.importantAlarm);
				$("#generalAlarm1").text(result.generalAlarm);
				$("#promptAlarm1").text(result.promptAlarm);
			}
		},
		error:function (XMLHttpRequest, textStatus, errorThrown)
		{
			messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
		}
	});
}

function getFaceAlarmDataNum(){
    $.ajax({
        type: "POST",
        url: "/accFaceAlertsAlarm.do?getAllDataNum",
        dataType: "json",
        async: true,
        success: function(data)
        {
            if(data.success){
                var result = data.data;
                $("#control_emergencyAlarm1").text(result.emergencyAlarm);
                $("#control_importantAlarm1").text(result.importantAlarm);
                $("#control_generalAlarm1").text(result.generalAlarm);
                $("#control_promptAlarm1").text(result.promptAlarm);
            }
        },
        error:function (XMLHttpRequest, textStatus, errorThrown)
        {
            messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
        }
    });
}


/**
 * 确认人员布控告警
 * @param data
 */
function confirmFaceAlarmReq(data){
	var alarmId = $("#idAlarmId").val();
	if(alarmId == null ||alarmId == "" || alarmId == undefined){
		return;
	}
	var eventRemark = $("#idEventRemark").val();
	$.ajax({
		type: "POST",
		url: "/accFaceAlertsAlarm.do?confirmAlarm",
		dataType: "json",
		data: {"id" :alarmId,"eventRemark":eventRemark},
		async: true,
		success: function(data)
		{
			if(data.success){
				var result = data.data;
				$("#control_emergencyAlarm1").text(result.emergencyAlarm);
				$("#control_importantAlarm1").text(result.importantAlarm);
				$("#control_generalAlarm1").text(result.generalAlarm);
				$("#control_promptAlarm1").text(result.promptAlarm);
				$("#control_alarmDetailTable input").val("");
				$("#control_alarmDetailTable textarea").val("");
				$("#idAlarmId").val("");
				myLayouts[layoutName].cells("d").collapse();
				messageBox({messageType:"alert",text: data.msg,callback:reloadAlarmGrid});
			}
		},
		error:function (XMLHttpRequest, textStatus, errorThrown)
		{
			messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
		}
	});
}
/**
 * 确认告警
 * @param data
 */
function confirmAlarmReq(data){
	var alarmId = $("#idAlarmId").val();
	if(alarmId == null ||alarmId == "" || alarmId == undefined){
		return;
	}
	var eventRemark = $("#idEventRemark").val();
	$.ajax({
		type: "POST",
		url: "/accIvsAlarmNotify.do?confirmAlarm",
		dataType: "json",
		data: {"id" :alarmId,"eventRemark":eventRemark},
		async: true,
		success: function(data)
		{
			if(data.success){
				var result = data.data;
				$("#emergencyAlarm1").text(result.emergencyAlarm);
				$("#importantAlarm1").text(result.importantAlarm);
				$("#generalAlarm1").text(result.generalAlarm);
				$("#promptAlarm1").text(result.promptAlarm);
				$("#alarmDetailTable input").val("");
				$("#alarmDetailTable textarea").val("");
				$("#idAlarmId").val("");
				myLayouts[layoutName].cells("d").collapse();
				messageBox({messageType:"alert",text: data.msg,callback:reloadAlarmGrid});
			}
		},
		error:function (XMLHttpRequest, textStatus, errorThrown)
		{
			messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
		}
	});
}

/**
 *
 * @param id
 */
function getAlarmDetailByTabbar(id){

    //布控告警
    if("controlAlarmSetTabbar"==$("#alarm_SetTabbar").val()){
        getFaceAlarmDetail(id);
    }
    //视频告警
    if("videoAlarmSetTabbar"==$("#alarm_SetTabbar").val()){
        getAlarmDetail(id);
    }

}

/**
 * 获取人员布控告警时间详情
 * @param id
 */
function getFaceAlarmDetail(id){
	/*id 为空提示，不显示*/
	if(id == null ||id == "" || id == undefined){
		return;
	}else{
		$.ajax({
			type: "GET",
			url: "/accFaceAlertsAlarm.do?detail&id="+id,
			dataType: "json",
			async: false,
			success: function(data)
			{
				if(data.success){

					var result = data.data;
					if(result == null ||result == "" || result == undefined){
						$("#idAlarmInName").val("");
						$("#idAlarmLevelValue").val("");
						$("#idOccurTime").val("");
						$("#idAlarmDeviceIp").val("");
						$("#idAlarmInCode").val("");
						$("#idEventRemark").val("");
						$("#idAlarmId").val("");
						$("#"+photoImgId).attr('src',"");
						return;
					}
					$("#idAlarmInName").val(result.cameraName);
					var levelValue = result.alarmLevel;
					if (levelValue ==4) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_1"));
					} else if (levelValue ==3) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_50"));
					} else if (levelValue ==2) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_80"));
					} else if (levelValue ==1) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_100"));
					}else{
						$("#idAlarmLevelValue").val();
					}
					$("#idOccurTime").val(result.alarmTime);
					$("#idAlarmDeviceIp_tr").attr("hidden","hidden");
					$("#idAlarmInCode_tr").attr("hidden","hidden");

					document.getElementById("confirmAlarm").style.display="none";
					document.getElementById("confirmFaceAlarm").style.display="inline";

					$("#idEventRemark").val("");
					$("#idAlarmId").val(result.id);
					var localPreviewUrl = result.localPreviewUrl;
					var imgs = '<img onerror="javascript:this.src=\'/images/userImage.gif\';" onclick="vidIvsAlarmNotify.getCapturePhoto(this.src)" src="'+localPreviewUrl+'" width="158px" height="160px"/>';
					if(localPreviewUrl != undefined && localPreviewUrl != null && localPreviewUrl!=''){
						var photoList = localPreviewUrl.split(";");
						if(photoList != undefined && photoList!=null && photoList.length >0){
							imgs = "";
							for(var i = 0 ; i<photoList.length;i++){
								if(photoList[i] != undefined && photoList[i] != null && photoList[i] != ''){
									imgs += '<img onerror="javascript:this.src=\'/images/userImage.gif\';" onclick="vidIvsAlarmNotify.getCapturePhoto(this.src)" src="'+photoList[i]+'" style="float:left;margin-left: 2px;vertical-align: top;" width="158px" height="160px"/>';
								}
							}
						}
					}
					$("#mapAlarmImgsDiv").html(imgs);
//				$("#"+photoImgId).attr('src',result.localPreviewUrl);
					// 右侧布局弹出
					myLayouts[layoutName].cells("d").expand();
					myLayouts[layoutName].cells("d").setWidth(270);
				}
			},
			error:function (XMLHttpRequest, textStatus, errorThrown)
			{
				messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
			}
		});
	}

}


/**
 * 获取告警时间详情
 * @param id
 */
function getAlarmDetail(id){
	/*id 为空提示，不显示*/
	if(id == null ||id == "" || id == undefined){
		return;
	}else{
		$.ajax({
			type: "GET",
			url: "/accIvsAlarmNotify.do?detail&id="+id,
			dataType: "json",
			async: true,
			success: function(data)
			{
				if(data.success){
					var result = data.data

					if(result == null ||result == "" || result == undefined){
						$("#idAlarmInName").val("");
						$("#idAlarmLevelValue").val("");
						$("#idOccurTime").val("");
						$("#idAlarmDeviceIp").val("");
						$("#idAlarmInCode").val("");
						$("#idEventRemark").val("");
						$("#idAlarmId").val("");
						$("#"+photoImgId).attr('src',"");
						return;
					}
					$("#idAlarmInName").val(result.alarmInName);
					var levelValue = result.alarmLevelValue;
					if (levelValue < 50) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_1"));
					} else if (levelValue >= 50 && levelValue < 80) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_50"));
					} else if (levelValue >= 80 && levelValue < 100) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_80"));
					} else if (levelValue >= 100) {
						$("#idAlarmLevelValue").val(I18n.getValue("acc_ivs_alarm_level_value_100"));
					}else{
						$("#idAlarmLevelValue").val();
					}
					$("#idOccurTime").val(result.occurTime);
					$("#idAlarmDeviceIp").val(result.deviceIp);
					$("#idAlarmInCode").val(result.alarmInCode);

					document.getElementById("confirmFaceAlarm").style.display="none";
					document.getElementById("confirmAlarm").style.display="inline";

					$("#idEventRemark").val("");
					$("#idAlarmId").val(result.id);
					var localPreviewUrl = result.localPreviewUrl;
					var imgs = '<img onerror="javascript:this.src=\'/images/userImage.gif\';" onclick="vidIvsAlarmNotify.getCapturePhoto(this.src)" src="'+localPreviewUrl+'" width="158px" height="160px"/>';
					if(localPreviewUrl != undefined && localPreviewUrl != null && localPreviewUrl!=''){
						var photoList = localPreviewUrl.split(";");
						if(photoList != undefined && photoList!=null && photoList.length >0){
							imgs = "";
							for(var i = 0 ; i<photoList.length;i++){
								if(photoList[i] != undefined && photoList[i] != null && photoList[i] != ''){
									imgs += '<img onerror="javascript:this.src=\'/images/userImage.gif\';" onclick="vidIvsAlarmNotify.getCapturePhoto(this.src)" src="'+photoList[i]+'" style="float:left;margin-left: 2px;vertical-align: top;" width="158px" height="160px"/>';
								}
							}
						}
					}
					$("#mapAlarmImgsDiv").html(imgs);
//				$("#"+photoImgId).attr('src',result.localPreviewUrl);
					// 右侧布局弹出
					myLayouts[layoutName].cells("d").expand();
					myLayouts[layoutName].cells("d").setWidth(270);
				}
			},
			error:function (XMLHttpRequest, textStatus, errorThrown)
			{
				messageBox({messageType: "alert", title: I18n.getValue("common_prompt_title"), text: I18n.getValue('common_prompt_serverError') + "-628"});
			}
		});
	}


}

/**
 * websocket 获取地图上的摄像头查询告警
 */
var mapAlarmClient;
var clientId = Math.round(Math.random() * 10000) + "${uuid!}";
function initAlarmDevClient() {

	try {
		var divs = $("div[id^=VidChannel_]");
		var devIds = [];
		if(window.tempMapType == 2){
			// gis 地图获取摄像机列表
			var features = source.getFeatures();
			if(features == null || features.length <1){
				return;
			}
			for(var i =0;i<features.length;i++){
				var entityId = features[i].getProperties().POP.split("_")[1];
				devIds.push(entityId);
			}
			// gis 地图获取摄像机列表END
		}else if(window.tempMapType == 1){
			if (divs.length > 0) {
				for (var i = 0; i < divs.length; i++) {
					var id = divs[i].id;
					// 先将图标还原
					var img = $("#" + id + " img")[0];
					var imgSrc = img.src;
					if (imgSrc.indexOf(".gif") != -1) {
						imgSrc = imgSrc.replace('_Prompt', '');
						imgSrc = imgSrc.replace('_General', '');
						imgSrc = imgSrc.replace('_Important', '');
						imgSrc = imgSrc.replace('_Exigency', '');
						img.src = imgSrc.replace(".gif", ".png");
					}
					id = id.replace("VidChannel_", "");
					devIds.push(id);
				}
			}
			
		}
		
		if(devIds.length <1){
			return;
		}

		if("videoAlarmSetTabbar"==$("#alarm_SetTabbar").val()){
			/**
			 *
			 */
			mapAlarmClient = Web.getSocket({
				id : "mapAlarmClient",
				url : "mapAlarmMonitor/getVidDeviceState",
				param : JSON.stringify({
					"clientId" : clientId,
					"devIds" : devIds
				}),
				onMessage : function(resp) {
					var devData = JSON.parse(resp.body);
					if (devData.success) {
						var data = devData.data;
						// 遍历替换图标
						$.each(data, function(index, item) {
							if(window.tempMapType == 1){
								// 普通地图展示告警信息
								generalMapAlarms(index,item);
							}else if(window.tempMapType == 2){
								// gis地图展示告警信息
								flash(index,item);

							}

						})
					}
				}
			});

		}


		if("controlAlarmSetTabbar"==$("#alarm_SetTabbar").val()){


			/**
			 *获取人员布控告警的地图信息
			 */
			mapAlarmClient = Web.getSocket({
				id : "mapAlarmClient",
				url : "/accFaceAlertsAlarm/getVidDeviceStateFaceAlerts",
				param : JSON.stringify({
					"clientId" : clientId,
					"devIds" : devIds
				}),
				onMessage : function(resp) {
					var devData = JSON.parse(resp.body);
					if (devData.success) {
						var data = devData.data;
						// 遍历替换图标
						$.each(data, function(index, item) {
							if(window.tempMapType == 1){
								// 普通地图展示告警信息
								generalMapAlarms_face(index,item);
							}else if(window.tempMapType == 2){
								// gis地图展示告警信息
								flash_face(index,item);
							}

						})
					}
				}
			});

		}


	} catch (err) {
		// console.log("Error name: " + err.name + "");
		// console.log("Error message: " + err.message);
	}
}

//实时修改gis地图上摄像机状态
function flash_face(index,item) {
	var start = new Date().getTime();
	var listenerKey;
	var onlineStatus = item;
	// 在线离线状态
	updateCameraStatus(index,item,onlineStatus);
	function animate(event) {
		var features = source.getFeatures();
		if(features == null || features.length <1){
			return true;
		}
		var duration = 3000;
		for(var i =0 ;i< features.length;i++){
			var featureId = features[i].getProperties().POP.split("_")[1];
			if(index == featureId){
				var styleImg = null;
				//判断没有告警记录，直接修改在线状态就退出此次循环
				if(item == "" || item == null || item == undefined){
					return false;
				}
				var vectorContext = event.vectorContext;
				var frameState = event.frameState;
				var flashGeom = features[i].getGeometry().clone();
				var elapsed = frameState.time - start;
				var elapsedRatio = elapsed / duration;
				var radius = ol.easing.easeOut(elapsedRatio) * 9;
				var opacity = ol.easing.easeOut(1-elapsedRatio);
				var color = 'rgba(255, 127, 0, ' + 0.4 + ')';
				if (item ==4) {
					color = 'rgba(0, 239, 227, ' + 0.4 + ')';
				} else if (item ==3) {
					color = 'rgba(255, 221, 2, ' + 0.4 + ')';
				} else if (item ==2) {
					color ='rgba(255, 127, 0, ' + 0.4 + ')';
				} else if (item ==1) {
					color = 'rgba(237, 28, 36, ' + 0.4 + ')';
				}
				var style = new ol.style.Style({
					image: new ol.style.Circle({
						radius: radius+13,
						snapToPixel: false,
						stroke: new ol.style.Stroke({
							color: color,
							width: opacity+3
						})
					})
				});
				vectorContext.setStyle(style);
				vectorContext.drawGeometry(flashGeom);
				if (elapsed > duration) {
					ol.Observable.unByKey(listenerKey);
					return;
				}
				map.render();
			}
		}
	}
	listenerKey = map.on('postcompose', animate);
}

//实时修改gis地图上摄像机状态
function flash(index,item) {

    var start = new Date().getTime();
    var listenerKey;
	var items = item.split("_");
	item = items[0];
	var onlineStatus = items[1];
	// 在线离线状态
	updateCameraStatus(index,item,onlineStatus);
    function animate(event) {

    	var features = source.getFeatures();
    	if(features == null || features.length <1){
    		return true;
    	}
        var duration = 3000;
        for(var i =0 ;i< features.length;i++){
        	var featureId = features[i].getProperties().POP.split("_")[1];
        	if(index == featureId){
        		var styleImg = null;

        		var vectorContext = event.vectorContext;
        		var frameState = event.frameState;
        		var flashGeom = features[i].getGeometry().clone();
        		var elapsed = frameState.time - start;
        		var elapsedRatio = elapsed / duration;
        		var radius = ol.easing.easeOut(elapsedRatio) * 9;
        		var opacity = ol.easing.easeOut(1-elapsedRatio);



        		var color = 'rgba(255, 127, 0, ' + 0.4 + ')';
        		if (item < 50) {
        			color = 'rgba(0, 239, 227, ' + 0.4 + ')';
        		} else if (item >= 50 && item < 80) {
        			color = 'rgba(255, 221, 2, ' + 0.4 + ')';
        		} else if (item >= 80 && item < 100) {
        			color ='rgba(255, 127, 0, ' + 0.4 + ')';
        		} else if (item >= 100) {
        			color = 'rgba(237, 28, 36, ' + 0.4 + ')';
        		}
        		var style = new ol.style.Style({
        			image: new ol.style.Circle({
        				radius: radius+13,
        				snapToPixel: false,
        				stroke: new ol.style.Stroke({
        					color: color,
        					width: opacity+3
        				})
        			})
        		});
				//判断没有告警记录，直接修改在线状态就退出此次循环
				if(item == "" || item == null || item == undefined){

				}else{
					vectorContext.setStyle(style);
					vectorContext.drawGeometry(flashGeom);
				}
        		if (elapsed > duration) {
        			ol.Observable.unByKey(listenerKey);
        			return;
        		}
        		map.render();
        	}
        }
    }
    listenerKey = map.on('postcompose', animate);
}

// 修改摄像机图标状态显示
function updateCameraStatus(index,item,onlineStatus){
	var features = source.getFeatures();
	if(features == null || features.length <1){
		return;
	}
    for(var i =0 ;i< features.length;i++){
    	var featureId = features[i].getProperties().POP.split("_")[1];
    	if(index == featureId){
    		if(item == "" || item == null || item == undefined){
    			var imgPath = features[i].getStyle().getImage().getSrc();
        		if(onlineStatus == 1){
        			// 在线
        			var imgStyle = new ol.style.Style({
        	        	 image: new ol.style.Icon(({
        	        		 scale: 1,
        	                 src: imgPath,
        	                 color : "#dceffc"
        	             }))
        	         });
        			features[i].setStyle(imgStyle);
        		}else if(onlineStatus == 0){
        			var imgStyle = new ol.style.Style({
       	        	 image: new ol.style.Icon(({
       	        		 scale: 1,
       	                 src: imgPath,
       	                 color : "#828282"
       	             }))
       	         });
       			features[i].setStyle(imgStyle);
        		}
        		return true;
        	}
    	}
    }
}


//普通地图展示告警信息
function generalMapAlarms_face(index,item){

	var img = $("#VidChannel_" + index + " img")[0];
	var imgSrc = img.src;
	var imgUrl = "";
	var onlineStatus = item;
	//判断没有告警记录，直接修改在线状态就退出此次循环
	if(item == "" || item == null || item == undefined){
		if(onlineStatus == 1){
			if(imgSrc.indexOf("_offline") != -1){
				imgUrl = imgSrc.replace("_offline","");
				img.src = imgUrl;
			}
		}else if(onlineStatus == 0){
			if(imgSrc.indexOf("_offline") == -1){
				if (imgSrc.indexOf(".png") != -1) {
					imgUrl = imgSrc.split(".png")[0];
					imgUrl = imgUrl+"_offline.png";
					img.src = imgUrl;
				}else if(imgSrc.indexOf(".gif") != -1){
					imgUrl = imgSrc.split(".gif")[0];
					imgUrl = imgUrl+"_offline.gif";
					img.src = imgUrl;
				}
			}
		}
		return true;
	}
	if (imgSrc.indexOf(".png") != -1) {
		imgUrl = imgSrc.split(".png");
	} else if (imgSrc.indexOf(".gif") != -1) {
		// 有比较高级的告警就跳出
		if (item ==4) {
			if (imgSrc.indexOf("_General") != -1
				|| imgSrc.indexOf("_Important") != -1
				|| imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Prompt.gif";
		} else if (item == 3) {
			if (imgSrc.indexOf("_Important") != -1
				|| imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_General.gif";
		} else if (item  == 2) {
			if (imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Important.gif";
		} else if (item  == 1) {
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Exigency.gif";
		}
		imgUrl = imgSrc.split(".gif");
	}
	imgUrl = imgUrl[0].split("_Prompt")[0];
	imgUrl = imgUrl.split("_General")[0];
	imgUrl = imgUrl.split("_Important")[0];
	imgUrl = imgUrl.split("_Exigency")[0];
	if (item  == 4) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Prompt.gif";
	} else if (item == 3) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_General.gif";
	} else if (item == 2) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Important.gif";
	} else if (item == 1) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Exigency.gif";
	}

}



//普通地图展示告警信息
function generalMapAlarms(index,item){

	var img = $("#VidChannel_" + index + " img")[0];
	var imgSrc = img.src;
	var imgUrl = "";
	var onlineStatus = null;
	var items = item.split("_");
	item = items[0];
	onlineStatus = items[1];
	//判断没有告警记录，直接修改在线状态就退出此次循环
	if(item == "" || item == null || item == undefined){
		if(onlineStatus == 1){
			if(imgSrc.indexOf("_offline") != -1){
				imgUrl = imgSrc.replace("_offline","");
				img.src = imgUrl;
			}
		}else if(onlineStatus == 0){
			if(imgSrc.indexOf("_offline") == -1){
				if (imgSrc.indexOf(".png") != -1) {
					imgUrl = imgSrc.split(".png")[0];
					imgUrl = imgUrl+"_offline.png";
					img.src = imgUrl;
				}else if(imgSrc.indexOf(".gif") != -1){
					imgUrl = imgSrc.split(".gif")[0];
					imgUrl = imgUrl+"_offline.gif";
					img.src = imgUrl;
				}
			}
		}
		return true;
	}
	if (imgSrc.indexOf(".png") != -1) {
		imgUrl = imgSrc.split(".png");
	} else if (imgSrc.indexOf(".gif") != -1) {
		// 有比较高级的告警就跳出
		if (item < 50) {
			if (imgSrc.indexOf("_General") != -1
					|| imgSrc.indexOf("_Important") != -1
					|| imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Prompt.gif";
		} else if (item >= 50 && item < 80) {
			if (imgSrc.indexOf("_Important") != -1
					|| imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_General.gif";
		} else if (item >= 80 && item < 100) {
			if (imgSrc.indexOf("_Exigency") != -1) {
				return true;
			}
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Important.gif";
		} else if (item >= 100) {
			if(onlineStatus==1){
				imgUrl = imgUrl[0].split("_offline")[0];
			}else if(imgUrl.indexOf("_offline")<1){
				imgUrl = imgUrl+ "_offline";
			}
			img.src = imgUrl + "_Exigency.gif";
		}
		imgUrl = imgSrc.split(".gif");
	}
	imgUrl = imgUrl[0].split("_Prompt")[0];
	imgUrl = imgUrl.split("_General")[0];
	imgUrl = imgUrl.split("_Important")[0];
	imgUrl = imgUrl.split("_Exigency")[0];
	if (item < 50) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Prompt.gif";
	} else if (item >= 50 && item < 80) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_General.gif";
	} else if (item >= 80 && item < 100) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Important.gif";
	} else if (item >= 100) {
		if(onlineStatus==1){
			imgUrl = imgUrl.split("_offline")[0];
		}else if(imgUrl.indexOf("_offline")<1){
			imgUrl = imgUrl+ "_offline";
		}
		img.src = imgUrl + "_Exigency.gif";
	}

}

/**
 * 根据类型查询报警记录
 * 
 * @param type
 */
function findAlarmData(type) {
	if (type < 50) {
		type = 1;
	} else if (type >= 50 && type < 80) {
		type = 50;
	} else if (type >= 80 && type < 100) {
		type = 80;
	} else if (type >= 100) {
		type = 100
	}
	ZKUI.Grid.get(alarmGridId).reload(function() {
	}, {
		"alarmLevelValue" : type
	});

}

/**
 * 修改告警列表颜色展示
 */
function  changeColor_video() {
	var accAlarmGrid = this;
	changeColor(accAlarmGrid,"alarmLevelValue");
}

/**
 * 修改告警列表颜色展示
 */
function  changeColor_face() {
	var accAlarmGrid = this;
	changeColorFaceAlarm(accAlarmGrid,"alarmLevel");
}
/**
 * 修改告警列表颜色展示
 */
function changeColor(accAlarmGrid,alarmLevelValue) {

	var rowNum = accAlarmGrid.getRowsNum();
	if (rowNum > 0) {
		for (var i = 0; i < accAlarmGrid.getRowsNum(); i++) {
			var rowData = accAlarmGrid.getRowData(accAlarmGrid.getRowId(i));
			if (rowData != "" && rowData != null && rowData != undefined) {

				var levelValue = rowData[alarmLevelValue];
				if (levelValue < 50) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
							"#00EFE3");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
							I18n.getValue("acc_ivs_alarm_level_value_1"));
				} else if (levelValue >= 50 && levelValue < 80) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
							"#FFDD02");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
							I18n.getValue("acc_ivs_alarm_level_value_50"));
				} else if (levelValue >= 80 && levelValue < 100) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
							"#FF7300");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
							I18n.getValue("acc_ivs_alarm_level_value_80"));
				} else if (levelValue >= 100) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
							"#ED1C24");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
							I18n.getValue("acc_ivs_alarm_level_value_100"));
				}
			}
		}
	}
}

/**
 * 修改告警列表颜色展示
 */
function changeColorFaceAlarm(accAlarmGrid,alarmLevelValue) {

	var rowNum = accAlarmGrid.getRowsNum();
	if (rowNum > 0) {
		for (var i = 0; i < accAlarmGrid.getRowsNum(); i++) {
			var rowData = accAlarmGrid.getRowData(accAlarmGrid.getRowId(i));
			if (rowData != "" && rowData != null && rowData != undefined) {

				var levelValue = rowData[alarmLevelValue];
				if (levelValue ==I18n.getValue("acc_ivs_alarm_level_value_1")) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
						"#00EFE3");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
						I18n.getValue("acc_ivs_alarm_level_value_1"));
				} else if (levelValue ==I18n.getValue("acc_ivs_alarm_level_value_50")) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
						"#FFDD02");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
						I18n.getValue("acc_ivs_alarm_level_value_50"));
				} else if (levelValue ==I18n.getValue("acc_ivs_alarm_level_value_80")) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
						"#FF7300");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
						I18n.getValue("acc_ivs_alarm_level_value_80"));
				} else if (levelValue ==I18n.getValue("acc_ivs_alarm_level_value_100")) {
					accAlarmGrid.setRowColor(accAlarmGrid.getRowId(i),
						"#ED1C24");
					accAlarmGrid.cells(accAlarmGrid.getRowId(i), 2).setValue(
						I18n.getValue("acc_ivs_alarm_level_value_100"));
				}
			}
		}
	}
}
