
/* 切换左侧大图区的图片 */
function showBigImg(obj) {
	$(".big-picture img").attr("src", obj.src);
}

/* 点击提交按钮确认告警 */
$("#submitBtn").click(function(e){
	var reportData = $.trim($("#alarmReport").val());
	if(reportData != ""){
		confirmAlarmDetail();
	}else{
		e.preventDefault();
		$("#alarmReport").css("border","1px solid red");
		openMessage(msgType.error, I18n.getValue("acc_no_report"));
		$("#alarmReport").val("");
	}
})
$("#alarmReport").on("input",function () {
	$(this).css("border","none");
})

/**
 * 点击视频播放的事件
 * @param alramType	告警类型
 * @param alartAlarmId	告警id
 * @param popType	弹出播放样式 1-预览	2-回放
 */
function alarmVideoPlayPop(alramType, alartAlarmId,popType) {
	var type = "";
	switch (alramType) {
		case "1":
			type = "faceAlarm";
			break;
		case "2":
			type = "vehicleAlarm";
			break;
		case "3":
			type = "ivsAlarm";
			break;
		default :
			type = "personFaceTrack";
			break;
	}
	if(popType == 1){
		// 预览
		vidIvsOCX.getOCXPopVideoPreviewHtml(alartAlarmId,type);
	}else if(popType == 2){
		// 回放
		vidIvsOCX.getOCXPopHtml(alartAlarmId,type);
	}
}

/**
 * 确认告警的事件
 */
function confirmAlarmDetail() {
    var alramId=$("#id").val();
    var eventRemark = $("#alarmReport").val();
    $.ajax({
        type: "post",
        url: "/accAlarm.do?saveConfirmAlarm",
        dataType: "json",
        async: false,
        data: {
            "alertsAlarmId" :alramId,
            "eventRemark":eventRemark},
        success: function(result)
        {
            if(result.ret == "ok") {
            	DhxCommon.closeWindow();
            	messageBox({messageType:"alert",text: result.msg});
            	getUserSendMessageTotal(); // 重新获取当前用户推送告警数据总条目数
            	removeTips(); // 移除右下角弹窗
            	return;
            }else{
                messageBox({messageType:"alert",text: result.msg});
            }
        }
    });
}