
var serverOcxMap=new Map();
$(function () {
    serverOcxMap.clear();
})

I18n.load([
    "map_navigation_replay",
    "map_navigation_preview",
],true);

/**
 * 通用方法
 */
{
    function dateToString(date){
        var year = date.getFullYear();
        var month =(date.getMonth() + 1).toString();
        var day = (date.getDate()).toString();
        if (month.length == 1) {
            month = "0" + month;
        }
        if (day.length == 1) {
            day = "0" + day;
        }
        var hours = date.getHours().toString();
        if(hours.length == 1){
            hours = "0" + hours;
        }
        var mintus = date.getMinutes().toString();
        if(mintus.length == 1){
            mintus = "0" + mintus;
        }
        var second = date.getSeconds().toString();
        if(second.length == 1){
            second = "0" + second;
        }

        var dateTime = year+ month + day + hours + mintus + second;
        return dateTime;
    }

}





/**
 * 通用方法
 */
var utils = {

    /**
     * 将用户输入的本地时间转换成UTC时间提交给平台
     * Convert LocalTime to UTC
     * @param loacltime 时间格式为：yyyyMMddHHmmss
     * @returns
     */
    toUTCString:function toUTCString(loacltime) {
        var localDate = null;
        if(loacltime.includes("-")){
            localDate = new Date(Date.parse(loacltime.replace(/-/g,"/")));
        }else{
            var pattern = /(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/;
            localDate = new Date(loacltime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
        }
        var utcString = localDate.getUTCFullYear() +""+
            (localDate.getUTCMonth()+1< 10?  "0"+ (parseInt(localDate.getUTCMonth())+1) : "" + (parseInt(localDate.getUTCMonth())+1)) +
            (localDate.getUTCDate()< 10?   "0"+ localDate.getUTCDate()  : "" + localDate.getUTCDate())  +
            (localDate.getUTCHours()< 10?  "0"+ localDate.getUTCHours() : "" + localDate.getUTCHours()) +
            (localDate.getUTCMinutes()< 10?"0"+ localDate.getUTCMinutes() : ""+localDate.getUTCMinutes())+
            (localDate.getUTCSeconds()< 10?"0"+ localDate.getUTCSeconds() : ""+localDate.getUTCSeconds());
        return utcString;
    },

    /**
     * 将秒数换成时分秒格式
     */
    formatSeconds:function formatSeconds(value) {
        var secondTime = parseInt(value);// 秒
        var minuteTime = 0;// 分
        var hourTime = 0;// 小时
        if(secondTime > 60) {//如果秒数大于60，将秒数转换成整数
            //获取分钟，除以60取整数，得到整数分钟
            minuteTime = parseInt(secondTime / 60);
            //获取秒数，秒数取佘，得到整数秒数
            secondTime = parseInt(secondTime % 60);
            //如果分钟大于60，将分钟转换成小时
            if(minuteTime > 60) {
                //获取小时，获取分钟除以60，得到整数小时
                hourTime = parseInt(minuteTime / 60);
                //获取小时后取佘的分，获取分钟除以60取佘的分
                minuteTime = parseInt(minuteTime % 60);
            }
        }
        var result = "";
        if(hourTime>0){
            if(parseInt(hourTime).toString().length>1){
                result += parseInt(hourTime)+":";
            }else{
                result += "0"+parseInt(hourTime)+":";
            }
        }else{
            result += "00:"
        }

        if(minuteTime > 0) {
            if(parseInt(minuteTime).toString().length>1){
                result += parseInt(minuteTime) +":";
            }else{
                result += "0"+parseInt(minuteTime) +":";
            }
        }else{
            result += "00:"
        }

        if(secondTime > 0) {
            if(parseInt(secondTime).toString().length>1){
                result += parseInt(secondTime);
            }else{
                result += "0"+parseInt(secondTime);
            }
        }else{
            result += "00"
        }
        return result;
    },

    /**
     * 根据formatter字符串转换时间字符串
     * 月(M)、日(d)、小时(h)、分(m)、秒(s) 占位符个数需要和时间字符串匹配
     * @param  {string} dateStr 时间字符串 如:"2015-11-12"
     * @param  {string} fmt     格式化字符串 如:"yyyy-MM-dd"
     * @return {Date}           标准时间
     * author: shaojiasong 2015-12-29
     */
    parseDate:function parseDate(dateStr,fmt){
        if(!dateStr || !fmt || (dateStr.length != fmt.length)) {
            throw new Error("转换时间时发生错误,时间字符串与格式字符串不匹配!");
        }
        //排除特殊字符,避免正则发生错误
        fmt = fmt.replace(/([\^\$\.\*\+\?\=\!\:\|\\\/\(\)\[\]\{\}])/ig,"\\$1");
        function getReg(str){
            var cfmt = fmt;
            cfmt = cfmt.replace(new RegExp(str+"+","g"),function(full){ return "("+full+")";}) || "";
            return cfmt.replace(/[yMdhmsS]/g,"\\d");
        }
        var year   = parseInt((new RegExp(getReg("y")).exec(dateStr)[1])) || 0;
        var month  = parseInt((new RegExp(getReg("M")).exec(dateStr)[1])) - 1 || 0;
        var day    = parseInt((new RegExp(getReg("d")).exec(dateStr)[1])) || 0;
        var hour   = parseInt((new RegExp(getReg("h")).exec(dateStr)[1])) || 0;
        var minute = parseInt((new RegExp(getReg("m")).exec(dateStr)[1])) || 0;
        var second = parseInt((new RegExp(getReg("s")).exec(dateStr)[1])) || 0;

        return new Date(year,month,day,hour,minute,second);
    },

};



/**
 * 远程数据操作
 */
{

    /**
     * 获取ocx 的登录配置
     */

    function getOcxInfo(cameraSn,callback) {
        $.ajax({
            type : "POST",
            url : "vidIspIntegration.do?getOcxInfo",
            dataType : "json",
            data:{
                cameraSn:cameraSn,
            },
            success : function(result) {
                if(result.ret == "ok") {
                    var resultParam=result.data;
                    var serverId = resultParam["serverId"];
                    var ip = resultParam["huaWeiServerIp"];
                    var port =resultParam["huaWeiServerPort"] ;
                    var user =resultParam["huaweiUser"];
                    var pwd =resultParam["huaweiPassWord"];
                    var msg =resultParam["msg"];
                    if(null==ip||null==port||null==user||null==pwd){
                        vidOpenMessage(msgType.warning,msg);
                    }
                    return callback(result.data);
                }else{
                    vidOpenMessage(msgType.warning,result.msg);
                    return;
                }
            }
        });
    }

    /**
     * 获取摄像机详情
     * @param cameraSns
     * @param callback
     */
    function listDeviceBySn(cameraSns,callback) {
        $.ajax({
            type : "POST",
            url : "vcnDevice.do?listDeviceBySn",
            dataType : "json",
            data:{
                cameraSns:cameraSns,
            },
            success : function(result) {
                if(result.ret == "ok") {
                    return callback(result.data);
                }
            }
        });
    }


    /**
     * 根据id获取人员告警的设备信息
     */
    function getVidFaceAlertsAlarm(id,callback) {
        $.ajax({
            type: "post",
            url: "vidFaceAlertsAlarm.do?getFaceAlarmDevice",
            dataType: "json",
            data: {"id" :id},
            async: false,
            success:function (result) {
                callback(result);
            }
        });
    }
    /**
     * 根据id获取车辆告警的设备信息
     */
    function getVidVehicleAlertsAlarm(id,callback) {
        $.ajax({
            type: "post",
            url: "vidVehicleMonitorAlarm.do?getVehicleAlarmDevice",
            dataType: "json",
            data: {"id" :id},
            async: false,
            success:function (result) {
                callback(result);
            }
        });
    }
    /**
     * 根据id获取ivs告警的设备信息
     */
    function getVidIvsAlertsAlarm(id,callback) {
        $.ajax({
            type: "post",
            url: "vidIvsAlarmNotify.do?getItemById",
            dataType: "json",
            data: {"id" :id},
            async: false,
            success:function (result) {
                callback(result);
            }
        });
    }
};

/**
 * 渲染列表
 */
var render = {
    vidOpenMessage: function vidOpenMessage(type, text, ptimeout) {
        $("div.jbox-tip").remove();
        setTimeout(function()
        {
            openMessage(type, text, ptimeout);
            if (isIE || navigator.userAgent.indexOf("Chrome") > 0)
            {
                var _tip = $(".jbox-tip .jbox");
                _tip.prepend('<iframe id="ocxIframe" style="width:' + _tip.width() + 'px; height:' + _tip.height() + 'px;z-index:-1;position:absolute"></iframe>')
                setTimeout(function()
                {
                    _tip.find("#ocxIframe").remove();
                }, 3000);
            }
        }, 10);
    }
};


/**
 * 本地方法弹框
 */
{

    /**
     * 单个视频回放的弹窗界面
     * @param startTime
     * @param endTime
     * @param cameraCode
     * @param nvrCode
     */
    function videoPlayPopup(startTime,endTime,cameraCode,nvrCode,deviceName) {
        var opts = {//弹窗配置对象
            path: "skip.do?page=vid_preview_vcnVideoPlayback"
                +"&vcnVideoPlayback_startTime="+startTime
                +"&vcnVideoPlayback_endTime="+endTime
                +"&cameraCode="+cameraCode
                +"&nvrCode="+nvrCode
                +"&deviceName="+deviceName,
            //设置弹窗路径
            width: 920,//设置弹窗宽度
            height: 650,//设置弹窗高度
            title: I18n.getValue("map_navigation_replay"),//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        w1 =  DhxCommon.createWindow(opts);
    }

    /**
     * 多个视频回放的弹窗界面
     * @param startTime
     * @param endTime
     * @param cameraCode
     * @param nvrCode
     */
    function videoReplayPopup(startTime,endTime,cameraCode,nvrCode) {
        var opts = {//弹窗配置对象
            path: "skip.do?page=vid_preview_vcnVideoReplay"
                +"&vcnVideoPlayback_startTime="+startTime
                +"&vcnVideoPlayback_endTime="+endTime
                +"&cameraCode="+cameraCode
                +"&nvrCode="+nvrCode,
            //设置弹窗路径
            width: 920,//设置弹窗宽度
            height: 650,//设置弹窗高度
            title: I18n.getValue("map_navigation_replay"),//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        w1 =  DhxCommon.createWindow(opts);
    }

    /**
     * 视频预览的弹窗界面
     * @param startTime
     * @param endTime
     * @param cameraCode
     * @param nvrCode
     */
    function videoPreviewPopup(cameraCode,nvrCode,deviceName) {
        var opts = {//弹窗配置对象
            path: "skip.do?page=vid_preview_vcnVideoPreview"
                +"&cameraCode="+cameraCode
                +"&nvrCode="+nvrCode
                +"&deviceName="+deviceName,
            //设置弹窗路径
            width: 920,//设置弹窗宽度
            height: 650,//设置弹窗高度
            title: I18n.getValue("map_navigation_preview"),//设置弹窗标题
            gridName: "gridbox"//设置grid
        };
        w1 =  DhxCommon.createWindow(opts);
    }

};

/**
 * 初始化ocx 方法
 */
var _ocxPrivateMethods = function(vidIvsOCX) {

    /**
     *
     * IVS_OCX_RefreshWnd(重绘OCX界面)
     */
    vidIvsOCX.refreshWnd= function refreshWnd () {

        if(zkVideoOcx) {
            zkVideoOcx.IVS_OCX_RefreshWnd(2);
        }
    }
    /**
     * 设置全屏
     */
    vidIvsOCX.screenload =function screenload(){
        if(zkVideoOcx){
            var result = zkVideoOcx.IVS_OCX_FullScreenDisplay();

        }
    }
    /**
     * 用户注销
     */
    vidIvsOCX.setLogout =function setLogout()
    {
        if (zkVideoOcx)
        {
            var result = zkVideoOcx.IVS_OCX_Logout();//用户注销
            if (result == 0)
            {
                //成功,TODO……
            }
        }
    }

    /**
     * 释放资源
     */
    vidIvsOCX.setCleanUp =function setCleanUp(callBackFun)
    {
        if (zkVideoOcx)
        {
            var result = zkVideoOcx.IVS_OCX_Logout();//用户注销
            result = zkVideoOcx.IVS_OCX_Cleanup();//释放OCX资源
            if (result == 0)
            {
                return callBackFun()
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }
    /**
     * 停止视频直播
     */
    vidIvsOCX.stopLivePlay =function stopLivePlay(callBackFun) {
        if (zkVideoOcx)
        {
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//获取窗格
            var result = zkVideoOcx.IVS_OCX_StopRealPlay(wnd);//停止实况
            if (result == 0)
            {
                return callBackFun()
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }


    /**
     * 停止视频直播
     */
    vidIvsOCX.stopWndLivePlay =function stopWndLivePlay(wnd,callBackFun) {
        if (zkVideoOcx) {
            var result = zkVideoOcx.IVS_OCX_StopRealPlay(wnd);//停止实况
            if (result == 0)
            {
                return callBackFun()
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }

    /**
     * 开始实时浏览
     * @param cameraCode
     * @returns {*}
     */
    vidIvsOCX.getBatchLivePlay =function getBatchLivePlay(postDate,callback){

        if (zkVideoOcx) {
            var resultMap={
                wnd:"",
                cameraId:"",
                result:"",
            };
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//窗格
            if (wnd == 0)
            {
                wnd = zkVideoOcx.IVS_OCX_GetFreeWnd();//获取空闲窗格
                var xml =  zkVideoOcx.IVS_OCX_SetActiveWnd(wnd); //设置激活窗格
            }

            var streamType =1;//码流类型 0-不指定 1-主码流 2-副码流1 副码流2
            var protocolType = 2;// 协议类型  1-UDP 2-TCP
            var direstFirst =1;// 是否直连优先 0-否 1-是
            var multi = 0;// 是否支持组播 0-否 1-是

            var pMediaParaxml =
                "<?xml version='1.0' encoding='UTF-8'?>" +
                "<Content>" +
                "    <RealplayParam>" +
                "        <StreamType>" +  streamType + "</StreamType>"  +
                "        <ProtocolType>" + protocolType + "</ProtocolType>" +
                "        <DirectFirst>" + direstFirst + "</DirectFirst>" +
                "        <Multicast>" + multi + "</Multicast>" +
                "    </RealplayParam>" +
                "</Content>";
            var result =  zkVideoOcx.IVS_OCX_StartRealPlay(pMediaParaxml, postDate["cameraCode"], wnd);//开始实况
            resultMap["wnd"]=wnd;
            if(undefined!=postDate["cameraId"]){
                resultMap["wnd"]=wnd;
                resultMap["cameraId"]=postDate["cameraId"];
                resultMap["result"]=result;
            }
            if(0==result){
                if(undefined!=postDate["cameraName"]){
                    // 标题
                    zkVideoOcx.IVS_OCX_ShowTitlebar(1);
                    zkVideoOcx.IVS_OCX_ShowToolbar(1);
                    zkVideoOcx.IVS_OCX_SetDeviceName(wnd,postDate["cameraName"]);
                }
                // 禁止拖拽
                zkVideoOcx.IVS_OCX_SetWndDrag(wnd, 0);
                // 选择空闲窗格
                wnd = zkVideoOcx.IVS_OCX_GetFreeWnd();
                var xml = zkVideoOcx.IVS_OCX_SetActiveWnd(wnd);
                if (xml != 0)
                {
                    zkVideoOcx.IVS_OCX_GetSelectWnd();
                }
            }
            return callback(resultMap);
        }


    }


    /**
     * 停止实况
     * @param cameraCode
     * @returns {*}
     */
    vidIvsOCX.stopVideo =function stopVideo(key,callback){
        var result = zkVideoOcx.IVS_OCX_StopRealPlay(key);// 停止实况
        return callback(key);
    }

    /**
     * 开始实时浏览
     * @param postDate
     * @param callback
     * @returns {*}
     */
    vidIvsOCX.getLivePlay =function getLivePlay(postDate,callback){
        if (zkVideoOcx) {
            var resultMap={
                wnd:"",
                cameraId:"",
                result:"",
            };
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//窗格
            if (wnd == 0){
                wnd = zkVideoOcx.IVS_OCX_GetFreeWnd();//获取空闲窗格
                var xml =  zkVideoOcx.IVS_OCX_SetActiveWnd(wnd); //设置激活窗格
            }

            if(undefined!=postDate["cameraName"]){
                // 标题
                zkVideoOcx.IVS_OCX_ShowTitlebar(1);
                zkVideoOcx.IVS_OCX_ShowToolbar(1);
                zkVideoOcx.IVS_OCX_SetDeviceName(wnd,postDate["cameraName"]);
            }

            var streamType =1;//码流类型 0-不指定 1-主码流 2-副码流1 副码流2
            var protocolType = 2;// 协议类型  1-UDP 2-TCP
            var direstFirst =1;// 是否直连优先 0-否 1-是
            var multi = 0;// 是否支持组播 0-否 1-是

            var pMediaParaxml =
                "<?xml version='1.0' encoding='UTF-8'?>" +
                "<Content>" +
                "    <RealplayParam>" +
                "        <StreamType>" +  streamType + "</StreamType>"  +
                "        <ProtocolType>" + protocolType + "</ProtocolType>" +
                "        <DirectFirst>" + direstFirst + "</DirectFirst>" +
                "        <Multicast>" + multi + "</Multicast>" +
                "    </RealplayParam>" +
                "</Content>";
            var result =  zkVideoOcx.IVS_OCX_StartRealPlay(pMediaParaxml, postDate["cameraCode"], wnd);//开始实况
            resultMap["wnd"]=wnd;
            if(undefined!=postDate["cameraId"]){
                resultMap["wnd"]=wnd;
                resultMap["cameraId"]=postDate["cameraId"];
                resultMap["result"]=result;
            }
            getOcxErrorCodeMsg(result);
            if(0==result){
                if(undefined!=postDate["cameraName"]){
                    // 标题
                    zkVideoOcx.IVS_OCX_ShowTitlebar(1);
                    zkVideoOcx.IVS_OCX_ShowToolbar(1);
                    zkVideoOcx.IVS_OCX_SetDeviceName(wnd,postDate["cameraName"]);
                }
                // 禁止拖拽
                zkVideoOcx.IVS_OCX_SetWndDrag(wnd, 0);
                // 选择空闲窗格
                wnd = zkVideoOcx.IVS_OCX_GetFreeWnd();
                var xml = zkVideoOcx.IVS_OCX_SetActiveWnd(wnd);
                if (xml != 0)
                {
                    zkVideoOcx.IVS_OCX_GetSelectWnd();
                }
            }
            return callback(resultMap);
        }



    }

    /**
     * 获取录像计划的列表
     * @param recordMethod
     */
    vidIvsOCX.getRecordList =function getRecordList(recordMethod,callBackFun){

        if (zkVideoOcx) {
            var fromTime = utils.toUTCString($("#vcnVideoPlayback_startTime").val());//录像起止时间，UTC时间
            var toTime =  utils.toUTCString($("#vcnVideoPlayback_endTime").val());
            var cameraCode =$("#cameraCode").val();
            var recordListXml = zkVideoOcx.IVS_OCX_GetRecordList(cameraCode,recordMethod,fromTime,toTime,1,1000);
            xmlDoc = $.parseXML(recordListXml);
            xmlDoc = $(xmlDoc);
            var result = xmlDoc.find("ResultCode").text();
            var recordDataInfoNode = xmlDoc.find("RecordDataInfo");
            $("#resultcode").val("IVS_OCX_GetRecordList:" + result);
            if (result == 0) {
                return callBackFun(recordDataInfoNode);
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }

    /**
     * 开始平台录像回放，回放服务器录像文件。
     * @param recordMethod
     */
    vidIvsOCX.startPlayBack =function startPlayBack(recordMethod,callBackFun){

        if (zkVideoOcx)
        {
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//窗格


            var startTime =  utils.toUTCString($("#vcnVideoPlayback_startTime").val());//录像起止时间，UTC时间
            var endTime =  utils.toUTCString($("#vcnVideoPlayback_endTime").val());
            var cameraCode = $("#cameraCode").val();
            var m_strNVRCode  = $("#nvrCode").val();
            var deviceName  = $("#deviceName").val();

            if(undefined!=deviceName){
                // 标题
                zkVideoOcx.IVS_OCX_ShowTitlebar(1);
                zkVideoOcx.IVS_OCX_ShowToolbar(1);
                zkVideoOcx.IVS_OCX_SetDeviceName(wnd,deviceName);
            }

            var playbackParam = "<Content>";//回放参数
            playbackParam += "<PlaybackParam>";
            playbackParam += "<ProtocolType>2</ProtocolType>";
            playbackParam += "<StartTime>" + startTime + "</StartTime>";
            playbackParam += "<EndTime>" + endTime + "</EndTime>";
            playbackParam += "<NVRCode>" + m_strNVRCode  + "</NVRCode>";
            playbackParam += "<Speed>1</Speed>";
            playbackParam += "</PlaybackParam>";
            playbackParam += "</Content>";

            var result = 0;

            if (recordMethod  == 0) {
                /*开始平台回放*/
                result = zkVideoOcx.IVS_OCX_StartPlatformPlayBack(cameraCode, playbackParam, wnd);
            } else if (recordMethod  == 1) {
                /*开始前端回放*/
                result = zkVideoOcx.IVS_OCX_StartPUPlayBack(cameraCode, playbackParam, wnd);
            }

            if (result == 0) {
                return callBackFun(wnd);
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }

        }
    }

    /**
     * 停止视频回放
     * @param recordMethod
     */
    vidIvsOCX.stopPlayBack =function stopPlayBack(recordMethod){

        if (zkVideoOcx)
        {
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//窗格

            var result;
            if (recordMethod  == 0)
            {
                /*停止平台回放*/
                result = zkVideoOcx.IVS_OCX_StopPlatformPlayBack(wnd);
            }
            else if (recordMethod  == 1)
            {
                /*停止前端回放*/
                result = zkVideoOcx.IVS_OCX_StopPUPlayBack(wnd);
            }

            if (result == 0)
            {
                //成功,TODO……
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }
    /**
     * 暂停回放
     */
    vidIvsOCX.OcxPause =function OcxPause(callback) {
        if (zkVideoOcx)
        {
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//获取选中的回放窗格
            var result = zkVideoOcx.IVS_OCX_PlayBackPause(wnd);//暂停回放
            if (result == 0)
            {
                //成功,TODO……
                // 进度条
                return callback;
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }
    /**
     * 恢复回放
     */
    vidIvsOCX.OcxResume =function resume(callback){
        if (zkVideoOcx)
        {
            var wnd = zkVideoOcx.IVS_OCX_GetSelectWnd();//获取回放窗格
            var result = zkVideoOcx.IVS_OCX_PlayBackResume(wnd);//恢复回放
            if (result == 0)
            {
                //成功,TODO……
                return callback;
            }else{
                getOcxErrorCodeMsg(result);
                return;
            }
        }
    }
    /**
     * 设置窗格
     */
    vidIvsOCX.setPane =function setPane(da){
        if(da != null && da != undefined){
            if(zkVideoOcx){
                zkVideoOcx.IVS_OCX_SetWndLayout(da);
            }
        }
    }
}



/**
 * 初始化视图
 */
var _initView = function(vidIvsOCX) {



    /**
     *列表字段渲染成图标
     * @param capturePhoto
     * @returns {string}
     */
    vidIvsOCX.videoTypeToIcon = function videoTypeToIcon(videoType){
        /*视频类型0：实时1：录像2：导入视频3：历史车辆图片*/
        switch (videoType) {
            case 0:
                return "<img src='/images/video/playback/play_step.png'  class='videoTypeToIcon' height='18px'   style='cursor: pointer;margin-left:10px;' />";
            case 1:
                break;
            case 2:
                break;
            default:return "";
        }

    },
        /**
         *列表字段渲染成图标
         * @param capturePhoto
         * @returns {string}
         */
        vidIvsOCX.videoExistsRecordToIcon = function videoExistsRecordToIcon(existsRecord){
            /* 是否存在告警录像：0：否 1：是*/
            // if (existsRecord) {
            return "<img src='/images/video/playback/play_step.png'  class='videoTypeToIcon' height='18px'   style='cursor: pointer;margin-left:10px;' />";
            // }
        },

        /**
         *列表id字段渲染出来
         * @param capturePhoto
         * @returns {string}
         */
        vidIvsOCX.getIdVisible = function getIdVisible(id){
            return "<input  id='"+id+"' class='IdVisible'  value='"+id+"' style='display: none' />";
        }


};
/**
 * 初始化事件
 */
var _initEvent = function(vidIvsOCX) {


    /**
     * 图标按钮getOCXPop弹窗事件
     * @param capturePhoto
     */
    vidIvsOCX.getOCXPop = function getOCXPop(recordMethod){
        var capturePhotoHtml = "<div id=\"ocx\" style=\"width: 100%; height: 93%;min-height: 40em; min-width: 45em;background: url('/images/public_logoOem.bmp') no-repeat scroll center black;\"></div>";
        $.jBox.open(capturePhotoHtml, "&nbsp;&nbsp;"+I18n.getValue('map_navigation_replay'), 580, 450, {
            id:"capturePhoto${uuid!}",
            opacity: 0,
            top: '5%',
            showIcon: 'jbox-title-icon-video',
            buttons: { }
        });
    }

    /**
     * 图标按钮getOCXPop弹窗回放事件
     * @param capturePhoto
     */
    vidIvsOCX.getOCXPopHtml = function getOCXPopHtml(id,type,postParam){
        switch (type) {
            case "faceAlarm":
                getVidFaceAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.cameraCode;
                    var alarmTime= result.data.alarmTime;
                    alarmTime=alarmTime.replace(/\-/g,"");
                    alarmTime=alarmTime.replace(/\:/g,"");
                    alarmTime=alarmTime.replace(/\s*/g,"");
                    var pattern = /(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/;
                    var  startTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    startTime = startTime.setSeconds(startTime.getSeconds()-30);
                    startTime = dateToString(new Date(startTime));
                    var  endTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    endTime = endTime.setSeconds(endTime.getSeconds()+30);
                    endTime = dateToString(new Date(endTime));
                    var nvrCode= result.data.nvrCode;
                    var deviceName=result.data.deviceName;
                    videoPlayPopup(startTime,endTime,cameraCode,nvrCode,deviceName);
                });
                break;
            case "vehicleAlarm":
                getVidVehicleAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.cameraCode;
                    var alarmTime= result.data.alarmTime;
                    alarmTime=alarmTime.replace(/\-/g,"");
                    alarmTime=alarmTime.replace(/\:/g,"");
                    alarmTime=alarmTime.replace(/\s*/g,"");
                    var pattern = /(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/;
                    var  startTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    startTime = startTime.setSeconds(startTime.getSeconds()-30);
                    startTime = dateToString(new Date(startTime));
                    var  endTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    endTime = endTime.setSeconds(endTime.getSeconds()+30);
                    endTime = dateToString(new Date(endTime));
                    var nvrCode= result.data.nvrCode;
                    var deviceName= result.data.deviceName;
                    videoPlayPopup(startTime,endTime,cameraCode,nvrCode,deviceName);
                });
                break;
            case "ivsAlarm":
                getVidIvsAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.alarmInCode;
                    var alarmTime= result.data.occurTime;
                    alarmTime=alarmTime.replace(/\-/g,"");
                    alarmTime=alarmTime.replace(/\:/g,"");
                    alarmTime=alarmTime.replace(/\s*/g,"");
                    var pattern = /(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/;
                    var  startTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    startTime = startTime.setSeconds(startTime.getSeconds()-30);
                    startTime = dateToString(new Date(startTime));
                    var  endTime = new Date(alarmTime.replace(pattern, '$1/$2/$3 $4:$5:$6'));
                    endTime = endTime.setSeconds(endTime.getSeconds()+30);
                    endTime = dateToString(new Date(endTime));
                    var nvrCode= result.data.nvrCode;
                    var deviceName= result.data.alarmInName;
                    videoPlayPopup(startTime,endTime,cameraCode,nvrCode,deviceName);
                });
                break;
            case "personFaceTrack":
                var cameraCode=postParam.cameraSn;
                var alarmTime= postParam.recordTime;
                var  startTime =parseFloat(alarmTime)-30*1000;
                startTime = dateToString(new Date(startTime));
                var  endTime = parseFloat(alarmTime)+30*1000;
                endTime = dateToString(new Date(endTime));
                var nvrCode= postParam.cameraCNCode;
                var deviceName=  postParam.deviceName;
                videoPlayPopup(startTime,endTime,cameraCode,nvrCode,deviceName);
                break;
            default:
                break;
        }


    }

    /**
     * 图标按钮getOCXPop弹窗直播事件
     * @param capturePhoto
     */
    vidIvsOCX.getOCXPopVideoPreviewHtml = function getOCXPopVideoPreviewHtml(id,type){
        switch (type) {
            case "faceAlarm":
                getVidFaceAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.cameraCode;
                    var alarmTime= result.data.alarmTime;
                    var nvrCode= result.data.nvrCode;
                    var deviceName= result.data.deviceName;
                    videoPreviewPopup(cameraCode,nvrCode,deviceName);
                });
                break;
            case "vehicleAlarm":
                getVidVehicleAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.cameraCode;
                    var alarmTime= result.data.alarmTime;
                    var nvrCode= result.data.nvrCode;
                    var deviceName=  result.data.deviceName;
                    videoPreviewPopup(cameraCode,nvrCode,deviceName);
                });
                break;
            case "ivsAlarm":
                getVidIvsAlertsAlarm(id,function (result) {
                    var cameraCode= result.data.alarmInCode;
                    var alarmTime= result.data.occurTime;
                    var nvrCode= result.data.nvrCode;
                    var alarmInName= result.data.alarmInName;
                    videoPreviewPopup(cameraCode,nvrCode,alarmInName);
                });
                break;
            default:
                break;
        }


    }



};


/**
 * 初始化Ocx
 */
var _initIvsOcx = function(vidIvsOCX) {

    vidIvsOCX.loginOCX=  function loginOCX(cameraCode) {
        getOcxInfo(cameraCode,function (result) {
            var serverId = result["serverId"];
            var ip = result["huaWeiServerIp"];
            var port =result["huaWeiServerPort"] ;
            var user =result["huaweiUser"];
            var pwd =result["huaweiPassWord"];
            if (zkVideoOcx) {
                var result = zkVideoOcx.IVS_OCX_Logout();//用户注销
                zkVideoOcx.ivs_ocx_init();
                var result = zkVideoOcx.IVS_OCX_Login(user, pwd, ip, port, 1);
                console.log("hua wei login result-"+result);
                serverOcxMap.set(serverId,true);
                serverOcxMap.forEach(function(value,key){
                    if(key!=serverId){
                        serverOcxMap.set(key,false);
                    }
                });
                getOcxErrorCodeMsg(result);
                return;
            }
        })
    };

    vidIvsOCX.initOcxVideo= function initOcxVideo (id, options,callBackFun,cameraCode) {
        loadPlugins = $("#loadPlugins").val();
        var ocx = $(id + " object[id='zkVideoOcx']")[0];
        var warnInfo = '<div id="ocxWarnInfo"><ul><li>'+I18n.getValue('vid_preview_warn1')+'</li><li>'+I18n.getValue('vid_preview_warn2')+'<br>' + '<span class="warningImage" style="margin-top:2px;"></span><a href="/vid/activeX/OCX.EXE#version=2.2.0.1">'+I18n.getValue('vid_preview_warn3')+'</a>' + (sysCfg.language== "zh_CN" ? "" : '&nbsp;'+I18n.getValue('vid_preview_warn12')+'</a>') + '</li>';
        if (undefined == ocx || ocx == null) {
            if (isIE) {
                $(id).append('<object id="zkVideoOcx" style="width: 100%; height: 100%;" classid="CLSID:3556A474-8B23-496F-9E5D-38F7B74654F4" codebase="/vid/activeX/OCX.EXE#version=2,2,0,36"></object>');
            } else if (navigator.userAgent.indexOf("Firefox") > 0 || navigator.userAgent.indexOf("Chrome") > 0) {
                if (navigator.userAgent.indexOf("Chrome") > 0)
                {
                    //warnInfo += '<li>'+I18n.getValue('vid_preview_warn4')+'</li><li>3.'+I18n.getValue('vid_preview_warn5')+I18n.getValue('vid_preview_warn8')+'</li><li>4.'+I18n.getValue('vid_preview_warn6')+'</li>' + (sysCfg.language== "zh_CN" ? "" : '<li>5.'+I18n.getValue('vid_preview_warn13')+'</li>') + '</ul></div>';
                } else {
                    //warnInfo += '<li>2.'+I18n.getValue('vid_preview_warn5')+I18n.getValue('vid_preview_warn9')+'</li><li>3.'+I18n.getValue('vid_preview_warn6')+'</li>' + (sysCfg.language == "zh_CN" ? "" : '<li>4.'+I18n.getValue('vid_preview_warn13')+'</li>') + '</ul></div>';
                }
                var version = navigator.userAgent.toLowerCase().match(/chrome\/(\d+)/);
                //谷歌版本45不支持插件
                if (version != null && version != undefined && version[1] > 44) {
                    vidOpenMessage(msgType.warning, I18n.getValue('vid_plugins_unSupported'));
                }
            } else {
                vidOpenMessage(msgType.warning, I18n.getValue('vid_plugins_unSupported'));
                return;
            }
        }
        try {
            vidIvsOCX.loginOCX(cameraCode);
            this.ocxObject = new $.OcxObject(id, options);
        } catch (err) {
            var errMsg = I18n.getValue('vid_plugins_loadingFailed');
            if (!options.isPreveiwPage) {
                //warnInfo = '<div id="ocxWarnInfo"><ul><li>'+I18n.getValue('vid_preview_warn1')+'</li><li>'+I18n.getValue('vid_preview_warn7')+'</li></ul>';
            } else if (err == I18n.getValue('vid_preview_warn1')) {
                errMsg = err;
            }
            $(id).html(warnInfo);
            vidOpenMessage(msgType.warning, errMsg);
        }
        return callBackFun();
    };





};




/**
 * 初始化
 */
(function (vidIvsOCX) {
    //数据初始化
    _initView(vidIvsOCX);
    //事件初始化
    _initEvent(vidIvsOCX);
    //初始化Ocx
    _initIvsOcx(vidIvsOCX);
    _ocxPrivateMethods(vidIvsOCX);
    window.vidIvsOCX = vidIvsOCX;
})(window.vidIvsOCX || {});





/**
 * ocx 控件引入
 * @type {boolean}
 */
var isIE = !!window.ActiveXObject || "ActiveXObject" in window, ocxVersion = "V3.1.3.6834", onvifOcxVersion = "V1.2.8.27", loadPlugins = "";


(function($){
    $.extend($, {
        /** id:ocx标签的ID */
        OcxObject : function(id, options) {
            this.settings = {
                split : 1,//分割数
                bLogoDisplay : "${oem}" != "Oem",//Logo是否显示
                realPlayType : 0,//码流类型
                bRButtonSpiltUI : true,//右键菜单分割是否是否屏蔽
            };
            $.extend(this.settings, options);
            if (loadPlugins == 0) {
                this.zkOcx = new $.ZkOcx(id, this.settings);
            }
            this.id = id;
            this.playCount = 0;
            this.loginData = new Array();
            $.extend(this, {
                LoginIVS : function(ip,port,user,pwd,devCameraCode){
                    var $this = this;
                    console.log($this);
                    $this.ocx = $this.zkOcx.show();
                    var loginid = $this.ocx.Login(ip, port, user, pwd);
                    if (loginid == 0)
                    {
                        $this.ocx.RealPlay(devCameraCode);
                    }
                },

            });
        },
        ZkOcx : function(id, options) {
            this.id = id;
            this.options = options;
            this.ocx = $(id + " object[id='zkVideoOcx']");

            if (zkVideoOcx) {
                var result = zkVideoOcx.ivs_ocx_init();

                // 设置OCX界面色调： "1"为黑色(暗色调) ，"2"为白色(亮色调)
                zkVideoOcx.IVS_OCX_SetSkin(1);
                // 设置OCX显示语言："zh-CN"为中文，"en-US"为英文
                zkVideoOcx.IVS_OCX_SetLanguage("en-US");
                zkVideoOcx.IVS_OCX_SetWndLayout(11); // 窗口
                zkVideoOcx.IVS_OCX_ShowTitlebar(0);
                zkVideoOcx.IVS_OCX_RefreshWnd(2);
                zkVideoOcx.IVS_OCX_ShowToolbar(0);
                // 抓拍、云台控制
                var ulToolbarFlag = 0x00000001 ^ 0x00000200;
                // 设置工具条上显示哪些工具按钮
                var result = zkVideoOcx.IVS_OCX_SetToolbar(ulToolbarFlag);
            }
            try {
                var result = zkVideoOcx.IVS_OCX_GetVersion();
                result = result.toString(16);
                if (result.length >= 7)
                {
                    this.version = result.substr(0, 1) + "." + result.substr(1, 2) + "." + result.substr(3, 2) + "." + result.substr(5, 2);
                }
            } catch (e) {
                this.version = "1.0.0.1";//OCX获取版本异常特殊处理
            }

            console.log("extend");
            $.extend(this, {
                show:function(){
                    if($(this.id+" object[id='onvifOcx']").length > 0)
                    {
                        $(this.id+" object[id='onvifOcx']").css("visibility","hidden").appendTo("body");
                        $(this.ocx).css("visibility","visible").appendTo(this.id);
                    }
                    return this;
                },
                Login:function(ip,port,user,pwd){
                    this.ocx.ivs_ocx_init();
                    var result = this.ocx.IVS_OCX_Login(user, pwd, ip, port, 1);
                    console.log("hua wei login result-"+result);
                    if (result == 109100049) {
                        // 端口非法
                        vidOpenMessage(msgType.warning,I18n.getValue('ivs_illegal_port'));
                        return;
                    } else if (result == 109100048) {
                        // ip地址非法
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_illegal_ip'));
                        return;
                    }else if(result == 109100019){
                        // 网络连接失败,服务器不在线或者网络原因引起连接超时等
                        vidOpenMessage(msgType.warning,  I18n.getValue("vid_network_connection_error"));
                        return;
                    }else if(result == 119108003){
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_geturl_timeout'));
                        return;
                    }
                    return result;
                },
                RealPlay:function(cameraCode){

                    var wnd = this.ocx.IVS_OCX_GetSelectWnd();
                    if (wnd == "") {
                        var wnd = this.ocx.IVS_OCX_GetFreeWnd();
                        var xml = this.ocx.IVS_OCX_SetActiveWnd(wnd);
                        if (xml != 0)
                        {
                            wnd = this.ocx.IVS_OCX_GetSelectWnd();
                        }
                    }
                    var streamType =1;//码流类型 0-不指定 1-主码流 2-副码流1 副码流2
                    var protocolType = 2;// 协议类型  1-UDP 2-TCP
                    var direstFirst =0;// 是否直连优先 0-否 1-是
                    var multi = 0;// 是否支持组播 0-否 1-是

                    var pMediaParaxml =
                        "<?xml version='1.0' encoding='UTF-8'?>" +
                        "<Content>" +
                        "    <RealplayParam>" +
                        "        <StreamType>" +  streamType + "</StreamType>"  +
                        "        <ProtocolType>" + protocolType + "</ProtocolType>" +
                        "        <DirectFirst>" + direstFirst + "</DirectFirst>" +
                        "        <Multicast>" + multi + "</Multicast>" +
                        "    </RealplayParam>" +
                        "</Content>";

                    var result = this.ocx.IVS_OCX_StartRealPlay(pMediaParaxml, cameraCode, wnd);
                    if(result == 129108001){
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_device_not_online'));
                        return;
                    }else if(result == 169100054){
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_error_invalid_input_parameter'));
                        return;
                    }else if(result == 999115450){
                        // 响应超时
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_response_timeout'));
                        return;
                    }else if(result == 119108003){
                        vidOpenMessage(msgType.warning, I18n.getValue('ivs_geturl_timeout'));
                        return;
                    }
                    return result;
                    // console.log("RealPlay=>> loginid:" + loginid + "  loginid:" + chNo + "  loginid:" + wIndex)
                    // if(undefined != wIndex && isIE)
                    // 	return this.ocx.RealPlayEx(loginid, chNo, this.options.realPlayType, wIndex);
                    // return this.ocx.RealPlay(loginid, chNo, this.options.realPlayType);
                },

            });
        },
        initOcx : function(id, options,cameraCode) {
            loadPlugins = $("#loadPlugins").val();
            var ocx = $(id + " object[id='zkVideoOcx']")[0];
            var warnInfo = '<div id="ocxWarnInfo"><ul><li>'+I18n.getValue('vid_preview_warn1')+'</li><li>'+I18n.getValue('vid_preview_warn2')+'<br>' + '<span class="warningImage" style="margin-top:2px;"></span><a href="/vid/activeX/OCX.EXE#version=2.2.0.1">'+I18n.getValue('vid_preview_warn3')+'</a>' + (sysCfg.language== "zh_CN" ? "" : '&nbsp;'+I18n.getValue('vid_preview_warn12')+'</a>') + '</li>';
            if (undefined == ocx || ocx == null)
            {
                if (isIE)
                {
                    //warnInfo += '<li>2.'+I18n.getValue('vid_preview_warn12')+'</li></ul></div>';
                    $(id).append('<object id="zkVideoOcx" style="width: 100%; height: 100%;" classid="CLSID:3556A474-8B23-496F-9E5D-38F7B74654F4" codebase="/vid/activeX/OCX.EXE#version=2,2,0,36"></object>');
                }
                else
                if (navigator.userAgent.indexOf("Firefox") > 0 || navigator.userAgent.indexOf("Chrome") > 0)
                {
                    if (navigator.userAgent.indexOf("Chrome") > 0)
                    {
                        //warnInfo += '<li>'+I18n.getValue('vid_preview_warn4')+'</li><li>3.'+I18n.getValue('vid_preview_warn5')+I18n.getValue('vid_preview_warn8')+'</li><li>4.'+I18n.getValue('vid_preview_warn6')+'</li>' + (sysCfg.language== "zh_CN" ? "" : '<li>5.'+I18n.getValue('vid_preview_warn13')+'</li>') + '</ul></div>';
                    }
                    else
                    {
                        //warnInfo += '<li>2.'+I18n.getValue('vid_preview_warn5')+I18n.getValue('vid_preview_warn9')+'</li><li>3.'+I18n.getValue('vid_preview_warn6')+'</li>' + (sysCfg.language == "zh_CN" ? "" : '<li>4.'+I18n.getValue('vid_preview_warn13')+'</li>') + '</ul></div>';
                    }
                    var version = navigator.userAgent.toLowerCase().match(/chrome\/(\d+)/);
                    if (version != null && version != undefined && version[1] > 44)//谷歌版本45不支持插件
                    {
                        vidOpenMessage(msgType.warning, I18n.getValue('vid_plugins_unSupported'));
                    }
                }
                else
                {
                    vidOpenMessage(msgType.warning, I18n.getValue('vid_plugins_unSupported'));
                    return;
                }
            }
            try
            {
                this.ocxObject = new $.OcxObject(id, options);
            }
            catch (err)
            {
                var errMsg = I18n.getValue('vid_plugins_loadingFailed');
                if (!options.isPreveiwPage)
                {
                    //warnInfo = '<div id="ocxWarnInfo"><ul><li>'+I18n.getValue('vid_preview_warn1')+'</li><li>'+I18n.getValue('vid_preview_warn7')+'</li></ul>';
                }
                else
                if (err == I18n.getValue('vid_preview_warn1'))
                {
                    errMsg = err;
                }
                $(id).html(warnInfo);
                vidOpenMessage(msgType.warning, errMsg);
            }
        },
        /** 初始弹出预览 */
        initPopUp : function(callback) {
            var divHtml = '<div id="videoContent" class="grab-cursor"><div class="clearfix">' + '	<div class="video-left-menu">' + ' 	<div class="vid-items"></div>' + ' 	<div class="rsThumbsArrow rsThumbsArrowLeft"><div class="rsThumbsArrowIcn"></div></div>' + ' 	<div class="rsThumbsArrow rsThumbsArrowRight"><div class="rsThumbsArrowIcn"></div></div>' + ' </div>' + ' <div class="video-right-menu">' + '    <div id="ocxObject" style="background: url(\'/vid/images/public_logo${oem}.bmp\') no-repeat scroll center black;"></div>' + ' </div>' + '</div><div>';
            $.jBox.open("html:" + divHtml, '&nbsp;&nbsp;'+I18n.getValue('common_linkIO_videoLink')+'<span id="ocxVersionTip"></span>', 450, 327, {
                opacity : 0,
                id : 'vidPreview',
                showScrolling : false,
                iframeScrolling : 'no',
                showIcon : 'jbox-title-icon-video',
                buttons : { /* '远程开门': 'ok', '${common_edit_cancel}': 'cancel' */},
                loaded : function(h)
                {
                    var $div = $("#vidPreview #jbox");
                    $div.css({
                        "top" : ($("body").height() - 346) + "px",
                        "left" : "225px"
                    });
                    $("#vidPreview").css("visibility", "visible");
                },
                closed : function()
                {
                    callback.apply();
                }
            });
            $.initOcx("#ocxObject", {
                split : 1,
                bRButtonSpiltUI : false
            });
            $("#vidPreview").css("visibility", "hidden");

            var $vidItems = $(".vid-items");
            $(".rsThumbsArrow.rsThumbsArrowLeft").click(function()
            {
                var length = $vidItems.children().length;
                var top = $vidItems.css("marginTop").replace("px", "");
                $(".rsThumbsArrow.rsThumbsArrowRight").show();
                if (top >= -48)
                {
                    $(this).hide();
                }
                $vidItems.animate({
                    marginTop : top * 1 + 48
                });
            });
            $(".rsThumbsArrow.rsThumbsArrowRight").click(function()
            {
                var length = $vidItems.children().length;
                var top = $vidItems.css("marginTop").replace("px", "");
                $(".rsThumbsArrow.rsThumbsArrowLeft").show();
                if (top <= -(length - 7) * 48)
                {
                    $(this).hide();
                }
                $vidItems.animate({
                    marginTop : top * 1 - 48
                });
            });
        },

        /** 弹出视频 */
        popUpVideo:function(vidDevice,type,eventName){
            var cameraCode=vidDevice.cameraCode;
            var p = this;
            this.initPopUp(function() {
                //关闭回调
                p.popUpFlag = "Uninitialized";
                try{
                    vidIvsOCX.setCleanUp(function () {
                        $("#vidPreview").html("");
                        window.clearInterval(p.t);
                    });
                }catch (e) {
                    $("#vidPreview").html("");
                    window.clearInterval(p.t);
                }
            });
            if(!$.ocxObject) {
                vidOpenMessage(msgType.warning, I18n.getValue('vid_plugins_loadingFailed'));
                return;
            }
            vidIvsOCX.loginOCX(cameraCode);
        },
    });
})(jQuery);



