# 视频插件-html对接工具
##插件简介
```sequence
视频插件是一款以浏览器为父程序，与前端通过webSocket进行指令通讯的视频播放工具,由前端发起唤起指令，插件执行并给予回调响应。
```
##注意事项
```sequence
1、视频插件的本质是附着于浏览器的覆盖层插件，该插件会遮盖平台的html页面，比如弹窗、提示框等。且不会随着浏览器的变动而变动，
当浏览器放大、缩小、切换tab页面等操作时，插件依旧会附着于指定位置。因此，我们需要监听浏览器的每个动作，以及平台的各种弹
窗，菜单切换效果，在发生时，主动向插件发起指定，要求它隐藏，移动，裁剪，放大or缩小的命令。以适配前端兼容。同时，在不同的
浏览器下也需要做兼容。避免展示的位置错误或者未响应到当前动作。当前，该js脚本已经兼容了绝大多数常见的业务场景。如果有特殊
业务场景请提出，我们会进行兼容修复或是协助给予其他使用建议。
2、不支持在同一个浏览器上同时打开相同的页面。
```
## websocket-html通讯时序
```sequence
H5->Server: 连接WS
Server->H5: 返回UUID（SetForm）
H5->Server: 初始化token（InitProgram）
H5->Server: 启动Client，将UUID传过去（StartProgram）
Server->Client: 启动Client
Client->Server: 连接WS
Server->Client: 返回UUID
Client->Server: 发送给H5，将UUID传过去
Server->H5: 收到Client的UUID（SetAddressee）
H5-->Client: 进行通讯
Client-->H5:
H5->Server: 断开WS/发送退出程序(CloseProgram)
Server->Client: 关闭程序
```
###初始化日志
```sequence
ivs log：start initialize ivs video play...
ivs log：webSocket connect succeed
ivs log：ivsPlay init succeed
ivs log：SetForm ---{e02fa8ab-6906-4b6e-b2bc-220227a6d767}
ivs log：action：initProgram:{{"from":"{e02fa8ab-6906-4b6e-b2bc-220227a6d767}","command":"InitProgram","data":{"token":"00F73CFB6E13491B9D538CDC90DDD1CA1EFED542515079B9DB57B980FD1076B97BDF84D5745195331F49BA81A8BF8C10","serverIP":"192.168.214.3","serverPort":"8098","https":"true","useragent":"Chrome","language":"zh_CN","skin":"techblue"}}}
ivs log：CallBack---{"addressee":"{e02fa8ab-6906-4b6e-b2bc-220227a6d767}","command":"CallBack","data":{"buildDate":"2021/12/11 15:51:42","callbackCommand":"InitProgram","downloadDir":"C:/Users/Administrator/AppData/Local/IVSWebPlugin","msg":"","result":"success","taskid":"","version":"1.2.0.1103"},"from":"server"}
```
## web端启动加载时序
```sequence
浏览器刷新-->连接websocket
初始化全局空插件备用-->携带参数调用初始化插件方法加载插件
调用startPlayVideo唤起插件-->进行视频预览及回放等
```
## 如何在html页面内使用
```sequence
<#assign gridName="vidPreview${uuid!}">
<div id="qtPlayId" style="width: 100%;height: 100%;">
    <#include '/ivs/template/errorTemplate.html'>
</div>
<script type="text/javascript">
    $().ready(function () {
        /**
         * param：ivsPreview 插件唯一标识，任意唯一字符串皆可。此唯一为整个web项目唯一、非当前页面唯一。推荐：模块名+业务名
         * param：ivsPreview.do 当前页面的三级菜单跳转路径
         * param：qtPlayId  作为该插件占位的div标识
         * param：语言
         */
        var sign = ZKQTPlay.init("ivsPreview", "ivsPreview.do", "qtPlayId", "${systemLanguage!}");
        /**
         * 返回值sign为该插件初始化完成的唯一标识，
         * 在操作需要调用qt接口的方法时，都需要携带该标识，
         * 标识=init时传入的第一个参数+随机数，随机数由插件自动生成.
         * 若初始化失败。不会返回sing，返回值为空串。
         */
        if (sign != '') {
            /** 携带init返回的标识，开启预览插件 */
            ZKQTPlay.startPlayVideo(sign);
        }
    });
</script>
```
## API方法支持
###注册插件--ZKQTPlay.init(sign, actionLink, id, language);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 插件唯一标识，任意唯一字符串皆可。此唯一为整个web项目唯一、非当前页面唯一。推荐：模块名+业务名|
|actionLink | "ivsPreview.do" | 当前页面的三级菜单跳转路径|
|id | "qtPlayId" | 作为该插件占位的div标识|
|language | "${systemLanguage!}" | 语言(弃用)
###判断插件是否已经注册--ZKQTPlay.isInit(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###展示插件--ZKQTPlay.showProgram(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###隐藏插件--ZKQTPlay.hideProgram(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###停止播放--ZKQTPlay.stopVideo(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###启动预览插件(带设备树)--ZKQTPlay.startPlayVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###启动回放插件(带设备树)--ZKQTPlay.startReplayVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###启动单回放插件(不带设备树)--ZKQTPlay.startSingleReplayVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###启动X个窗口的插件--ZKQTPlay.startMultiVideo(sign, pageName, videoPaneCount,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###启动单预览插件(不带设备树)--ZKQTPlay.startSingleVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###启动视频划线插件--ZKQTPlay.startIntelligentVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###隐藏启动视频划线插件--ZKQTPlay.startHideIntelligentVideo(sign, pageName,toolBarBtnConfig);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|pageName | "V6600" | 插件所处tab页面名 document.title |
|toolBarBtnConfig | "btnPause暂停,btnSnapShot抓拍,btnRecord录像,btnDownLoad下载,btnEnlarge局部放大,btnMore更多,btnMediaInfo, 媒体资料,btnClose关闭" | 插件所处tab页面名 document.title |
###停止插件(停止播放+隐藏 非销毁)--ZKQTPlay.stopPlayVideo(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###恢复指定窗口--ZKQTPlay.recoverCutWindow(sign, taskId);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|taskId | "ivsPreview" | 裁剪方法的任务id |
###移动插件--ZKQTPlay.moveProgram(sign);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
###播放视频--ZKQTPlay.playVideo(sign, rtspUrl, mainType, "1", id, channelCode, vidParentDeviceId, cameraName);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|rtspUrl | "rtsp://192.168.214.179:554/ch01.264?ptype=udp" | 流地址 |
|mainType | "1" | 类型 主/辅码流 |
|winIdIndex | "1" | 窗口索引 |
|id | "" | 放空串(弃用) |
|channelCode | "1" | 通道code |
|vidParentDeviceId | "402856837cfd558f017cfd5646590866" | 所属主设备id |
|cameraName | "demo01" | 摄像机名称 |
###播放指定窗口的视频(一般应用于多分屏)--ZKQTPlay.playMultiVideo(sign, rtspUrl, mainType, winIdIndex, id, channelCode, vidParentDeviceId, cameraName);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|rtspUrl | "rtsp://192.168.214.179:554/ch01.264?ptype=udp" | 流地址 |
|mainType | "1" | 类型 主/辅码流 |
|winIdIndex | "1" | 窗口索引 |
|id | "" | 放空串(弃用) |
|channelCode | "1" | 通道code |
|vidParentDeviceId | "402856837cfd558f017cfd5646590866" | 所属主设备id |
|cameraName | "demo01" | 摄像机名称 |
###播放回放--ZKQTPlay.playReplayVideo(sign, rtspUrl, mainType, startTime, endTime, userName, passWord, channelCode, vidParentDeviceId, cameraName);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|rtspUrl | "rtsp://192.168.213.9:554/08051841540907160101?DstCode=01&ServiceType=4&ClientType=0&StreamID=1&SrcTP=2&DstTP=2&SrcPP=0&DstPP=1&MediaTransMode=0&BroadcastType=0&SV=1&TimeSpan=20211212T160000Z-20211213T100036Z&Token=A9VjmJoVsLo83TldKsNGQlTMpjUGJE4F+d/wn5r74sk=&Multiplex=2M3GrIDSAbo+9sSm7CPfzx5LQbt/oUhUtu5RNTQEd7Q=&" | 流地址 |
|mainType | "1" | 类型 主/辅码流 |
|startTime | "2021-12-13 10:00:36" | 开始时间 |
|endTime | "2021-12-13 10:01:36" | 结束时间 |
|userName | "userName" | 用户名 |
|passWord | "password" | 密码 |
|channelCode | "1" | 通道code |
|vidParentDeviceId | "402856837cfd558f017cfd5646590866" | 所属主设备id |
|cameraName | "demo01" | 摄像机名称 |
###添加视频划线--ZKQTPlay.putVideoDash(sign, watchAreaList);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|watchAreaList | "[{"enable": "1","index": "1","name": "区域1","areaType": "2","direction": "-1","pointList": [{"x": 266,"y": 148}, {"x": 380,"y": 148 }, {"x": 380,"y": 416}, {"x": 266,"y": 416}]" | 划线数据点位集合 |
###区域启停或者删除--ZKQTPlay.editAreaInfo(sign, editType, index, enableStatus, direction, secret);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|editType | "enableArea" | 'enableArea'启用 'deleteArea'删除 |
|index | "1" | 区域索引 |
|enableStatus | "0" | 0：禁用1：启用 |
|direction | "" | 弃用 |
|secret | "" | 弃用 |
###任务管理清空画线--ZKQTPlay.clearAllDraw(sign, clear);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|clear | "1" | 0：否1：是 |
###智能画线 保存返回信息--ZKQTPlay.returnUpdateInfo(sign, save);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | sign | 初始化返回的sign |
|param | save | 0：否1：是 |
###任务管理画线回退操作--ZKQTPlay.backDrawOperate(sign, back);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|back | "1" | 0：否1：是 |
###获取HDMI数量--ZKQTPlay.getHDMICount(sign, module, subCommand, data);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|module | module | 透穿接口主分组 |
|subCommand | subCommand | 透穿接口子分组 |
|data | data | 透传数据 |
###同步电视墙数据--ZKQTPlay.synchronousData(sign, module, subCommand, data);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|module | module | 透穿接口主分组 |
|subCommand | subCommand | 透穿接口子分组 |
|data | data | 透传数据 |
###指定窗口上墙--ZKQTPlay.toWallByWindowId(sign, module, subCommand, data);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|sign | "ivsPreview" | 初始化返回的sign |
|module | module | 透穿接口主分组 |
|subCommand | subCommand | 透穿接口子分组 |
|data | data | 透传数据 |
###插件默认文件存储路径--ZKQTPlay.selectFilePath(param);
| 参数 | 例子 | 描述 |
| ---- | --- | --- |
|param | "" | 为空唤起路径，有值设置路径 |