/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.locker.remote.LockerVisualPanelRemote;
import com.zkteco.zkbiosecurity.locker.service.LockerDeviceService;
import com.zkteco.zkbiosecurity.locker.service.LockerLockPersonService;
import com.zkteco.zkbiosecurity.locker.service.LockerLockService;
import com.zkteco.zkbiosecurity.locker.service.LockerParamsService;
import com.zkteco.zkbiosecurity.locker.vo.LockerLockItem;
import com.zkteco.zkbiosecurity.locker.vo.LockerSelectPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LockerVisualPanelController
extends BaseController
implements LockerVisualPanelRemote {
    @Autowired
    private LockerLockService lockerLockService;
    @Autowired
    private LockerLockPersonService lockerLockPersonService;
    @Autowired
    private LockerDeviceService lockerDeviceService;
    @Autowired
    private LockerParamsService lockerParamsService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"locker:visualPanel"})
    public ModelAndView index() {
        String multiplePeopleShareCabinet = this.lockerParamsService.getValByName("locker.multiplePeopleShareCabinet");
        this.request.setAttribute("multiplePeopleShareCabinet", (Object)multiplePeopleShareCabinet);
        return new ModelAndView("locker/visualPanel/visualPanel");
    }

    public ZKResultMsg getVisualPanelAndPersByDevId(LockerLockItem lockerLockItem) {
        return this.lockerLockService.getVisualPanelAndPersByDevId(lockerLockItem);
    }

    public DxGrid selectPersPersonList(LockerSelectPersonItem condition) {
        Pager pager = new Pager();
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setNotInId(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(condition.getSelectId());
        }
        pager = this.lockerLockPersonService.getNoExistPersonFilterDept(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg addOrDelPerson() {
        String lockId = this.request.getParameter("lockId");
        String persIds = this.request.getParameter("persIds");
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            this.lockerLockPersonService.addOrDelPerson(lockId, persIds);
        }
        catch (ZKBusinessException e) {
            this.progressCache.setProcess(new ProcessBean(99, 99, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg clearLocker(String devId) {
        this.lockerDeviceService.clearLocker(devId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg openLocker(@RequestParam(value="lockId") String lockId) {
        this.lockerDeviceService.openLocker(lockId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg setEnabledLock() {
        String lockerLockId = this.request.getParameter("lockId");
        String enabled = this.request.getParameter("enabled");
        return this.lockerLockService.setEnabledLock(lockerLockId, Boolean.parseBoolean(enabled));
    }
}

