/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.locker.constants.LockerConstants;
import com.zkteco.zkbiosecurity.locker.remote.LockerTransactionRemote;
import com.zkteco.zkbiosecurity.locker.service.LockerParamsService;
import com.zkteco.zkbiosecurity.locker.service.LockerTransactionService;
import com.zkteco.zkbiosecurity.locker.vo.LockerTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LockerTransactionController
extends ExportController
implements LockerTransactionRemote {
    @Autowired
    private LockerTransactionService lockerTransactionService;
    @Autowired
    private LockerParamsService lockerParamsService;

    @RequiresPermissions(value={"locker:transaction"})
    public ModelAndView index() {
        return new ModelAndView("locker/transaction/lockerTransaction");
    }

    @RequiresPermissions(value={"locker:transaction:refresh"})
    public DxGrid list(LockerTransactionItem condition) {
        Pager pager = this.lockerTransactionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"locker:transaction:export"})
    @LogRequest(module="locker_module", object="common_leftMenu_transaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        LockerTransactionItem lockerTransactionItem = new LockerTransactionItem();
        this.setConditionValue((BaseItem)lockerTransactionItem);
        List itemList = this.lockerTransactionService.getItemDataByAuthFilter(request.getSession().getId(), LockerTransactionItem.class, lockerTransactionItem, this.getBeginIndex(), this.getEndIndex());
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("lockSize", LockerConstants.LOCK_SIZE);
        map.put("verifyType", LockerConstants.VERIFY_TYPE);
        map.put("opType", LockerConstants.OP_TYPE);
        this.excelExport(itemList, LockerTransactionItem.class, map);
    }

    public ZKResultMsg getDecryptPhotoBase64(String photoPath) {
        String decryptPhoto;
        if (StringUtils.isNotBlank((CharSequence)photoPath) && StringUtils.isNotBlank((CharSequence)(decryptPhoto = this.lockerParamsService.getDecryptBase64ByCapturePhotoPath(photoPath)))) {
            return new ZKResultMsg((Object)("data:image/jpg;base64," + decryptPhoto));
        }
        return ZKResultMsg.failMsg();
    }

    @RequiresPermissions(value={"locker:transaction:del"})
    @LogRequest(module="locker_module", object="common_leftMenu_transaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.lockerTransactionService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg viewVidLinkData(String vidLinkageHandle, String fileType) {
        return this.lockerTransactionService.viewVidLinkData(vidLinkageHandle, fileType);
    }

    public ZKResultMsg getVideoFile(String id) {
        Map retMap = this.lockerTransactionService.getVideoFileValidate(id);
        if (Objects.nonNull(retMap)) {
            ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
            if (null != ret) {
                return I18nUtil.i18nMsg((ZKResultMsg)ret);
            }
            String filePath = retMap.get("filePath").toString();
            File file = (File)retMap.get("file");
            int index = filePath.lastIndexOf(File.separator);
            String fileName = filePath.substring(index + 1);
            if (file.isDirectory() && file.listFiles().length > 0) {
                File childFile = file.listFiles()[0];
                fileName = fileName.substring(0, fileName.lastIndexOf(".")) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
            }
            this.response.setCharacterEncoding("utf-8");
            this.response.setContentType("multipart/form-data");
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            try {
                int length;
                FileInputStream inputStream = new FileInputStream(filePath);
                ServletOutputStream os = this.response.getOutputStream();
                byte[] b = new byte[2048];
                while ((length = ((InputStream)inputStream).read(b)) > 0) {
                    os.write(b, 0, length);
                }
                os.close();
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    public DxGrid getLast5ListByLockId(String lockId) {
        Pager pager = this.lockerTransactionService.getLast5ListByLockId(lockId);
        return GridUtil.convert((Pager)pager, LockerTransactionItem.class);
    }
}

