/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.locker.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.locker.remote.LockerParamsRemote;
import com.zkteco.zkbiosecurity.locker.service.LockerParamsService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LockerParamsController
extends BaseController
implements LockerParamsRemote {
    @Autowired
    private LockerParamsService lockerParamsService;

    @RequiresPermissions(value={"locker:params"})
    public ModelAndView index() {
        Map lockerParams = this.lockerParamsService.getLockerParams();
        this.request.setAttribute("lockerParams", (Object)lockerParams);
        return new ModelAndView("locker/params/params");
    }

    @RequiresPermissions(value={"locker:params:edit"})
    @LogRequest(module="locker_module", object="common_leftMenu_paramSet", opType="common_op_edit", opContent="common_op_edit")
    public ZKResultMsg save(Map<String, String> params) {
        this.lockerParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

